/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/* 
 * File:   ServerAutoDetetc_Client.h
 * Author: Hagi
 *
 * Created on 16. April 2019, 08:57
 */
#ifndef SERVERAUTODETETC_CLIENT_H
#define SERVERAUTODETETC_CLIENT_H
#include "_SPITMACROS.h"
#include "SPIT_Handler.h"
#include "SPITSocket.h"
#include "SAD_DetectedServer.h"
#include <string>
#include <list>


static const string		SERVERAUTODETECT_PRECODE = "#SAD#";
static const string		SERVERAUTODETECT_SEPERATOR = "#,#";
static const string		SERVERAUTODETECT_TASKID = "SPIT";
static const string		SERVERAUTODETECT_PORT = "15110";



class SAD_Client {
	
//----- SAD Client Interface ------
private:
	static recursive_mutex				s_MutexClientInterface;	
	static SAD_ClientInterface*			s_SADClientInterface;
	
	

	
	
	
	
//----- SAD_Client -----
public:
private:
	static mutex				s_MutexSAD;
	static condition_variable	s_ConditionStopSAD;
	static bool					s_StopSAD;
	static thread*				s_ThreadSend;	
	static thread*				s_ThreadReceiveIP4;
	static thread*				s_ThreadReceiveIP6;
	
	static recursive_mutex		s_MutexSocket;
	static SPITSocket*			s_SPITSocket;

	static void sendAutoDetectServer();
	static void cycleStart();
	static void cycleEnd();
	static void receiveAutoDetectServer_IP4();
	static void receiveAutoDetectServer_IP6();

public:
	static void startAutoDetectServer(SAD_ClientInterface* p_SADClientInterface, SPITSocket* p_SPITSocket);
	static void stopAutoDetectServer(SAD_ClientInterface* p_SADClientInterface);
};

#endif /* SERVERAUTODETETC_CLIENT_H */

