/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

#include "_SPITMACROS.h"

string createGUID() {
	#if defined(OS_WINDOWS)
		GUID o_GUID;
		CoCreateGuid(&o_GUID);
		char guid_string[37]; // 32 hex chars + 4 hyphens + null terminator
		snprintf(
			  guid_string, sizeof(guid_string) / sizeof(guid_string[0]),
			  "%08x-%04x-%04x-%02x%02x-%02x%02x%02x%02x%02x%02x",
			  o_GUID.Data1, o_GUID.Data2, o_GUID.Data3,
			  o_GUID.Data4[0], o_GUID.Data4[1], o_GUID.Data4[2],
			  o_GUID.Data4[3], o_GUID.Data4[4], o_GUID.Data4[5],
			  o_GUID.Data4[6], o_GUID.Data4[7]);
		string stringGUID = guid_string;
		return stringGUID;
	#endif


	#if defined(OS_MAC) || defined(OS_LINUX)
		uuid_t id;
		uuid_generate(id);
		char *guid_string = new char[100];
		uuid_unparse(id, guid_string);
		string stringGUID = guid_string;
		return stringGUID;
	#endif
}
/** The name of the client's host computer*/
string getClientHostName() {
	string stringHostName;
	char hostname[255];
	if (gethostname(hostname, 255) != 0) {
		stringHostName = "";
	}
	else {
		stringHostName = hostname;
	}
	return stringHostName;;
}
