/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/* 
 * File:   Watchdog.h
 * Author: Hagi
 *
 * Created on 22. April 2019, 13:02
 */

#ifndef WATCHDOG_H
#define WATCHDOG_H

#include "_SPITMACROS.h"
#include <mutex>
#include <condition_variable>
#include <thread>

using namespace std;


class Watchdog {
public:
	class Listener {
	public:
		virtual void sendWatchdog()=0;
		virtual void eventWatchdogLost()=0;
	};

	static int	WATCHDOGTIME;
	static bool	s_StopWatchdog;

	Watchdog(Listener* p_Listener);
	virtual ~Watchdog();
		
private:
	Listener*			m_Listener;
	
	mutex				m_MutexLock;
	condition_variable	m_ConditionVariable;
	thread*				m_WatchdogThread;
	
	bool				m_Answered;
	
	void runWatchdog();
public:
	void startWatchdog();
	void answerWatchdog();
	void stopWatchdog();
};

#endif /* WATCHDOG_H */

