/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/* 
 * SPITWatchdog sends watchdog messages to the server from time to time. 
 * If there is no response from the server an eventWatchdogLost is triggered.
 * 
 * File:   Watchdog.cpp
 * Author: Hagi
 * 
 * Created on 22. April 2019, 13:02
 */


#include "Watchdog.h"

int Watchdog::WATCHDOGTIME = 3000;
bool Watchdog::s_StopWatchdog = true;

Watchdog::Watchdog(Listener* p_Listener) {
	s_StopWatchdog = true;
	m_Listener = p_Listener;
	m_WatchdogThread = NULL;	
}


Watchdog::~Watchdog() {
	stopWatchdog();
}

void Watchdog::startWatchdog() {
	if (s_StopWatchdog == false) return;
	{
		unique_lock<mutex> o_UniqueLock(m_MutexLock);
		s_StopWatchdog = false;
	}
	m_WatchdogThread = new thread(&Watchdog::runWatchdog, this);

}
void Watchdog::stopWatchdog() {
	if (m_WatchdogThread != NULL) {
		{
			unique_lock<mutex> o_UniqueLock(m_MutexLock);
			if (s_StopWatchdog == true) {
				return;
			}
			s_StopWatchdog = true;
		}
		if (this_thread::get_id() != m_WatchdogThread->get_id()) {
			m_ConditionVariable.notify_one();
			m_WatchdogThread->join();
		}
		m_WatchdogThread = NULL;
	}
}
void Watchdog::answerWatchdog() {
	m_Answered = true;
}

void Watchdog::runWatchdog() {
	bool boolDone;
	auto waitTime = std::chrono::milliseconds(WATCHDOGTIME);
	while (s_StopWatchdog == false) {
		
		m_Answered = false;
		m_Listener->sendWatchdog();
		{
			unique_lock<mutex> o_UniqueLock(m_MutexLock);
			boolDone = m_ConditionVariable.wait_for(o_UniqueLock, waitTime, []{return s_StopWatchdog;});
			if (s_StopWatchdog == true) {
				return;
			}
		}
		if (boolDone) {
			return;
		}
		if (m_Answered == false) {
			stopWatchdog();
			m_Listener->eventWatchdogLost();
			return;
		}
	}
		
}
