/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/* 
 * File:   UnixSocket.h
 * Author: Hagi
 *
 * Created on 12. April 2019, 15:58
 */

#ifndef UNIXSOCKET_H
#define UNIXSOCKET_H

#include "_SPITMACROS.h"
#if defined(OS_MAC) || defined(OS_LINUX)

#include <ifaddrs.h>
#include <sys/socket.h>
#include <netdb.h>
#include <arpa/inet.h>
#include <string.h>
#include <stdio.h>
#include <fcntl.h>
#include <unistd.h>
#include <thread>

#include "SPITSocket.h"

class UnixSocket : public SPITSocket{
public:
	static const int INVALID_SOCKET = -1;
public:
	UnixSocket();
	virtual ~UnixSocket();
private:
	int m_UDPSocketIP4;
	int m_UDPSocketIP6;
public:
	void getAdaptersInfo();
	string getBroadcastIP4(IPAddress* p_IPAdress);
	int setBroadcast(bool p_Broadcast);
	
	static int init();
	static int cleanUp();
	bool createSocket_UDP();
	int bindSocket(string p_ServerIP, string p_ClientIP, string p_ClientPort);
	int sendMessageTo(int p_InetFamily, string p_ServerIP, string p_ServerPort, const char* p_MessageBytes, int p_MessageLength);
	int receiveMessage(int p_InetFamily, char* p_Buffer, int p_BufferLength, string* p_ServerIP);
};
#endif

#endif /* UNIXSOCKET_H */

