/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/* 
 * File:   SPIT_Message.h
 * Author: Hagi
 *
 * Created on 3. April 2019, 08:51
 */

#ifndef SPIT_MESSAGE_H
#define SPIT_MESSAGE_H

#include <cstdlib>
#include <string>
using namespace std;

static const string SPITID = "#spit#";
//static char stringEmpty[] = "";
static char nullChar[] = "\0";

class SPIT_Message {	
//----------- Header -----------
public:
	
	class Header {
	public:
		static const int	BYTESLENGTH = 99;
		virtual ~Header();
		Header(const Header& orig);
		Header();
	//Members
	private:
		string			m_SPITID;
		int				m_SPITVersion;
		unsigned char	m_MessageNumber;
		int				m_BytesCount;
		string			m_ServerID;
		string			m_ClientID;
		int				m_OPFlag;
		int				m_ParseOffset = 0;

		void initMembers();
		
	public:
		const string getSPITID() const {
			return m_SPITID;
		}
		int getSPITVersion() const {
			return m_SPITVersion;
		}
		unsigned char getMessageNumber() const {
			return m_MessageNumber;
		}
		int getBytesCount() const {
			return m_BytesCount;
		}
		const string getServerID() const {
			return m_ServerID;
		}
		const string getClientID() const {
			return m_ClientID;
		}
		int getOPFlag() const {
			return m_OPFlag;
		}
		
	//Receive
	public:
		bool parse(char* p_Bytes, int p_ByteCount);
		
	//Send
	public:
		Header(int p_SPITVersion, int p_OPFlag);
		void setMessageNumber(unsigned char p_MessageNumber);
		void setServerID(string p_ServerID);
		void setClientID(string p_ID);
		void setOPFlag(int p_OPFlag);
		bool fillBytes(char* p_Bytes, int p_ByteCount);
	};

//----------- OPPart -----------
public:
	class OPPart {
		
	//Members
	protected:
		Header*		m_Header;
		int			m_ParseOffset;
		int			m_BytesCount;
	private:
		void initMembers();
	public:
		virtual ~OPPart();
//		OPPart(const OPPart& orig);
		Header* getHeader() const {
			return m_Header;
		}
		
		int getBytesCount() const {
			return m_BytesCount;
		}
		const string getServerID() const {
			if (m_Header == NULL) return "";
			return m_Header->getServerID();
		}
		const string getClientID() const {
			if (m_Header == NULL) return "";
			return m_Header->getClientID();
		}
		
		int getOPFlag() const {
			if (m_Header == NULL) return -1;
			return m_Header->getOPFlag();
		}
		
	//Receive
	public:
		OPPart(Header* p_Header, int p_OPFlag);
		void setHeader(Header* p_Header);
		virtual bool parse(char* p_Bytes, int p_ByteCounth)=0;
		
	//Send
	public:
		OPPart();
		virtual bool fillBytes(char* p_Bytes, int p_ByteCount)=0;		
	};

	
//----------- SPIT_Message -----------
	
public:
	static const int	SPITVERSION = 1;

	//SPIT_Object value usage
	static const char	VALUEUSE_DISCARD = 0x00; //value of SPITObejct is not used
	static const char	VALUEUSE_INRANGE = 0x01; //value of SPITOBject in range 0 - 1000000ppm
	static const char	VALUEUSE_OVERRIDE = 0x02; //value can be overridden
	
	//SPIT Player type
	static const char PLAYERTYPE_MAIN = 0x02;
	static const char PLAYERTYPE_CONTINIOUS = 0x01;
	static const char PLAYERTYPE_DISCRETE = 0x00;

	//PlayObject value usage
	static const char VALUEFLAG_DIRECT = 0x00; //use the vlue direct
	static const char VALUEFLAG_INCREASE = 0x01; //increase the value
	static const char VALUEFLAG_DECREASE = 0x02; //decrease the value
	
	
	SPIT_Message();
	virtual ~SPIT_Message();
//	SPIT_Message(const SPIT_Message& orig);
	
//Members
private:
	char*			m_MessageBytes;
	int				m_MessageByteCount;
	Header*			m_Header;
	OPPart*			m_OPPart;
	bool			m_MessageBytesCreated;
	
	void initMembers();
	
//Receive
public:	
	SPIT_Message(char* p_MessageBytes, int p_MessageBytesLength);
	
//	SPIT_Message(const SPIT_Message& orig);
	const Header* getHeader() const {
		return m_Header;
	}
	int getOPFlag() const {
		if (m_Header == NULL) return -1;
		return m_Header->getOPFlag();
	}
	const OPPart* getOPPart() const {
		return m_OPPart;
	}
	int getMesageByteCount() const {
		return m_MessageByteCount;
	}
	
	OPPart* parse();
	
//Send
public:
	SPIT_Message(OPPart* p_OPPart);
	bool fillBytes();
	const char* getMessageBytes();
	
	
	
	
//------------------------------ Connection ----------------------------------	
	
//----------- Connect -----------
public:	
	class Connect : public OPPart {
	public:
		static const int	OPFLAG = 1;
		static const int	BYTESLENGTH = 304;

	private:		
		string	m_ClientComputerName;
		string	m_ClientName;
		string	m_LoginName;
		string	m_LoginPassword;
		string	m_ServerIP;
		int		m_ServerPort;
		void initMembers();
	public:
		~Connect();
//		Connect(const Connect& orig);
		//Receive
	public:
		Connect(Header* p_Header);
		bool parse(char* p_Bytes, int p_ByteCount);
		
		const string getClientComputerName() const {
			return m_ClientComputerName;
		}
		const string getClientName() const {
			return m_ClientName;
		}
		const string getLoginName() const {
			return m_LoginName;
		}
		const string getLoginPassword() const {
			return m_LoginPassword;
		}
		const string getServerIP() const {
			return m_ServerIP;
		} 
		int getServerPort() const {
			return m_ServerPort;
		}
		
		//Send
	public:
		Connect();
		void setClientComputerName(string p_ComputerName);
		void setClientName(string p_ClientName);
		void setLoginName(string p_LoginName);
		void setLoginPassword(string p_LoginPassword);
		void setServerIP(string p_ServerIP);
		void setServerPort(int p_ServerPort);
		bool fillBytes(char* p_MessageBytes, int p_ByteCount);
	};
	
//----------- ConnectAnswer -----------

	class ConnectAnswer : public OPPart {
	public:
		static const int	OPFLAG = 2;
		static const int	BYTESLENGTH = 137;
	private:
		string	m_ServerComputerName;
		string	m_ServerName;
		bool	m_Connected;
		int		m_StepTime; //ms step size the Server will send play sequences 
				
		void initMembers();
	public:
		~ConnectAnswer();
		ConnectAnswer(const ConnectAnswer& orig);
		//Receive
		ConnectAnswer(Header* p_Header);
		
		bool parse(char* p_Bytes, int p_ByteCount);
		
		const string getServerComputerName() const {
			return m_ServerComputerName;
		}
		const string getServerName() const {
			return m_ServerName;
		}
		bool getConnected() const {
			return m_Connected;
		}
		int getStepTime() const {
			return m_StepTime;
		}
		
		//Send
	public:
		ConnectAnswer();
		void setServerComputerName(string p_ServerComputerName);
		void setServerName(string p_ContollerName);
		void setConnected(bool p_Connected);
		void setStepTime(int p_StepTime_ms);
		bool fillBytes(char* p_MessageBytes, int p_ByteCount);
	};

//----------- Disconnect -----------

	class Disconnect : public OPPart {
	public:
		static const int	OPFLAG = 3;
		static const int	BYTESLENGTH = 4;
		
	private:	
		void initMembers();
	public:
		~Disconnect();
		Disconnect(const Disconnect& orig);
		//Receive
		Disconnect(Header* p_Header);	
		bool parse(char* p_Bytes, int p_ByteCount);
		
		// Send
	public:
		Disconnect();
		bool fillBytes(char* p_MessageBytes, int p_ByteCount);
	};

//----------- Watchdog -----------
	
	class Watchdog : public OPPart {
	public:
		static const int	OPFLAG = 8;
		static const int	BYTESLENGTH = 4;
	private:
		void initMembers();
	public:
		~Watchdog();
		Watchdog(const Watchdog& orig);
		//Receive
		Watchdog(Header* p_Header);
		bool parse(char* p_Bytes, int p_ByteCount);
				
		// Send
	public:
		Watchdog();
		bool fillBytes(char* p_MessageBytes, int p_ByteCount);
	};

//----------- WatchdogAnswer -----------
	
	class WatchdogAnswer : public OPPart {
	public:
		static const int	OPFLAG = 9;
		static const int	BYTESLENGTH = 4;
	private:	
		void initMembers();
		//Receive
	public:
		~WatchdogAnswer();
		WatchdogAnswer(const WatchdogAnswer& orig);
		WatchdogAnswer(Header* p_Header);
		bool parse(char* p_Bytes, int p_ByteCount);
		
	// Send
	public:
		WatchdogAnswer();
		bool fillBytes(char* p_MessageBytes, int p_ByteCount);
	};
	
	
//------------------------------ SPITProject ----------------------------------	

//----------- ReportSPITProject -----------
	
	class ReportSPITProject : public OPPart {
	public:
		static const int OPFLAG = 11;
		static const int	BYTESLENGTH = 113;
	private:	
		string	m_ProjectID;
		string	m_ProjectName;
		int		m_FramesPerSecond; //Frames per second
		
		void initMembers();
		//Receive
	public:
		~ReportSPITProject();
		ReportSPITProject(const ReportSPITProject& orig);
		ReportSPITProject(Header* p_Header);
		bool parse(char* p_Bytes, int p_ByteCount);
		const string getProjectID() const {
			return m_ProjectID;
		}
		const string getProjectName() const {
			return m_ProjectName;
		}
		int getFramesPerSecond() const {
			return m_FramesPerSecond;
		}
		// Send
		ReportSPITProject();
		
		void setProjectID(string p_ClientID);
		void setProjectName(string p_ClientName);
		void setFramesPerSecond(const int p_FramesPerSecond);
		bool fillBytes(char* p_MessageBytes, int p_ByteCount);
	};

//----------- CloseSPITProject -----------
	
	class CloseSPITProject : public OPPart {
	public:
		static const int	OPFLAG = 13;
		static const int	BYTESLENGTH = 45;
	private:
		string	m_ProjectID;
		
		void initMembers();
	public:
		~CloseSPITProject();
		CloseSPITProject(const CloseSPITProject& orig);
		//Receive
		CloseSPITProject(Header* p_Header);
		bool parse(char* p_Bytes, int p_ByteCount);
		const string getProjectID() const {
			return m_ProjectID;
		}
		// Send
	public:
		CloseSPITProject();
		
		void setProjectID(string p_ClientID);
		bool fillBytes(char* p_MessageBytes, int p_ByteCount);
	};
	
//----------- StartProjectTransfer -----------
	class RequestProjectTransfer : public OPPart {
	public:
		static const int	OPFLAG = 15;
		static const int	BYTESLENGTH = 4;
	private:
		void initMembers();
	public:
		~RequestProjectTransfer();
		RequestProjectTransfer(const RequestProjectTransfer& orig);
		//Receive
		RequestProjectTransfer(Header* p_Header);
		bool parse(char* p_Bytes, int p_ByteCount);
		// Send
	public:
		RequestProjectTransfer();
		bool fillBytes(char* p_MessageBytes, int p_ByteCount);
	};
	
//----------- StartProjectTransfer -----------
	
	class StartProjectTransfer : public OPPart {
	public:
		static const int	OPFLAG = 16;
		static const int	BYTESLENGTH = 4;
		
	private:	
		void initMembers();
	public:
		~StartProjectTransfer();
		StartProjectTransfer(const StartProjectTransfer& orig);
		//Receive
		StartProjectTransfer(Header* p_Header);
		bool parse(char* p_Bytes, int p_ByteCount);
		// Send
	public:
		StartProjectTransfer();
		bool fillBytes(char* p_MessageBytes, int p_ByteCount);
	};

//----------- EndProjectTransfer -----------
	class EndProjectTransfer : public OPPart {
	public:
		static const int	OPFLAG = 17;
		static const int	BYTESLENGTH = 4;
	private:			
		void initMembers();
	public:
		~EndProjectTransfer();
		EndProjectTransfer(const EndProjectTransfer& orig);
		//Receive
		EndProjectTransfer(Header* p_Header);
		bool parse(char* p_Bytes, int p_ByteCount);
		// Send
		EndProjectTransfer();
		bool fillBytes(char* p_MessageBytes, int p_ByteCount);
	};
	
//---------------------------- SPIT_Types ----------------------------------
	
//----------- ReportSPITType -----------
	class ReportSPITType : public OPPart {
	public:
		static const int	OPFLAG = 21;
		static const int	BYTESLENGTH = 168;
	private:	
		bool	m_Confirmed;
		string	m_SPITTypeID;
		bool	m_Fixed;
		bool	m_ServerRemote;
		bool	m_ServerProjectIndepended;
		string	m_SPITTypeGroupName;
		string	m_SPITTypeName;
		long long	m_Delay;
		long long	m_Duration;
		
		void initMembers();
	public:
		~ReportSPITType();
		ReportSPITType(const ReportSPITType& orig);
		//Receive
		ReportSPITType(Header* p_Header);
		bool parse(char* p_Bytes, int p_ByteCount);
		
		bool getConfirmed() const {
			return m_Confirmed;
		}
		const string getID() const {
			return m_SPITTypeID;
		}
		bool getFixed() const {
			return m_Fixed;
		}
		bool getServerRemote() const {
			return m_ServerRemote;
		}
		bool getServerProjectIndepended() const {
			return m_ServerProjectIndepended;
		}
		const string getGroupName() const {
			return m_SPITTypeGroupName;
		}
		const string getName() const {
			return m_SPITTypeName;
		}
		long long getDelay() const {
			return m_Delay;
		}
		long long getDuration() const {
			return m_Duration;
		}
		// Send
	public:
		ReportSPITType();
		
		void setConfirmed(bool p_Confirmed);
		void setID(string p_ID);
		void setFixed(bool p_Fixed);
		void setServerRemote(bool p_IsServerRemote);
		void setServerProjectIndepended(bool p_ProjectIndpended);
		void setGroupName(string p_GroupName);
		void setName(string p_Name);
		void setDelay(long long p_Delay);
		void setDuration(long long p_Duration);
		
		bool fillBytes(char* p_MessageBytes, int p_ByteCount);
	};
	
//----------- RemoveSPITType -----------
	
	class RemoveSPITType : public OPPart {
	public:
		static const int	OPFLAG = 23;
		static const int	BYTESLENGTH = 45;
	private:	
		string	m_SPITTypeID;
		
		void initMembers();
	public:
		~RemoveSPITType();
		RemoveSPITType(const RemoveSPITType& orig);
		//Receive
		RemoveSPITType(Header* p_Header);
		bool parse(char* p_Bytes, int p_ByteCount);
		
		const string getID() const {
			return m_SPITTypeID;
		}
		// Send
		RemoveSPITType();
		
		void setID(string p_ID);
		bool fillBytes(char* p_MessageBytes, int p_ByteCount);
	};



//---------------------------- SPITObjects ----------------------------------
	
//----------- ReportSPITObject -----------
	
	class ReportSPITObject : public OPPart {
	public:
		static const int	OPFLAG = 31;
		static const int	BYTESLENGTH = 339;
	private:	
		bool		m_Confirmed;
		string		m_SPITObjectID;
		bool		m_Fixed;
		bool		m_ServerRemote;
		string		m_SPITObjectName;
		string		m_SPITTypeID;
		string		m_ServerParams;
		long long	m_FrameStart;
		long long	m_FrameLength;
		long long	m_FrameFadeInLength;
		long long	m_FrameFadeOutLength;
		int			m_ValueFactor;
		char		m_ValueUse;
		int			m_Track;
		string		m_Remark;
		long long	m_Delay;
		long long	m_Duration;
		bool		m_ActionAssigned;
		
		void initMembers();
	public:
		~ReportSPITObject();
		ReportSPITObject(const ReportSPITObject& orig);
		//Receive
		ReportSPITObject(Header* p_Header);
		bool parse(char* p_Bytes, int p_ByteCount);
		
		bool getConfirmed() const {
			return m_Confirmed;
		}
		const string getID() const {
			return m_SPITObjectID;
		}
		bool getFixed() const {
			return m_Fixed;
		}
		bool getServerRemote() const {
			return m_ServerRemote;
		}
		const string getName() const {
			return m_SPITObjectName;
		}
		const string getSPITTypeID() const {
			return m_SPITTypeID;
		}
		const string getServerParams() const {
			return m_ServerParams;
		}
		long long getFrameStart() const {
			return m_FrameStart;
		}
		long long getFrameLength() const {
			return m_FrameLength;
		}
		long long getFrameFadeInLength() const {
			return m_FrameFadeInLength;
		}
		long long getFrameFadeOutLength() const {
			return m_FrameFadeOutLength;
		}
		int getValueFactor() const {
			return m_ValueFactor;
		}
		char getValueUse() const {
			return m_ValueUse;
		}
		int getTrack() const {
			return m_Track;
		}
		const string getRemark() const {
			return m_Remark;
		}
		long long getDelay() const {
			return m_Delay;
		}
		long long getDuration() const {
			return m_Duration;
		}
		bool getActionAssigned() const {
			return m_ActionAssigned;
		}
		// Send
	public:
		ReportSPITObject();
		
		void setConfirmed(bool p_Confirmed);
		void setID(string p_ID);
		void setFixed(bool p_Fixed);
		void setServerRemote(bool p_IsRemote);
		void setName(string p_Name);
		void setSPITTypeID(string p_ID);
		void setServerParams(string p_Parameters);
		void setFrameStart(long long p_StartTime);
		void setFrameLength(long long p_Length);
		void setFrameFadeInLength(long long p_FadeInTime);
		void setFrameFadeOutLength(long long p_FadeOutTime);
		void setValueFactor(int p_Volume);
		void setValueUse(char p_ValueUse);
		void setTrack(int p_Track);
		void setRemark(string p_Description);
		void setDelay(long long p_Delay);
		void setDuration(long long p_Duration);
		void setActionAssigned(bool p_ActionAssigned);
		bool fillBytes(char* p_MessageBytes, int p_ByteCount);
	};

//----------- RemoveSPITObject -----------
	
	class RemoveSPITObject : public OPPart {
	public:
		static const int	OPFLAG = 33;
		static const int	BYTESLENGTH = 45;
	private:
		string	m_SPITObjectID;
		
		void initMembers();
	public:
		~RemoveSPITObject();
		RemoveSPITObject(const RemoveSPITObject& orig);
		//Receive
		RemoveSPITObject(Header* p_Header);
		bool parse(char* p_Bytes, int p_ByteCount);
		
		const string getID() const {
			return m_SPITObjectID;
		}
		// Send
	public:
		RemoveSPITObject();	
		void setID(string p_ID);
		bool fillBytes(char* p_MessageBytes, int p_ByteCount);
	};
	
//---------------------------- SPITPlayer ----------------------------------

//----------- PlaySPITStart -----------
	
	class PlaySPITStart : public OPPart {
	public:
		static const int	OPFLAG = 37;
		static const int	BYTESLENGTH = 119;
	private:		
		string		m_PlayerID;
		string		m_PlayerName;
		char		m_PlayerType;
		bool		m_PlayerIsRunning;
		long long	m_Time; //Frames
		
		void initMembers();
	public:
		~PlaySPITStart();
		PlaySPITStart(const PlaySPITStart& orig);
		//Receive
		PlaySPITStart(Header* p_Header);
		bool parse(char* p_Bytes, int p_ByteCount);
		
		const string getPlayerID() const {
			return m_PlayerID;
		}
		const string getPlayerName() const {
			return m_PlayerName;
		}
		char getPlayerType() const {
			return m_PlayerType;
		}
		bool getPlayerIsRunning() const {
			return m_PlayerIsRunning;
		}
		long long getTime() const {
			return m_Time;
		}
		
		// Send
	public:
		PlaySPITStart();
		
		void setPlayerID(string p_PlayerID);
		void setPlayerName(string p_PlayerName);
		void setPlayerType(char p_PlayerType);
		void setPlayerIsRunning(bool p_IsPlaying);
		void setTime(long long p_Time);
		bool fillBytes(char* p_MessageBytes, int p_ByteCount);
	};
	
//----------- PlaySPITObject -----------
	
	class PlaySPITObject : public OPPart {
	public:
		static const int	OPFLAG = 38;
		static const int	BYTESLENGTH = 100;
	private:
		string		m_PlayerID;
		string		m_SPITObjectID;
		long long	m_FrameInsideObject; //Frames
		bool		m_PlayPrePosition;
		int			m_Value;
		char		m_ValueFlag;
		
		void initMembers();
	public:
		~PlaySPITObject();
		PlaySPITObject(const PlaySPITObject& orig);
		//Receive
		PlaySPITObject(Header* p_Header);
		bool parse(char* p_Bytes, int p_ByteCount);
		
		const string getPlayerID() const {
			return m_PlayerID;
		} 
		const string getSPITObjectID() const {
			return m_SPITObjectID;
		}
		long long getFrameInsideObject() const {
			return m_FrameInsideObject;
		}
		bool getPlayPrePosition() const {
			return m_PlayPrePosition;
		}
		int getValue() const {
			return m_Value;
		}
		char getValueFlag() const {
			return m_ValueFlag;
		}
		// Send
		PlaySPITObject();
		
		void setPlayerID(string p_PlayerID);
		void setID(string p_ID);
		void setFrameInsideObject(long long p_TimeInside);
		void setPlayPrePosition(bool p_PlayOldPosition);
		void setValue(int p_Value);
		void setValueFlag(char p_ValueFlag);
		bool fillBytes(char* p_MessageBytes, int p_ByteCount);
	};
	
//----------- PlaySPITEnd -----------
	class PlaySPITEnd : public OPPart {
	public:
		static const int	OPFLAG = 39;
		static const int	BYTESLENGTH = 45;
	private:
		string	m_PlayerID;
		
		void initMembers();
	public:
		~PlaySPITEnd();
		PlaySPITEnd(const PlaySPITEnd& orig);
		//Receive
		PlaySPITEnd(Header* p_Header);
		bool parse(char* p_Bytes, int p_ByteCount);
		
		const string getPlayerID() const {
			return m_PlayerID;
		}
		// Send
	public:
		PlaySPITEnd();		
		void setPlayerID(string p_PlayerID);
		bool fillBytes(char* p_MessageBytes, int p_ByteCount);
	};
	
	
//----------- ReportPlayStatus -----------
	
	class ReportPlayStatus : public OPPart {
	public:
		static const int	OPFLAG = 40;
		static const int	BYTESLENGTH = 57;
	private:
		string		m_SPITObjectID;
		long long	m_FrameInsideObject; //Frames
		int			m_Value;
		
		void initMembers();
	public:
		~ReportPlayStatus();
		ReportPlayStatus(const ReportPlayStatus& orig);
		//Receive
		ReportPlayStatus(Header* p_Header);
		bool parse(char* p_Bytes, int p_ByteCount);
		
		const string getID() const {
			return m_SPITObjectID;
		}
		long long getFrameInsideObject() const {
			return m_FrameInsideObject;
		}
		int getValue() const {
			return m_Value;
		}
		// Send
		ReportPlayStatus();
		
		void setID(string p_ID);
		void setFrameInsideObject(long long p_TimeInside);
		void setValue(int p_Value);
		bool fillBytes(char* p_MessageBytes, int p_ByteCount);
	};
	
	
	
	
//----------------------- static helper functions ----------------------------
public:
	static bool isSystemLittleEndian();
	static int getInt(char* p_Bytes, int p_ByteCount, int p_Offset);
	static int setInt(int p_Value, char* p_Bytes, int p_ByteCount, int p_Offset);
	static long long getLong(char* p_Bytes, int p_ByteCount, int p_Offset);
	static int setLong(long long p_Value, char* p_Bytes, int p_ByteCount, int p_Offset);
	static bool getBoolean(char* p_Bytes, int p_ByteCount, int p_Offset);
	static int setBoolean(bool p_Value, char* p_Bytes, int p_ByteCount, int p_Offset);
	static char getByte(char* p_Bytes, int p_ByteCount, int p_Offset);
	static int setByte(int p_Value, char* p_Bytes, int p_ByteCount, int p_Offset);
	/**
	 * Returns the string char* of the part of the byte sequence (0x00 null terminated).
	 * @param p_Bytes the byte array
	 * @param p_Offset the startposition of strings bytes
	 * @param p_Length the length of the string included the null terminate byte (0x00).<br>
	 * The length of the string will be p_Length -1.
	 * @return the String char*
	 * @throws Exception  if p_Bytes == null<br>
	 * p_Offset less than 0<br>
	 * p_Bytes.length less than p_Offset + p_Length<br>
	 * No 0x00 null terminate byte is found
	 */
	static string getString(char* p_Bytes, int p_ByteCount, int p_Offset, int p_Length);
	
	/**
	 * Fill the p_String in the byte array.<br>
	 * If p_String length is greater than p_Length -1, the p_String will be truncated.
	 * CAUTION the return value should be freed after use. 
	 * @param p_String the string
	 * @param p_Bytes the byte array where the string is filled
	 * @param p_Offset the offset inside the byte array
	 * @param p_Length the maximal length of the string included the null character.<br>
	 * @throws Exception if p_String == NULL, p_Bytes == NULL<br>
	 * p_Offset less than 0<br>
	 * p_ByteCount less than p_Offset + p_Length
	 * @return p_Length
	 */
	static int setString(string p_String, char* p_Bytes, int p_ByteCount, int p_Offset, int p_Length);
	/**
	 * Compares two strings for equality.
	 * @param p_String1 string terminated by null character
	 * @param p_String2 string terminated by null character
	 * @return true if both strings are equal<br>
	 * false if the strings are NULL or not equal or not terminated by "\0"
	 */
//	static bool stringEqual(const char* p_String1, const char* p_String2);
//	static char* stringCopy(const char* p_String);
	static char* createByteArray(const OPPart* p_OPPart, int* p_BytesCount);
};
#endif /* SPIT_MESSAGE_H */

	
	