/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/* 
 * SPITType describes a SPIT Type
 * File:   SPITType.cpp
 * Author: Hagi
 * 
 * Created on 8. April 2019, 08:40
 * Changed on 13. December 2022
 */


#include "SPITType.h"
#include "_SPITMACROS.h"

	unordered_map<string, SPITType*> SPITType::s_SPITTypes;
	unordered_map<string, SPITType*> SPITType::s_SPITTypesRemote;
	recursive_mutex SPITType::s_MutexSPITType; 	
	
	SPITType* SPITType::getSPITType(string p_ID) {
		{
			unique_lock<recursive_mutex> o_LockType(s_MutexSPITType);
			auto i = s_SPITTypes.find(p_ID);
			if (i == s_SPITTypes.end()) {
				return NULL;
			}
			return i->second;
		}
	}
	/**
	 * Returns the reference of the SPITType with ID == p_ID.<br>
	 * Throws an exception if no SPITType is not found.<br>
	 * @param p_ID the ID
	 * @return reference of the SPITType with ID == p_ID
	 */
	const SPITType& SPITType::getSPITTypeRef(string p_ID) {
		{
			unique_lock<recursive_mutex> o_LockType(s_MutexSPITType);
			auto i = s_SPITTypes.find(p_ID);
			if (i == s_SPITTypes.end()) {
				throw "SPITType no SPITType with given ID";
			}
			return *(i->second);
		}
	}

	SPITType* SPITType::getSPITTypeRemote(string p_ID) {
		{
			unique_lock<recursive_mutex> o_LockType(s_MutexSPITType);
			auto i = s_SPITTypesRemote.find(p_ID);
			if (i == s_SPITTypesRemote.end()) {
				return NULL;
			}
			return i->second;
		}
	}
	/**
	 * Returns the reference of the remote SPITType with ID == p_ID.<br>
	 * Throws an exception if no SPITType is not found.<br>
	 * @param p_ID the ID
	 * @return reference of the SPITType with ID == p_ID
	 */
	const SPITType& SPITType::getSPITTypeRemoteRef(string p_ID) {
		{
			unique_lock<recursive_mutex> o_LockType(s_MutexSPITType);
			auto i = s_SPITTypesRemote.find(p_ID);
			if (i == s_SPITTypesRemote.end()) {
				throw "Remote SPITType no SPITType with given ID";
			}
			return *(i->second);
		}
	}

	bool SPITType::addSPITType(SPITType* p_ptrSpitType) {
		if (p_ptrSpitType == NULL) return false;
		{
			unique_lock<recursive_mutex> o_LockType(s_MutexSPITType);
			s_SPITTypes[p_ptrSpitType->getID()] = p_ptrSpitType;
			return true;
		}
	}
	bool SPITType::addSPITTypeRemote(SPITType* p_ptrSpitType) {
		if (p_ptrSpitType == NULL) return false;
		{
			unique_lock<recursive_mutex> o_LockType(s_MutexSPITType);
			s_SPITTypesRemote[p_ptrSpitType->getID()] = p_ptrSpitType;
			return true;
		}
	}
	bool SPITType::removeSPITType(SPITType* p_ptrSpitType) {
		if (p_ptrSpitType == NULL) return false;
		{
			unique_lock<recursive_mutex> o_LockType(s_MutexSPITType);
			auto i = s_SPITTypes.find(p_ptrSpitType->getID());
			if (i == s_SPITTypes.end()) {
				return false;
			}
			i = s_SPITTypes.erase(i);
			return true;
		}
	}
	bool SPITType::removeSPITTypeRemote(SPITType* p_ptrSpitType) {
		if (p_ptrSpitType == NULL) return false;
		{
			unique_lock<recursive_mutex> o_LockType(s_MutexSPITType);
			auto i = s_SPITTypesRemote.find(p_ptrSpitType->getID());
			if (i == s_SPITTypesRemote.end()) {
				return false;
			}
			i = s_SPITTypesRemote.erase(i);
			return true;
		}
	}

	int	SPITType::getSPITTypeCount() {
		return s_SPITTypes.size();
	}
	int	SPITType::getSPITTypeRemoteCount() {
		return s_SPITTypesRemote.size();
	}
	SPITType* SPITType::getSPITType(int p_Index) {
		SPITType* ptrSPITType = NULL;	
		{
			unique_lock<recursive_mutex> o_LockType(s_MutexSPITType);
			if (p_Index < (int)s_SPITTypes.size()) {
				unordered_map<string, SPITType*>::iterator i = next(s_SPITTypes.begin(), p_Index);
				ptrSPITType = i->second;
			}
			return ptrSPITType;
		}
	}
	/**
	 * Returns a reference to the SPITType at position p_Index.<br>
	 * Throws an exception if p_Index is out of range.<br>
	 * @param p_Index position
	 * @return  the reference of the SPITType at position. 
	 */
	const SPITType& SPITType::getSPITTypeRef(int p_Index) {
		SPITType* ptrSPITType = NULL;	
		{
			unique_lock<recursive_mutex> o_LockType(s_MutexSPITType);
			if (p_Index >= 0 && p_Index < (int)s_SPITTypes.size()) {
				unordered_map<string, SPITType*>::iterator i = next(s_SPITTypes.begin(), p_Index);
				ptrSPITType = i->second;
				return *ptrSPITType;
			}
			else {
				throw "SPITType index out of range";
			}
		}
	}
	SPITType* SPITType::getSPITTypeRemote(int p_Index) {
		SPITType* ptrSPITType = NULL;
		{
			unique_lock<recursive_mutex> o_LockType(s_MutexSPITType);
			if (p_Index < (int)s_SPITTypesRemote.size()) {
				unordered_map<string, SPITType*>::iterator i = next(s_SPITTypesRemote.begin(), p_Index);
				ptrSPITType = i->second;
			}
			return ptrSPITType;
		}
	}
	/**
	 * Returns a reference to the remote SPITType at position p_Index.<br>
	 * Throws an exception if p_Index is out of range.<br>
	 * @param p_Index position
	 * @return the reference of the SPITType at position. 
	 */
	const SPITType& SPITType::getSPITTypeRemoteRef(int p_Index) {
		SPITType* ptrSPITType = NULL;
		{
			unique_lock<recursive_mutex> o_LockType(s_MutexSPITType);
			if (p_Index >= 0 && p_Index < (int)s_SPITTypesRemote.size()) {
				unordered_map<string, SPITType*>::iterator i = next(s_SPITTypesRemote.begin(), p_Index);
				ptrSPITType = i->second;
				return *ptrSPITType;
			}
			else {
				throw "Remote SPITType index out of range";
			}
		}
	}
	
	void SPITType::clearSPITTypes() {
		SPITType* ptrSPITType;
		{
			unique_lock<recursive_mutex> o_LockType(s_MutexSPITType);
			for (auto i = s_SPITTypes.begin(); i != s_SPITTypes.end(); i++) {
				ptrSPITType = i->second;
				i = s_SPITTypes.erase(i);
				delete ptrSPITType;
				if (i == s_SPITTypes.end()) {
					break;
				}
			}
		}
	}
	void SPITType::clearSPITTypesRemote() {
		SPITType* ptrSPITType;
		{
			unique_lock<recursive_mutex> o_LockType(s_MutexSPITType);
			for (auto i = s_SPITTypesRemote.begin(); i != s_SPITTypesRemote.end(); i++) {
				ptrSPITType = i->second;
				i = s_SPITTypesRemote.erase(i);
				delete ptrSPITType;
				if (i == s_SPITTypesRemote.end()) {
					break;
				}
			}
		}
	}
	
	void SPITType::eventProjectClosed() {
		SPITType* ptrSPITType;
		{
			unique_lock<recursive_mutex> o_LockType(s_MutexSPITType);
			for (auto i = s_SPITTypes.begin(); i != s_SPITTypes.end(); i++) {
				ptrSPITType = i->second;
				if (ptrSPITType->getCreatedByClient() == true) {
					continue;
				}
				i = s_SPITTypes.erase(i);
				delete ptrSPITType;
				if (i == s_SPITTypes.end()) {
					break;
				}
			}
			//Remote
			for (auto i = s_SPITTypesRemote.begin(); i != s_SPITTypesRemote.end(); i++) {
				ptrSPITType = i->second;
				i = s_SPITTypesRemote.erase(i);
				delete ptrSPITType;
				if (i == s_SPITTypesRemote.end()) {
					break;
				}
			}
			
		}
		
	}
	
	/**
	 * Sets confirmed = false for all SPITTypes.<br>
	 * This should be called when the client has loaded a project.<br>
	 */
	void SPITType::setConfirmedFalse() {
		SPITType* ptrSPITType;
		{
			unique_lock<recursive_mutex> o_LockType(s_MutexSPITType);
			for (auto i = s_SPITTypes.begin(); i != s_SPITTypes.end(); i++) {
				ptrSPITType = i->second;
				ptrSPITType->setConfirmed(false);
			}
		}
	}
	
	
	
	
	
	
SPITType::SPITType() {
	initMembers();
}
/*
SPITType::SPITType(const SPITType& orig) {
	m_Confirmed = orig.getConfirmed();
	m_DefaultDelay = orig.getDefaultDelay();
	m_DefaultDuration = orig.getDefaultDuration();
	m_Fixed = orig.getFixed();
	m_GroupName = orig.getGroupName();
	m_ID = orig.getID();
	m_Name = orig.getName();
	m_ServerProjectIndepended = orig.getProjectIndepended();
	m_ServerRemote = orig.getServerRemote();
}
*/
SPITType::SPITType(string p_ID, string p_GroupName, string p_Name, bool p_Fixed, bool p_ProjectIndepended,long long p_DefaultDelay, long long p_DefaultDuration) {
	initMembers();
	m_ActionAssigned = false;
	m_Confirmed = false;
	m_ID = p_ID;
	m_GroupName = p_GroupName;
	m_Name = p_Name;
	m_Fixed = p_Fixed;
	m_ServerProjectIndepended = p_ProjectIndepended;
	m_DefaultDelay = p_DefaultDelay;
	m_DefaultDuration = p_DefaultDuration;
}

SPITType::~SPITType() {
}

void SPITType::initMembers() {
	m_Confirmed = false;
	m_DefaultDelay = 0;
	m_DefaultDuration = 0;
	m_Fixed = false;
	m_GroupName = "";
	m_ID = createGUID();
	m_Name = "";
	m_ServerProjectIndepended = false;
	m_ServerRemote = false;
}



void SPITType::setCreatedByClient(bool p_CreatedByClient) {
	m_CreatedByClient = p_CreatedByClient;
}


	void SPITType::setID(string p_ID) {
		m_ID = p_ID;
	}
	
	/**
	 * This is used by the server and client to tell if the other side has registered the changes.
	 * @param p_Confirmed
	 * @return if m_Confirmed has changed
	 */
	bool SPITType::setConfirmed(bool p_Confirmed) {
		if (m_Confirmed == p_Confirmed) return false;
		m_Confirmed = p_Confirmed;
		return true;
	}
	
	bool SPITType::setGroupName(string p_GroupName) {
		if (m_GroupName == p_GroupName) return false;
		m_GroupName = p_GroupName;
		m_Confirmed = false;
		return true;
	}
	bool SPITType::setName(string p_Name) {
		if (m_Name == p_Name) return false;
		m_Name = p_Name;
		m_Confirmed = false;
		return true;
	}
	bool SPITType::setServerRemote(bool p_BelongstoServer) {
		if (m_ServerRemote == p_BelongstoServer) return false;
		m_ServerRemote = p_BelongstoServer;
		m_Confirmed = false;
		return true;
	}
	bool SPITType::setProjectIndepended(bool p_ProjectIndepended) {
		if (m_ServerProjectIndepended == p_ProjectIndepended) return false;
		m_ServerProjectIndepended = p_ProjectIndepended;
		m_Confirmed = false;
		return true;
	}
	bool SPITType::setFixed(bool p_Fixed) {
		if (m_Fixed == p_Fixed) return false;
		m_Fixed = p_Fixed;
		m_Confirmed = false;
		return true;
	}
	bool SPITType::setDefaultDelay(long long p_Delay) {
		if (m_DefaultDelay == p_Delay) return false;
		m_DefaultDelay = p_Delay;
		m_Confirmed = false;
		return true;
	}
	bool SPITType::setDefaultDuration(long long p_Duration) {
		if (m_DefaultDuration == p_Duration) return false;
		m_DefaultDuration = p_Duration;
		m_Confirmed = false;
		return true;
	}
	
	/**
	 * Virtual construct - means ActionAssigned for SPITTypes is is not implemented in SPITProtocol.<br>
	 * This can used to setActionAssigned to all SPITObjects with this SPITType.<br>
	 * This may be used in the case when the same action should be done for every SPITObject with this SPITType associated.<br>
	 * @return true = the m_ActionAssigned has changed.
	 */
	bool SPITType::setActionAssigned(bool p_ActionAssigned) {
		if (m_ActionAssigned == p_ActionAssigned) return false;
		m_ActionAssigned = p_ActionAssigned;
		m_Confirmed = false;
		return true;
	}

	/**
	 * Set the content of the SPITType as received from the server
	 * @param p_ReportSPITType
	 * @return true = the SPITType is changed<br>
	 * false = the SPITType is NOT changed, because it is not allowed to change. 
	 */
	bool SPITType::setMessageOP(SPIT_Message::ReportSPITType* p_ReportSPITType) {
		bool boolChangeAllowed;
		bool boolChanged = false;
		
		if (m_CreatedByClient == true && m_Fixed == true) {
			boolChangeAllowed = false;
		}
		else {
			boolChangeAllowed = true;
		}
		
		//Confirmation should be changable
		if (m_CreatedByClient) {
			//Server reports a client created SPITType -> the type is confirmed
			m_Confirmed = true;
		}
		else {
			//type is NOT client created -> the client has to confirm the SPITtype
			m_Confirmed = p_ReportSPITType->getConfirmed();
		}
		if (m_DefaultDelay != p_ReportSPITType->getDelay()) {
			if (boolChangeAllowed == false) throw new exception();
			m_DefaultDelay = p_ReportSPITType->getDelay();
			boolChanged = true;
		}
		if (m_DefaultDuration != p_ReportSPITType->getDuration()) {
			if (boolChangeAllowed == false) throw new exception();
			m_DefaultDuration = p_ReportSPITType->getDuration();
			boolChanged = true;
		}
		if (m_Fixed != p_ReportSPITType->getFixed()) {
			if (boolChangeAllowed == false) throw new exception();
			m_Fixed = p_ReportSPITType->getFixed();
			boolChanged = true;
		}
		if (m_GroupName != p_ReportSPITType->getGroupName()) {
			if (boolChangeAllowed == false) throw new exception();
			m_GroupName = p_ReportSPITType->getGroupName();
			boolChanged = true;
		}
		if (m_ID != p_ReportSPITType->getID()) {
			if (boolChangeAllowed == false) throw new exception();
			m_ID = p_ReportSPITType->getID();
			boolChanged = true;
		}
		if (m_Name != p_ReportSPITType->getName()) {
			if (boolChangeAllowed == false) throw new exception();
			m_Name = p_ReportSPITType->getName();
			boolChanged = true;
		}
		if (m_ServerProjectIndepended != p_ReportSPITType->getServerProjectIndepended()) {
			if (boolChangeAllowed == false) throw new exception();
			m_ServerProjectIndepended = p_ReportSPITType->getServerProjectIndepended();
			boolChanged = true;
		}
		if (m_ServerRemote != p_ReportSPITType->getServerRemote()) {
			if (boolChangeAllowed == false) throw new exception();
			m_ServerRemote = p_ReportSPITType->getServerRemote();
			boolChanged = true;
		}
		return boolChanged;
	}
	
	void SPITType::fillMessageOP(SPIT_Message::ReportSPITType* ptrSMReportSPITType) {
		ptrSMReportSPITType->setConfirmed(m_Confirmed);
		ptrSMReportSPITType->setDelay(m_DefaultDelay);
		ptrSMReportSPITType->setDuration(m_DefaultDuration);
		ptrSMReportSPITType->setFixed(m_Fixed);
		ptrSMReportSPITType->setGroupName(m_GroupName);
		ptrSMReportSPITType->setID(m_ID);
		ptrSMReportSPITType->setName(m_Name);
		ptrSMReportSPITType->setServerProjectIndepended(m_ServerProjectIndepended);
		ptrSMReportSPITType->setServerRemote(m_ServerRemote);		
	}
	void SPITType::fillMessageOP(SPIT_Message::RemoveSPITType* ptrSMRemoveSPITType) {
		ptrSMRemoveSPITType->setID(m_ID);
	}
