/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/* 
 * File:   SPITPLayer.h
 * Author: Hagi
 *
 * Created on 30. April 2019, 11:44
 */

#ifndef SPITPLAYER_H
#define SPITPLAYER_H

#include "SPITObject.h"
#include <unordered_map>

class SPITPlayer {
	
//----- PlaySPITType used in PlaySequences: PlaySPITStart, PlaySPITObject,..., PlaySPITEnd ------
	
public:
	class PlaySPITType {
	public:
		PlaySPITType();
		PlaySPITType(SPITPlayer* p_SPITPlayer, string p_SPITObjectID);
		PlaySPITType(const PlaySPITType& orig);
		
		string getSPITTypeID() const {
			return m_SPITTypeID;
		}
		
		void startPlaySequence();
		
		bool getIsNew() const {
			return m_IsNew;
		}
		void setIsNew(bool p_IsNew) {
			m_IsNew = p_IsNew;
		}
		bool getIsPlayed() const {
			return m_IsPlayed;
		}
		void setIsPlayed(bool p_IsPlayed) {
			m_IsPlayed = p_IsPlayed;
		}

		
		string getPlayerID() const {
			return m_PlayerID;
		}
		string getPlayerName() const {
			return m_PlayerName;
		}
		bool getPlayerIsRunning() const {
			return m_PlayerRuns;
		}
		void setPlayerIsRunning(bool p_PlayerRuns) {
			m_PlayerRuns = p_PlayerRuns;
		}

		void setValue(double p_Value) {
			m_Value = p_Value;
		}
		void addValue(double p_Value, double p_ValueFactor) {
			m_Value += (p_Value * p_ValueFactor);
		}
		
		double getValue() const {
			return m_Value;
		}
		
		
	private:
		string		m_PlayerID;
		string		m_PlayerName;
		bool		m_PlayerRuns;
		string		m_SPITTypeID;
		bool		m_IsPlayed;
		bool		m_IsNew;
		
		double		m_Value;
		
		
	};
	

	
//----- SPITPlayer ------
public:
	static recursive_mutex s_Mutex;
	static recursive_mutex* getMutex() {
		return &s_Mutex;
	}
	//list the SPITPlayers
	static unordered_map<string, SPITPlayer*> s_SPITPlayers; //all actual played objects
	static SPITPlayer* getSPITPlayer(string p_PlayerID); //if a player does not exist creates a new one
	static void clearPlayers();
//	static void removeSPITObject(string p_SPITObjectID);
	
	
	SPITPlayer(string p_PlayerID);
	virtual ~SPITPlayer();
	
	
	void startPlaySequence(); //called by SPIT_Client::parsePlaySPITStart
	PlaySPITType* addSPITType_Playing (string p_SPITTypeID); //called by SPIT_Client::parsePlaySPITStart
	void endPlaySequence(); //called by SPIT_Client::parsePlaySPITEnd

	string getID() {
		return m_ID;
	}
	
	unordered_map<string, PlaySPITType*>* getPlaySPITTypes();

	void setIsRunning(bool p_IsRunning);
	bool getIsRunning() {
		return m_IsRunning;
	}
	void setName(string p_Name);
	string getName() {
		return m_Name;
	}
	void setType(char p_Type);
	char getType() {
		return m_Type;
	}
	void setTime(long long p_Frames);
	long long getTime() {
		return m_TimeFrames;
	}
	
	
private:
	string								m_ID;
	string								m_Name;
	char								m_Type;
	unordered_map<string, PlaySPITType*>	m_PlaySPITTypes;
	bool								m_IsRunning;
	long long							m_TimeFrames;
};

#endif /* SPITPLAYER_H */

