/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/* 
 * This class describes a detected SPITServer, found by SAD_Client.<br>
 * File:   SAD_DetectedServer.h
 * Author: Hagi
 *
 * Created on 4. Mai 2019, 13:51
 */

#ifndef SAD_DETECTEDSERVER_H
#define SAD_DETECTEDSERVER_H

#include "SAD_ClientInterface.h"
#include <string>
#include <mutex>
#include <unordered_map>
#include <list>

using namespace std;



class SAD_DetectedServer {
	
public:
	SAD_DetectedServer();
	SAD_DetectedServer(const SAD_DetectedServer& orig) {
			m_ID = orig.getID();
			m_Name = orig.getName();
			m_ComputerName = orig.getComputerName();
			m_IP = orig.getIP();
			m_IPIsLoopback = orig.getIpIsLoopback();
			m_IPIsIP4 = orig.getIpIsIP4();
			m_IPIsIP6 = orig.getIpIsIP6();
			m_ClientIP = orig.getClientIP();
			m_Port = orig.getPort();
			m_Additions = orig.getAdditions();
	}
	~SAD_DetectedServer();
	
	private:
		string	m_ID;
		string	m_Name;
		string	m_ComputerName;
		string	m_IP;
		bool	m_IPIsLoopback;
		bool	m_IPIsIP4;
		bool	m_IPIsIP6;
		string	m_ClientIP;
		string	m_Port;
		string	m_Additions;
		string	m_ServerProjectName;
		bool	m_New;
		bool	m_Changed;
		bool	m_FoundAgain;
		
	public:
		/**
		 * 
		 * @return ID of the SPITServer 
		 */
		string getID() const {
			return m_ID;
		}
		/**
		 * 
		 * @return name of the SPITServer 
		 */
		string getName() const {
			return m_Name;
		}
		/**
		 * 
		 * @return name of the computer where the SPITServer runs 
		 */
		string getComputerName() const {
			return m_ComputerName;
		}
		/**
		 * @return IP address at which the server can be reached  
		 */
		string getIP() const {
			return m_IP;
		}
		/**
		 * @return true = the SPITServer's IP address is a loopback address
		 */
		bool getIpIsLoopback() const {
			return m_IPIsLoopback;
		}
		/**
		 * @return true = the SPITServer's IP address is an IP4 address
		 */
		bool getIpIsIP4() const {
			return m_IPIsIP4;
		}
		/**
		 * @return true = the SPITServer's IP address is an IP6 address
		 */
		bool getIpIsIP6() const {
			return m_IPIsIP6;
		}
		/**
		 * @return port of the SPITServer 
		 */
		string getPort() const {
			return m_Port;
		}
		/**
		 * 
		 * @return The IP address of the client under which this client reached the server.
		 */
		string getClientIP() const {
			return m_ClientIP;
		}
		/**
		 * Sometimes the SPITServer has additional informations
		 * @return 
		 */
		string getAdditions() const {
			return m_Additions;
		}
		/**
		 * Sometimes the SPITServer project name
		 * @return 
		 */
		string getProjectName() const {
			return m_ServerProjectName;
		}
		
private:
		void setID(string p_ID);
		void setName(string p_Name);
		void setComputerName(string p_ComputerName);
		void setIP(string p_IP);
		void setClientIP(string p_IP);
		void setPort(string p_Port);
		void setAdditions(string p_Additions);
		void setProjectName(string p_ServerProjectName);
		
		void setIPIsLoopback(bool p_IsLoopback) {
			m_IPIsLoopback = p_IsLoopback;
		}
		void setIPIsIP4(bool p_IsIP4) {
			m_IPIsIP4 = p_IsIP4;
		}
		void setIPIsIP6(bool p_IsIP6) {
			m_IPIsIP6 = p_IsIP6;
		}
		
		bool getNew() const {
			return m_New;
		}
		bool getChanged() const {
			return m_Changed;
		}
		bool getFoundAgain() const {
			return m_FoundAgain;
		}
		
		void setChanged() {
			m_Changed = true;
		}
		void setNew(bool p_New) {
			m_New = p_New;
		}
		void setFoundAgain() {
			m_FoundAgain = true;
		}
		//SAD_Client m_ThreadSend will send to Multicast addresses
		void startCycleSAD() {
			m_IPIsLoopback = false;
			m_IPIsIP4 = false;
			m_IPIsIP6 = false;
			m_Changed = false;
			m_FoundAgain = false;
			m_New = false;
		} 
		//SAD_Client m_Thread_Send has paused in the meantime m_ThreadReceive may received messages from servers
		void endCycleSAD() {
			
		}
private:
	static recursive_mutex s_MutexDetectedServer;	
	static unordered_map<string, SAD_DetectedServer*> s_DetectedServers;
public:	
	static const int		PARAMINDEX_PRECODE = 0;
	static const int		PARAMINDEX_SPITTASKID = 1;
	static const int		PARAMINDEX_NAME = 2;
	static const int		PARAMINDEX_ID = 3;
	static const int		PARAMINDEX_COMPUTERNAME = 4;
	static const int		PARAMINDEX_PORT = 5;
	static const int		PARAMINDEX_CLIENTIP = 6;
	static const int		PARAMINDEX_ADDITIONS = 7;
	static const int		PARAMINDEX_SERVERPROJECTNAME = 8;
	static const int		PARAMINDEX_IP = 9;
	/**
	 * Used by SAD_Client to add a found SPITServer - don't use this manually
	 * @param p_IsIP4 true = the server is reached via a IP4 address<br>false = the server is reahed via a IP6 address
	 * @param p_ServerID the id of the server, every instance of a SPITServer has an own id
	 * @param p_ServerParams the server's parameter
	 */
	static void addDetectedServer(bool p_IsIP4, string p_ServerID, string  p_ServerParams[]);
	/**
	 * Used by SAD_Client to remove a SPITServer - don't use this manually
	 * @param p_DetectedServer
	 */
	static void removeDetectedServer(SAD_DetectedServer* p_DetectedServer);
	/**
	 * Used by SAD_Client to clear all found SPITServers - don't use this manually
	 */
	static void clearDetectedServers();
	/**
	 * Used by SAD_Client internally - don't use this manually
	 */
	static void cycleStart();
	/**
	 * Used by SAD_Client internally -don't use this manually
	 * @param p_SADClientInterface
	 */
	static void cycleEnd(SAD_ClientInterface* p_SADClientInterface);	

	/**
	 * Returns a reference of the DetectedServer with the id p_ServerID.<br> 
	 * If no DetectedServer is found an eyception is thrown.
	 * @param p_ServerID the id of the SPITServer
	 * @return the reference of the SAD_DetectedServer instance with getID() == p_ServerID 
	 */
	static const SAD_DetectedServer& getRefDetectedServer(string p_ServerID) {
		SAD_DetectedServer* ptrDetectedServer = NULL;
		{
			unique_lock<recursive_mutex> o_Lock(s_MutexDetectedServer);
			auto i = s_DetectedServers.find(p_ServerID);
			if (i != s_DetectedServers.end()) {
				ptrDetectedServer = i->second;
			}
			if (ptrDetectedServer != NULL) {
				return *ptrDetectedServer;
			}

			throw new exception();
		}
	}

};


#endif /* SAD_DETECTEDSERVER_H */

