/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/* 
 * File:   SAD_ClientInterface.h
 * Author: Hagi
 *
 * Created on 16. April 2019, 13:08
 */

#ifndef SAD_CLIENTINTERFACE_H
#define SAD_CLIENTINTERFACE_H

#include <string>
using namespace std;

class SAD_ClientInterface {
public:
	/**
	 * If a new server was found by the ServerAutoDetect mechanism, this function is called.<br>
	 * To do so the SAD_Client ServerAutoDetect has to be startet - see SAD_Client::startServerAutoDetect.<br>
	 * If a server can be reached via several IP addresses, the IP address is selected according to the following preference:<br>
	 * 1.) If a loopback address is available, it is used.<br>
	 * 2.) If an IP4 address is available, it is used.<br>
	 * 3.) In the other cases the IP6 address is used.<br>
	 * @param p_ID the id of the server (every started server should generate an id)
	 * @param p_Name the name of the SPIT server
	 * @param p_ComputerName the Hostname of the cpmputer on which the SPIT server is running
	 * @param p_IP the selected ip address of the SPIT server
	 * @param p_Port the port of the SPIT server
	 * @param p_Addition sometimes server may have additional informations
	 * @param p_isLoopback the server ip is a loopback address
	 * @param p_IsIP4 the server ip is a ip4 address
	 * @param p_IsIP6 the server ip is a ip6 address
	 */
	virtual void eventServerDetected(string p_ID, string p_Name, string p_ComputerName, string p_IP, string p_Port, string p_Addition, string p_ProjectName, string p_CLientIP, bool p_isLoopback, bool p_IsIP4, bool p_IsIP6) = 0;
	/**
	 * If a SPITServer is not more found, this function is called.
	 * To do so the SAD_Client ServerAutoDetect has to be startet - see SAD_Client::startServerAutoDetect.<br>
	 * @param p_ID the id of the server (every started server should generate an id)
	 * @param p_Name the name of the SPIT server
	 * @param p_ComputerName the Hostname of the cpmputer on which the SPIT server is running
	 * @param p_IP the selected ip address of the SPIT server
	 * @param p_Port the port of the SPIT server
	 * @param p_Addition sometimes server may have additional informations
	 * @param p_isLoopback the server ip is a loopback address
	 * @param p_IsIP4 the server ip is a ip4 address
	 * @param p_IsIP6 the server ip is a ip6 address
	 */
	virtual void eventServerLost(string p_ID, string p_Name, string p_ComputerName, string p_IP, string p_Port, string p_Addition, string p_ProjectName, string p_CLientIP, bool p_isLoopback, bool p_IsIP4, bool p_IsIP6) = 0;
	virtual void eventServerChanged(string p_ID, string p_Name, string p_ComputerName, string p_IP, string p_Port, string p_Addition, string p_ProjectName, string p_CLientIP, bool p_isLoopback, bool p_IsIP4, bool p_IsIP6) = 0;
};

#endif /* SAD_CLIENTINTERFACE_H */

