/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/* 
 * File:   MySPITApp.h
 * Author: Hagi
 *
 * Created on 17. April 2019, 18:24
 */

#ifndef MYAPP_H
#define MYAPP_H

#include "SPIT_Client.h"
#include <string>
#include <chrono>
#include "SPIT_ClientInterface.h"

using namespace std;


class MyApp : SPIT_ClientInterface {
	
public:
	
	//Client's infos is set by the client
	static string	s_ClientName;
	static string	s_ClientProjectID;
	static string	s_ClientProjectName;
	static int		s_ClientDefaultFramesPerSecond;
	
	
	MyApp();
	virtual ~MyApp();
	
	bool checkPossibleConnection(const SAD_DetectedServer& p_DetectedServer);
	void tryConnection(const SAD_DetectedServer& p_DetectedServer);
	void loadClientProject();
	
private:
	SPIT_Client*	m_SPIT_Client; //pointer to an instance of the SPIT_Client, which do the main work for you
	
	//MySPITApp client project infos they are transferred after the server send his project infos, see eventProjectReport
	string			m_ClientProjectID; //can be an id or simple the project's name
	string			m_ClientProjectName; //the name of the client's (this) project
	
	//Server's info filled by eventConnectionStatus when SPIT_Client::CONNECTION_OK
	string			m_ServerID;
	string			m_ServerIP;
	string			m_ServerName;
	string			m_ServerComputerName;
	int				m_ServerStepTime;
	
	//Server's project infos filled by eventProjectReport
	string			m_ServerProjectID; 
	string			m_ServerProjectName; 
	int				m_ServerFramesPerSecond; //set when the server reports his project, see eventProjectReport

	
	
	

public:
	//---------- SPIT_ClientInterface -------------
	string getClientProjectID();	//should return the client's project id, maybe the same as project name
	string getClientProjectName();	//should return the client's project name
	SPIT_Client* getSPIT_Client();
	
	//----- ServerAutoDetection -----
	void startServerAutoDetect(); //starts the autodetection of SPITServers in the local network area (see eventServerDetected)
	void stopServerAutoDetect(); //stopps the autodetection
	void eventServerDetected(const SAD_DetectedServer& p_DetectedServer);	//a SPITServer is detected
	void eventServerLost(const SAD_DetectedServer& p_DetectedServer);		//a prior detected SPITServer is lost
	void eventServerChanged(const SAD_DetectedServer& p_DetectedServer);		//a prior detected SPITServer is lost
	
	//----- Connection -----	
	void eventConnectionStatus(string p_ServerID, string p_ServerComputerName, string p_ServerName, int p_ServerStepTime, int p_ConnectionStatus, int p_OldConnectionStatus);
	
	//----- Project -----	
	void eventReportProject_Server(string p_ProjectID, string p_ProjectName, int p_FramesPerSeoond);
	void eventProjectClosed_Server(string p_ProjectID);
	
	void eventStartProjectTransfer_Server();
	void eventEndProjectTransfer_Server();
	
	void eventStartProjectTransfer_Client();
	void eventEndProjectTransfer_Client();
	
	//----- SPITType -----	
	bool checkSPITTypeVeto(SPIT_Message::ReportSPITType* p_ReportSPITType);
	void eventSPITType(bool p_New, const SPITType& p_SPITType);
	void eventSPITTypeRemote(bool p_New, const SPITType& p_SPITType);	
	void eventSPITTypeRemoved(const SPITType& p_SPITType);
	void eventSPITTypeRemoteRemoved(const SPITType& p_SPITType);

	//----- SPITObject -----	
	bool checkSPITObjectVeto(SPIT_Message::ReportSPITObject* p_ReportSPITOnject);
	void eventSPITObject(bool p_New, const SPITType& p_SPITType, const SPITObject& p_SPITObject);
	void eventSPITObjectRemote(bool p_New, const SPITType& p_SPITType, const SPITObject& p_SPITObject);
	void eventSPITObjectRemoved(const SPITType& p_SPITType, const SPITObject& p_SPITObject);	
	void eventSPITObjectRemoteRemoved(const SPITType& p_SPITType, const SPITObject& p_SPITObject);

	//----- Play SPITObjects -----	
	void eventPlay(string p_PlayerID, string p_PlayerName, char p_PlayerType, bool p_PlayerIsRunning, long long p_TimeFrames);

	void eventPlaySPITType(string p_PlayerID, string p_SPITTypeID, bool p_PlayerIsRunning, bool p_Started, bool p_Ended, double p_Value);
	
	//----- Server changes status of one of his REMOTE SPITObjects -----	
	//REMOTE only Server->Client RemoteObject's play status
	void eventSPITObjectPlayStatus(const SPITType& p_SPITType, const SPITObject& p_SPITObject, long long p_FrameInsideObject, int p_Value);

	void sendRemoteObject(string p_SPITObjectID, int p_Valueppm = 0, char p_ValueFlag = 0x00);
	//-----
	
	//------ User's options normally should not be used, the server is master of things ------
public:
	//----- SPITType -----
	int removeSPITType(string p_SPITTypeID);
	int changeSPITType(SPITType* p_SPITType);
	
	//----- SPITObject -----
	int removeSPITObject(string p_SPITObjectID);
	int changeSPITObject(SPITObject* p_SPITObject);
	
};

#endif /* MYSPITAPP_H */

