/*
 * Decompiled with CFR 0.152.
 */
package ServerAutoDetectPackage;

import ServerAutoDetectPackage.ServerAutoDetect;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.UUID;

public class ServerAutoDetect_Server {
    public static boolean DEBUGON = false;
    public static String s_ComputerName;
    public static HashMap<String, ServerAutoDetect_Server> s_ServerAutoDetect_Servers;
    public static final Object s_SyncServerAutoDetectServers;
    public static MulticastSocket s_MulticastSocket_IP6;
    public static Runnable s_Runnable_Multicast_IP6;
    public static Thread s_Thread_Multicast_IP6;
    public static boolean s_AutoDetect_IsRunning;
    public static boolean s_IsMulticastRunning_IP6;
    public static boolean s_AutoDetect_Stop;
    private String m_ServerID;
    private String m_ServerTaskID;
    private String m_ServerTaskName;
    private int m_LocalPortConnected;
    private String m_ServerAddition;
    private String m_ServerProjectName;
    private boolean m_StopAutoDetect;
    private boolean m_AutoDetect_IsRunning;
    private Runnable m_Runnable_Loopback_IP4;
    private int m_ServerLoopbackPort;
    private DatagramSocket m_LoopbackSocket_IP4;
    private Thread m_Thread_Loopback_IP4;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startServerAutoDetect(String p_ServerID, String p_ServerTaskID, String p_ServerTaskName, int p_ServerLoopbackPort, int p_LocalPortConnected, String p_ServerAdditon, String p_ServerProjectName) {
        ServerAutoDetect_Server o_ServerAutoDetect_Server;
        if (p_ServerTaskID == null) {
            p_ServerTaskID = "";
        }
        try {
            s_ComputerName = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            s_ComputerName = "";
        }
        Object object = s_SyncServerAutoDetectServers;
        synchronized (object) {
            o_ServerAutoDetect_Server = ServerAutoDetect_Server.getServerAutoDetect_Server(p_ServerID);
            if (o_ServerAutoDetect_Server == null) {
                o_ServerAutoDetect_Server = new ServerAutoDetect_Server(p_ServerID, p_ServerTaskID, p_ServerTaskName, p_ServerLoopbackPort, p_LocalPortConnected, p_ServerAdditon, p_ServerProjectName);
                s_ServerAutoDetect_Servers.put(p_ServerID, o_ServerAutoDetect_Server);
            } else {
                o_ServerAutoDetect_Server.setServerProjectName(p_ServerProjectName);
            }
        }
        o_ServerAutoDetect_Server.startDetection();
        ServerAutoDetect_Server.startServerAutoDetect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServerAutoDetect_Server getServerAutoDetect_Server(String p_ServerID) {
        if (p_ServerID == null) {
            return null;
        }
        Object object = s_SyncServerAutoDetectServers;
        synchronized (object) {
            ServerAutoDetect_Server o_ServerAutoDetect_Server = s_ServerAutoDetect_Servers.get(p_ServerID);
            return o_ServerAutoDetect_Server;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<ServerAutoDetect_Server> getServersByTaskID(ArrayList<ServerAutoDetect_Server> p_Servers, String p_TaskID) {
        Object object = s_SyncServerAutoDetectServers;
        synchronized (object) {
            if (p_Servers == null) {
                p_Servers = new ArrayList();
            } else {
                p_Servers.clear();
            }
            if (p_TaskID == null) {
                return p_Servers;
            }
            for (ServerAutoDetect_Server o_ServerAutoDetect_Server : s_ServerAutoDetect_Servers.values()) {
                if (o_ServerAutoDetect_Server == null || !p_TaskID.equals(o_ServerAutoDetect_Server.getServerTaskID()) || o_ServerAutoDetect_Server.getStopDetect()) continue;
                p_Servers.add(o_ServerAutoDetect_Server);
            }
        }
        return p_Servers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopServerAutoDetect(String p_ServerID) {
        ServerAutoDetect_Server o_ServerAutoDetect_Server = null;
        Object object = s_SyncServerAutoDetectServers;
        synchronized (object) {
            try {
                o_ServerAutoDetect_Server = ServerAutoDetect_Server.getServerAutoDetect_Server(p_ServerID);
                if (o_ServerAutoDetect_Server == null) {
                    return;
                }
                o_ServerAutoDetect_Server.stopDetection();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ServerAutoDetect_Server.removeServerAutoDetect(p_ServerID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeServerAutoDetect(String p_ServerID) {
        ServerAutoDetect_Server o_ServerAutoDetect_Server = ServerAutoDetect_Server.getServerAutoDetect_Server(p_ServerID);
        if (o_ServerAutoDetect_Server == null) {
            return;
        }
        Object object = s_SyncServerAutoDetectServers;
        synchronized (object) {
            o_ServerAutoDetect_Server.stopDetection();
            s_ServerAutoDetect_Servers.remove(p_ServerID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void startServerAutoDetect() {
        Object object = s_SyncServerAutoDetectServers;
        synchronized (object) {
            s_AutoDetect_Stop = false;
            if (s_AutoDetect_IsRunning) {
                return;
            }
            if (ServerAutoDetect.INETADDRESS_MULTICAST_IP6 == null) {
                return;
            }
            ServerAutoDetect_Server.createRunnables();
            s_AutoDetect_IsRunning = true;
            s_Thread_Multicast_IP6 = new Thread(s_Runnable_Multicast_IP6, ServerAutoDetect_Server.class.getSimpleName() + "IP6");
            s_Thread_Multicast_IP6.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopServerAutoDetect() {
        Object object = s_SyncServerAutoDetectServers;
        synchronized (object) {
            s_AutoDetect_Stop = true;
            Iterator<ServerAutoDetect_Server> o_Iterator = s_ServerAutoDetect_Servers.values().iterator();
            while (o_Iterator.hasNext()) {
                ServerAutoDetect_Server o_ServerAutoDetect_Server = o_Iterator.next();
                if (o_ServerAutoDetect_Server != null) {
                    o_ServerAutoDetect_Server.stopDetection();
                }
                o_Iterator.remove();
            }
            s_AutoDetect_IsRunning = false;
        }
    }

    private static void createRunnables() {
        if (s_Runnable_Multicast_IP6 == null) {
            s_Runnable_Multicast_IP6 = new Runnable(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public void run() {
                    if (ServerAutoDetect.INETADDRESS_MULTICAST_IP6 == null) {
                        return;
                    }
                    try {
                        s_MulticastSocket_IP6 = new MulticastSocket(15110);
                        s_MulticastSocket_IP6.setSoTimeout(5000);
                        s_MulticastSocket_IP6.joinGroup(ServerAutoDetect.INETADDRESS_MULTICAST_IP6);
                        if (!DEBUGON) {
                            // empty if block
                        }
                    }
                    catch (Exception e) {
                        if (DEBUGON) {
                            // empty if block
                        }
                        s_IsMulticastRunning_IP6 = false;
                        return;
                    }
                    byte[] byteArray_Received = new byte[15000];
                    DatagramPacket o_DatagramPacket_Received = new DatagramPacket(byteArray_Received, byteArray_Received.length);
                    while (!s_AutoDetect_Stop) {
                        String stringMessage;
                        block25: {
                            s_IsMulticastRunning_IP6 = true;
                            try {
                                s_MulticastSocket_IP6.receive(o_DatagramPacket_Received);
                            }
                            catch (Exception e) {
                                block24: {
                                    if (e instanceof SocketTimeoutException) {
                                        if (!s_AutoDetect_Stop) {
                                            continue;
                                        }
                                    } else if (DEBUGON) {
                                        // empty if block
                                    }
                                    try {
                                        s_MulticastSocket_IP6.leaveGroup(ServerAutoDetect.INETADDRESS_MULTICAST_IP6);
                                        if (s_MulticastSocket_IP6.isClosed()) break block24;
                                        s_MulticastSocket_IP6.close();
                                        if (DEBUGON) {
                                            System.out.println(ServerAutoDetect_Server.class.getSimpleName() + " MulticastSocket_IP6 closed");
                                        }
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                                s_IsMulticastRunning_IP6 = false;
                                return;
                            }
                            try {
                                stringMessage = new String(o_DatagramPacket_Received.getData(), o_DatagramPacket_Received.getOffset(), o_DatagramPacket_Received.getLength(), ServerAutoDetect.CHARSET).trim();
                                if (DEBUGON) break block25;
                            }
                            catch (Exception e) {
                                continue;
                            }
                        }
                        try {
                            if (!stringMessage.startsWith("#SAD#")) {
                            }
                        }
                        catch (Exception e) {}
                        continue;
                        String[] o_StringMessageParts = stringMessage.split("#,#");
                        if (o_StringMessageParts.length < 2) continue;
                        String stringMessageServerTaskID = o_StringMessageParts[1];
                        ServerAutoDetect_Server.sendAnswer(stringMessageServerTaskID, s_MulticastSocket_IP6, o_DatagramPacket_Received.getAddress(), o_DatagramPacket_Received.getPort());
                    }
                    try {
                        s_MulticastSocket_IP6.leaveGroup(ServerAutoDetect.INETADDRESS_MULTICAST_IP6);
                        if (!s_MulticastSocket_IP6.isClosed()) {
                            s_MulticastSocket_IP6.close();
                            if (DEBUGON) {
                                // empty if block
                            }
                        }
                        s_IsMulticastRunning_IP6 = false;
                        return;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
        }
    }

    private static void sendAnswer(String p_ServerTaskID, DatagramSocket p_DatagramSocket, InetAddress p_ClientInetAddress, int p_ClientPort) {
        ArrayList<ServerAutoDetect_Server> o_ServerAutoDetect_Servers = new ArrayList<ServerAutoDetect_Server>();
        StringBuffer stringBufferAnswer = new StringBuffer();
        if ((o_ServerAutoDetect_Servers = ServerAutoDetect_Server.getServersByTaskID(o_ServerAutoDetect_Servers, p_ServerTaskID)) == null || o_ServerAutoDetect_Servers.size() <= 0) {
            return;
        }
        for (int intServer = 0; intServer < o_ServerAutoDetect_Servers.size(); ++intServer) {
            ServerAutoDetect_Server o_ServerAutoDetect_Server = o_ServerAutoDetect_Servers.get(intServer);
            if (o_ServerAutoDetect_Server == null) continue;
            stringBufferAnswer.delete(0, stringBufferAnswer.length());
            stringBufferAnswer.append("#SAD#");
            stringBufferAnswer.append("#,#");
            stringBufferAnswer.append(p_ServerTaskID);
            stringBufferAnswer.append("#,#");
            stringBufferAnswer.append(o_ServerAutoDetect_Server.getServerTaskName());
            stringBufferAnswer.append("#,#");
            stringBufferAnswer.append(o_ServerAutoDetect_Server.getServerID());
            stringBufferAnswer.append("#,#");
            stringBufferAnswer.append(s_ComputerName);
            stringBufferAnswer.append("#,#");
            stringBufferAnswer.append(o_ServerAutoDetect_Server.getLocalPortConnected());
            stringBufferAnswer.append("#,#");
            String stringClientIP = ServerAutoDetect.cleanIPAddress(p_ClientInetAddress.toString());
            stringBufferAnswer.append(stringClientIP);
            String stringServerAddition = o_ServerAutoDetect_Server.getServerAddition();
            if (stringServerAddition == null) {
                stringServerAddition = "";
            }
            stringBufferAnswer.append("#,#");
            stringBufferAnswer.append(stringServerAddition);
            stringBufferAnswer.append("#,#");
            stringBufferAnswer.append(o_ServerAutoDetect_Server.getServerProjectName());
            byte[] byteArray_Send = stringBufferAnswer.toString().getBytes(ServerAutoDetect.CHARSET);
            DatagramPacket o_DatagramPacket_Send = new DatagramPacket(byteArray_Send, byteArray_Send.length, p_ClientInetAddress, p_ClientPort);
            try {
                if (DEBUGON) {
                    System.out.println(ServerAutoDetect_Server.class.getName() + " " + p_ServerTaskID + " send message: ");
                    System.out.println(stringBufferAnswer.toString());
                    System.out.println();
                }
                p_DatagramSocket.send(o_DatagramPacket_Send);
                continue;
            }
            catch (Exception e) {
                if (!DEBUGON) continue;
            }
        }
    }

    public ServerAutoDetect_Server(String p_ServerID, String p_ServerTaskID, String p_ServerTaskName, int p_ServerLoopbackPort, int p_LocalPortConnected, String p_ServerAddition, String p_ServerProjectName) {
        if (p_ServerTaskID == null) {
            p_ServerTaskID = "";
        }
        this.initMembers();
        if (p_ServerID != null) {
            this.m_ServerID = p_ServerID;
        }
        this.m_ServerTaskID = p_ServerTaskID;
        this.m_ServerLoopbackPort = p_ServerLoopbackPort;
        this.m_ServerTaskName = p_ServerTaskName;
        this.m_LocalPortConnected = p_LocalPortConnected;
        this.m_ServerAddition = p_ServerAddition;
        if (this.m_ServerAddition == null) {
            this.m_ServerAddition = "";
        }
        this.m_ServerProjectName = p_ServerProjectName;
        if (this.m_ServerProjectName == null) {
            this.m_ServerProjectName = "";
        }
    }

    private void initMembers() {
        this.m_ServerID = UUID.randomUUID().toString();
        this.m_ServerAddition = "";
        this.m_ServerProjectName = "";
        s_IsMulticastRunning_IP6 = false;
        this.m_StopAutoDetect = false;
        this.m_AutoDetect_IsRunning = false;
    }

    public String getServerID() {
        return this.m_ServerID;
    }

    public String getServerTaskID() {
        return this.m_ServerTaskID;
    }

    public String getServerTaskName() {
        return this.m_ServerTaskName;
    }

    public int getLocalPortConnected() {
        return this.m_LocalPortConnected;
    }

    public void setServerProjectName(String p_ServerProjectName) {
        this.m_ServerProjectName = p_ServerProjectName == null ? "" : p_ServerProjectName;
    }

    public String getServerProjectName() {
        return this.m_ServerProjectName;
    }

    public String getServerAddition() {
        return this.m_ServerAddition;
    }

    public void startDetection() {
        this.m_StopAutoDetect = false;
        if (this.m_AutoDetect_IsRunning) {
            return;
        }
        this.createRunnable();
        this.m_Thread_Loopback_IP4 = new Thread(this.m_Runnable_Loopback_IP4, ServerAutoDetect_Server.class.getSimpleName() + "Loopback_IP4");
        this.m_Thread_Loopback_IP4.start();
    }

    public void stopDetection() {
        this.m_StopAutoDetect = true;
    }

    public boolean getStopDetect() {
        return this.m_StopAutoDetect;
    }

    private void createRunnable() {
        if (this.m_Runnable_Loopback_IP4 == null) {
            this.m_Runnable_Loopback_IP4 = new Runnable(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public void run() {
                    if (ServerAutoDetect.INETADDRESS_LOOPBACK_I\u00dc4 == null) {
                        return;
                    }
                    try {
                        InetSocketAddress o_SocketAddress = new InetSocketAddress(ServerAutoDetect.INETADDRESS_LOOPBACK_I\u00dc4, ServerAutoDetect_Server.this.m_ServerLoopbackPort);
                        ServerAutoDetect_Server.this.m_LoopbackSocket_IP4 = new MulticastSocket(o_SocketAddress);
                        ServerAutoDetect_Server.this.m_LoopbackSocket_IP4.setSoTimeout(5000);
                        ServerAutoDetect_Server.this.m_LoopbackSocket_IP4.setReuseAddress(true);
                        if (!DEBUGON) {
                            // empty if block
                        }
                    }
                    catch (Exception e) {
                        if (!DEBUGON) return;
                        return;
                    }
                    byte[] byteArray_Received = new byte[15000];
                    while (!ServerAutoDetect_Server.this.m_StopAutoDetect) {
                        String stringMessage;
                        DatagramPacket o_DatagramPacket_Received;
                        block22: {
                            ServerAutoDetect_Server.this.m_AutoDetect_IsRunning = true;
                            o_DatagramPacket_Received = new DatagramPacket(byteArray_Received, byteArray_Received.length);
                            try {
                                ServerAutoDetect_Server.this.m_LoopbackSocket_IP4.receive(o_DatagramPacket_Received);
                            }
                            catch (Exception e) {
                                if (e instanceof SocketTimeoutException) {
                                    if (!ServerAutoDetect_Server.this.m_StopAutoDetect) {
                                        continue;
                                    }
                                } else if (DEBUGON) {
                                    // empty if block
                                }
                                try {
                                    if (ServerAutoDetect_Server.this.m_LoopbackSocket_IP4.isClosed()) return;
                                    ServerAutoDetect_Server.this.m_LoopbackSocket_IP4.close();
                                    if (!DEBUGON) return;
                                    System.out.println(ServerAutoDetect_Server.class.getSimpleName() + " LoopbackSocket_IP4 closed");
                                    return;
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                return;
                            }
                            try {
                                stringMessage = new String(o_DatagramPacket_Received.getData(), o_DatagramPacket_Received.getOffset(), o_DatagramPacket_Received.getLength(), ServerAutoDetect.CHARSET).trim();
                                if (DEBUGON) break block22;
                            }
                            catch (Exception e) {
                                continue;
                            }
                        }
                        try {
                            if (!stringMessage.startsWith("#SAD#")) {
                            }
                        }
                        catch (Exception e) {}
                        continue;
                        String[] o_StringMessageParts = stringMessage.split("#,#");
                        if (o_StringMessageParts.length < 2) continue;
                        String stringMessageServerTaskID = o_StringMessageParts[1];
                        ServerAutoDetect_Server.sendAnswer(stringMessageServerTaskID, ServerAutoDetect_Server.this.m_LoopbackSocket_IP4, o_DatagramPacket_Received.getAddress(), o_DatagramPacket_Received.getPort());
                    }
                    try {
                        if (!ServerAutoDetect_Server.this.m_LoopbackSocket_IP4.isClosed()) {
                            ServerAutoDetect_Server.this.m_LoopbackSocket_IP4.close();
                            if (!DEBUGON) {
                                // empty if block
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ServerAutoDetect_Server.this.m_AutoDetect_IsRunning = false;
                }
            };
        }
    }

    static {
        s_ServerAutoDetect_Servers = new HashMap();
        s_SyncServerAutoDetectServers = new Object();
        s_AutoDetect_IsRunning = false;
        s_AutoDetect_Stop = false;
    }
}

