/*
 * Decompiled with CFR 0.152.
 */
package SPITModelPackage;

import SPITActionPackage.SPIT_ActionStatus;
import SPITLibraryPackage.SPIT_Object_Interface;
import SPITLibraryPackage.SPIT_TypeDescription;
import SPITLibraryPackage.SPIT_Type_Interface;
import SPITModelPackage.SPIT_TimeTools;
import SPITModelPackage.SPIT_TypeModel;
import SwingModelPackage.TableAndListModel;
import SwingToolTipPackage.JLabel_RightClickToolTip;
import SwingToolTipPackage.PopUpToolTip;
import java.awt.Color;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Comparator;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.RowFilter;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;

public class SPIT_ObjectModel
extends TableAndListModel<SPIT_Object_Interface>
implements PropertyChangeListener {
    public static final int COLUMNCOUNT = 7;
    public static final int COLUMNINDEX_OBJECTPLAYTIME = 0;
    public static final int COLUMNINDEX_OBJECTPLAYVALUE = 1;
    public static final int COLUMNINDEX_OBJECTSTARTTIME = 2;
    public static final int COLUMNINDEX_OBJECTNAME = 3;
    public static final int COLUMNINDEX_OBJECTDELAY = 4;
    public static final int COLUMNINDEX_OBJECTDURATION = 5;
    public static final int COLUMNINDEX_OBJECTSPITTYPE = 6;
    public static String COLUMN_OBJECTPLAYTIME = "Time";
    public static String COLUMN_OBJECTPLAYVALUE = "Value %";
    public static String COLUMN_OBJECTSTARTTIME = "Start";
    public static String COLUMN_OBJECTNAME = "Name";
    public static String COLUMN_OBJECTDELAY = "Delay";
    public static String COLUMN_OBJECTDURATION = "Duration";
    public static String COLUMN_OBJECTSPITTYPE = SPIT_TypeDescription.DEFAULTNAME;
    public static double FRAMESPERSECOND = 44100.0;
    private TableRowSorter m_TableRowSorter;
    private SPITRowFilter m_SPITRowFilter;
    private final Object m_SyncObject = new Object();

    public SPIT_ObjectModel() {
        super(false);
        this.initMembers();
    }

    private void initMembers() {
        this.m_TableRowSorter = new TableRowSorter<SPIT_ObjectModel>(this);
        this.m_SPITRowFilter = new SPITRowFilter(this);
    }

    public TableRowSorter<SPIT_ObjectModel> createTableRowSorter() {
        TableRowSorter<SPIT_ObjectModel> o_TableRowSorter = new TableRowSorter<SPIT_ObjectModel>(this);
        o_TableRowSorter.setComparator(3, new StringComparator_Normal());
        return o_TableRowSorter;
    }

    public SPITRowFilter<SPIT_ObjectModel, Integer> createRowFilter() {
        SPITRowFilter<SPIT_ObjectModel, Integer> o_SPITRowFilter = new SPITRowFilter<SPIT_ObjectModel, Integer>(this);
        return o_SPITRowFilter;
    }

    public void finishJTable(JTable p_JTable) {
        if (p_JTable == null) {
            return;
        }
        this.finishJTable(p_JTable, this.createRowFilter());
    }

    public void finishJTable(JTable p_JTable, RowFilter p_RowFilter) {
        TableAndListModel.TableCellEditorRenderer_Time o_TableCellEditorRenderer_Time;
        TableAndListModel.TableCellEditorRenderer_String o_TableCellEditorRenderer_String;
        if (p_JTable == null) {
            return;
        }
        super.finishJTable(p_JTable, this.createTableRowSorter(), p_RowFilter);
        TableColumnModel o_TableColumnModel = p_JTable.getColumnModel();
        TableColumn o_TableColumn = o_TableColumnModel.getColumn(3);
        if (o_TableColumn != null) {
            o_TableCellEditorRenderer_String = new SPITObjectTableCellRenderer();
            o_TableCellEditorRenderer_String.setToolTipText_Automatic(1);
            o_TableCellEditorRenderer_String.setToolTipTextAt(false, true);
            o_TableColumn.setCellEditor((TableCellEditor)o_TableCellEditorRenderer_String);
            o_TableColumn.setCellRenderer((TableCellRenderer)o_TableCellEditorRenderer_String);
        }
        if ((o_TableColumn = o_TableColumnModel.getColumn(6)) != null) {
            o_TableCellEditorRenderer_String = new SPIT_TypeModel.SPITTypeTableCellRenderer();
            o_TableCellEditorRenderer_String.setToolTipText_Automatic(1);
            o_TableCellEditorRenderer_String.setToolTipTextAt(false, true);
            o_TableColumn.setCellEditor((TableCellEditor)o_TableCellEditorRenderer_String);
            o_TableColumn.setCellRenderer((TableCellRenderer)o_TableCellEditorRenderer_String);
        }
        if ((o_TableColumn = o_TableColumnModel.getColumn(4)) != null) {
            o_TableColumn.setMinWidth(100);
            o_TableColumn.setMaxWidth(100);
            o_TableColumn.setPreferredWidth(100);
            o_TableColumn.setResizable(false);
            o_TableCellEditorRenderer_Time = new TableAndListModel.TableCellEditorRenderer_Time();
            o_TableCellEditorRenderer_Time.setToolTipText_Automatic(1);
            o_TableCellEditorRenderer_Time.setToolTipTextAt(false, true);
            o_TableColumn.setCellEditor((TableCellEditor)o_TableCellEditorRenderer_Time);
            o_TableColumn.setCellRenderer((TableCellRenderer)o_TableCellEditorRenderer_Time);
        }
        if ((o_TableColumn = o_TableColumnModel.getColumn(5)) != null) {
            o_TableColumn.setMinWidth(100);
            o_TableColumn.setMaxWidth(100);
            o_TableColumn.setPreferredWidth(100);
            o_TableColumn.setResizable(false);
            o_TableCellEditorRenderer_Time = new TableAndListModel.TableCellEditorRenderer_Time();
            o_TableCellEditorRenderer_Time.setToolTipText_Automatic(1);
            o_TableCellEditorRenderer_Time.setToolTipTextAt(false, true);
            o_TableColumn.setCellEditor((TableCellEditor)o_TableCellEditorRenderer_Time);
            o_TableColumn.setCellRenderer((TableCellRenderer)o_TableCellEditorRenderer_Time);
        }
        if ((o_TableColumn = o_TableColumnModel.getColumn(2)) != null) {
            o_TableColumn.setMinWidth(110);
            o_TableColumn.setMaxWidth(110);
            o_TableColumn.setPreferredWidth(110);
            o_TableColumn.setResizable(false);
            o_TableCellEditorRenderer_Time = new TableAndListModel.TableCellEditorRenderer_Time();
            o_TableCellEditorRenderer_Time.setToolTipText_Automatic(1);
            o_TableCellEditorRenderer_Time.setToolTipTextAt(false, true);
            o_TableColumn.setCellEditor((TableCellEditor)o_TableCellEditorRenderer_Time);
            o_TableColumn.setCellRenderer((TableCellRenderer)o_TableCellEditorRenderer_Time);
        }
        if ((o_TableColumn = o_TableColumnModel.getColumn(0)) != null) {
            o_TableColumn.setMinWidth(110);
            o_TableColumn.setMaxWidth(110);
            o_TableColumn.setPreferredWidth(110);
            o_TableColumn.setResizable(false);
            o_TableCellEditorRenderer_Time = new TableAndListModel.TableCellEditorRenderer_Time();
            o_TableCellEditorRenderer_Time.setToolTipText_Automatic(1);
            o_TableCellEditorRenderer_Time.setToolTipTextAt(false, true);
            o_TableColumn.setCellEditor((TableCellEditor)o_TableCellEditorRenderer_Time);
            o_TableColumn.setCellRenderer((TableCellRenderer)o_TableCellEditorRenderer_Time);
        }
        if ((o_TableColumn = o_TableColumnModel.getColumn(1)) != null) {
            o_TableColumn.setMinWidth(80);
            o_TableColumn.setMaxWidth(80);
            o_TableColumn.setPreferredWidth(80);
            o_TableColumn.setResizable(false);
            TableAndListModel.TableCellEditorRenderer_Integer o_TableCellEditorRenderer_Integer = new TableAndListModel.TableCellEditorRenderer_Integer();
            o_TableCellEditorRenderer_Integer.setAllowNegativeNumbers(false);
            o_TableCellEditorRenderer_Integer.setToolTipText_Automatic(1);
            o_TableCellEditorRenderer_Integer.setToolTipTextAt(false, true);
            o_TableColumn.setCellEditor((TableCellEditor)o_TableCellEditorRenderer_Integer);
            o_TableColumn.setCellRenderer((TableCellRenderer)o_TableCellEditorRenderer_Integer);
        }
        p_JTable.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.m_SyncObject;
        synchronized (object) {
            super.clear();
        }
    }

    public boolean contains(String p_ID) {
        if (p_ID == null) {
            return false;
        }
        SPIT_Object_Interface o_SPIT_Object_Interface = this.getSPIT_Object(p_ID);
        return o_SPIT_Object_Interface != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SPIT_Object_Interface getSPIT_Object(String p_ID) {
        Object object = this.m_SyncObject;
        synchronized (object) {
            for (int intObject = 0; intObject < this.size(); ++intObject) {
                SPIT_Object_Interface o_SPIT_Object_Interface = (SPIT_Object_Interface)this.get(intObject);
                if (o_SPIT_Object_Interface == null || !p_ID.equals(o_SPIT_Object_Interface.getID())) continue;
                return o_SPIT_Object_Interface;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addSPIT_Object(SPIT_Object_Interface p_SPIT_Object_Interface) {
        if (p_SPIT_Object_Interface == null) {
            return false;
        }
        boolean boolAdded = true;
        Object object = this.m_SyncObject;
        synchronized (object) {
            boolAdded = this.getSPIT_Object(p_SPIT_Object_Interface.getID()) != null ? false : this.addElement(p_SPIT_Object_Interface);
            if (boolAdded) {
                p_SPIT_Object_Interface.addPropertyChangeListener(this);
            }
        }
        return boolAdded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeSPIT_Object(SPIT_Object_Interface p_SPIT_Object_Interface) {
        if (p_SPIT_Object_Interface == null) {
            return false;
        }
        if (!super.contains((Object)p_SPIT_Object_Interface)) {
            return false;
        }
        Object object = this.m_SyncObject;
        synchronized (object) {
            this.removeElement(p_SPIT_Object_Interface);
            p_SPIT_Object_Interface.removePropertyChangeListener(this);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSelectedSPIT_Object(JTable p_JTable, SPIT_Object_Interface p_SPIT_Object_Interface) {
        if (p_JTable == null) {
            return;
        }
        if (p_SPIT_Object_Interface == null) {
            return;
        }
        Object object = this.m_SyncObject;
        synchronized (object) {
            super.addSelectedElement(p_JTable, (Object)p_SPIT_Object_Interface);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSelectedSPIT_Object(JTable p_JTable, SPIT_Object_Interface p_SPIT_Object_Interface) {
        if (p_JTable == null) {
            return;
        }
        if (p_SPIT_Object_Interface == null) {
            return;
        }
        Object object = this.m_SyncObject;
        synchronized (object) {
            super.removeSelectedElement(p_JTable, (Object)p_SPIT_Object_Interface);
        }
    }

    public SPIT_Object_Interface getSPIT_Object(int p_Index) {
        if (p_Index < 0) {
            return null;
        }
        return (SPIT_Object_Interface)super.get(p_Index);
    }

    public int getColumnCount() {
        return 7;
    }

    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return COLUMN_OBJECTPLAYTIME;
            }
            case 1: {
                return COLUMN_OBJECTPLAYVALUE;
            }
            case 2: {
                return COLUMN_OBJECTSTARTTIME;
            }
            case 3: {
                return COLUMN_OBJECTNAME;
            }
            case 4: {
                return COLUMN_OBJECTDELAY;
            }
            case 5: {
                return COLUMN_OBJECTDURATION;
            }
            case 6: {
                return COLUMN_OBJECTSPITTYPE;
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValue(SPIT_Object_Interface p_SPIT_Object_Interface, int columnIndex) {
        if (p_SPIT_Object_Interface == null) {
            return "";
        }
        String stringValue = "";
        Object object = this.m_SyncObject;
        synchronized (object) {
            SPIT_ActionStatus o_SPIT_ActionStatus = p_SPIT_Object_Interface.getSPIT_ActionStatus();
            if (o_SPIT_ActionStatus == null) {
                return "";
            }
            switch (columnIndex) {
                case 0: {
                    if (o_SPIT_ActionStatus.getPlayFrameInside() < 0L) {
                        stringValue = "";
                        break;
                    }
                    stringValue = SPIT_TimeTools.getTimeStringFromFrames(o_SPIT_ActionStatus.getPlayFrameInside(), FRAMESPERSECOND);
                    break;
                }
                case 1: {
                    if (o_SPIT_ActionStatus.getPlayValue() == 0) {
                        stringValue = "";
                        break;
                    }
                    stringValue = String.valueOf((int)((float)o_SPIT_ActionStatus.getPlayValue() * ((float)p_SPIT_Object_Interface.getValueFactor() / 1000000.0f) / 10000.0f));
                    break;
                }
                case 2: {
                    stringValue = SPIT_TimeTools.getTimeStringFromFrames(p_SPIT_Object_Interface.getFrameStart(), FRAMESPERSECOND);
                    break;
                }
                case 3: {
                    stringValue = p_SPIT_Object_Interface.getName();
                    break;
                }
                case 4: {
                    stringValue = SPIT_TimeTools.getTimeStringFromFrames(p_SPIT_Object_Interface.getDelay(), FRAMESPERSECOND);
                    break;
                }
                case 5: {
                    stringValue = SPIT_TimeTools.getTimeStringFromFrames(p_SPIT_Object_Interface.getDuration(), FRAMESPERSECOND);
                    break;
                }
                case 6: {
                    SPIT_Type_Interface o_SPIT_Type_Interface = p_SPIT_Object_Interface.getSPIT_Type();
                    if (o_SPIT_Type_Interface == null) {
                        return "";
                    }
                    stringValue = o_SPIT_Type_Interface.getName();
                }
            }
            return stringValue;
        }
    }

    public boolean isCellEditable(int row, int col) {
        switch (col) {
            case 2: {
                return false;
            }
            case 3: {
                return true;
            }
            case 6: {
                return false;
            }
            case 4: {
                return true;
            }
            case 5: {
                return true;
            }
        }
        return false;
    }

    public void setValue(SPIT_Object_Interface p_SPIT_Object_Interface, Object value, int col) {
        if (p_SPIT_Object_Interface == null) {
            return;
        }
        if (!(value instanceof String)) {
            return;
        }
        switch (col) {
            case 3: {
                String stringValue = (String)value;
                p_SPIT_Object_Interface.setName(stringValue);
                break;
            }
            case 4: {
                String stringValue = (String)value;
                long longFrames = SPIT_TimeTools.getFramesFromTimeString(stringValue, FRAMESPERSECOND);
                p_SPIT_Object_Interface.setDelay(longFrames);
                break;
            }
            case 5: {
                String stringValue = (String)value;
                long longFrames = SPIT_TimeTools.getFramesFromTimeString(stringValue, FRAMESPERSECOND);
                p_SPIT_Object_Interface.setDuration(longFrames);
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() instanceof SPIT_Object_Interface) {
            SPIT_Object_Interface o_SPIT_Object_Interface = (SPIT_Object_Interface)evt.getSource();
            if ("paramchanged".equals(evt.getPropertyName())) {
                super.changedElement((Object)o_SPIT_Object_Interface);
            } else if ("confirmed".equals(evt.getPropertyName())) {
                super.changedElement((Object)o_SPIT_Object_Interface);
            } else if ("actionassigned".equals(evt.getPropertyName())) {
                super.changedElement((Object)o_SPIT_Object_Interface);
            }
        }
    }

    public static class SPITObjectTableCellRenderer
    extends TableAndListModel.TableCellEditorRenderer_String {
        public static Color s_NotConfirmedColor = new Color(255, 0, 0);
        public static Color s_FIXEDColor = new Color(0, 100, 0);

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel_RightClickToolTip o_JLable = (JLabel_RightClickToolTip)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (table.getModel() instanceof SPIT_ObjectModel) {
                SPIT_Object_Interface o_SPIT_Object_Interface;
                SPIT_ObjectModel o_SPITObjectTableModel = (SPIT_ObjectModel)((Object)table.getModel());
                try {
                    int intRowModel = table.convertRowIndexToModel(row);
                    o_SPIT_Object_Interface = (SPIT_Object_Interface)o_SPITObjectTableModel.getElementAt(intRowModel);
                }
                catch (Exception e) {
                    o_SPIT_Object_Interface = null;
                }
                if (o_SPIT_Object_Interface != null) {
                    if (!o_SPIT_Object_Interface.getConfirmed()) {
                        o_JLable.setBackground(s_NotConfirmedColor);
                    }
                    if (o_SPIT_Object_Interface.getRemark().length() > 0) {
                        o_JLable.setToolTipText(o_SPIT_Object_Interface.getRemark());
                        o_JLable.setToolTipText_RightClick(o_SPIT_Object_Interface.getRemark());
                    } else {
                        o_JLable.setToolTipText(null);
                        o_JLable.setToolTipText_RightClick(null);
                    }
                }
            }
            return o_JLable;
        }
    }

    public static class SPITRowFilter<T, INteger>
    extends RowFilter<SPIT_Object_Interface, Integer> {
        private SPIT_ObjectModel m_SPIT_ObjectModel;
        private String m_FilterString;

        public SPITRowFilter(SPIT_ObjectModel p_SPIT_ObjectModel) {
            this.initMembers();
            this.m_SPIT_ObjectModel = p_SPIT_ObjectModel;
        }

        private void initMembers() {
            this.m_FilterString = null;
        }

        public void setFilterString(String p_FilterString) {
            this.m_FilterString = p_FilterString == null ? "" : p_FilterString.toLowerCase();
            if (this.m_SPIT_ObjectModel != null) {
                this.m_SPIT_ObjectModel.fireTableDataChanged();
            }
        }

        @Override
        public boolean include(RowFilter.Entry entry) {
            if (this.m_SPIT_ObjectModel == null) {
                return false;
            }
            int intRow = (Integer)entry.getIdentifier();
            SPIT_Object_Interface o_SPIT_Object_Interface = this.m_SPIT_ObjectModel.getSPIT_Object(intRow);
            if (o_SPIT_Object_Interface == null) {
                return false;
            }
            if (this.m_FilterString == null) {
                return true;
            }
            if (this.m_FilterString.length() <= 0) {
                return true;
            }
            if (o_SPIT_Object_Interface.getName().toLowerCase().contains(this.m_FilterString)) {
                return true;
            }
            SPIT_Type_Interface o_SPIT_Type_Interface = o_SPIT_Object_Interface.getSPIT_Type();
            if (o_SPIT_Type_Interface == null) {
                return false;
            }
            if (o_SPIT_Type_Interface.getGroupName().toLowerCase().contains(this.m_FilterString)) {
                return true;
            }
            return o_SPIT_Type_Interface.getName().toLowerCase().contains(this.m_FilterString);
        }
    }

    public static class StringComparator_NumericInteger
    implements Comparator<String> {
        @Override
        public int compare(String o1, String o2) {
            Integer int2;
            Integer int1;
            if (o1 == null || o2 == null) {
                return 0;
            }
            try {
                int1 = Integer.valueOf(o1.trim());
                int2 = Integer.valueOf(o2.trim());
            }
            catch (Exception e) {
                return 0;
            }
            return int1.compareTo(int2);
        }
    }

    public static class StringComparator_Normal
    implements Comparator<String> {
        @Override
        public int compare(String o1, String o2) {
            if (o1 == null || o2 == null) {
                return 0;
            }
            return o1.compareToIgnoreCase(o2);
        }
    }
}

