/*
 * Decompiled with CFR 0.152.
 */
package LanguageTools.FlagsPackage;

import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LanguageTools.LocalePackage.LiveLangageLocaleHandling;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Locale;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class LiveLanguageFlagModel
extends DefaultComboBoxModel {
    ArrayList<LanguageFlagItem> m_Items;

    public LiveLanguageFlagModel(ArrayList<Locale> p_ArrayListLocales) {
        this.initMembers();
        if (p_ArrayListLocales == null) {
            return;
        }
        for (int intLocale = 0; intLocale < p_ArrayListLocales.size(); ++intLocale) {
            Locale o_Locale = p_ArrayListLocales.get(intLocale);
            if (o_Locale == null) continue;
            LanguageFlagItem o_LanguageImageText = new LanguageFlagItem(o_Locale);
            this.addSorted(o_LanguageImageText);
        }
        for (int intItem = 0; intItem < this.m_Items.size(); ++intItem) {
            super.addElement(this.m_Items.get(intItem));
        }
    }

    private void initMembers() {
        this.m_Items = new ArrayList();
    }

    private void addSorted(LanguageFlagItem p_Item) {
        LanguageFlagItem o_FlagItem;
        int intItem;
        if (p_Item == null) {
            return;
        }
        for (intItem = 0; intItem < this.m_Items.size() && !((o_FlagItem = this.m_Items.get(intItem)).getDisplayCountry().length() <= 0 ? p_Item.getDisplayCountry().length() <= 0 && p_Item.getDisplayLanguage().compareToIgnoreCase(o_FlagItem.getDisplayLanguage()) < 0 : p_Item.getDisplayCountry().length() <= 0 || p_Item.getDisplayLanguage().compareToIgnoreCase(o_FlagItem.getDisplayLanguage()) == 0 && p_Item.getDisplayCountry().compareToIgnoreCase(o_FlagItem.getDisplayCountry()) < 0 || p_Item.getDisplayLanguage().compareToIgnoreCase(o_FlagItem.getDisplayLanguage()) < 0); ++intItem) {
        }
        this.m_Items.add(intItem, p_Item);
    }

    @Override
    public LanguageFlagItem getElementAt(int p_Index) {
        if (p_Index < 0) {
            return null;
        }
        if (p_Index >= super.getSize()) {
            return null;
        }
        return (LanguageFlagItem)super.getElementAt(p_Index);
    }

    @Override
    public LanguageFlagItem getSelectedItem() {
        return (LanguageFlagItem)super.getSelectedItem();
    }

    public LanguageFlagItem getLanguageFlagItem(Locale p_Locale) {
        if (p_Locale == null) {
            return null;
        }
        LanguageFlagItem o_LanguageFlagItem = null;
        LanguageFlagItem o_ResultFlagItem = null;
        for (int intItem = 0; intItem < this.m_Items.size(); ++intItem) {
            o_LanguageFlagItem = this.m_Items.get(intItem);
            if (o_LanguageFlagItem.getLocale().equals(p_Locale)) {
                o_ResultFlagItem = o_LanguageFlagItem;
                break;
            }
            if (o_ResultFlagItem != null || !o_LanguageFlagItem.getLocale().getLanguage().equals(p_Locale.getLanguage())) continue;
            o_ResultFlagItem = o_LanguageFlagItem;
        }
        return o_ResultFlagItem;
    }

    public static ImageIcon getFlagFromLocale(Locale p_Locale) {
        if (p_Locale == null) {
            return null;
        }
        return LiveLanguageFlagModel.getFlagFromLanguageKey(LiveLanguage.getLocaleKeyFromLocale(p_Locale));
    }

    public static ImageIcon getFlagFromLanguageKey(String p_LanguageKey) {
        if (p_LanguageKey == null || p_LanguageKey.length() <= 0) {
            return null;
        }
        String o_FileName = LiveLangageLocaleHandling.getName_ReplacedPoint(LiveLanguageFlagModel.class.getPackage().getName()) + "/" + p_LanguageKey + ".gif";
        ImageIcon o_Image = null;
        try {
            o_Image = new ImageIcon(LiveLanguageFlagModel.class.getClassLoader().getResource(o_FileName));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return o_Image;
    }

    public static class LiveImageTextListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public LiveImageTextListCellRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(0);
            this.setVerticalAlignment(0);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            LanguageFlagItem o_FlagItem = (LanguageFlagItem)value;
            if (o_FlagItem == null) {
                this.setIcon(null);
                this.setText("");
                return this;
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            Icon o_Icon = o_FlagItem.getIcon();
            String stringText = o_FlagItem.getDisplayCountry().length() > 0 ? o_FlagItem.getDisplayCountry() : o_FlagItem.getDisplayLanguage();
            this.setIcon(o_Icon);
            this.setText(stringText);
            this.setFont(list.getFont());
            this.setHorizontalAlignment(2);
            return this;
        }
    }

    public static class LanguageFlagItem {
        private Locale m_Locale;
        private String m_Language;
        private String m_Country;
        private ImageIcon m_ImageIcon;

        public LanguageFlagItem(Locale p_Locale) {
            this.m_Locale = p_Locale;
            this.m_Country = LiveLangageLocaleHandling.getCountryName(this.m_Locale);
            this.m_Language = LiveLangageLocaleHandling.getLanguageName(this.m_Locale);
            this.m_ImageIcon = LiveLanguageFlagModel.getFlagFromLocale(p_Locale);
        }

        public Locale getLocale() {
            return this.m_Locale;
        }

        public String getDisplayLanguage() {
            return this.m_Language;
        }

        public String getDisplayCountry() {
            return this.m_Country;
        }

        public Icon getIcon() {
            return this.m_ImageIcon;
        }
    }
}

