/*
 * Decompiled with CFR 0.152.
 */
package SPITClientPackage;

import SPITClientPackage.SPIT_Client;
import SPITLibraryPackage.SPIT_Message;
import TimerPackage.JavaTimer;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.util.ArrayList;

public class SPIT_ClientSocket {
    public static int SEND_WAITTIME = 5;
    public static boolean s_DEBUGON = true;
    private SPIT_Client m_SPITClient;
    private DatagramSocket m_DatagramSocket;
    private InetAddress m_ServerInetAddress;
    private int m_ServerPort;
    private Runnable m_Send_Runnable;
    private ArrayList<DatagramPacket> m_Send_DatagramPackets;
    private Thread m_SendThread;
    private final Object m_SyncSendMessage = new Object();
    private Runnable m_Receive_Runnable;
    private Thread m_ReceiveThread;
    private final Object m_SyncReceiveMessage = new Object();
    private boolean m_StopReceive;
    private boolean m_StopSend;

    public SPIT_ClientSocket(SPIT_Client p_SPITClient) {
        this.initMembers();
        this.m_SPITClient = p_SPITClient;
    }

    private void initMembers() {
        this.m_DatagramSocket = null;
        this.m_ServerInetAddress = null;
        this.m_ServerPort = 0;
        this.m_StopReceive = true;
        this.m_StopSend = true;
        this.m_Send_DatagramPackets = new ArrayList();
        this.initRunnableSend();
        this.initRunnableReceive();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean connect(InetAddress p_ServerInetAddress, int p_ServerPort, String p_ClientIP, int p_ClientPort, String p_LoginName, String p_LoginPassword) {
        if (p_ServerInetAddress == null) {
            return false;
        }
        if (p_ServerPort < 0 || p_ServerPort > 65535) {
            return false;
        }
        if (p_ClientPort > 65535) {
            return false;
        }
        this.disconnect();
        SPIT_Client o_SPIT_Client = this.m_SPITClient;
        if (o_SPIT_Client == null) {
            return false;
        }
        System.out.println("                SPIT_ClientSocket TRYCONNECT Server: " + p_ServerInetAddress);
        try {
            this.m_ServerInetAddress = p_ServerInetAddress;
            this.m_ServerPort = p_ServerPort;
            InetSocketAddress o_InetSocketAddress = new InetSocketAddress(p_ClientIP, p_ClientPort);
            this.m_DatagramSocket = new DatagramSocket(o_InetSocketAddress);
            if (p_ClientPort > 0) {
                // empty if block
            }
        }
        catch (Exception e) {
            System.out.println("                SPIT_ClientSocket CONNECTION ERROR Server: " + this.m_ServerInetAddress);
            System.out.println("                                  ERROR: " + e.getMessage());
            this.m_ServerInetAddress = null;
            this.m_ServerPort = 0;
            this.m_DatagramSocket = null;
            return false;
        }
        try {
            this.m_DatagramSocket.setReceiveBufferSize(524288);
            this.m_DatagramSocket.setSendBufferSize(524288);
        }
        catch (Exception exception) {
            // empty catch block
        }
        o_SPIT_Client.resetMessageNumberReceived();
        this.m_StopSend = false;
        this.m_SendThread = new Thread(this.m_Send_Runnable);
        this.m_SendThread.start();
        this.m_StopReceive = false;
        this.m_ReceiveThread = new Thread(this.m_Receive_Runnable);
        this.m_ReceiveThread.start();
        SPIT_Message o_SPIT_Message = SPIT_Message.createConnect(o_SPIT_Client.getClientComputerName(), o_SPIT_Client.getName(), p_LoginName, p_LoginPassword, SPIT_Client.cleanIPAddress(this.m_ServerInetAddress.getHostAddress()), this.m_ServerPort);
        return SPIT_Client.sendMessage(o_SPIT_Message);
    }

    public void connected() {
        System.out.println("                SPIT_ClientSocket CONNECTED Server: " + this.m_ServerInetAddress);
    }

    public boolean disconnect() {
        System.out.println("                SPIT_ClientSocket DISCONNECT Server: " + this.m_ServerInetAddress);
        boolean boolOK = this.sendDisconnect();
        this.closeDatagramSocket();
        return boolOK;
    }

    private void initRunnableReceive() {
        this.m_Receive_Runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                byte[] o_BytesReceived = new byte[512];
                DatagramPacket o_DatagramPacket = new DatagramPacket(o_BytesReceived, o_BytesReceived.length);
                while (!SPIT_ClientSocket.this.m_StopReceive) {
                    Object object = SPIT_ClientSocket.this.m_SyncReceiveMessage;
                    synchronized (object) {
                        if (SPIT_ClientSocket.this.m_DatagramSocket == null || SPIT_ClientSocket.this.m_DatagramSocket.isClosed()) {
                            SPIT_ClientSocket.this.m_StopReceive = true;
                            continue;
                        }
                    }
                    try {
                        SPIT_ClientSocket.this.m_DatagramSocket.receive(o_DatagramPacket);
                    }
                    catch (SocketTimeoutException e_SocketTimeoutException) {
                        continue;
                    }
                    catch (Exception e) {
                        SPIT_ClientSocket.this.m_StopReceive = true;
                        continue;
                    }
                    SPIT_Client o_SPITClient = SPIT_ClientSocket.this.m_SPITClient;
                    SPIT_Message o_SPIT_Message = SPIT_Message.createSPIT_Message(o_DatagramPacket.getData(), o_DatagramPacket.getLength());
                    if (o_SPIT_Message == null) {
                        if (!s_DEBUGON) continue;
                        System.out.println("                SPIT_ClientSocket RunnableReceive ERROR received Mesage was not a SPIT_Message");
                        continue;
                    }
                    SPIT_Message.Header o_SPIT_Message_Header = o_SPIT_Message.getHeader();
                    if (o_SPIT_Message_Header == null) {
                        if (s_DEBUGON) {
                            System.out.println("SPIT_ClientSocket RunnableReceive ERROR SPIT_Message_Header is NULL");
                        }
                        o_SPIT_Message = null;
                        continue;
                    }
                    SPIT_Message.OPPart o_SPIT_Message_OPPart = o_SPIT_Message.getOPPart();
                    if (o_SPIT_Message_OPPart == null) {
                        if (s_DEBUGON) {
                            System.out.println("Error SPIT_ClientSocket RunnableReceive ERROR SPIT_Message_OPPart is NULL");
                        }
                        o_SPIT_Message = null;
                        continue;
                    }
                    if (o_SPITClient == null) continue;
                    if (s_DEBUGON) {
                        System.out.println("<- Client receiveSPIT_Message OP " + o_SPIT_Message.getOPPart().getClass().getSimpleName());
                    }
                    o_SPITClient.checkParseSPIT_Message(o_SPIT_Message);
                }
            }
        };
    }

    public int getPort() {
        DatagramSocket o_DatagramSocket = this.m_DatagramSocket;
        if (o_DatagramSocket == null) {
            return 0;
        }
        return o_DatagramSocket.getPort();
    }

    public String getIPAddress() {
        DatagramSocket o_DatagramSocket = this.m_DatagramSocket;
        if (o_DatagramSocket == null) {
            return "";
        }
        InetAddress o_InetAddress = o_DatagramSocket.getInetAddress();
        if (o_InetAddress == null) {
            return "";
        }
        String stringIPAddress = SPIT_Client.cleanIPAddress(o_InetAddress.getHostAddress());
        return stringIPAddress;
    }

    public InetAddress getInetAddress() {
        DatagramSocket o_DatagramSocket = this.m_DatagramSocket;
        if (o_DatagramSocket == null) {
            return null;
        }
        InetAddress o_InetAddress = o_DatagramSocket.getInetAddress();
        return o_InetAddress;
    }

    public boolean sendSPIT_Message(SPIT_Message p_SPIT_Message) {
        if (p_SPIT_Message == null) {
            return false;
        }
        DatagramSocket o_DatagramSocket = this.m_DatagramSocket;
        if (o_DatagramSocket == null) {
            return false;
        }
        if (o_DatagramSocket.isClosed()) {
            return false;
        }
        byte[] o_BytesMessage = p_SPIT_Message.getMessageBytes();
        if (o_BytesMessage == null) {
            return false;
        }
        byte[] o_BytesSend = SPIT_Message.getDataBytes(p_SPIT_Message.getMessageBytesCount());
        try {
            System.arraycopy(o_BytesMessage, 0, o_BytesSend, 0, o_BytesSend.length);
        }
        catch (Exception e) {
            return false;
        }
        if (s_DEBUGON) {
            System.out.println("                -> SPIT_ClientSocket sendSPIT_Message OP " + p_SPIT_Message.getOPPart().getClass().getSimpleName());
        }
        DatagramPacket o_DatagramPacket = new DatagramPacket(o_BytesSend, p_SPIT_Message.getMessageBytesCount(), this.m_ServerInetAddress, this.m_ServerPort);
        return this.addDatagramPacketToSend(o_DatagramPacket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addDatagramPacketToSend(DatagramPacket p_DatagramPacket) {
        if (p_DatagramPacket == null) {
            return false;
        }
        Object object = this.m_SyncSendMessage;
        synchronized (object) {
            if (this.m_StopSend || this.m_DatagramSocket == null || this.m_DatagramSocket.isClosed()) {
                return false;
            }
            this.m_Send_DatagramPackets.add(p_DatagramPacket);
            this.m_SyncSendMessage.notifyAll();
        }
        return true;
    }

    private void initRunnableSend() {
        this.m_Send_Runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                DatagramPacket o_DatagramPacket;
                ArrayList o_Rest_DatagramPackets = null;
                JavaTimer o_JavaTimer = new JavaTimer();
                while (!SPIT_ClientSocket.this.m_StopSend) {
                    Object object = SPIT_ClientSocket.this.m_SyncSendMessage;
                    synchronized (object) {
                        if (SPIT_ClientSocket.this.m_Send_DatagramPackets.size() <= 0) {
                            try {
                                SPIT_ClientSocket.this.m_SyncSendMessage.wait(2000L);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            if (SPIT_ClientSocket.this.m_DatagramSocket == null || SPIT_ClientSocket.this.m_DatagramSocket.isClosed()) {
                                break;
                            }
                        }
                        if (SPIT_ClientSocket.this.m_StopSend) {
                            if (SPIT_ClientSocket.this.m_Send_DatagramPackets.size() > 0) {
                                o_Rest_DatagramPackets = new ArrayList(SPIT_ClientSocket.this.m_Send_DatagramPackets.size());
                                o_Rest_DatagramPackets.addAll(SPIT_ClientSocket.this.m_Send_DatagramPackets);
                            }
                            continue;
                        }
                        if (SPIT_ClientSocket.this.m_Send_DatagramPackets.size() <= 0) {
                            continue;
                        }
                    }
                    o_DatagramPacket = null;
                    object = SPIT_ClientSocket.this.m_SyncSendMessage;
                    synchronized (object) {
                        if (SPIT_ClientSocket.this.m_Send_DatagramPackets.size() > 0) {
                            o_DatagramPacket = (DatagramPacket)SPIT_ClientSocket.this.m_Send_DatagramPackets.get(0);
                            try {
                                SPIT_ClientSocket.this.m_DatagramSocket.send(o_DatagramPacket);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            try {
                                o_JavaTimer.sleep(1L);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            SPIT_ClientSocket.this.m_Send_DatagramPackets.remove(0);
                            SPIT_Message.addEmpty(o_DatagramPacket.getData());
                        }
                    }
                }
                if (o_Rest_DatagramPackets != null) {
                    try {
                        for (int intMessage = 0; intMessage < o_Rest_DatagramPackets.size(); ++intMessage) {
                            o_DatagramPacket = (DatagramPacket)o_Rest_DatagramPackets.get(intMessage);
                            SPIT_ClientSocket.this.m_DatagramSocket.send(o_DatagramPacket);
                            o_JavaTimer.sleep(5L);
                            SPIT_Message.addEmpty(o_DatagramPacket.getData());
                        }
                        o_Rest_DatagramPackets.clear();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                Object object = SPIT_ClientSocket.this.m_SyncSendMessage;
                synchronized (object) {
                    SPIT_ClientSocket.this.m_Send_DatagramPackets.clear();
                    try {
                        if (SPIT_ClientSocket.this.m_DatagramSocket != null) {
                            SPIT_ClientSocket.this.m_DatagramSocket.close();
                            SPIT_ClientSocket.this.m_DatagramSocket = null;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                o_JavaTimer.close();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeDatagramSocket() {
        this.m_StopReceive = true;
        Object object = this.m_SyncReceiveMessage;
        synchronized (object) {
            this.m_SyncReceiveMessage.notifyAll();
        }
        DatagramSocket o_DatagramSocket = this.m_DatagramSocket;
        if (o_DatagramSocket == null) {
            return;
        }
        if (o_DatagramSocket.isClosed()) {
            this.m_DatagramSocket = null;
            return;
        }
        this.m_StopSend = true;
        object = this.m_SyncSendMessage;
        synchronized (object) {
            this.m_SyncSendMessage.notifyAll();
        }
        try {
            if (this.m_SendThread != null) {
                this.m_SendThread.join(3000L);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_SendThread = null;
        object = this.m_SyncSendMessage;
        synchronized (object) {
            try {
                if (this.m_DatagramSocket != null) {
                    this.m_DatagramSocket.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_DatagramSocket = null;
        }
    }

    private boolean sendDisconnect() {
        if (this.m_SPITClient == null) {
            return false;
        }
        SPIT_Message o_SPIT_Message = SPIT_Message.createDisconnect();
        return SPIT_Client.sendMessage(o_SPIT_Message);
    }

    public InetAddress getServerInetAddress() {
        return this.m_ServerInetAddress;
    }

    public String getServerHostAddress() {
        if (this.m_ServerInetAddress == null) {
            return "";
        }
        String stringIPAddress = SPIT_Client.cleanIPAddress(this.m_ServerInetAddress.getHostAddress());
        return stringIPAddress;
    }

    public int getServerPort() {
        return this.m_ServerPort;
    }
}

