/*
 * Decompiled with CFR 0.152.
 */
package UserJVMOptionsPackage;

import UserJVMOptionsPackage.JDialog_UserJVMOptions;
import com.sun.management.OperatingSystemMXBean;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import jdk.packager.services.UserJvmOptionsService;

public class UserJVMOptionsChecker {
    public static boolean m_Debug = false;
    public static long MINIMUMMEMORY_BIGMACHINE_MB = 1500L;
    public static long MINIMUMMEMORY_SMALLMACHINE_MB = 900L;
    public static float BYTESOFMB = 1048576.0f;

    public static boolean checkOptions(Map<String, String> p_UserJVMOptions, String p_Arguments) {
        String stringOptionValue_ToSet;
        JDialog_UserJVMOptions o_JDialog_UserJVMOptions = null;
        boolean boolOptionsChanged = false;
        if (!UserJVMOptionsChecker.checkIsStartedFromInstalledApp()) {
            return false;
        }
        UserJvmOptionsService o_UserJvmOptionsService = UserJvmOptionsService.getUserJVMDefaults();
        if (o_UserJvmOptionsService == null) {
            return false;
        }
        HashMap mapOptionsDefaults = o_UserJvmOptionsService.getUserJVMOptionDefaults();
        if (mapOptionsDefaults == null) {
            mapOptionsDefaults = new HashMap();
        }
        HashMap<String, String> mapOptionsExisting = new HashMap<String, String>();
        Map mapUserOptionsFound = o_UserJvmOptionsService.getUserJVMOptions();
        if (mapUserOptionsFound != null) {
            mapOptionsExisting.putAll(mapUserOptionsFound);
        }
        HashMap<String, String> mapOptionsExistingToRemove = new HashMap<String, String>();
        mapOptionsExistingToRemove.putAll(mapOptionsExisting);
        HashMap<String, String> mapOptionsToSet = new HashMap<String, String>();
        if (p_UserJVMOptions != null) {
            mapOptionsToSet.putAll(p_UserJVMOptions);
        }
        if (m_Debug) {
            o_JDialog_UserJVMOptions = new JDialog_UserJVMOptions(null, true);
        }
        if (m_Debug) {
            o_JDialog_UserJVMOptions.addUserJVMOption("Working Directory: ", UserJVMOptionsChecker.getWorkingDirectory());
        }
        for (String stringOptionName : mapOptionsExisting.keySet()) {
            String stringOptionValue_Existing = (String)mapOptionsExisting.get(stringOptionName);
            if (m_Debug) {
                o_JDialog_UserJVMOptions.addUserJVMOption(stringOptionName, stringOptionValue_Existing);
            }
            if ((stringOptionValue_ToSet = (String)mapOptionsToSet.get(stringOptionName)) == null) continue;
            if (!stringOptionValue_ToSet.equals(stringOptionValue_Existing)) {
                mapOptionsExisting.put(stringOptionName, stringOptionValue_ToSet);
                boolOptionsChanged = true;
                if (m_Debug) {
                    o_JDialog_UserJVMOptions.addUserJVMOption("Changed: " + stringOptionName, stringOptionValue_ToSet);
                }
            }
            mapOptionsToSet.remove(stringOptionName);
            mapOptionsExistingToRemove.remove(stringOptionName);
        }
        if (mapOptionsExistingToRemove.size() > 0) {
            for (String stringOptionName : mapOptionsExistingToRemove.keySet()) {
                if (mapOptionsDefaults.get(stringOptionName) != null) continue;
                boolOptionsChanged = true;
                mapOptionsExisting.remove(stringOptionName);
                if (!m_Debug) continue;
                o_JDialog_UserJVMOptions.addUserJVMOption("Removed: " + stringOptionName, "");
            }
        }
        if (mapOptionsToSet.size() > 0) {
            for (String stringOptionName : mapOptionsToSet.keySet()) {
                stringOptionValue_ToSet = (String)mapOptionsToSet.get(stringOptionName);
                mapOptionsExisting.put(stringOptionName, stringOptionValue_ToSet);
                boolOptionsChanged = true;
                if (!m_Debug) continue;
                o_JDialog_UserJVMOptions.addUserJVMOption("New: " + stringOptionName, stringOptionValue_ToSet);
            }
        }
        if (boolOptionsChanged) {
            o_UserJvmOptionsService.setUserJVMOptions(mapOptionsExisting);
            if (m_Debug) {
                o_JDialog_UserJVMOptions.addUserJVMOption("APP WILL RESTART:", "");
                o_JDialog_UserJVMOptions.addUserJVMOption("Exec ", UserJVMOptionsChecker.createRestartStringExec(p_Arguments));
            }
        }
        if (m_Debug) {
            o_JDialog_UserJVMOptions.setVisible(true);
        }
        if (boolOptionsChanged) {
            UserJVMOptionsChecker.restart(p_Arguments);
        }
        return boolOptionsChanged;
    }

    public static void setDebugOn(boolean p_Debug) {
        m_Debug = p_Debug;
    }

    public static String getWorkingDirectory() {
        URL urlWorkingDirectory = UserJVMOptionsChecker.class.getProtectionDomain().getCodeSource().getLocation();
        String stringWorkingDirectory = urlWorkingDirectory.getFile();
        try {
            stringWorkingDirectory = URLDecoder.decode(stringWorkingDirectory, "UTF-8");
        }
        catch (Exception exception) {
            // empty catch block
        }
        File o_RunFile = new File(stringWorkingDirectory);
        stringWorkingDirectory = o_RunFile.getParent();
        return stringWorkingDirectory;
    }

    public static boolean checkIsStartedFromInstalledApp() {
        File o_Directory = new File(UserJVMOptionsChecker.getWorkingDirectory());
        if (!o_Directory.exists()) {
            return false;
        }
        String stringOS = System.getProperty("os.name").toLowerCase();
        if (stringOS.indexOf("win") >= 0) {
            String stringFileName;
            if (!"app".equals((o_Directory = o_Directory.getParentFile()).getName().toLowerCase())) {
                return false;
            }
            File o_AppFile = new File(o_Directory = o_Directory.getParentFile(), stringFileName = o_Directory.getName() + ".exe");
            return o_AppFile.exists();
        }
        if (stringOS.indexOf("mac") >= 0) {
            if (!"java".equals((o_Directory = o_Directory.getParentFile()).getName().toLowerCase())) {
                return false;
            }
            return "contents".equals((o_Directory = o_Directory.getParentFile()).getName().toLowerCase());
        }
        if (stringOS.indexOf("nix") >= 0 || stringOS.indexOf("nux") >= 0) {
            if (!"java".equals((o_Directory = o_Directory.getParentFile()).getName().toLowerCase())) {
                return false;
            }
            return "bin".equals((o_Directory = o_Directory.getParentFile()).getName().toLowerCase());
        }
        if (stringOS.indexOf("sunos") >= 0) {
            return false;
        }
        return false;
    }

    public static void restart(String p_Arguments) {
        try {
            Thread.sleep(500L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String stringRestartExec = UserJVMOptionsChecker.createRestartStringExec(p_Arguments);
        if (stringRestartExec == null) {
            return;
        }
        try {
            Runtime.getRuntime().exec(stringRestartExec);
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.exit(0);
    }

    public static String createRestartStringExec(String p_Arguments) {
        String stringOS = System.getProperty("os.name").toLowerCase();
        String stringRestartExec = stringOS.indexOf("win") >= 0 ? UserJVMOptionsChecker.restartStringOnWindows(p_Arguments) : (stringOS.indexOf("mac") >= 0 ? UserJVMOptionsChecker.restartStringOnMacOS(p_Arguments) : (stringOS.indexOf("nix") >= 0 || stringOS.indexOf("nux") >= 0 ? UserJVMOptionsChecker.restartStringOnLinux(p_Arguments) : (stringOS.indexOf("sunos") >= 0 ? null : null)));
        return stringRestartExec;
    }

    public static String restartStringOnWindows(String p_Arguments) {
        String stringExeName;
        File o_WorkingDirectory;
        if (p_Arguments != null && p_Arguments.length() <= 0) {
            p_Arguments = null;
        }
        if (!(o_WorkingDirectory = new File(UserJVMOptionsChecker.getWorkingDirectory())).exists()) {
            return null;
        }
        File o_FileExeDirectory = o_WorkingDirectory.getParentFile().getParentFile();
        File o_FileExe = new File(o_FileExeDirectory, stringExeName = o_FileExeDirectory.getName() + ".exe");
        if (!o_FileExe.exists()) {
            return null;
        }
        if (p_Arguments == null) {
            return "\"" + o_FileExe.getAbsolutePath() + "\"";
        }
        return "\"" + o_FileExe.getAbsolutePath() + "\" " + p_Arguments;
    }

    public static String restartStringOnMacOS(String p_Arguments) {
        File o_WorkingDirectory;
        if (p_Arguments != null && p_Arguments.length() <= 0) {
            p_Arguments = null;
        }
        if (!(o_WorkingDirectory = new File(UserJVMOptionsChecker.getWorkingDirectory())).exists()) {
            return null;
        }
        File o_FileApp = o_WorkingDirectory.getParentFile().getParentFile().getParentFile();
        if (!o_FileApp.exists()) {
            return null;
        }
        if (p_Arguments == null) {
            return "open -n " + o_FileApp.getAbsolutePath();
        }
        return "open -n " + o_FileApp.getAbsolutePath() + " --args " + p_Arguments;
    }

    public static String restartStringOnLinux(String p_Arguments) {
        File o_WorkingDirectory;
        if (p_Arguments != null && p_Arguments.length() <= 0) {
            p_Arguments = null;
        }
        if (!(o_WorkingDirectory = new File(UserJVMOptionsChecker.getWorkingDirectory())).exists()) {
            return null;
        }
        File o_FileApp = o_WorkingDirectory.getParentFile().getParentFile().getParentFile();
        if (!o_FileApp.exists()) {
            return null;
        }
        String stringAppName = o_FileApp.getName();
        int intIndexSuffix = stringAppName.indexOf(".app");
        if (intIndexSuffix > 0) {
            stringAppName = stringAppName.substring(0, intIndexSuffix);
        }
        if (p_Arguments == null) {
            return "setsid " + o_FileApp.getAbsolutePath();
        }
        return "setsid " + o_FileApp.getAbsolutePath() + " " + p_Arguments;
    }

    public static long getTotalPhysicalMemorySize() {
        OperatingSystemMXBean operatingSystemMXBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
        long value = operatingSystemMXBean.getTotalPhysicalMemorySize();
        return value;
    }

    public static long getFreePhysicalMemorySize() {
        OperatingSystemMXBean operatingSystemMXBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
        long value = operatingSystemMXBean.getFreePhysicalMemorySize();
        return value;
    }

    public static void setMinimumMemorySize(long p_SizeSmallMachine, long p_SizeBigMachine) {
        long longTotalMemory = UserJVMOptionsChecker.getTotalPhysicalMemorySize();
        if (longTotalMemory < 2500000000L) {
            MINIMUMMEMORY_SMALLMACHINE_MB = p_SizeSmallMachine;
        } else {
            MINIMUMMEMORY_BIGMACHINE_MB = p_SizeBigMachine;
        }
    }

    public static boolean isBigMachine() {
        long longTotalMemory = UserJVMOptionsChecker.getTotalPhysicalMemorySize();
        return longTotalMemory >= 2500000000L;
    }

    public static long calculateMemorySizeMBOfPercent(float p_Percantage) {
        long longMinSize;
        long longTotalMemory = UserJVMOptionsChecker.getTotalPhysicalMemorySize();
        long longSize = (long)((float)longTotalMemory * p_Percantage / BYTESOFMB);
        if (longSize < (longMinSize = longTotalMemory < 2500000000L ? MINIMUMMEMORY_SMALLMACHINE_MB : MINIMUMMEMORY_BIGMACHINE_MB)) {
            longSize = longMinSize;
        }
        return longSize;
    }
}

