/*
 * Decompiled with CFR 0.152.
 */
package RXTX_Package;

import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LanguageTools.LiveLanguagePackage.LiveLanguageString;
import RXTX_Package.RXTXMessageObject;
import RXTX_Package.RXTX_Connection;
import RXTX_Package.RXTX_Connection_CommDevice;
import RXTX_Package.RXTX_Connection_LANDevice;
import SPITClientGUI.SPITType_RXTX_Devices_TableModel;
import SwingModelPackage.SinglePropertyChangeSupport;
import SwingModelPackage.TableAndListModel;
import SwingToolTipPackage.PopUpToolTip;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.UUID;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;

public class RXTX_Device
implements Externalizable {
    public static final int SOFTWAREVERSIO = 1;
    public static final String RXTX_DEVICETYPE_USB = "USB";
    public static final String RXTX_DEVICETYPE_LAN = "Lan";
    public static String PROP_DEVICE_NAME = "rxtx_device_name";
    public static String PROP_DEVICE_CONNECTION = "rxtx_device_connection";
    public static String PROP_DEVICE_CLOSE = "rxtx_device_close";
    public static RXTX_Device_TableModel s_RXTX_Device_TableModel = new RXTX_Device_TableModel();
    public static SPITType_RXTX_Devices_TableModel s_SPITType_RXTX_Devices_TableModel = new SPITType_RXTX_Devices_TableModel();
    public static ImageIcon s_Icon = new ImageIcon(RXTX_Device.class.getResource("/IconsPackage/icon.png"));
    public static ImageIcon s_Icon_USB = new ImageIcon(RXTX_Device.class.getResource("/IconsPackage/USBPlug_White.png"));
    public static ImageIcon s_Icon_LAN = new ImageIcon(RXTX_Device.class.getResource("/IconsPackage/LANPlug.png"));
    public static ImageIcon s_Icon_Connected = new ImageIcon(RXTX_Device.class.getResource("/IconsPackage/Icon_Connected.png"));
    public static ImageIcon s_Icon_Disconnected = new ImageIcon(RXTX_Device.class.getResource("/IconsPackage/Icon_Disconnected.png"));
    public static int s_AutoConnection_Pause = 15000;
    public static boolean s_AutoConnection = false;
    public static Thread s_Thread_AutoConnection;
    public static final Object s_SyncAutoConection;
    protected String m_DeviceType;
    protected String m_ID;
    protected String m_Name;
    protected RXTX_Connection m_RXTX_Connection;
    protected boolean m_ManuallyDisconnected;
    protected Charset m_Charset;
    protected SinglePropertyChangeSupport m_PropertyChangeSupport;
    private static ArrayList<RXTXMessageListener> s_MessageListeners;
    private static final Object s_SyncMessageListener;
    public static RXTX_Device_Comparator s_RXTX_Device_Comparator;

    public static int getRXTX_DeviceCount() {
        return s_RXTX_Device_TableModel.size();
    }

    public static RXTX_Device getRXTX_Device(int p_Index) {
        if (p_Index < 0) {
            return null;
        }
        return (RXTX_Device)s_RXTX_Device_TableModel.get(p_Index);
    }

    public static RXTX_Device getRXTX_Device(String p_ID) {
        if (p_ID == null) {
            return null;
        }
        return s_SPITType_RXTX_Devices_TableModel.getRXTX_Device(p_ID);
    }

    public static void closeAll() {
        for (int intDevice = s_RXTX_Device_TableModel.size() - 1; intDevice >= 0; --intDevice) {
            RXTX_Device o_RXTX_Device = s_RXTX_Device_TableModel.getRXTX_Device(intDevice);
            if (o_RXTX_Device == null) continue;
            o_RXTX_Device.close();
        }
    }

    public static void save(ObjectOutputStream out) throws IOException {
        int intDeviceCount = s_RXTX_Device_TableModel.size();
        out.writeInt(intDeviceCount);
        for (int intDevice = 0; intDevice < intDeviceCount; ++intDevice) {
            RXTX_Device o_RXTX_Device = s_RXTX_Device_TableModel.getRXTX_Device(intDevice);
            o_RXTX_Device.writeExternal(out);
        }
    }

    public static void load(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int intDeviceCount = in.readInt();
        for (int intDevice = 0; intDevice < intDeviceCount; ++intDevice) {
            RXTX_Device o_RXTX_Device = new RXTX_Device();
            o_RXTX_Device.readExternal(in);
        }
    }

    public static void connectAll() {
        int intDeviceCount = RXTX_Device.getRXTX_DeviceCount();
        RXTX_Connection_CommDevice.refreshCommPorts();
        for (int intDevice = 0; intDevice < intDeviceCount; ++intDevice) {
            RXTX_Device o_RXTX_Device = RXTX_Device.getRXTX_Device(intDevice);
            if (o_RXTX_Device.getIsConnected() || o_RXTX_Device.getManuallyDisconnected()) continue;
            o_RXTX_Device.connect();
        }
    }

    public static void disconnectAll() {
        int intDeviceCount = RXTX_Device.getRXTX_DeviceCount();
        for (int intDevice = 0; intDevice < intDeviceCount; ++intDevice) {
            RXTX_Device o_RXTX_Device = RXTX_Device.getRXTX_Device(intDevice);
            o_RXTX_Device.disconnect();
        }
    }

    public static void startAutoConnection() {
        if (s_AutoConnection) {
            return;
        }
        if (s_Thread_AutoConnection != null) {
            // empty if block
        }
        s_AutoConnection = true;
        Runnable o_RunnableAutoConnection = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                RXTX_Device.connectAll();
                while (s_AutoConnection) {
                    Object object = s_SyncAutoConection;
                    synchronized (object) {
                        try {
                            s_SyncAutoConection.wait(s_AutoConnection_Pause);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (s_AutoConnection) {
                            RXTX_Device.connectAll();
                        }
                    }
                }
                s_Thread_AutoConnection = null;
            }
        };
        s_Thread_AutoConnection = new Thread(o_RunnableAutoConnection);
        s_Thread_AutoConnection.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopAutoConnection() {
        s_AutoConnection = false;
        Object object = s_SyncAutoConection;
        synchronized (object) {
            s_SyncAutoConection.notifyAll();
        }
    }

    public RXTX_Device() {
        this.initMembers();
        s_RXTX_Device_TableModel.addRXTX_Device(this);
        s_SPITType_RXTX_Devices_TableModel.addRXTX_Device(this);
    }

    private void initMembers() {
        this.m_DeviceType = "";
        this.m_ID = UUID.randomUUID().toString();
        this.m_Name = "RXTX_Device";
        this.m_ManuallyDisconnected = false;
        this.m_PropertyChangeSupport = new SinglePropertyChangeSupport(this);
    }

    public void close() {
        this.disconnect();
        if (this.m_PropertyChangeSupport != null) {
            this.m_PropertyChangeSupport.firePropertyChange(PROP_DEVICE_CLOSE, this, null);
            this.m_PropertyChangeSupport.clear();
        }
    }

    public boolean connect() {
        if (this.m_RXTX_Connection == null) {
            return false;
        }
        return this.m_RXTX_Connection.connect();
    }

    public void disconnect() {
        if (this.m_RXTX_Connection == null) {
            return;
        }
        this.m_RXTX_Connection.disconnect();
    }

    public String getDeviceType() {
        return this.m_DeviceType;
    }

    public boolean setID(String p_ID) {
        if (p_ID == null) {
            return false;
        }
        if (p_ID.equals(this.m_ID)) {
            return false;
        }
        this.m_ID = p_ID;
        return true;
    }

    public String getID() {
        return this.m_ID;
    }

    boolean setName(String p_Name) {
        if (p_Name == null) {
            return false;
        }
        if (p_Name.equals(this.m_Name)) {
            return false;
        }
        String stringOldName = this.m_Name;
        this.m_Name = p_Name;
        this.m_PropertyChangeSupport.firePropertyChange(PROP_DEVICE_NAME, stringOldName, this.m_Name);
        return true;
    }

    public String getName() {
        return this.m_Name;
    }

    public Icon getIcon() {
        switch (this.m_DeviceType) {
            case "USB": {
                return s_Icon_USB;
            }
            case "Lan": {
                return s_Icon_LAN;
            }
        }
        return null;
    }

    public boolean setRXTX_Connection(RXTX_Connection p_RXTX_Connection) {
        if (p_RXTX_Connection == this.m_RXTX_Connection) {
            return false;
        }
        this.m_RXTX_Connection = p_RXTX_Connection;
        if (p_RXTX_Connection instanceof RXTX_Connection_CommDevice) {
            this.m_DeviceType = RXTX_DEVICETYPE_USB;
        } else if (p_RXTX_Connection instanceof RXTX_Connection_LANDevice) {
            this.m_DeviceType = RXTX_DEVICETYPE_LAN;
        }
        this.m_PropertyChangeSupport.firePropertyChange(PROP_DEVICE_CONNECTION, false, true);
        return true;
    }

    public RXTX_Connection getRXTX_Connection() {
        return this.m_RXTX_Connection;
    }

    public boolean eventConnectionStatus(int p_ConnectionStatus) {
        this.m_PropertyChangeSupport.firePropertyChange(PROP_DEVICE_CONNECTION, 1 - p_ConnectionStatus, p_ConnectionStatus);
        return true;
    }

    public boolean getIsConnected() {
        if (this.m_RXTX_Connection == null) {
            return false;
        }
        return this.m_RXTX_Connection.getIsConnected();
    }

    public void setManuallyDisconnected(boolean p_ManuallyDisconnected) {
        this.m_ManuallyDisconnected = p_ManuallyDisconnected;
    }

    public boolean getManuallyDisconnected() {
        return this.m_ManuallyDisconnected;
    }

    public void eventDataReceived(byte[] p_BytesReadenAll, int p_DataLenght) {
        String stringReaden = new String(p_BytesReadenAll, 0, p_DataLenght, RXTXMessageObject.s_Charset);
        System.out.println("RXTX_Device eventDataReceived BytesLength: " + stringReaden.length() + " Message: " + stringReaden);
        RXTX_Device.notifyRXTXMessageReceived(this, p_BytesReadenAll, p_DataLenght);
    }

    public boolean sendMessage(byte[] p_MessageBytes, int p_DataLenght) {
        if (this.m_RXTX_Connection == null || !this.m_RXTX_Connection.getIsConnected()) {
            return false;
        }
        return this.m_RXTX_Connection.sendMessage(p_MessageBytes, p_DataLenght);
    }

    public void addPropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
        if (p_PropertyChangeListener == null) {
            return;
        }
        if (this.m_PropertyChangeSupport != null) {
            this.m_PropertyChangeSupport.addPropertyChangeListener(p_PropertyChangeListener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
        if (this.m_PropertyChangeSupport != null) {
            this.m_PropertyChangeSupport.removePropertyChangeListener(p_PropertyChangeListener);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(1);
        out.writeUTF(this.m_DeviceType);
        out.writeUTF(this.m_ID);
        out.writeUTF(this.m_Name);
        this.m_RXTX_Connection.writeExternal(out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int intSftwareVersion = in.readInt();
        String stringDeviceType = in.readUTF();
        this.m_ID = in.readUTF();
        this.m_Name = in.readUTF();
        switch (stringDeviceType) {
            case "USB": {
                RXTX_Connection_CommDevice o_RXTX_Connection = new RXTX_Connection_CommDevice(this);
                this.setRXTX_Connection(o_RXTX_Connection);
                ((RXTX_Connection)o_RXTX_Connection).readExternal(in);
                break;
            }
            case "Lan": {
                RXTX_Connection_LANDevice o_RXTX_Connection = new RXTX_Connection_LANDevice(this);
                this.setRXTX_Connection(o_RXTX_Connection);
                ((RXTX_Connection)o_RXTX_Connection).readExternal(in);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addRXTXMessageListener(RXTXMessageListener p_RXTXMessageListener) {
        if (p_RXTXMessageListener == null) {
            return;
        }
        Object object = s_SyncMessageListener;
        synchronized (object) {
            if (s_MessageListeners.contains(p_RXTXMessageListener)) {
                return;
            }
            s_MessageListeners.add(p_RXTXMessageListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeRXTXMessageListener(RXTXMessageListener p_RXTXMessageListener) {
        if (p_RXTXMessageListener == null) {
            return;
        }
        Object object = s_SyncMessageListener;
        synchronized (object) {
            s_MessageListeners.remove(p_RXTXMessageListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notifyRXTXMessageReceived(RXTX_Device p_RXTX_Device, byte[] p_BytesReadenAll, int p_DataLenght) {
        ArrayList<RXTXMessageListener> o_MessageListeners;
        if (p_BytesReadenAll == null || p_DataLenght <= 0) {
            return;
        }
        Object object = s_SyncMessageListener;
        synchronized (object) {
            if (s_MessageListeners.size() <= 0) {
                return;
            }
            o_MessageListeners = new ArrayList<RXTXMessageListener>(s_MessageListeners.size());
            o_MessageListeners.addAll(s_MessageListeners);
        }
        for (int intListener = 0; intListener < o_MessageListeners.size(); ++intListener) {
            RXTXMessageListener o_RXTXMessageListener = (RXTXMessageListener)o_MessageListeners.get(intListener);
            if (o_RXTXMessageListener == null) continue;
            o_RXTXMessageListener.eventMessageReceived(p_RXTX_Device, p_BytesReadenAll, p_DataLenght);
        }
    }

    static {
        s_SyncAutoConection = new Object();
        s_MessageListeners = new ArrayList();
        s_SyncMessageListener = new Object();
        s_RXTX_Device_Comparator = new RXTX_Device_Comparator();
    }

    public static class RXTX_Device_Comparator
    implements Comparator<RXTX_Device> {
        @Override
        public int compare(RXTX_Device o1, RXTX_Device o2) {
            if (o1 == null || o2 == null) {
                return 0;
            }
            return o1.getName().compareToIgnoreCase(o2.getName());
        }
    }

    public static class RXTX_Device_TableModel
    extends TableAndListModel<RXTX_Device>
    implements PropertyChangeListener {
        public static final int COLUMNCOUNT = 3;
        public static final int COLUMNINDEX_DEVICETYPE = 0;
        public static final int COLUMNINDEX_DEVICENAME = 1;
        public static final int COLUMNINDEX_DEVICECONNECTION = 2;
        @LiveLanguageString
        public static String COLUMN_DEVICETYPE = "";
        @LiveLanguageString
        public static String COLUMN_DEVICENAME = "Name";
        @LiveLanguageString
        public static String COLUMN_DEVICECONNECTION = "Connection";
        private TableAndListModel.TableCellEditorRenderer_String m_TableCellRenderer_Connection;
        private final Object m_SyncObject = new Object();

        public RXTX_Device_TableModel() {
            super(false);
            this.initMembers();
            LiveLanguage.addLanguageListener((Object)this, (String)"SPIT_RXTX");
        }

        private void initMembers() {
        }

        public void finishJTable(JTable p_JTable) {
            TableAndListModel.TableCellEditorRenderer_String o_TableCellEditorRenderer_String;
            if (p_JTable == null) {
                return;
            }
            TableRowSorter<RXTX_Device_TableModel> o_TableRowSorter = new TableRowSorter<RXTX_Device_TableModel>(this);
            o_TableRowSorter.setComparator(0, TableAndListModel.getStringComparator_Normal());
            o_TableRowSorter.setComparator(1, TableAndListModel.getStringComparator_Normal());
            o_TableRowSorter.setComparator(2, TableAndListModel.getStringComparator_Normal());
            super.finishJTable(p_JTable, o_TableRowSorter, null);
            TableColumnModel o_TableColumnModel = p_JTable.getColumnModel();
            TableColumn o_TableColumn = o_TableColumnModel.getColumn(0);
            if (o_TableColumn != null) {
                o_TableColumn.setMaxWidth(80);
                o_TableCellEditorRenderer_String = new TableAndListModel.TableCellEditorRenderer_String();
                o_TableCellEditorRenderer_String.setIconAutomatic(1);
                o_TableCellEditorRenderer_String.setHorizontalAlignment(10);
                o_TableCellEditorRenderer_String.setToolTipText_Automatic(2);
                o_TableCellEditorRenderer_String.setToolTipTextAt(false, false);
                o_TableColumn.setCellEditor(o_TableCellEditorRenderer_String);
                o_TableColumn.setCellRenderer(o_TableCellEditorRenderer_String);
            }
            if ((o_TableColumn = o_TableColumnModel.getColumn(1)) != null) {
                o_TableCellEditorRenderer_String = new TableAndListModel.TableCellEditorRenderer_String();
                o_TableCellEditorRenderer_String.setHorizontalAlignment(0);
                o_TableCellEditorRenderer_String.setToolTipText_Automatic(2);
                o_TableCellEditorRenderer_String.setToolTipTextAt(false, true);
                o_TableColumn.setCellEditor(o_TableCellEditorRenderer_String);
                o_TableColumn.setCellRenderer(o_TableCellEditorRenderer_String);
            }
            if ((o_TableColumn = o_TableColumnModel.getColumn(2)) != null) {
                o_TableCellEditorRenderer_String = new TableAndListModel.TableCellEditorRenderer_String();
                o_TableCellEditorRenderer_String.setToolTipText_Automatic(2);
                o_TableCellEditorRenderer_String.setHorizontalAlignment(0);
                o_TableCellEditorRenderer_String.setToolTipTextAt(false, true);
                o_TableColumn.setCellEditor(o_TableCellEditorRenderer_String);
                o_TableColumn.setCellRenderer(o_TableCellEditorRenderer_String);
                this.m_TableCellRenderer_Connection = o_TableCellEditorRenderer_String;
            }
            p_JTable.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        }

        @Override
        public boolean contains(String p_ID) {
            if (p_ID == null) {
                return false;
            }
            RXTX_Device o_RXTX_Device = this.getRXTX_Device(p_ID);
            return o_RXTX_Device != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public RXTX_Device getRXTX_Device(String p_ID) {
            Object object = this.m_SyncObject;
            synchronized (object) {
                for (int intDMXScene = 0; intDMXScene < this.size(); ++intDMXScene) {
                    RXTX_Device o_RXTX_Device = (RXTX_Device)this.get(intDMXScene);
                    if (o_RXTX_Device == null || !p_ID.equals(o_RXTX_Device.getID())) continue;
                    return o_RXTX_Device;
                }
            }
            return null;
        }

        public void addRXTX_Device(RXTX_Device p_RXTX_Device) {
            if (p_RXTX_Device == null) {
                return;
            }
            if (this.add(p_RXTX_Device)) {
                p_RXTX_Device.addPropertyChangeListener(this);
            }
        }

        public void removeRXTX_Device(RXTX_Device p_RXTX_Device) {
            if (p_RXTX_Device == null) {
                return;
            }
            if (this.remove(p_RXTX_Device)) {
                p_RXTX_Device.removePropertyChangeListener(this);
            }
        }

        public void addSelectedRXTX_Device(JTable p_JTable, RXTX_Device p_RXTX_Device) {
            if (p_JTable == null) {
                return;
            }
            if (p_RXTX_Device == null) {
                return;
            }
            super.addSelectedElement(p_JTable, p_RXTX_Device);
        }

        public void removeSelectedRXTX_Device(JTable p_JTable, RXTX_Device p_RXTX_Device) {
            if (p_JTable == null) {
                return;
            }
            if (p_RXTX_Device == null) {
                return;
            }
            super.removeSelectedElement(p_JTable, p_RXTX_Device);
        }

        public RXTX_Device getRXTX_Device(int p_Index) {
            if (p_Index < 0) {
                return null;
            }
            return (RXTX_Device)super.get(p_Index);
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return COLUMN_DEVICETYPE;
                }
                case 1: {
                    return COLUMN_DEVICENAME;
                }
                case 2: {
                    return COLUMN_DEVICECONNECTION;
                }
            }
            return "";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getValue(RXTX_Device p_RXTX_Device, int columnIndex) {
            String stringValue = "";
            RXTX_Device o_RXTX_Device = p_RXTX_Device;
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (o_RXTX_Device == null) {
                    return stringValue;
                }
                RXTX_Connection o_RXTX_Connection = o_RXTX_Device.getRXTX_Connection();
                switch (columnIndex) {
                    case 0: {
                        stringValue = p_RXTX_Device.getDeviceType();
                        break;
                    }
                    case 1: {
                        stringValue = p_RXTX_Device.getName();
                        break;
                    }
                    case 2: {
                        if (o_RXTX_Connection == null) {
                            return "";
                        }
                        stringValue = o_RXTX_Connection.getConnectionString();
                        if (o_RXTX_Connection.getIsConnected()) {
                            this.m_TableCellRenderer_Connection.setIcon(s_Icon_Connected);
                            break;
                        }
                        this.m_TableCellRenderer_Connection.setIcon(s_Icon_Disconnected);
                    }
                }
                return stringValue;
            }
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            switch (col) {
                case 0: {
                    return false;
                }
                case 1: {
                    return true;
                }
                case 2: {
                    return false;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setValue(RXTX_Device p_RXTX_Device, Object value, int col) {
            Object object = this.m_SyncObject;
            synchronized (object) {
                if (p_RXTX_Device == null) {
                    return;
                }
            }
            switch (col) {
                case 1: {
                    String stringValue = (String)value;
                    p_RXTX_Device.setName(stringValue);
                }
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() instanceof RXTX_Device) {
                RXTX_Device o_RXTX_Device = (RXTX_Device)evt.getSource();
                if (PROP_DEVICE_NAME.equals(evt.getPropertyName())) {
                    this.changedElement(o_RXTX_Device);
                } else if (PROP_DEVICE_CONNECTION.equals(evt.getPropertyName())) {
                    this.changedElement(o_RXTX_Device);
                } else if (PROP_DEVICE_CLOSE.equals(evt.getPropertyName())) {
                    this.removeRXTX_Device(o_RXTX_Device);
                }
            }
        }
    }

    public static interface RXTXMessageListener {
        public void eventMessageReceived(RXTX_Device var1, byte[] var2, int var3);
    }
}

