/*
 * Decompiled with CFR 0.152.
 */
package RXTX_Package;

import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LiveCommSerial.CommSerialPortConnection;
import LiveCommSerial.CommSerialPortEvent;
import LiveCommSerial.CommSerialPortEventListener;
import RXTX_Package.RXTX_Connection;
import RXTX_Package.RXTX_Connection_CommDevice;
import RXTX_Package.RXTX_Device;
import SwingModelPackage.TableAndListModel;
import SwingTextPackage.DocumentFilter_Integer;
import SwingToolTipPackage.PopUpToolTip;
import com.fazecast.jSerialComm.SerialPort;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class JPanel_CommDevice_Settings
extends JPanel
implements PropertyChangeListener,
CommSerialPortEventListener {
    public static String STOP_BITS_1 = "StopBits 1";
    public static String STOP_BITS_1_5 = "StopBits 1.5";
    public static String STOP_BITS_2 = "StopBits 2";
    public static String PARITY_NONE = "NO_PARITY";
    public static String PARITY_ODD = "ODD_PARITY";
    public static String PARITY_EVEN = "EVEN_PARITY";
    public static String PARITY_MARK = "MARK_PARITY";
    public static String PARITY_SPACE = "SPACE_PARITY";
    private Container m_JDialog;
    private TableAndListModel.ListModelWrapper<SerialPort> m_ListModelWrapper_SerialPorts;
    private TableAndListModel.ListModel<Integer> m_ListModel_DataBits;
    private TableAndListModel.ListModel<String> m_ListModel_StopBits;
    private TableAndListModel.ListModel<String> m_ListModel_Parity;
    private RXTX_Connection_CommDevice m_RXTX_Connection_CommDevice;
    private RXTX_Device m_RXTX_Device;
    private String m_Selected_SerialPort;
    private int m_Selected_Baudrate;
    private int m_Selected_DataBits;
    private int m_Selected_Parity;
    private int m_Selected_StopBits;
    private JButton jButton_Connect;
    private JButton jButton_Disconnect;
    private JButton jButton_RefreshPortList;
    private JComboBox<String> jComboBox_Baudrate;
    private JComboBox jComboBox_CommPort;
    private JComboBox jComboBox_DataBits;
    private JComboBox jComboBox_Parity;
    private JComboBox jComboBox_StopBits;
    private JLabel jLabel1;
    private JLabel jLabel_Baudrate;
    private JLabel jLabel_CommPort;
    private JLabel jLabel_DataBits;
    private JLabel jLabel_Error;
    private JLabel jLabel_Parity;
    private JLabel jLabel_StopBits;
    private JPanel jPanel_Buttons;
    private JTextField jTextField_Baudrate;

    public JPanel_CommDevice_Settings(Container p_JDialog) {
        this.m_JDialog = p_JDialog;
        this.initMembers();
        this.initComponents();
        this.initComponentsFurther();
        LiveLanguage.addLanguageListener((Object)this, null);
        this.refreshGUI();
    }

    private void initMembers() {
        this.m_RXTX_Connection_CommDevice = null;
        this.m_RXTX_Device = null;
        this.m_Selected_SerialPort = null;
        this.m_Selected_Baudrate = 0;
        this.m_Selected_DataBits = 8;
        this.m_Selected_Parity = 0;
        this.m_Selected_StopBits = 1;
        this.m_ListModel_DataBits = new TableAndListModel.ListModel(false);
        this.m_ListModel_DataBits.add(5);
        this.m_ListModel_DataBits.add(6);
        this.m_ListModel_DataBits.add(7);
        this.m_ListModel_DataBits.add(8);
        this.m_ListModel_StopBits = new TableAndListModel.ListModel(false);
        this.m_ListModel_StopBits.add(STOP_BITS_1);
        this.m_ListModel_StopBits.add(STOP_BITS_1_5);
        this.m_ListModel_StopBits.add(STOP_BITS_2);
        this.m_ListModel_Parity = new TableAndListModel.ListModel(false);
        this.m_ListModel_Parity.add(PARITY_NONE);
        this.m_ListModel_Parity.add(PARITY_ODD);
        this.m_ListModel_Parity.add(PARITY_EVEN);
        this.m_ListModel_Parity.add(PARITY_MARK);
        this.m_ListModel_Parity.add(PARITY_SPACE);
    }

    private void initComponentsFurther() {
        DocumentFilter_Integer o_DocumentFilter_Integer = new DocumentFilter_Integer(this.jTextField_Baudrate);
        o_DocumentFilter_Integer.setAllowNegativeNumbers(false);
        this.m_ListModelWrapper_SerialPorts = RXTX_Connection_CommDevice.s_ListModel_SerialPorts.createListModelWrapper();
        this.jComboBox_CommPort.setModel(this.m_ListModelWrapper_SerialPorts);
        this.jComboBox_CommPort.setRenderer(RXTX_Connection_CommDevice.s_ListModel_SerialPorts.getListRenderer());
        this.m_ListModelWrapper_SerialPorts.addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
                JPanel_CommDevice_Settings.this.refreshGUI();
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                JPanel_CommDevice_Settings.this.refreshGUI();
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
            }
        });
        this.jComboBox_DataBits.setModel(this.m_ListModel_DataBits);
        this.jComboBox_StopBits.setModel(this.m_ListModel_StopBits);
        this.jComboBox_Parity.setModel(this.m_ListModel_Parity);
        this.jButton_RefreshPortList.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_Connect.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_Disconnect.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jTextField_Baudrate.setComponentPopupMenu(PopUpToolTip.getSelfReference());
    }

    private void initComponents() {
        this.jComboBox_CommPort = new JComboBox();
        this.jButton_RefreshPortList = new JButton();
        this.jLabel_CommPort = new JLabel();
        this.jLabel_DataBits = new JLabel();
        this.jComboBox_DataBits = new JComboBox();
        this.jPanel_Buttons = new JPanel();
        this.jButton_Connect = new JButton();
        this.jButton_Disconnect = new JButton();
        this.jLabel_StopBits = new JLabel();
        this.jComboBox_StopBits = new JComboBox();
        this.jLabel_Parity = new JLabel();
        this.jComboBox_Parity = new JComboBox();
        this.jLabel_Baudrate = new JLabel();
        this.jTextField_Baudrate = new JTextField();
        this.jLabel1 = new JLabel();
        this.jLabel_Error = new JLabel();
        this.jComboBox_Baudrate = new JComboBox();
        this.setBorder(BorderFactory.createLineBorder(new Color(255, 255, 255)));
        this.setLayout(new GridBagLayout());
        this.jComboBox_CommPort.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBox_CommPort.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanel_CommDevice_Settings.this.jComboBox_CommPortActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jComboBox_CommPort, gridBagConstraints);
        this.jButton_RefreshPortList.setIcon(new ImageIcon(this.getClass().getResource("/Image/Edit_Refresh.png")));
        this.jButton_RefreshPortList.setToolTipText("Refresh the list of Commports");
        this.jButton_RefreshPortList.setContentAreaFilled(false);
        this.jButton_RefreshPortList.setIconTextGap(0);
        this.jButton_RefreshPortList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanel_CommDevice_Settings.this.jButton_RefreshPortListActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jButton_RefreshPortList, gridBagConstraints);
        this.jLabel_CommPort.setText("CommPort");
        this.jLabel_CommPort.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jLabel_CommPort, gridBagConstraints);
        this.jLabel_DataBits.setText("DataBits");
        this.jLabel_DataBits.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jLabel_DataBits, gridBagConstraints);
        this.jComboBox_DataBits.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBox_DataBits.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanel_CommDevice_Settings.this.jComboBox_DataBitsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jComboBox_DataBits, gridBagConstraints);
        this.jPanel_Buttons.setLayout(new GridBagLayout());
        this.jButton_Connect.setText("Connect");
        this.jButton_Connect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanel_CommDevice_Settings.this.jButton_ConnectActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Buttons.add((Component)this.jButton_Connect, gridBagConstraints);
        this.jButton_Disconnect.setText("Disconnect");
        this.jButton_Disconnect.setToolTipText("");
        this.jButton_Disconnect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanel_CommDevice_Settings.this.jButton_DisconnectActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Buttons.add((Component)this.jButton_Disconnect, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jPanel_Buttons, gridBagConstraints);
        this.jLabel_StopBits.setText("StopBits");
        this.jLabel_StopBits.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jLabel_StopBits, gridBagConstraints);
        this.jComboBox_StopBits.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBox_StopBits.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanel_CommDevice_Settings.this.jComboBox_StopBitsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jComboBox_StopBits, gridBagConstraints);
        this.jLabel_Parity.setText("Parity");
        this.jLabel_Parity.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jLabel_Parity, gridBagConstraints);
        this.jComboBox_Parity.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBox_Parity.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanel_CommDevice_Settings.this.jComboBox_ParityActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jComboBox_Parity, gridBagConstraints);
        this.jLabel_Baudrate.setText("Baudrate");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jLabel_Baudrate, gridBagConstraints);
        this.jTextField_Baudrate.setHorizontalAlignment(0);
        this.jTextField_Baudrate.setText("jTextField1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.add((Component)this.jTextField_Baudrate, gridBagConstraints);
        this.jLabel1.setFont(new Font("Tahoma", 0, 12));
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setText("jLabel1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel_Error.setFont(new Font("Tahoma", 0, 12));
        this.jLabel_Error.setForeground(new Color(255, 102, 102));
        this.jLabel_Error.setHorizontalAlignment(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jLabel_Error, gridBagConstraints);
        this.jComboBox_Baudrate.setModel(new DefaultComboBoxModel<String>(new String[]{"9600", "19200", "38400", "57600", "74880", "115200", "230400"}));
        this.jComboBox_Baudrate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanel_CommDevice_Settings.this.jComboBox_BaudrateActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        this.add(this.jComboBox_Baudrate, gridBagConstraints);
    }

    public void setRXTX_Device(RXTX_Device p_RXTX_Device) {
        CommSerialPortConnection o_CommSerialPortConnection;
        if (this.m_RXTX_Device == p_RXTX_Device) {
            return;
        }
        this.jLabel_Error.setText("");
        if (this.m_RXTX_Device != null) {
            if (this.m_RXTX_Connection_CommDevice != null && (o_CommSerialPortConnection = this.m_RXTX_Connection_CommDevice.getCommSerialPortConnection()) != null) {
                o_CommSerialPortConnection.removeCommSerialPortEventListener((CommSerialPortEventListener)this);
            }
            this.m_RXTX_Device.removePropertyChangeListener(this);
            this.m_RXTX_Connection_CommDevice = null;
        }
        this.m_RXTX_Device = p_RXTX_Device;
        if (this.m_RXTX_Device != null) {
            RXTX_Connection o_RXTX_Connection = this.m_RXTX_Device.getRXTX_Connection();
            if (o_RXTX_Connection instanceof RXTX_Connection_CommDevice) {
                RXTX_Connection_CommDevice o_RXTX_Connection_CommDevice = (RXTX_Connection_CommDevice)o_RXTX_Connection;
                if (o_RXTX_Connection_CommDevice.getComm_Port() != null) {
                    this.m_Selected_SerialPort = o_RXTX_Connection_CommDevice.getComm_Port();
                }
                this.m_Selected_Baudrate = o_RXTX_Connection_CommDevice.getComm_BaudRate();
                this.m_Selected_DataBits = o_RXTX_Connection_CommDevice.getComm_DataBits();
                this.m_Selected_Parity = o_RXTX_Connection_CommDevice.getComm_Parity();
                this.m_Selected_StopBits = o_RXTX_Connection_CommDevice.getComm_StopBits();
                this.m_RXTX_Connection_CommDevice = o_RXTX_Connection_CommDevice;
                o_CommSerialPortConnection = this.m_RXTX_Connection_CommDevice.getCommSerialPortConnection();
                if (o_CommSerialPortConnection != null) {
                    o_CommSerialPortConnection.addCommSerialPortEventListener((CommSerialPortEventListener)this);
                }
                this.refreshCommPorts();
                String stringBaudrate = "9600";
                try {
                    stringBaudrate = String.valueOf(this.m_Selected_Baudrate);
                }
                catch (Exception e) {
                    stringBaudrate = "9600";
                }
                this.jTextField_Baudrate.setText(stringBaudrate);
                this.jComboBox_Baudrate.setSelectedItem(stringBaudrate);
                this.setSelectedDataBits(this.m_Selected_DataBits);
                this.setSelectedStopBits(this.m_Selected_StopBits);
                this.setSelectedParity(this.m_Selected_Parity);
            } else {
                this.m_RXTX_Connection_CommDevice = null;
            }
            this.m_RXTX_Device.addPropertyChangeListener(this);
        }
        this.refreshGUI();
    }

    public void refreshCommPorts() {
        Runnable o_RunnableDetectCommports = new Runnable(){

            @Override
            public void run() {
                RXTX_Connection_CommDevice.refreshCommPorts();
                Runnable o_Runnable = new Runnable(){

                    @Override
                    public void run() {
                        if (JPanel_CommDevice_Settings.this.jComboBox_CommPort.getModel().getSize() > 0 && JPanel_CommDevice_Settings.this.m_Selected_SerialPort != null) {
                            if (JPanel_CommDevice_Settings.this.m_Selected_SerialPort != null && JPanel_CommDevice_Settings.this.m_Selected_SerialPort.length() > 0) {
                                JPanel_CommDevice_Settings.this.setSelectedSerialPort(JPanel_CommDevice_Settings.this.m_Selected_SerialPort);
                            } else {
                                JPanel_CommDevice_Settings.this.jComboBox_CommPort.setSelectedIndex(0);
                            }
                        }
                    }
                };
                EventQueue.invokeLater(o_Runnable);
            }
        };
        Thread o_Thread = new Thread(o_RunnableDetectCommports, this.getClass().getSimpleName());
        o_Thread.start();
    }

    private void setSelectedSerialPort(String p_SerialPortName) {
        int intPortCount = this.m_ListModelWrapper_SerialPorts.getSize();
        if (intPortCount <= 0) {
            return;
        }
        for (int intPort = 0; intPort < intPortCount; ++intPort) {
            SerialPort o_SerialPort = this.m_ListModelWrapper_SerialPorts.get(intPort);
            if (o_SerialPort == null || !o_SerialPort.getSystemPortName().equals(p_SerialPortName)) continue;
            this.jComboBox_CommPort.setSelectedItem(o_SerialPort);
            return;
        }
    }

    private void setSelectedDataBits(int p_DataBits) {
        for (int intIndex = 0; intIndex < this.m_ListModel_DataBits.size(); ++intIndex) {
            int intDataBits = this.m_ListModel_DataBits.get(intIndex);
            if (intDataBits != p_DataBits) continue;
            this.jComboBox_DataBits.setSelectedIndex(intIndex);
            break;
        }
    }

    private void setSelectedStopBits(int p_StopBits) {
        switch (p_StopBits) {
            case 1: {
                this.jComboBox_StopBits.setSelectedIndex(0);
                break;
            }
            case 2: {
                this.jComboBox_StopBits.setSelectedIndex(1);
                break;
            }
            case 3: {
                this.jComboBox_StopBits.setSelectedIndex(2);
            }
        }
    }

    private void setSelectedParity(int p_Parity) {
        if (p_Parity >= 0 && p_Parity <= 4) {
            this.jComboBox_Parity.setSelectedIndex(p_Parity);
        }
    }

    public void refreshGUI() {
        this.jButton_RefreshPortList.setEnabled(false);
        this.jTextField_Baudrate.setEnabled(false);
        this.jComboBox_Baudrate.setEnabled(false);
        this.jComboBox_CommPort.setEnabled(false);
        this.jComboBox_DataBits.setEnabled(false);
        this.jComboBox_StopBits.setEnabled(false);
        this.jComboBox_Parity.setEnabled(false);
        this.jButton_RefreshPortList.setEnabled(false);
        if (this.m_RXTX_Connection_CommDevice == null || this.m_RXTX_Device == null) {
            this.jButton_Connect.setVisible(false);
            this.jButton_Disconnect.setVisible(false);
            this.jLabel1.setText("");
            this.jLabel_Error.setText("");
            return;
        }
        this.jLabel1.setText(this.m_RXTX_Device.getName());
        if (this.m_RXTX_Connection_CommDevice.getIsConnected()) {
            this.jButton_Connect.setVisible(false);
            this.jButton_Disconnect.setVisible(true);
            this.jLabel_Error.setText("");
        } else {
            this.jButton_RefreshPortList.setEnabled(true);
            this.jTextField_Baudrate.setEnabled(true);
            this.jComboBox_Baudrate.setEnabled(true);
            this.jComboBox_CommPort.setEnabled(true);
            this.jComboBox_DataBits.setEnabled(true);
            this.jComboBox_StopBits.setEnabled(true);
            this.jComboBox_Parity.setEnabled(true);
            this.jButton_RefreshPortList.setEnabled(true);
            this.jButton_Connect.setVisible(true);
            this.jButton_Disconnect.setVisible(false);
        }
    }

    private void jComboBox_CommPortActionPerformed(ActionEvent evt) {
        SerialPort o_SerialPort = this.m_ListModelWrapper_SerialPorts.getSelectedItem();
        if (o_SerialPort != null) {
            this.m_Selected_SerialPort = o_SerialPort.getSystemPortName();
        }
    }

    private void jButton_RefreshPortListActionPerformed(ActionEvent evt) {
        this.refreshCommPorts();
    }

    private void jComboBox_DataBitsActionPerformed(ActionEvent evt) {
        this.m_Selected_DataBits = (Integer)this.jComboBox_DataBits.getSelectedItem();
        this.refreshGUI();
    }

    private void jButton_ConnectActionPerformed(ActionEvent evt) {
        this.jLabel_Error.setText("");
        if (this.m_RXTX_Connection_CommDevice != null) {
            this.m_RXTX_Connection_CommDevice.setManuallyDisconnected(false);
            try {
                int intBaudrate;
                this.m_Selected_Baudrate = intBaudrate = Integer.valueOf(this.jTextField_Baudrate.getText()).intValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_RXTX_Connection_CommDevice.setComm_Port(this.m_Selected_SerialPort);
            this.m_RXTX_Connection_CommDevice.setComm_BaudRate(this.m_Selected_Baudrate);
            this.m_RXTX_Connection_CommDevice.setComm_DataBits(this.m_Selected_DataBits);
            this.m_RXTX_Connection_CommDevice.setComm_Parity(this.m_Selected_Parity);
            this.m_RXTX_Connection_CommDevice.setComm_StopBits(this.m_Selected_StopBits);
            if (this.m_RXTX_Connection_CommDevice.connect() && this.m_JDialog != null) {
                this.m_JDialog.repaint();
                this.m_JDialog.setVisible(false);
                this.setRXTX_Device(null);
            }
        }
    }

    private void jButton_DisconnectActionPerformed(ActionEvent evt) {
        Container o_Container;
        if (this.m_RXTX_Connection_CommDevice != null) {
            this.m_RXTX_Connection_CommDevice.disconnect();
            this.m_RXTX_Connection_CommDevice.setManuallyDisconnected(true);
        }
        if (this.m_JDialog != null && (o_Container = this.m_JDialog.getParent()) != null) {
            o_Container.repaint();
        }
    }

    private void jComboBox_StopBitsActionPerformed(ActionEvent evt) {
        this.m_Selected_StopBits = this.jComboBox_StopBits.getSelectedIndex() + 1;
    }

    private void jComboBox_ParityActionPerformed(ActionEvent evt) {
        this.m_Selected_Parity = this.jComboBox_Parity.getSelectedIndex();
    }

    private void jComboBox_BaudrateActionPerformed(ActionEvent evt) {
        String stringBaudrate = (String)this.jComboBox_Baudrate.getSelectedItem();
        this.jTextField_Baudrate.setText(stringBaudrate);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.refreshGUI();
    }

    public void eventCommSerialPortConnection(int p_ConnectionStatus) {
    }

    public void eventCommSerialPortComm(CommSerialPortEvent p_CommSerialPortEvent) {
    }

    public void eventCommSerialPortDataReceived(byte[] p_BytesReadenAll, int p_DataLenght) {
    }

    public void eventCommSerialPortException(Exception p_Exception) {
        this.jLabel_Error.setText(p_Exception.getMessage());
    }
}

