/*
 * Decompiled with CFR 0.152.
 */
package TimerPackage;

public class JavaTimer {
    public static boolean s_DEBUG = false;
    public static boolean s_IsWindowsOS = false;
    public static boolean s_IsWindowsDllLoaded = false;
    private long m_PointerTimer;
    private final Object m_SyncTimer = new Object();

    public JavaTimer() {
        this.initMembers();
        if (s_IsWindowsDllLoaded) {
            this.m_PointerTimer = JavaTimer.createTimer();
        }
        if (this.m_PointerTimer < 0L) {
            // empty if block
        }
    }

    private void initMembers() {
        this.m_PointerTimer = -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (s_IsWindowsDllLoaded && this.m_PointerTimer > 0L) {
            JavaTimer.close(this.m_PointerTimer);
            this.m_PointerTimer = -1L;
            return;
        }
        Object object = this.m_SyncTimer;
        synchronized (object) {
            this.m_SyncTimer.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sleep(long p_Milliseconds) {
        Object object;
        if (p_Milliseconds <= 0L) {
            return;
        }
        boolean boolSleepDone = false;
        long longStartNano = 0L;
        long longEndNano = 0L;
        long longSleepedMilliseconds = 0L;
        if (s_DEBUG) {
            longStartNano = System.nanoTime();
            System.out.print("    JavaTimer sleep  p_Milliseconds: " + p_Milliseconds);
        }
        if (s_IsWindowsOS) {
            if (s_IsWindowsDllLoaded && this.m_PointerTimer > 0L) {
                object = this.m_SyncTimer;
                synchronized (object) {
                    long longRetiurnValue = JavaTimer.waitMilliseconds(this.m_PointerTimer, p_Milliseconds);
                    if (longRetiurnValue >= 0L) {
                        boolSleepDone = true;
                        if (longRetiurnValue == 0L && s_DEBUG) {
                            longStartNano = System.nanoTime();
                            System.out.print(" Timer cancelled ");
                        }
                    }
                }
            }
            if (!boolSleepDone) {
                object = this.m_SyncTimer;
                synchronized (object) {
                    if (p_Milliseconds > 8L) {
                        try {
                            this.m_SyncTimer.wait(p_Milliseconds);
                        }
                        catch (Exception exception) {}
                    } else if (s_DEBUG) {
                        System.out.print(" less than half WindowsDefaultTimePeriod ");
                    }
                }
                boolSleepDone = true;
            }
        }
        if (!boolSleepDone) {
            object = this.m_SyncTimer;
            synchronized (object) {
                try {
                    this.m_SyncTimer.wait(p_Milliseconds);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (s_DEBUG) {
            longEndNano = System.nanoTime();
            longSleepedMilliseconds = (longEndNano - longStartNano) / 1000000L;
            System.out.println(" sleeped: " + longSleepedMilliseconds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelSleep() {
        if (s_IsWindowsDllLoaded && this.m_PointerTimer > 0L) {
            JavaTimer.cancelWaitMilliseconds(this.m_PointerTimer);
            return;
        }
        Object object = this.m_SyncTimer;
        synchronized (object) {
            this.m_SyncTimer.notifyAll();
        }
    }

    public void doNoting() {
    }

    public long getSystemMillis() {
        if (s_IsWindowsDllLoaded) {
            return JavaTimer.getSystemMillis(this.m_PointerTimer);
        }
        return System.nanoTime() / 1000000L;
    }

    public static int getWindowsHighResolutionTimersCount() {
        if (s_IsWindowsDllLoaded) {
            return JavaTimer.getTimersCount();
        }
        return 0;
    }

    private static native long createTimer();

    private static native long waitMilliseconds(long var0, long var2);

    private static native void cancelWaitMilliseconds(long var0);

    private static native long getSystemMillis(long var0);

    private static native void close(long var0);

    private static native int getTimersCount();

    static {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.indexOf("win") >= 0) {
            s_IsWindowsOS = true;
            if (Integer.valueOf(System.getProperty("sun.arch.data.model")) >= 64) {
                try {
                    System.loadLibrary("import/JavaTimer64");
                    s_IsWindowsDllLoaded = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

