/*
 * Decompiled with CFR 0.152.
 */
package LanguageTools.LiveLanguagePackage;

import LanguageTools.FlagsPackage.LiveLanguageFlagModel;
import LanguageTools.LiveLanguagePackage.LiveLanguageListener;
import LanguageTools.LiveLanguagePackage.LiveLanguageResourceBundle;
import LanguageTools.LiveLanguagePackage.LiveLanguageString;
import LanguageTools.LocalePackage.LiveLangageLocaleHandling;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import javax.swing.ImageIcon;

public class LiveLanguage {
    public static String DEFAULTCHARSET_FILE = "UTF-16";
    public static boolean s_WriteLanguageFile = false;
    public static Locale s_DefaultLocale;
    public static Locale s_ActualLocale;
    public static String s_DefaultLanguageFolder;
    public static String s_DefaultLanguageFileBase;
    public static HashMap<Object, String> s_LanguageListeners;
    public static HashMap<String, String> s_WrittenClasses;
    public static LiveLanguageListener.LiveLanguageStandardMethod[] m_ArrayStandardMethods;
    public static ArrayList<LiveLanguageListener.LiveLanguageStandardMethod> m_ArrayListStandardMethods;
    public static final Object s_SyncListeners;

    public static void setWriteDefault(boolean p_WriteLanguageFile) {
        s_WriteLanguageFile = p_WriteLanguageFile;
    }

    public static String getDefaultLanguageFolder() {
        return s_DefaultLanguageFolder;
    }

    public static void setDefaultLanguageFileBaseName(String p_FileBaseName) {
        if (p_FileBaseName == null) {
            return;
        }
        s_DefaultLanguageFileBase = p_FileBaseName;
        LiveLanguage.eventLocaleChanged(null, s_ActualLocale);
    }

    public String getDefaultLanguageFileBaseName() {
        return s_DefaultLanguageFileBase;
    }

    public static String getLanguageFolder() {
        String stringFileName = s_DefaultLanguageFolder != null && s_DefaultLanguageFolder.length() > 0 ? s_DefaultLanguageFolder : "";
        return stringFileName;
    }

    public static String getLanguageFileBaseName(Object p_LiveLanguageListener) {
        String stringFileBaseName = s_LanguageListeners.get(p_LiveLanguageListener);
        if (stringFileBaseName == null) {
            stringFileBaseName = s_DefaultLanguageFileBase;
        }
        if (stringFileBaseName == null) {
            stringFileBaseName = p_LiveLanguageListener.getClass().getSimpleName();
        }
        return stringFileBaseName;
    }

    public static String getLanguageFileName(Object p_LiveLanguageListener, Locale p_Locale) {
        if (p_LiveLanguageListener == null) {
            return null;
        }
        String stringLocale = p_Locale == null ? "" : LiveLanguage.getLocaleKeyFromLocale(p_Locale);
        String stringFileBaseName = LiveLanguage.getLanguageFileBaseName(p_LiveLanguageListener);
        if (stringLocale.length() > 0) {
            stringLocale = "_" + stringLocale;
        }
        String stringFileName = s_DefaultLanguageFolder != null && s_DefaultLanguageFolder.length() > 0 ? s_DefaultLanguageFolder + File.separator + stringFileBaseName + stringLocale + ".lng" : stringFileBaseName + stringLocale + ".lng";
        return stringFileName;
    }

    public static void selectLanguage(Locale p_Locale) {
        Locale o_OldLocale = s_ActualLocale;
        if (p_Locale != null) {
            s_ActualLocale = p_Locale;
        }
        if (s_ActualLocale == null) {
            s_ActualLocale = s_DefaultLocale;
        }
        LiveLanguage.eventLocaleChanged(o_OldLocale, s_ActualLocale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshLanguage(LiveLanguageListener p_LanguageListener) {
        if (p_LanguageListener == null) {
            return;
        }
        Object object = s_SyncListeners;
        synchronized (object) {
            if (!s_LanguageListeners.containsKey(p_LanguageListener)) {
                return;
            }
        }
        LiveLanguage.loadLanguageStrings(p_LanguageListener);
    }

    public static Locale getLocaleActual() {
        if (s_ActualLocale == null) {
            return s_DefaultLocale;
        }
        return s_ActualLocale;
    }

    public String getLanguageName(Locale p_Locale) {
        if (p_Locale == null) {
            p_Locale = LiveLanguage.getLocaleActual();
        }
        return LiveLangageLocaleHandling.getDisplayLanguage(p_Locale);
    }

    public String getCountryName(Locale p_Locale) {
        if (p_Locale == null) {
            p_Locale = LiveLanguage.getLocaleActual();
        }
        return LiveLangageLocaleHandling.getCountryName(p_Locale);
    }

    public static ImageIcon getFlag(Locale p_Locale) {
        if (p_Locale == null) {
            p_Locale = LiveLanguage.getLocaleActual();
        }
        return LiveLanguage.getFlagFromLanguageKey(LiveLanguage.getLocaleKeyFromLocale(p_Locale));
    }

    public static ImageIcon getFlagFromLanguageKey(String p_LanguageKey) {
        ImageIcon o_Image;
        if (p_LanguageKey == null || p_LanguageKey.length() <= 0) {
            p_LanguageKey = LiveLanguage.getLocaleKeyFromLocale(LiveLanguage.getLocaleActual());
        }
        String o_FileName = LiveLangageLocaleHandling.getName_ReplacedPoint(LiveLanguageFlagModel.class.getPackage().getName()) + "/" + p_LanguageKey + ".gif";
        try {
            o_Image = new ImageIcon(LiveLanguageFlagModel.class.getClassLoader().getResource(o_FileName));
        }
        catch (Exception e) {
            o_Image = null;
        }
        return o_Image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addLanguageListener(Object p_LanguageListener, String p_FileBaseName) {
        if (p_LanguageListener == null) {
            return;
        }
        Object object = s_SyncListeners;
        synchronized (object) {
            if (s_LanguageListeners == null) {
                return;
            }
            if (s_LanguageListeners.containsKey(p_LanguageListener)) {
                return;
            }
            s_LanguageListeners.put(p_LanguageListener, p_FileBaseName);
        }
        if (s_WriteLanguageFile) {
            LiveLanguage.writeLanguageStrings(p_LanguageListener);
        }
        LiveLanguage.loadLanguageStrings(p_LanguageListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addLanguageListener_Interest(Object p_LanguageListener) {
        if (p_LanguageListener == null) {
            return;
        }
        Object object = s_SyncListeners;
        synchronized (object) {
            if (s_LanguageListeners == null) {
                return;
            }
            if (s_LanguageListeners.containsKey(p_LanguageListener)) {
                return;
            }
            s_LanguageListeners.put(p_LanguageListener, null);
        }
        LiveLanguage.loadLanguageStrings(p_LanguageListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeLanguageListener(Object p_LanguageListener) {
        if (p_LanguageListener == null) {
            return;
        }
        Object object = s_SyncListeners;
        synchronized (object) {
            if (s_LanguageListeners == null) {
                return;
            }
            s_LanguageListeners.remove(p_LanguageListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void eventLocaleChanged(Locale p_OldLocale, Locale p_Locale) {
        ArrayList<Object> o_Listeners;
        boolean boolFireEvent = false;
        Object object = s_SyncListeners;
        synchronized (object) {
            if (s_LanguageListeners == null) {
                return;
            }
            o_Listeners = new ArrayList<Object>(s_LanguageListeners.size());
            o_Listeners.addAll(s_LanguageListeners.keySet());
        }
        for (int intListener = 0; intListener < o_Listeners.size(); ++intListener) {
            Object o_LanguageListener = o_Listeners.get(intListener);
            LiveLanguage.loadLanguageStrings(o_LanguageListener);
            if (p_OldLocale != null && !p_OldLocale.equals(p_Locale)) {
                boolFireEvent = true;
            }
            if (p_Locale != null && !p_Locale.equals(p_OldLocale)) {
                boolFireEvent = true;
            }
            if (!boolFireEvent || !(o_LanguageListener instanceof LiveLanguageListener)) continue;
            ((LiveLanguageListener)o_LanguageListener).eventLanguageChanged(p_Locale, p_Locale);
        }
    }

    public static Locale getLocaleFromLocaleKey(String p_LocaleKey) {
        return LiveLangageLocaleHandling.getLocaleFromLocaleKey(p_LocaleKey);
    }

    public static String getLocaleKeyFromLocale(Locale p_Locale) {
        return LiveLangageLocaleHandling.getLocaleKeyFromLocale(p_Locale);
    }

    public static boolean isLocaleValid(Locale p_LanguageLocale) {
        return LiveLangageLocaleHandling.isLocaleValid(p_LanguageLocale);
    }

    public static boolean isLocaleKeyValid(String p_LanguageKey) {
        return LiveLangageLocaleHandling.isLocaleKeyValid(p_LanguageKey);
    }

    public static boolean isLocaleAvailable(Locale p_Locale) {
        return LiveLangageLocaleHandling.isLocaleAvailable(p_Locale);
    }

    public static boolean isLocaleKeyAvailable(String p_LocaleKey) {
        return LiveLangageLocaleHandling.isLocaleKeyAvailable(p_LocaleKey);
    }

    public static String getLanguage(Locale p_Locale) {
        return LiveLangageLocaleHandling.getLanguage(p_Locale);
    }

    public static String getDisplayLanguage(Locale p_Locale) {
        return LiveLangageLocaleHandling.getDisplayLanguage(p_Locale);
    }

    public static String getCountry(Locale p_Locale) {
        return LiveLangageLocaleHandling.getCountry(p_Locale);
    }

    public static String getDisplayCountry(Locale p_Locale) {
        return LiveLangageLocaleHandling.getDisplayCountry(p_Locale);
    }

    public int getStandardMethodsCount() {
        return m_ArrayListStandardMethods.size();
    }

    public LiveLanguageListener.LiveLanguageStandardMethod getStandardMethod(int p_Index) {
        if (p_Index < 0 || p_Index >= m_ArrayListStandardMethods.size()) {
            return null;
        }
        return m_ArrayListStandardMethods.get(p_Index);
    }

    public void addStandardMethod(LiveLanguageListener.LiveLanguageStandardMethod p_StandardMethod) {
        if (p_StandardMethod == null) {
            return;
        }
        if (!p_StandardMethod.isValid()) {
            return;
        }
        if (m_ArrayListStandardMethods.contains(p_StandardMethod)) {
            return;
        }
        for (int intMethod = 0; intMethod < m_ArrayListStandardMethods.size(); ++intMethod) {
            LiveLanguageListener.LiveLanguageStandardMethod o_StandardMethod = m_ArrayListStandardMethods.get(intMethod);
            if (!o_StandardMethod.equals(p_StandardMethod)) continue;
            return;
        }
        m_ArrayListStandardMethods.add(p_StandardMethod);
    }

    public LiveLanguageListener.LiveLanguageStandardMethod removeStandardMethod(int p_Index) {
        if (p_Index < 0 || p_Index >= m_ArrayListStandardMethods.size()) {
            return null;
        }
        return m_ArrayListStandardMethods.remove(p_Index);
    }

    public boolean removeStandardMethod(LiveLanguageListener.LiveLanguageStandardMethod p_StandardMethod) {
        if (p_StandardMethod == null) {
            return false;
        }
        boolean boolContains = false;
        if (m_ArrayListStandardMethods.contains(p_StandardMethod)) {
            return m_ArrayListStandardMethods.remove(p_StandardMethod);
        }
        if (!boolContains) {
            int intMethod;
            for (intMethod = 0; intMethod < m_ArrayListStandardMethods.size(); ++intMethod) {
                LiveLanguageListener.LiveLanguageStandardMethod o_StandardMethod = m_ArrayListStandardMethods.get(intMethod);
                if (!o_StandardMethod.equals(p_StandardMethod)) continue;
                boolContains = true;
                break;
            }
            if (boolContains) {
                return m_ArrayListStandardMethods.remove(intMethod) != null;
            }
        }
        return false;
    }

    public static LiveLanguageResourceBundle getLanguageResourceBundle(String p_FileNameBasis, Locale p_Locale) {
        LiveLanguageResourceBundle o_LiveLanguageResourceBundle = new LiveLanguageResourceBundle();
        if (p_FileNameBasis == null || p_FileNameBasis.length() <= 0) {
            return o_LiveLanguageResourceBundle;
        }
        if (p_Locale == null) {
            p_Locale = s_DefaultLocale;
        }
        int intTryCount = 0;
        String stringFilePathName = s_DefaultLanguageFolder != null && s_DefaultLanguageFolder.length() > 0 ? s_DefaultLanguageFolder + "/" + p_FileNameBasis : p_FileNameBasis;
        String stringlocaleKey = LiveLanguage.getLocaleKeyFromLocale(p_Locale);
        if (stringlocaleKey == null || stringlocaleKey.length() <= 0) {
            stringlocaleKey = "";
        }
        while (stringFilePathName != null && stringFilePathName.length() > 0) {
            File o_File = new File(stringFilePathName + "_" + stringlocaleKey + ".lng");
            o_LiveLanguageResourceBundle = new LiveLanguageResourceBundle(o_File);
            if (o_LiveLanguageResourceBundle.isValid()) {
                return o_LiveLanguageResourceBundle;
            }
            o_File = new File(stringFilePathName + "_" + p_Locale.getLanguage() + ".lng");
            o_LiveLanguageResourceBundle = new LiveLanguageResourceBundle(o_File);
            if (o_LiveLanguageResourceBundle.isValid()) {
                return o_LiveLanguageResourceBundle;
            }
            o_File = new File(stringFilePathName + ".lng");
            o_LiveLanguageResourceBundle = new LiveLanguageResourceBundle(o_File);
            if (o_LiveLanguageResourceBundle.isValid()) {
                return o_LiveLanguageResourceBundle;
            }
            switch (intTryCount) {
                case 0: {
                    stringFilePathName = "lib/" + p_FileNameBasis;
                    break;
                }
                case 1: {
                    stringFilePathName = p_FileNameBasis;
                    break;
                }
                case 2: {
                    stringFilePathName = "languages/" + p_FileNameBasis;
                    break;
                }
                default: {
                    stringFilePathName = null;
                }
            }
            ++intTryCount;
        }
        return o_LiveLanguageResourceBundle;
    }

    public static String getResourceString(PropertyResourceBundle p_ResourceBundle, String p_ClassKey, String p_TextKey, Object[] p_TextArguments) {
        if (p_ResourceBundle == null) {
            return null;
        }
        if (p_TextKey == null) {
            return null;
        }
        String stringResource = null;
        String stringComposedKey = p_ClassKey != null ? p_ClassKey + "/" + p_TextKey : p_TextKey;
        try {
            stringResource = p_ResourceBundle.getString(stringComposedKey);
        }
        catch (Exception e) {
            stringResource = null;
        }
        if (stringResource == null) {
            try {
                stringResource = p_ResourceBundle.getString(p_TextKey);
            }
            catch (Exception e) {
                stringResource = null;
            }
        }
        if (stringResource == null) {
            return null;
        }
        if (p_TextArguments == null || p_TextArguments.length <= 0) {
            return stringResource;
        }
        MessageFormat o_MessageFormat = new MessageFormat("");
        o_MessageFormat.setLocale(p_ResourceBundle.getLocale());
        o_MessageFormat.applyPattern(stringResource);
        return o_MessageFormat.format(p_TextArguments);
    }

    public static void loadLanguageStrings(Object p_LanguageListener) {
        if (p_LanguageListener == null) {
            return;
        }
        ComponentOrientation o_ComponentOrientation = LiveLangageLocaleHandling.getComponentOrientation(s_ActualLocale);
        String stringFileNameBasis = LiveLanguage.getLanguageFileBaseName(p_LanguageListener);
        LiveLanguageResourceBundle o_LiveLanguageResourceBundle = LiveLanguage.getLanguageResourceBundle(stringFileNameBasis, s_ActualLocale);
        if (!o_LiveLanguageResourceBundle.isValid()) {
            o_LiveLanguageResourceBundle.close();
            return;
        }
        if (o_LiveLanguageResourceBundle != null) {
            PropertyResourceBundle o_PropertyResourceBundle = o_LiveLanguageResourceBundle.getPropertyResourceBundle();
            LiveLanguage.loadLanguageStrings(o_PropertyResourceBundle, p_LanguageListener, null, p_LanguageListener);
            Field[] o_DeclaredFields = p_LanguageListener.getClass().getDeclaredFields();
            for (int intField = 0; intField < o_DeclaredFields.length; ++intField) {
                Field o_Field = o_DeclaredFields[intField];
                try {
                    Object o_FieldsObject;
                    boolean boolFieldAccessible = o_Field.isAccessible();
                    if (!boolFieldAccessible) {
                        o_Field.setAccessible(true);
                    }
                    if (LiveLanguage.loadLanguageStrings(o_PropertyResourceBundle, p_LanguageListener, o_Field, o_FieldsObject = o_Field.get(p_LanguageListener)) && o_FieldsObject instanceof Component && o_ComponentOrientation != null) {
                        Component o_Component = (Component)o_FieldsObject;
                        o_Component.setComponentOrientation(o_ComponentOrientation);
                    }
                    if (boolFieldAccessible) continue;
                    o_Field.setAccessible(false);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            o_LiveLanguageResourceBundle.close();
        }
    }

    public static boolean loadLanguageStrings(PropertyResourceBundle p_PropertyResourceBundle, Object p_Object, Field p_Field, Object p_FieldObject) {
        Annotation[] o_FieldAnnotations;
        if (p_Object == null) {
            return false;
        }
        if (p_PropertyResourceBundle == null) {
            return false;
        }
        boolean boolFound = false;
        boolean boolUseStandardMethods = true;
        Class<?> o_Type = p_FieldObject.getClass();
        String stringFieldName = p_Field != null ? p_Field.getName() : p_FieldObject.getClass().getSimpleName();
        String stringListenerClass = p_Object.getClass().getSimpleName();
        if (p_Field != null && p_Field.getType() == String.class && (o_FieldAnnotations = p_Field.getDeclaredAnnotations()).length > 0) {
            for (int intAnnotation = 0; intAnnotation < o_FieldAnnotations.length; ++intAnnotation) {
                if (!(o_FieldAnnotations[intAnnotation] instanceof LiveLanguageString)) continue;
                try {
                    String stringResource = LiveLanguage.getResourceString(p_PropertyResourceBundle, stringListenerClass, stringFieldName, null);
                    if (stringResource != null) {
                        if (stringResource.contentEquals("null")) {
                            stringResource = null;
                        }
                        boolFound = true;
                        p_Field.setAccessible(true);
                        p_Field.set(p_Object, stringResource);
                    }
                }
                catch (Exception e) {
                    String stringResource = "";
                }
                return boolFound;
            }
        }
        if (p_FieldObject == null) {
            return false;
        }
        if (boolUseStandardMethods) {
            for (int intMethod = 0; intMethod < m_ArrayListStandardMethods.size(); ++intMethod) {
                LiveLanguageListener.LiveLanguageStandardMethod o_StandardMethod = m_ArrayListStandardMethods.get(intMethod);
                try {
                    String stringResource;
                    String stringPropertyKey = o_StandardMethod.getPropertyKey();
                    if (!o_StandardMethod.isIndexed()) {
                        stringResource = LiveLanguage.getResourceString(p_PropertyResourceBundle, stringListenerClass, stringFieldName + "/" + stringPropertyKey, null);
                        if (stringResource == null) continue;
                        if (stringResource.equals("null")) {
                            stringResource = null;
                        }
                        o_StandardMethod.invokeSet(p_FieldObject, stringResource);
                        boolFound = true;
                        continue;
                    }
                    int intIndexCount = o_StandardMethod.invokeGetIndexCount(p_FieldObject);
                    for (int intIndex = 0; intIndex < intIndexCount; ++intIndex) {
                        stringResource = LiveLanguage.getResourceString(p_PropertyResourceBundle, stringListenerClass, stringFieldName + "/" + stringPropertyKey + "(" + intIndex + ")", null);
                        if (stringResource == null) continue;
                        if (stringResource.equals("null")) {
                            stringResource = null;
                        }
                        o_StandardMethod.invokeSet(p_FieldObject, intIndex, stringResource);
                        boolFound = true;
                    }
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return boolFound;
    }

    public static String loadLanguageString(Object p_LanguageListener, String p_TextKey) {
        if (p_LanguageListener == null) {
            return null;
        }
        boolean boolFound = false;
        String stringResource = null;
        String stringListenerClass = p_LanguageListener.getClass().getSimpleName();
        String stringFileBaseName = LiveLanguage.getLanguageFileBaseName(p_LanguageListener);
        LiveLanguageResourceBundle o_LiveLanguageResourceBundle = LiveLanguage.getLanguageResourceBundle(stringFileBaseName, s_ActualLocale);
        if (!o_LiveLanguageResourceBundle.isValid()) {
            o_LiveLanguageResourceBundle.close();
            return null;
        }
        if (o_LiveLanguageResourceBundle != null) {
            PropertyResourceBundle o_PropertyResourceBundle = o_LiveLanguageResourceBundle.getPropertyResourceBundle();
            if (o_PropertyResourceBundle != null && (stringResource = LiveLanguage.getResourceString(o_PropertyResourceBundle, stringListenerClass, p_TextKey, null)) != null) {
                boolFound = true;
            }
            o_LiveLanguageResourceBundle.close();
        }
        if (boolFound) {
            return stringResource;
        }
        return null;
    }

    public static void writeLanguageStrings(Object p_LanguageListener) {
        if (p_LanguageListener == null) {
            return;
        }
        FileOutputStream o_FileOutputStream = null;
        OutputStreamWriter o_OutputStreamWriter = null;
        boolean boolCreateNewFile = true;
        String stringClassName = p_LanguageListener.getClass().getName();
        if (s_WrittenClasses.containsKey(stringClassName)) {
            return;
        }
        String stringLanguageFolderName = LiveLanguage.getLanguageFolder();
        File o_LanguageFolder = stringLanguageFolderName.length() > 0 ? new File(stringLanguageFolderName) : null;
        String stringFileName = LiveLanguage.getLanguageFileName(p_LanguageListener, null);
        File o_File = new File(stringFileName);
        boolCreateNewFile = !s_WrittenClasses.containsValue(stringFileName);
        if (boolCreateNewFile) {
            try {
                if (o_LanguageFolder != null && !o_LanguageFolder.exists()) {
                    o_LanguageFolder.mkdir();
                }
                if (o_File.exists()) {
                    o_File.delete();
                }
                o_File.createNewFile();
            }
            catch (Exception e) {
                return;
            }
        }
        s_WrittenClasses.put(stringClassName, stringFileName);
        try {
            o_FileOutputStream = new FileOutputStream(o_File, true);
            o_OutputStreamWriter = new OutputStreamWriter((OutputStream)o_FileOutputStream, DEFAULTCHARSET_FILE);
        }
        catch (Exception e) {
            try {
                if (o_OutputStreamWriter != null) {
                    o_OutputStreamWriter.close();
                }
                if (o_FileOutputStream != null) {
                    o_FileOutputStream.close();
                }
            }
            catch (Exception eClose) {
                // empty catch block
            }
            return;
        }
        try {
            o_OutputStreamWriter.append("\n");
            o_OutputStreamWriter.append("--- " + p_LanguageListener.getClass().getSimpleName() + " ---\n");
        }
        catch (Exception e) {
            // empty catch block
        }
        LiveLanguage.writeLanguageStrings(p_LanguageListener, null, p_LanguageListener, o_OutputStreamWriter);
        Field[] o_DeclaredFields = p_LanguageListener.getClass().getDeclaredFields();
        for (int intField = 0; intField < o_DeclaredFields.length; ++intField) {
            Field o_Field = o_DeclaredFields[intField];
            try {
                boolean boolFieldAccessible = o_Field.isAccessible();
                if (!boolFieldAccessible) {
                    o_Field.setAccessible(true);
                }
                Object o_FieldsObject = o_Field.get(p_LanguageListener);
                LiveLanguage.writeLanguageStrings(p_LanguageListener, o_Field, o_FieldsObject, o_OutputStreamWriter);
                if (boolFieldAccessible) continue;
                o_Field.setAccessible(false);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        try {
            if (o_OutputStreamWriter != null) {
                o_OutputStreamWriter.flush();
                o_OutputStreamWriter.close();
            }
            if (o_FileOutputStream != null) {
                o_FileOutputStream.close();
            }
        }
        catch (Exception eClose) {
            // empty catch block
        }
    }

    public static void writeLanguageStrings(Object p_LiveLanguageListener, Field p_Field, Object p_FieldObject, OutputStreamWriter p_FileWriter) {
        String stringResource;
        Annotation[] o_FieldAnnotations;
        if (p_LiveLanguageListener == null || p_FieldObject == null || p_FileWriter == null) {
            return;
        }
        boolean boolUseStandardMethods = true;
        String stringListenerClass = p_LiveLanguageListener.getClass().getSimpleName();
        Class<?> o_Type = p_FieldObject.getClass();
        String stringFieldName = p_Field != null ? p_Field.getName() : p_FieldObject.getClass().getSimpleName();
        if (p_Field != null && p_Field.getType() == String.class && (o_FieldAnnotations = p_Field.getDeclaredAnnotations()).length > 0) {
            for (int intAnnotation = 0; intAnnotation < o_FieldAnnotations.length; ++intAnnotation) {
                if (!(o_FieldAnnotations[intAnnotation] instanceof LiveLanguageString)) continue;
                try {
                    stringResource = (String)p_FieldObject;
                    p_FileWriter.append(stringListenerClass + "/" + stringFieldName + "=" + stringResource + "\n");
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        if (p_FieldObject == null) {
            return;
        }
        if (boolUseStandardMethods) {
            for (int intMethod = 0; intMethod < m_ArrayListStandardMethods.size(); ++intMethod) {
                LiveLanguageListener.LiveLanguageStandardMethod o_StandardMethod = m_ArrayListStandardMethods.get(intMethod);
                try {
                    String stringPropertyKey = o_StandardMethod.getPropertyKey();
                    if (!o_StandardMethod.isIndexed()) {
                        stringResource = o_StandardMethod.invokeGet(p_FieldObject);
                        p_FileWriter.append(stringListenerClass + "/" + stringFieldName + "/" + stringPropertyKey + "=" + stringResource + "\n");
                        continue;
                    }
                    int intIndexCount = o_StandardMethod.invokeGetIndexCount(p_FieldObject);
                    for (int intIndex = 0; intIndex < intIndexCount; ++intIndex) {
                        stringResource = o_StandardMethod.invokeGet(p_FieldObject, intIndex);
                        p_FileWriter.append(stringListenerClass + "/" + stringFieldName + "/" + stringPropertyKey + "(" + intIndex + ")" + "=" + stringResource + "\n");
                    }
                    continue;
                }
                catch (Exception e) {
                    boolean intTest = false;
                }
            }
        }
    }

    public static ImageIcon getFlagFromLocale(Locale p_Locale) {
        return LiveLanguageFlagModel.getFlagFromLocale(p_Locale);
    }

    public static LiveLanguageFlagModel getLanguagesFlagListModel(Object p_LanguageListener) {
        String stringFileNameBasis;
        LiveLanguageResourceBundle o_LanguageResourceBundle;
        ArrayList<Locale> o_ArrayListLocales = new ArrayList<Locale>();
        if (p_LanguageListener != null && (o_LanguageResourceBundle = LiveLanguage.getLanguageResourceBundle((stringFileNameBasis = LiveLanguage.getLanguageFileBaseName(p_LanguageListener)) + "_installed.lng", null)) != null) {
            PropertyResourceBundle o_PropertyResourceBundle = o_LanguageResourceBundle.getPropertyResourceBundle();
            if (o_PropertyResourceBundle != null) {
                Enumeration<String> o_Keys = o_PropertyResourceBundle.getKeys();
                while (o_Keys.hasMoreElements()) {
                    String stringKey = o_Keys.nextElement();
                    Locale o_Locale = LiveLanguage.getLocaleFromLocaleKey(stringKey);
                    o_ArrayListLocales.add(o_Locale);
                }
            }
            o_LanguageResourceBundle.close();
        }
        LiveLanguageFlagModel o_LiveLanguageFlagModel = new LiveLanguageFlagModel(o_ArrayListLocales);
        return o_LiveLanguageFlagModel;
    }

    static {
        s_ActualLocale = s_DefaultLocale = Locale.getDefault();
        s_DefaultLanguageFolder = "Languages";
        s_DefaultLanguageFileBase = "Project";
        s_LanguageListeners = new HashMap();
        s_WrittenClasses = new HashMap();
        m_ArrayStandardMethods = new LiveLanguageListener.LiveLanguageStandardMethod[]{new LiveLanguageListener.LiveLanguageStandardMethod("title", "getTitle", "setTitle", false, null), new LiveLanguageListener.LiveLanguageStandardMethod("text", "getText", "setText", false, null), new LiveLanguageListener.LiveLanguageStandardMethod("toolTipText", "getToolTipText", "setToolTipText", false, null), new LiveLanguageListener.LiveLanguageStandardMethod("titleAt", "getTitleAt", "setTitleAt", true, "getTabCount")};
        m_ArrayListStandardMethods = new ArrayList<LiveLanguageListener.LiveLanguageStandardMethod>(Arrays.asList(m_ArrayStandardMethods));
        s_SyncListeners = new Object();
    }
}

