/*
 * Decompiled with CFR 0.152.
 */
package LanguageTools.EditPackage;

import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LanguageTools.LiveLanguagePackage.LiveLanguageResourceBundle;
import LanguageTools.LocalePackage.LiveLangageLocaleHandling;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import javax.swing.table.AbstractTableModel;

public class LiveLanguageEditTableModel
extends AbstractTableModel {
    protected String[] m_ColumnDefaultNames = new String[]{"", "Default"};
    protected ArrayList<Locale> m_ColumnLocales = new ArrayList();
    protected ArrayList<String> m_ColumnNames;
    protected ArrayList<Boolean> m_ColumnChanged;
    protected ArrayList<ArrayList<String>> m_RowData;
    protected ArrayList<String> m_ArrayListOldPropertyKeys;
    protected File m_LanguageDefaultFile;
    protected String m_LanguageFileNameBasis;
    protected File m_LanguageParentDirectory;
    protected String m_LanguageParentDirectoryPath;

    public LiveLanguageEditTableModel() {
        this.m_ColumnLocales.add(null);
        this.m_ColumnLocales.add(null);
        this.m_ColumnChanged = new ArrayList();
        this.m_ColumnChanged.add(Boolean.FALSE);
        this.m_ColumnChanged.add(Boolean.FALSE);
        this.m_ColumnNames = new ArrayList();
        for (int intColumn = 0; intColumn < this.m_ColumnDefaultNames.length; ++intColumn) {
            this.m_ColumnNames.add(this.m_ColumnDefaultNames[intColumn]);
        }
        this.m_RowData = new ArrayList();
        this.m_ArrayListOldPropertyKeys = new ArrayList();
    }

    @Override
    public String getColumnName(int p_ColumnIndex) {
        if (p_ColumnIndex < 0 || p_ColumnIndex >= this.m_ColumnNames.size()) {
            return "";
        }
        return this.m_ColumnNames.get(p_ColumnIndex);
    }

    @Override
    public int getRowCount() {
        return this.m_RowData.size();
    }

    @Override
    public int getColumnCount() {
        return this.m_ColumnNames.size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (row < 0 || row >= this.m_RowData.size()) {
            return null;
        }
        if (col < 0 || col >= this.m_ColumnNames.size()) {
            return null;
        }
        return this.m_RowData.get(row).get(col);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return true;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        String stringNewValue;
        String stringOldValue = (String)this.getValueAt(row, col);
        if (!stringOldValue.equals(stringNewValue = (String)value)) {
            this.m_ColumnChanged.set(col, Boolean.TRUE);
        }
        this.m_RowData.get(row).set(col, value.toString());
        this.fireTableCellUpdated(row, col);
    }

    protected void clearModel() {
        int intRows = this.m_RowData.size();
        int intCols = this.m_ColumnNames.size();
        if (this.m_RowData.size() > 0) {
            this.m_RowData.clear();
            this.m_ArrayListOldPropertyKeys.clear();
            this.fireTableRowsDeleted(0, intRows - 1);
        }
        if (intCols > this.m_ColumnDefaultNames.length) {
            int intColumn;
            for (intColumn = intCols - 1; intColumn >= this.m_ColumnDefaultNames.length; --intColumn) {
                this.m_ColumnNames.remove(intColumn);
                this.m_ColumnLocales.remove(intColumn);
                this.m_ColumnChanged.remove(intColumn);
            }
            for (intColumn = 0; intColumn < this.m_ColumnDefaultNames.length; ++intColumn) {
                this.m_ColumnChanged.set(intColumn, Boolean.FALSE);
            }
            this.fireTableStructureChanged();
        }
    }

    public void addRow(int p_Line, boolean p_Before) {
        ArrayList<String> o_ArrayListRow = new ArrayList<String>();
        for (int intCol = 0; intCol < this.m_ColumnNames.size(); ++intCol) {
            o_ArrayListRow.add("");
        }
        int intLine = p_Line < 0 || p_Line >= this.m_RowData.size() ? (p_Before ? 0 : this.m_RowData.size()) : (p_Before ? p_Line : p_Line + 1);
        this.m_ColumnChanged.set(0, Boolean.TRUE);
        this.m_RowData.add(intLine, o_ArrayListRow);
        this.m_ArrayListOldPropertyKeys.add(intLine, "");
        this.fireTableRowsInserted(intLine, intLine);
    }

    public void deleteRow(int p_Line) {
        if (p_Line < 0 || p_Line >= this.m_RowData.size()) {
            return;
        }
        this.m_ColumnChanged.set(0, Boolean.TRUE);
        this.m_RowData.remove(p_Line);
        this.m_ArrayListOldPropertyKeys.remove(p_Line);
        this.fireTableRowsDeleted(p_Line, p_Line);
    }

    public void moveRowUp(int p_SelectedRow) {
        if (p_SelectedRow < 0) {
            return;
        }
        if (p_SelectedRow >= this.m_RowData.size()) {
            return;
        }
        if (p_SelectedRow == 0) {
            return;
        }
        this.m_ColumnChanged.set(0, Boolean.TRUE);
        ArrayList<String> o_ArrayListRow = this.m_RowData.get(p_SelectedRow);
        String stringOlPropertyKey = this.m_ArrayListOldPropertyKeys.get(p_SelectedRow);
        this.m_RowData.remove(p_SelectedRow);
        this.m_ArrayListOldPropertyKeys.remove(p_SelectedRow);
        this.fireTableRowsDeleted(p_SelectedRow, p_SelectedRow);
        this.m_RowData.add(p_SelectedRow - 1, o_ArrayListRow);
        this.m_ArrayListOldPropertyKeys.add(p_SelectedRow - 1, stringOlPropertyKey);
        this.fireTableRowsInserted(p_SelectedRow - 1, p_SelectedRow - 1);
    }

    public void moveRowDown(int p_SelectedRow) {
        if (p_SelectedRow < 0) {
            return;
        }
        if (p_SelectedRow >= this.m_RowData.size()) {
            return;
        }
        if (p_SelectedRow == this.m_RowData.size() - 1) {
            return;
        }
        this.m_ColumnChanged.set(0, Boolean.TRUE);
        ArrayList<String> o_ArrayListRow = this.m_RowData.get(p_SelectedRow);
        String stringOlPropertyKey = this.m_ArrayListOldPropertyKeys.get(p_SelectedRow);
        this.m_RowData.remove(p_SelectedRow);
        this.m_ArrayListOldPropertyKeys.remove(p_SelectedRow);
        this.fireTableRowsDeleted(p_SelectedRow, p_SelectedRow);
        this.m_RowData.add(p_SelectedRow + 1, o_ArrayListRow);
        this.m_ArrayListOldPropertyKeys.add(p_SelectedRow + 1, stringOlPropertyKey);
        this.fireTableRowsInserted(p_SelectedRow + 1, p_SelectedRow + 1);
    }

    public boolean setLanguageFile(File p_File) {
        if (p_File == null) {
            return false;
        }
        String stringFileName = p_File.getName();
        if (stringFileName == null || stringFileName.length() < 5) {
            return false;
        }
        String[] o_FileParts = stringFileName.split("\\.", -1);
        if (!o_FileParts[o_FileParts.length - 1].equals("lng")) {
            return false;
        }
        stringFileName = stringFileName.substring(0, stringFileName.length() - 4);
        String[] o_LanguageParts = stringFileName.split("_", -1);
        String stringLocaleKey = "";
        int intLength = o_LanguageParts.length;
        if (intLength >= 2) {
            stringLocaleKey = o_LanguageParts[intLength - 2] + "_" + o_LanguageParts[intLength - 1];
        }
        if (LiveLangageLocaleHandling.isLocaleKeyValid(stringLocaleKey)) {
            stringFileName = stringFileName.substring(0, stringFileName.length() - (stringLocaleKey.length() + 1));
        } else {
            stringLocaleKey = o_LanguageParts[intLength - 1];
            if (LiveLangageLocaleHandling.isLocaleKeyValid(stringLocaleKey)) {
                stringFileName = stringFileName.substring(0, stringFileName.length() - (stringLocaleKey.length() + 1));
            } else {
                stringLocaleKey = "";
            }
        }
        this.m_LanguageParentDirectory = p_File.getParentFile();
        if (this.m_LanguageParentDirectory != null) {
            this.m_LanguageParentDirectoryPath = this.m_LanguageParentDirectory.getPath();
        }
        this.m_LanguageFileNameBasis = stringFileName;
        stringFileName = this.m_LanguageParentDirectoryPath == null ? this.m_LanguageFileNameBasis + ".lng" : this.m_LanguageParentDirectoryPath + "/" + this.m_LanguageFileNameBasis + ".lng";
        this.m_LanguageDefaultFile = new File(stringFileName);
        if (!this.m_LanguageDefaultFile.exists()) {
            stringFileName = this.m_LanguageParentDirectoryPath == null ? "lib/" + this.m_LanguageFileNameBasis + ".lng" : this.m_LanguageParentDirectoryPath + "/lib/" + this.m_LanguageFileNameBasis + ".lng";
            this.m_LanguageDefaultFile = new File(stringFileName);
            if (!this.m_LanguageDefaultFile.exists()) {
                stringFileName = this.m_LanguageParentDirectoryPath == null ? "languages/" + this.m_LanguageFileNameBasis + ".lng" : this.m_LanguageParentDirectoryPath + "/languages/" + this.m_LanguageFileNameBasis + ".lng";
                this.m_LanguageDefaultFile = new File(stringFileName);
                if (!this.m_LanguageDefaultFile.exists()) {
                    this.m_LanguageDefaultFile = null;
                }
            }
        }
        if (this.m_LanguageDefaultFile != null) {
            this.m_LanguageParentDirectory = this.m_LanguageDefaultFile.getParentFile();
            if (this.m_LanguageParentDirectory != null) {
                this.m_LanguageParentDirectoryPath = this.m_LanguageParentDirectory.getPath();
            }
        }
        Locale o_Locale = LiveLangageLocaleHandling.getLocaleFromLocaleKey(stringLocaleKey);
        return this.createModel(o_Locale);
    }

    private boolean createModel(Locale p_Locale) {
        this.clearModel();
        FileInputStream o_FileInputStream = null;
        InputStreamReader o_InputStreamReader = null;
        BufferedReader o_BufferedReader = null;
        File o_File = this.m_LanguageDefaultFile != null ? this.m_LanguageDefaultFile : (this.m_LanguageParentDirectoryPath == null ? new File(this.m_LanguageFileNameBasis + "_" + p_Locale.toString() + ".lng") : new File(this.m_LanguageParentDirectoryPath + "/" + this.m_LanguageFileNameBasis + "_" + p_Locale.toString() + ".lng"));
        try {
            o_FileInputStream = new FileInputStream(o_File);
            o_InputStreamReader = new InputStreamReader((InputStream)o_FileInputStream, LiveLanguage.DEFAULTCHARSET_FILE);
            o_BufferedReader = new BufferedReader(o_InputStreamReader);
        }
        catch (Exception e) {
            try {
                if (o_BufferedReader != null) {
                    o_BufferedReader.close();
                }
                if (o_InputStreamReader != null) {
                    o_InputStreamReader.close();
                }
                if (o_FileInputStream != null) {
                    o_FileInputStream.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
        String stringLine = "";
        while (stringLine != null) {
            try {
                stringLine = o_BufferedReader.readLine();
            }
            catch (IOException e) {
                stringLine = null;
                break;
            }
            if (stringLine == null) break;
            String[] o_StringResourceParts = stringLine.split("=", -1);
            if (o_StringResourceParts.length > 2) {
                // empty if block
            }
            String stringCol = "";
            ArrayList<String> o_ArrayListRow = new ArrayList<String>();
            for (int intPart = 0; intPart < 2; ++intPart) {
                if (intPart >= o_StringResourceParts.length) {
                    stringCol = "";
                } else if (intPart == 1 && o_StringResourceParts.length > 2) {
                    for (int intStringCol = 1; intStringCol < o_StringResourceParts.length; ++intStringCol) {
                        stringCol = stringCol + o_StringResourceParts[intStringCol];
                    }
                } else {
                    stringCol = o_StringResourceParts[intPart];
                }
                o_ArrayListRow.add(stringCol);
            }
            this.m_RowData.add(o_ArrayListRow);
            this.m_ArrayListOldPropertyKeys.add(o_StringResourceParts[0]);
            this.fireTableRowsInserted(this.m_RowData.size() - 1, this.m_RowData.size() - 1);
        }
        try {
            if (o_BufferedReader != null) {
                o_BufferedReader.close();
            }
            if (o_InputStreamReader != null) {
                o_InputStreamReader.close();
            }
            if (o_FileInputStream != null) {
                o_FileInputStream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.addLanguage(p_Locale);
        return true;
    }

    public boolean addLanguage(Locale p_Locale) {
        if (p_Locale != null && p_Locale.toString().length() >= 5) {
            Locale o_Locale = new Locale(p_Locale.toString().substring(0, 2));
            this.openLanguage(o_Locale);
        }
        return this.openLanguage(p_Locale);
    }

    private boolean openLanguage(Locale p_Locale) {
        if (p_Locale == null) {
            return false;
        }
        if (this.m_ColumnLocales.contains(p_Locale)) {
            return false;
        }
        FileInputStream o_FileInputStreamDefault = null;
        InputStreamReader o_InputStreamReaderDefault = null;
        PropertyResourceBundle o_PropertyResourceBundleDefault = null;
        try {
            o_FileInputStreamDefault = new FileInputStream(this.m_LanguageDefaultFile);
            o_InputStreamReaderDefault = new InputStreamReader((InputStream)o_FileInputStreamDefault, LiveLanguage.DEFAULTCHARSET_FILE);
            o_PropertyResourceBundleDefault = new PropertyResourceBundle(o_InputStreamReaderDefault);
        }
        catch (Exception e) {
            try {
                if (o_InputStreamReaderDefault != null) {
                    o_InputStreamReaderDefault.close();
                }
                if (o_FileInputStreamDefault != null) {
                    o_FileInputStreamDefault.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            o_PropertyResourceBundleDefault = null;
        }
        File o_File = this.m_LanguageParentDirectoryPath == null ? new File(this.m_LanguageFileNameBasis + "_" + p_Locale.toString() + ".lng") : new File(this.m_LanguageParentDirectoryPath + "/" + this.m_LanguageFileNameBasis + "_" + p_Locale.toString() + ".lng");
        FileInputStream o_FileInputStreamLocale = null;
        InputStreamReader o_InputStreamReaderLocale = null;
        PropertyResourceBundle o_PropertyResourceBundleLocale = null;
        if (o_File.exists()) {
            try {
                o_FileInputStreamLocale = new FileInputStream(o_File);
                o_InputStreamReaderLocale = new InputStreamReader((InputStream)o_FileInputStreamLocale, LiveLanguage.DEFAULTCHARSET_FILE);
                o_PropertyResourceBundleLocale = new PropertyResourceBundle(o_InputStreamReaderLocale);
            }
            catch (Exception e) {
                try {
                    if (o_InputStreamReaderLocale != null) {
                        o_InputStreamReaderLocale.close();
                    }
                    if (o_FileInputStreamLocale != null) {
                        o_FileInputStreamLocale.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                o_PropertyResourceBundleLocale = null;
            }
        }
        this.m_ColumnLocales.add(p_Locale);
        this.m_ColumnNames.add(LiveLangageLocaleHandling.getDisplayLanguage(p_Locale) + " " + LiveLangageLocaleHandling.getDisplayCountry(p_Locale));
        this.m_ColumnChanged.add(Boolean.FALSE);
        for (int intRow = 0; intRow < this.m_RowData.size(); ++intRow) {
            String stringResource;
            String stringPropertyKey = this.m_ArrayListOldPropertyKeys.get(intRow);
            if (o_PropertyResourceBundleLocale == null) {
                if (o_PropertyResourceBundleDefault == null) {
                    stringResource = "";
                } else {
                    try {
                        stringResource = o_PropertyResourceBundleDefault.getString(stringPropertyKey);
                        if (stringResource == null) {
                            stringResource = "";
                        }
                    }
                    catch (Exception e) {
                        stringResource = "";
                    }
                }
            } else {
                try {
                    stringResource = o_PropertyResourceBundleLocale.getString(stringPropertyKey);
                }
                catch (Exception e) {
                    stringResource = "";
                }
            }
            if (stringResource == null) {
                stringResource = "";
            }
            this.m_RowData.get(intRow).add(stringResource);
        }
        try {
            o_FileInputStreamDefault.close();
            o_FileInputStreamLocale.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.fireTableStructureChanged();
        return true;
    }

    public int getColumnIndex(Locale p_Locale) {
        return this.m_ColumnLocales.indexOf(p_Locale);
    }

    public Locale getLocaleFromIndex(int p_Index) {
        if (p_Index < 2) {
            return null;
        }
        if (p_Index >= this.m_ColumnLocales.size()) {
            return null;
        }
        return this.m_ColumnLocales.get(p_Index);
    }

    public boolean getHasChanged() {
        boolean boolChanged = false;
        for (int intColumn = 0; intColumn < this.m_ColumnChanged.size(); ++intColumn) {
            if (!this.m_ColumnChanged.get(intColumn).booleanValue()) continue;
            boolChanged = true;
            break;
        }
        return boolChanged;
    }

    public boolean getHasChanged(int p_ColumnIndex) {
        if (p_ColumnIndex < 0) {
            return false;
        }
        if (p_ColumnIndex >= this.m_ColumnLocales.size()) {
            return false;
        }
        return this.m_ColumnChanged.get(p_ColumnIndex);
    }

    public boolean getHasChanged(Locale p_Locale) {
        if (p_Locale == null) {
            return false;
        }
        int intLocaleIndex = this.m_ColumnLocales.indexOf(p_Locale);
        if (intLocaleIndex < 0) {
            return false;
        }
        return this.m_ColumnChanged.get(intLocaleIndex);
    }

    public boolean removeLanguage(Locale p_Locale) {
        if (p_Locale == null) {
            return false;
        }
        int intLocaleIndex = this.m_ColumnLocales.indexOf(p_Locale);
        if (intLocaleIndex < 0) {
            return false;
        }
        for (int intRow = 0; intRow < this.m_RowData.size(); ++intRow) {
            ArrayList<String> o_ArrayListRow = this.m_RowData.get(intRow);
            o_ArrayListRow.remove(intLocaleIndex);
        }
        this.m_ColumnNames.remove(intLocaleIndex);
        this.m_ColumnLocales.remove(intLocaleIndex);
        this.m_ColumnChanged.remove(intLocaleIndex);
        this.fireTableStructureChanged();
        return true;
    }

    public void saveLanguages() {
        if (this.m_ColumnChanged.get(0).booleanValue()) {
            this.saveColumn0();
        }
        for (int intColumn = 1; intColumn < this.m_ColumnNames.size(); ++intColumn) {
            if (!this.m_ColumnChanged.get(intColumn).booleanValue()) continue;
            this.saveLanguageColumn(intColumn);
        }
    }

    public void saveLanguageColumn(Locale p_Locale) {
        int intColumnIndex = this.m_ColumnLocales.indexOf(p_Locale);
        if (intColumnIndex < 0) {
            return;
        }
        this.saveLanguageColumn(intColumnIndex);
    }

    public void saveLanguageColumn(int p_Column) {
        OutputStreamWriter o_OutputStreamWriter;
        FileOutputStream o_OutputStream;
        boolean boolCreated;
        File o_File;
        if (p_Column < 0) {
            return;
        }
        if (p_Column >= this.m_ColumnNames.size()) {
            return;
        }
        if (this.m_ColumnChanged.get(0).booleanValue()) {
            this.saveColumn0();
        }
        Locale o_Locale = null;
        BufferedWriter o_BufferedWriter = null;
        switch (p_Column) {
            case 1: {
                String stringFileName = this.m_LanguageParentDirectoryPath == null ? this.m_LanguageFileNameBasis + ".lng" : this.m_LanguageParentDirectoryPath + "/" + this.m_LanguageFileNameBasis + ".lng";
                o_File = new File(stringFileName);
                break;
            }
            default: {
                o_Locale = this.m_ColumnLocales.get(p_Column);
                String stringFileName = this.m_LanguageParentDirectoryPath == null ? this.m_LanguageFileNameBasis + "_" + o_Locale.toString() + ".lng" : this.m_LanguageParentDirectoryPath + "/" + this.m_LanguageFileNameBasis + "_" + o_Locale.toString() + ".lng";
                o_File = new File(stringFileName);
            }
        }
        if (o_File.exists()) {
            o_File.delete();
        }
        try {
            boolCreated = o_File.createNewFile();
        }
        catch (Exception e) {
            return;
        }
        if (!boolCreated) {
            return;
        }
        try {
            o_OutputStream = new FileOutputStream(o_File);
            o_OutputStreamWriter = new OutputStreamWriter((OutputStream)o_OutputStream, LiveLanguage.DEFAULTCHARSET_FILE);
            o_BufferedWriter = new BufferedWriter(o_OutputStreamWriter);
        }
        catch (Exception e) {
            try {
                if (o_BufferedWriter != null) {
                    o_BufferedWriter.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        for (int intRow = 0; intRow < this.m_RowData.size(); ++intRow) {
            ArrayList<String> o_ArrayListRow = this.m_RowData.get(intRow);
            String stringResource = o_ArrayListRow.get(0);
            stringResource = stringResource + "=";
            stringResource = stringResource + o_ArrayListRow.get(p_Column);
            stringResource = stringResource + "\n";
            try {
                o_BufferedWriter.write(stringResource);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        try {
            if (o_BufferedWriter != null) {
                o_BufferedWriter.flush();
                o_BufferedWriter.close();
            }
            if (o_OutputStreamWriter != null) {
                o_OutputStreamWriter.close();
            }
            if (o_OutputStream != null) {
                o_OutputStream.close();
            }
        }
        catch (Exception intRow) {
            // empty catch block
        }
        this.m_ColumnChanged.set(p_Column, Boolean.FALSE);
        if (p_Column < this.m_ColumnDefaultNames.length) {
            return;
        }
        ArrayList<String> o_ArrayListOldKey = new ArrayList<String>();
        String stringInstalledLanguages = this.m_LanguageParentDirectoryPath == null ? this.m_LanguageFileNameBasis + "_installed.lng" : this.m_LanguageParentDirectoryPath + "/" + this.m_LanguageFileNameBasis + "_installed.lng";
        o_File = new File(stringInstalledLanguages);
        LiveLanguageResourceBundle o_LanguageResourceBundle = new LiveLanguageResourceBundle(o_File);
        if (o_LanguageResourceBundle.isValid()) {
            PropertyResourceBundle o_PropertyResourceBundle = o_LanguageResourceBundle.getPropertyResourceBundle();
            Enumeration<String> o_Keys = o_PropertyResourceBundle.getKeys();
            while (o_Keys.hasMoreElements()) {
                String stringKey = o_Keys.nextElement();
                o_ArrayListOldKey.add(stringKey);
            }
        }
        o_LanguageResourceBundle.close();
        boolean boolFound = false;
        for (int intOldKey = 0; intOldKey < o_ArrayListOldKey.size(); ++intOldKey) {
            if (!o_Locale.toString().equals(o_ArrayListOldKey.get(intOldKey))) continue;
            boolFound = true;
            break;
        }
        if (!boolFound) {
            o_ArrayListOldKey.add(o_Locale.toString());
        }
        o_File.delete();
        o_OutputStream = null;
        o_OutputStreamWriter = null;
        o_BufferedWriter = null;
        try {
            o_File.createNewFile();
            o_OutputStream = new FileOutputStream(o_File);
            o_OutputStreamWriter = new OutputStreamWriter((OutputStream)o_OutputStream, LiveLanguage.DEFAULTCHARSET_FILE);
            o_BufferedWriter = new BufferedWriter(o_OutputStreamWriter);
        }
        catch (Exception e) {
            try {
                if (o_BufferedWriter != null) {
                    o_BufferedWriter.flush();
                    o_BufferedWriter.close();
                }
                if (o_OutputStreamWriter != null) {
                    o_OutputStreamWriter.close();
                }
                if (o_OutputStream != null) {
                    o_OutputStream.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        for (int intKey = 0; intKey < o_ArrayListOldKey.size(); ++intKey) {
            try {
                o_BufferedWriter.write((String)o_ArrayListOldKey.get(intKey) + "\n");
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        try {
            if (o_BufferedWriter != null) {
                o_BufferedWriter.flush();
                o_BufferedWriter.close();
            }
            if (o_OutputStreamWriter != null) {
                o_OutputStreamWriter.close();
            }
            if (o_OutputStream != null) {
                o_OutputStream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void deleteLanguage(Locale p_Locale) {
        this.deleteLanguageColumn(p_Locale);
    }

    public void deleteLanguageColumn(Locale p_Locale) {
        int intColumnIndex = this.m_ColumnLocales.indexOf(p_Locale);
        if (intColumnIndex < 0) {
            return;
        }
        this.deleteLanguageColumn(intColumnIndex);
    }

    public void deleteLanguageColumn(int p_Column) {
        if (p_Column < 2) {
            return;
        }
        if (p_Column >= this.m_ColumnLocales.size()) {
            return;
        }
        BufferedWriter o_BufferedWriter = null;
        Locale o_Locale = this.m_ColumnLocales.get(p_Column);
        String stringFileName = this.m_LanguageParentDirectoryPath == null ? this.m_LanguageFileNameBasis + "_" + o_Locale.toString() + ".lng" : this.m_LanguageParentDirectoryPath + "/" + this.m_LanguageFileNameBasis + "_" + o_Locale.toString() + ".lng";
        File o_File = new File(stringFileName);
        this.removeLanguage(o_Locale);
        if (o_File.exists()) {
            try {
                o_File.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ArrayList<String> o_ArrayListOldKey = new ArrayList<String>();
        String stringInstalledLanguages = this.m_LanguageParentDirectoryPath == null ? this.m_LanguageFileNameBasis + "_installed.lng" : this.m_LanguageParentDirectoryPath + "/" + this.m_LanguageFileNameBasis + "_installed.lng";
        o_File = new File(stringInstalledLanguages);
        LiveLanguageResourceBundle o_LanguageResourceBundle = new LiveLanguageResourceBundle(o_File);
        if (o_LanguageResourceBundle.isValid()) {
            PropertyResourceBundle o_PropertyResourceBundle = o_LanguageResourceBundle.getPropertyResourceBundle();
            Enumeration<String> o_Keys = o_PropertyResourceBundle.getKeys();
            while (o_Keys.hasMoreElements()) {
                String stringKey = o_Keys.nextElement();
                o_ArrayListOldKey.add(stringKey);
            }
        }
        o_LanguageResourceBundle.close();
        boolean boolFound = false;
        for (int intOldKey = 0; intOldKey < o_ArrayListOldKey.size(); ++intOldKey) {
            if (!o_Locale.toString().equals(o_ArrayListOldKey.get(intOldKey))) continue;
            boolFound = true;
            break;
        }
        if (boolFound) {
            o_ArrayListOldKey.remove(o_Locale.toString());
        }
        o_File.delete();
        FileOutputStream o_OutputStream = null;
        OutputStreamWriter o_OutputStreamWriter = null;
        o_BufferedWriter = null;
        try {
            o_File.createNewFile();
            o_OutputStream = new FileOutputStream(o_File);
            o_OutputStreamWriter = new OutputStreamWriter((OutputStream)o_OutputStream, LiveLanguage.DEFAULTCHARSET_FILE);
            o_BufferedWriter = new BufferedWriter(o_OutputStreamWriter);
        }
        catch (Exception e) {
            try {
                if (o_BufferedWriter != null) {
                    o_BufferedWriter.flush();
                    o_BufferedWriter.close();
                }
                if (o_OutputStreamWriter != null) {
                    o_OutputStreamWriter.close();
                }
                if (o_OutputStream != null) {
                    o_OutputStream.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        for (int intKey = 0; intKey < o_ArrayListOldKey.size(); ++intKey) {
            try {
                o_BufferedWriter.write((String)o_ArrayListOldKey.get(intKey) + "\n");
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        try {
            if (o_BufferedWriter != null) {
                o_BufferedWriter.flush();
                o_BufferedWriter.close();
            }
            if (o_OutputStreamWriter != null) {
                o_OutputStreamWriter.close();
            }
            if (o_OutputStream != null) {
                o_OutputStream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void saveColumn0() {
        String stringLocaleKey;
        if (!this.m_ColumnChanged.get(0).booleanValue()) {
            return;
        }
        ArrayList<String> o_ArrayListResources = new ArrayList<String>();
        ArrayList<String> o_ArrayListInstalledKey = new ArrayList<String>();
        BufferedWriter o_BufferedWriter = null;
        this.m_ColumnChanged.set(0, Boolean.FALSE);
        o_ArrayListInstalledKey.add("");
        String stringFileName = this.m_LanguageParentDirectoryPath == null ? this.m_LanguageFileNameBasis + "_installed.lng" : this.m_LanguageParentDirectoryPath + "/" + this.m_LanguageFileNameBasis + "_installed.lng";
        File o_File = new File(stringFileName);
        LiveLanguageResourceBundle o_LanguageResourceBundleInstalled = new LiveLanguageResourceBundle(o_File);
        if (o_LanguageResourceBundleInstalled.isValid()) {
            PropertyResourceBundle o_PropertyResourceBundleInstalled = o_LanguageResourceBundleInstalled.getPropertyResourceBundle();
            Enumeration<String> o_Keys = o_PropertyResourceBundleInstalled.getKeys();
            while (o_Keys.hasMoreElements()) {
                stringLocaleKey = o_Keys.nextElement();
                o_ArrayListInstalledKey.add(stringLocaleKey);
            }
            o_LanguageResourceBundleInstalled.close();
        }
        for (int intLanguageKey = 0; intLanguageKey < o_ArrayListInstalledKey.size(); ++intLanguageKey) {
            int intProperty;
            LiveLanguageResourceBundle o_LiveLanguageResourceBundle;
            stringLocaleKey = (String)o_ArrayListInstalledKey.get(intLanguageKey);
            if (stringLocaleKey.length() > 0) {
                stringLocaleKey = "_" + stringLocaleKey;
            }
            if (!(o_LiveLanguageResourceBundle = new LiveLanguageResourceBundle(o_File = new File(stringFileName = this.m_LanguageParentDirectoryPath == null ? this.m_LanguageFileNameBasis + stringLocaleKey + ".lng" : this.m_LanguageParentDirectoryPath + "/" + this.m_LanguageFileNameBasis + stringLocaleKey + ".lng"))).isValid()) continue;
            o_ArrayListResources.clear();
            PropertyResourceBundle o_PropertyResourceBundle = o_LiveLanguageResourceBundle.getPropertyResourceBundle();
            for (intProperty = 0; intProperty < this.m_RowData.size(); ++intProperty) {
                String stringResource;
                String stringPropertyKey = this.m_ArrayListOldPropertyKeys.get(intProperty);
                try {
                    stringResource = o_PropertyResourceBundle.getString(stringPropertyKey);
                }
                catch (Exception eResource) {
                    stringResource = "";
                }
                if (stringResource == null) {
                    stringResource = "";
                }
                o_ArrayListResources.add(stringResource);
            }
            o_LiveLanguageResourceBundle.close();
            if (o_File.exists()) {
                o_File.delete();
            }
            FileOutputStream o_OutputStream = null;
            OutputStreamWriter o_OutputStreamWriter = null;
            o_BufferedWriter = null;
            try {
                o_File.createNewFile();
                o_OutputStream = new FileOutputStream(o_File);
                o_OutputStreamWriter = new OutputStreamWriter((OutputStream)o_OutputStream, LiveLanguage.DEFAULTCHARSET_FILE);
                o_BufferedWriter = new BufferedWriter(o_OutputStreamWriter);
            }
            catch (Exception e) {
                try {
                    if (o_BufferedWriter != null) {
                        o_BufferedWriter.flush();
                        o_BufferedWriter.close();
                    }
                    if (o_OutputStreamWriter != null) {
                        o_OutputStreamWriter.close();
                    }
                    if (o_OutputStream == null) continue;
                    o_OutputStream.close();
                }
                catch (Exception eResource) {}
                continue;
            }
            for (intProperty = 0; intProperty < this.m_RowData.size(); ++intProperty) {
                try {
                    o_BufferedWriter.write(this.m_RowData.get(intProperty).get(0) + "=" + (String)o_ArrayListResources.get(intProperty) + "\n");
                    continue;
                }
                catch (Exception eWrite) {
                    // empty catch block
                }
            }
            try {
                if (o_BufferedWriter != null) {
                    o_BufferedWriter.flush();
                    o_BufferedWriter.close();
                }
                if (o_OutputStreamWriter != null) {
                    o_OutputStreamWriter.close();
                }
                if (o_OutputStream == null) continue;
                o_OutputStream.close();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.m_ArrayListOldPropertyKeys.clear();
        for (int intProperty = 0; intProperty < this.m_RowData.size(); ++intProperty) {
            this.m_ArrayListOldPropertyKeys.add(this.m_RowData.get(intProperty).get(0));
        }
        o_LanguageResourceBundleInstalled.close();
    }

    public File getLanguageDefaultFile() {
        return this.m_LanguageDefaultFile;
    }

    public File getLanguageParentDirectory() {
        return this.m_LanguageParentDirectory;
    }

    public String getLanguageFileNameBasis() {
        return this.m_LanguageFileNameBasis;
    }
}

