/*
 * Decompiled with CFR 0.152.
 */
package ToolsPackage;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import javax.swing.filechooser.FileFilter;

public class FileTools {
    public static boolean checkWritable(File p_File) {
        boolean boolWritable;
        File o_Directory;
        boolean boolExists;
        if (p_File == null) {
            return false;
        }
        if (!p_File.isDirectory()) {
            if (!p_File.exists()) {
                boolExists = false;
                try {
                    p_File.createNewFile();
                }
                catch (Exception e) {
                    return false;
                }
            } else {
                boolExists = true;
            }
            o_Directory = p_File.getParentFile();
        } else {
            o_Directory = p_File;
            if (!p_File.exists()) {
                boolExists = false;
                try {
                    p_File.mkdir();
                }
                catch (Exception e) {
                    return false;
                }
            } else {
                boolExists = true;
            }
        }
        try {
            File o_FileSubDir = new File(o_Directory.getAbsolutePath() + File.separator + "XXX_FILE_CHECKWRITABLE_XXX");
            o_FileSubDir.mkdir();
            if (o_FileSubDir.exists()) {
                boolWritable = true;
                o_FileSubDir.delete();
            } else {
                boolWritable = false;
            }
        }
        catch (Exception e) {
            boolWritable = false;
        }
        if (!boolExists) {
            try {
                p_File.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return boolWritable;
    }

    public static String getFileNameBase(String p_FileName) {
        if (p_FileName == null) {
            return "";
        }
        String stringFileName = p_FileName;
        int intPos = -1;
        if (stringFileName.length() > 1 && (intPos = stringFileName.lastIndexOf(".")) > 0) {
            stringFileName = stringFileName.substring(0, intPos);
        }
        return stringFileName;
    }

    public static String getFileNameBase(File p_File) {
        if (p_File == null) {
            return "";
        }
        return FileTools.getFileNameBase(p_File.getName());
    }

    public static String getFileNameExtension(String p_FileName) {
        if (p_FileName == null) {
            return "";
        }
        String stringFileName = p_FileName;
        int intPos = -1;
        stringFileName = stringFileName.length() > 1 ? ((intPos = stringFileName.lastIndexOf(".")) > 0 ? stringFileName.substring(intPos, stringFileName.length()) : "") : "";
        return stringFileName;
    }

    public static String getFileNameExtension(File p_File) {
        if (p_File == null) {
            return "";
        }
        return FileTools.getFileNameExtension(p_File.getName());
    }

    public static String getPathName(File p_File) {
        String stringPathName;
        if (p_File == null) {
            return "";
        }
        File o_Directory = p_File.getParentFile();
        try {
            stringPathName = o_Directory.getCanonicalPath();
        }
        catch (Exception e) {
            stringPathName = o_Directory.getPath();
        }
        return stringPathName;
    }

    public static File copyFileTo(File p_File, File p_NewDirectory, String p_FileName, boolean p_Overwrite) {
        String stringOldDirectory;
        if (p_File == null) {
            return null;
        }
        if (!p_File.exists()) {
            return null;
        }
        if (p_NewDirectory == null) {
            return null;
        }
        if (!p_NewDirectory.exists() && !p_NewDirectory.mkdir()) {
            return null;
        }
        if (!p_NewDirectory.isDirectory()) {
            return null;
        }
        String stringFileName = p_FileName == null ? p_File.getName() : p_FileName;
        String stringNewDirectory = p_NewDirectory.getAbsolutePath();
        File o_ParentFile = p_File.getParentFile();
        if (o_ParentFile != null && stringNewDirectory.equals(stringOldDirectory = p_File.getParentFile().getAbsolutePath()) && p_File.getName().equals(stringFileName)) {
            return p_File;
        }
        File o_NewFile = new File(stringNewDirectory + "/" + stringFileName);
        if (p_File.equals(o_NewFile)) {
            return null;
        }
        if (o_NewFile.exists() && !p_Overwrite) {
            return o_NewFile;
        }
        InputStream in = null;
        OutputStream out = null;
        try {
            int len;
            if (o_NewFile.exists()) {
                o_NewFile.delete();
            }
            o_NewFile.createNewFile();
            in = new FileInputStream(p_File);
            out = new FileOutputStream(o_NewFile);
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) >= 0) {
                out.write(buf, 0, len);
            }
            in.close();
            out.close();
        }
        catch (Exception e) {
            try {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
        return o_NewFile;
    }

    public static boolean copyFilesTo(File p_OldDirectory, File p_NewDirectory, boolean p_Overwrite, boolean p_RemoveOld) {
        File o_File;
        int intFile;
        File[] o_Files;
        if (p_OldDirectory == null) {
            return false;
        }
        if (p_NewDirectory == null) {
            return false;
        }
        if (!p_OldDirectory.exists()) {
            return false;
        }
        if (!p_NewDirectory.exists()) {
            return false;
        }
        if (p_OldDirectory.getAbsolutePath().equals(p_NewDirectory.getAbsolutePath())) {
            return true;
        }
        try {
            o_Files = p_OldDirectory.listFiles();
            for (intFile = 0; intFile < o_Files.length; ++intFile) {
                o_File = o_Files[intFile];
                if (o_File.isDirectory() || FileTools.copyFileTo(o_File, p_NewDirectory, null, p_Overwrite) != null) continue;
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        if (p_RemoveOld) {
            try {
                o_Files = p_OldDirectory.listFiles();
                for (intFile = 0; intFile < o_Files.length; ++intFile) {
                    o_File = o_Files[intFile];
                    if (o_File.isDirectory()) continue;
                    o_File.delete();
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    public static boolean equalsContent(File p_File1, File p_File2) {
        if (p_File1 == null && p_File2 == null) {
            return true;
        }
        if (p_File1 == null) {
            return false;
        }
        if (p_File2 == null) {
            return false;
        }
        if (p_File1.isDirectory() && p_File2.isDirectory()) {
            return true;
        }
        if (p_File1.isDirectory()) {
            return false;
        }
        if (p_File2.isDirectory()) {
            return false;
        }
        if (p_File1.length() != p_File2.length()) {
            return false;
        }
        FileInputStream o_InputStream1 = null;
        FileInputStream o_InputStream2 = null;
        boolean boolEqualContent = true;
        try {
            int len1;
            o_InputStream1 = new FileInputStream(p_File1);
            o_InputStream2 = new FileInputStream(p_File2);
            byte[] buf1 = new byte[1024];
            byte[] buf2 = new byte[1024];
            block4: while ((len1 = ((InputStream)o_InputStream1).read(buf1)) >= 0 && boolEqualContent) {
                int len2 = 0;
                int intOffset2 = 0;
                while (len2 < len1) {
                    len2 = ((InputStream)o_InputStream2).read(buf2, intOffset2, len1 - intOffset2);
                    if (len2 < 0) {
                        boolEqualContent = false;
                        break;
                    }
                    intOffset2 += len2;
                }
                for (int intByte = 0; intByte < len1; ++intByte) {
                    if (buf1[intByte] == buf2[intByte]) continue;
                    boolEqualContent = false;
                    continue block4;
                }
            }
        }
        catch (Exception e) {
            boolEqualContent = false;
        }
        try {
            if (o_InputStream1 != null) {
                ((InputStream)o_InputStream1).close();
            }
            if (o_InputStream2 != null) {
                ((InputStream)o_InputStream2).close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return boolEqualContent;
    }

    public static FileFilter createFileFilter(final String p_FileExtension, final String p_FileTypeName) {
        FileFilter o_FileFilter = new FileFilter(){

            @Override
            public boolean accept(File p_File) {
                if (p_File.isDirectory()) {
                    return true;
                }
                return p_File.getPath().endsWith(p_FileExtension);
            }

            @Override
            public String getDescription() {
                return p_FileTypeName;
            }
        };
        return o_FileFilter;
    }

    public static FileFilter createFileFilter(final String[] p_FileExtensions, final String p_FileTypeName) {
        FileFilter o_FileFilter = new FileFilter(){

            @Override
            public boolean accept(File p_File) {
                if (p_File.isDirectory()) {
                    return true;
                }
                int intLastPointPos = p_File.getPath().lastIndexOf(".");
                String stringActualPostfix = p_File.getPath().substring(intLastPointPos).trim().toLowerCase();
                for (int intPostfix = 0; intPostfix < p_FileExtensions.length; ++intPostfix) {
                    String stringPostfix = p_FileExtensions[intPostfix];
                    if (!stringPostfix.toLowerCase().equals(stringActualPostfix)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public String getDescription() {
                return p_FileTypeName;
            }
        };
        return o_FileFilter;
    }

    public static String getCheckSum_MD5(File p_File) {
        String stringCheckSum;
        block7: {
            if (p_File == null) {
                return "";
            }
            if (!p_File.exists()) {
                return "";
            }
            stringCheckSum = "";
            FileInputStream o_FileInputStream = null;
            try {
                int numOfBytesRead;
                o_FileInputStream = new FileInputStream(p_File);
                MessageDigest o_MessageDigest = MessageDigest.getInstance("MD5");
                byte[] buffer = new byte[8192];
                while ((numOfBytesRead = o_FileInputStream.read(buffer)) > 0) {
                    o_MessageDigest.update(buffer, 0, numOfBytesRead);
                }
                byte[] hash = o_MessageDigest.digest();
                stringCheckSum = String.format("%032x", new BigInteger(1, hash));
                o_FileInputStream.close();
            }
            catch (Exception ex) {
                if (o_FileInputStream == null) break block7;
                try {
                    o_FileInputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return stringCheckSum;
    }

    public static String validateFileName(String p_FileName) {
        if (p_FileName == null) {
            return "";
        }
        String stringFileNameBase = FileTools.getFileNameBase(p_FileName);
        String stringFileNameExtension = FileTools.getFileNameExtension(p_FileName);
        stringFileNameBase = stringFileNameBase.replace(".", "");
        stringFileNameBase = stringFileNameBase.replace(":", "");
        stringFileNameBase = stringFileNameBase.replace(",", "");
        stringFileNameBase = stringFileNameBase.replace(";", "");
        stringFileNameBase = stringFileNameBase.replace("(", "");
        stringFileNameBase = stringFileNameBase.replace(")", "");
        stringFileNameBase = stringFileNameBase.replace("[", "");
        stringFileNameBase = stringFileNameBase.replace("}", "");
        stringFileNameBase = stringFileNameBase.replace("{", "");
        stringFileNameBase = stringFileNameBase.replace("}", "");
        stringFileNameBase = stringFileNameBase.replace("'", "");
        stringFileNameBase = stringFileNameBase.replace("\"", "");
        stringFileNameBase = stringFileNameBase.replace("/", "");
        stringFileNameBase = stringFileNameBase.replace("\\", "");
        stringFileNameBase = stringFileNameBase.replace("!", "");
        stringFileNameBase = stringFileNameBase.replace("\u00a7", "");
        stringFileNameBase = stringFileNameBase.replace("$", "");
        stringFileNameBase = stringFileNameBase.replace("%", "");
        stringFileNameBase = stringFileNameBase.replace("&", "");
        stringFileNameBase = stringFileNameBase.replace("@", "");
        stringFileNameBase = stringFileNameBase.replace("\u20ac", "");
        stringFileNameBase = stringFileNameBase.replace("\u00a9", "");
        stringFileNameBase = stringFileNameBase.replace("\u00ae", "");
        stringFileNameBase = stringFileNameBase.replace("\u2122", "");
        stringFileNameBase = stringFileNameBase.replace("-", "_");
        stringFileNameBase = stringFileNameBase.replace(" ", "_");
        StringBuffer o_StringBuffer = new StringBuffer();
        o_StringBuffer.append(stringFileNameBase);
        o_StringBuffer.append(stringFileNameExtension);
        return o_StringBuffer.toString();
    }
}

