/*
 * Decompiled with CFR 0.152.
 */
package RXTX_Package;

import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LanguageTools.LiveLanguagePackage.LiveLanguageString;
import LiveCommSerial.CommSerialPortEvent;
import LiveCommSerial.CommSerialPortEventListener;
import RXTX_Package.RXTX_Connection;
import RXTX_Package.RXTX_Connection_LANDevice;
import RXTX_Package.RXTX_Device;
import SwingTextPackage.DocumentFilter_Integer;
import SwingToolTipPackage.PopUpToolTip;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.InetAddress;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class JPanel_LANDevice_Settings
extends JPanel
implements PropertyChangeListener,
CommSerialPortEventListener {
    @LiveLanguageString
    public static String ERROR_INETADDRESSNOTREACHABLE = "Address is not reachable";
    @LiveLanguageString
    public static String REMARK_CHECK_INETADDRESS = "<html>Check Address<br>please wait..</html";
    @LiveLanguageString
    public static String REMARK_INETADDRESS_REACHABLE = "<html>adress is ok and reachable</html";
    private Container m_JDialog;
    private RXTX_Connection_LANDevice m_RXTX_Connection_LANDevice;
    private RXTX_Device m_RXTX_Device;
    private String m_Address;
    private String m_HostName;
    private int m_Port;
    private JButton jButton_CheckAddress;
    private JButton jButton_Connect;
    private JButton jButton_Disconnect;
    private JLabel jLabel_Error;
    private JLabel jLabel_HostName;
    private JLabel jLabel_InetAddress;
    private JLabel jLabel_Port;
    private JLabel jLabel_RXTX_Device;
    private JPanel jPanel_Buttons;
    private JTextField jTextField_InetAddress;
    private JTextField jTextField_Port;

    public JPanel_LANDevice_Settings(Container p_JDialog) {
        this.m_JDialog = p_JDialog;
        this.initMembers();
        this.initComponents();
        this.initComponentsFurther();
        LiveLanguage.addLanguageListener((Object)this, null);
        this.refreshGUI();
    }

    private void initMembers() {
        this.m_RXTX_Connection_LANDevice = null;
        this.m_RXTX_Device = null;
        this.m_Address = "";
        this.m_Port = 0;
        this.m_HostName = "---";
    }

    private void initComponentsFurther() {
        DocumentFilter_Integer o_DocumentFilter_Integer = new DocumentFilter_Integer(this.jTextField_Port);
        o_DocumentFilter_Integer.setAllowNegativeNumbers(false);
        this.jButton_Connect.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jButton_Disconnect.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jTextField_InetAddress.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        this.jTextField_Port.setComponentPopupMenu(PopUpToolTip.getSelfReference());
    }

    private void initComponents() {
        this.jPanel_Buttons = new JPanel();
        this.jButton_Connect = new JButton();
        this.jButton_Disconnect = new JButton();
        this.jLabel_InetAddress = new JLabel();
        this.jTextField_InetAddress = new JTextField();
        this.jLabel_RXTX_Device = new JLabel();
        this.jLabel_Error = new JLabel();
        this.jLabel_Port = new JLabel();
        this.jTextField_Port = new JTextField();
        this.jLabel_HostName = new JLabel();
        this.jButton_CheckAddress = new JButton();
        this.setBorder(BorderFactory.createLineBorder(new Color(255, 255, 255)));
        this.setLayout(new GridBagLayout());
        this.jPanel_Buttons.setLayout(new GridBagLayout());
        this.jButton_Connect.setText("Connect");
        this.jButton_Connect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanel_LANDevice_Settings.this.jButton_ConnectActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Buttons.add((Component)this.jButton_Connect, gridBagConstraints);
        this.jButton_Disconnect.setText("Disconnect");
        this.jButton_Disconnect.setToolTipText("");
        this.jButton_Disconnect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanel_LANDevice_Settings.this.jButton_DisconnectActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Buttons.add((Component)this.jButton_Disconnect, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 3, 3, 3);
        this.add((Component)this.jPanel_Buttons, gridBagConstraints);
        this.jLabel_InetAddress.setText("Address");
        this.jLabel_InetAddress.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jLabel_InetAddress, gridBagConstraints);
        this.jTextField_InetAddress.setHorizontalAlignment(0);
        this.jTextField_InetAddress.setText("jTextField1");
        this.jTextField_InetAddress.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                JPanel_LANDevice_Settings.this.jTextField_InetAddressFocusLost(evt);
            }
        });
        this.jTextField_InetAddress.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                JPanel_LANDevice_Settings.this.jTextField_InetAddressKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jTextField_InetAddress, gridBagConstraints);
        this.jLabel_RXTX_Device.setFont(new Font("Tahoma", 0, 12));
        this.jLabel_RXTX_Device.setHorizontalAlignment(0);
        this.jLabel_RXTX_Device.setText("jLabel1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jLabel_RXTX_Device, gridBagConstraints);
        this.jLabel_Error.setFont(new Font("Tahoma", 0, 12));
        this.jLabel_Error.setForeground(new Color(255, 102, 102));
        this.jLabel_Error.setHorizontalAlignment(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jLabel_Error, gridBagConstraints);
        this.jLabel_Port.setText("Port");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jLabel_Port, gridBagConstraints);
        this.jTextField_Port.setHorizontalAlignment(0);
        this.jTextField_Port.setText("jTextField1");
        this.jTextField_Port.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                JPanel_LANDevice_Settings.this.jTextField_PortFocusLost(evt);
            }
        });
        this.jTextField_Port.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                JPanel_LANDevice_Settings.this.jTextField_PortKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.add((Component)this.jTextField_Port, gridBagConstraints);
        this.jLabel_HostName.setHorizontalAlignment(0);
        this.jLabel_HostName.setText("-");
        this.jLabel_HostName.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jLabel_HostName, gridBagConstraints);
        this.jButton_CheckAddress.setText("Check Address");
        this.jButton_CheckAddress.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanel_LANDevice_Settings.this.jButton_CheckAddressActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        this.add((Component)this.jButton_CheckAddress, gridBagConstraints);
    }

    public void setRXTX_Device(RXTX_Device p_RXTX_Device) {
        if (this.m_RXTX_Device == p_RXTX_Device) {
            return;
        }
        this.jLabel_Error.setText("");
        if (this.m_RXTX_Device != null) {
            if (this.m_RXTX_Connection_LANDevice != null) {
                // empty if block
            }
            this.m_RXTX_Device.removePropertyChangeListener(this);
            this.m_RXTX_Connection_LANDevice = null;
        }
        this.m_RXTX_Device = p_RXTX_Device;
        this.m_Address = "";
        this.m_Port = 0;
        this.m_HostName = "---";
        if (this.m_RXTX_Device != null) {
            RXTX_Connection o_RXTX_Connection = this.m_RXTX_Device.getRXTX_Connection();
            if (o_RXTX_Connection instanceof RXTX_Connection_LANDevice) {
                RXTX_Connection_LANDevice o_RXTX_Connection_LANDevice;
                this.m_RXTX_Connection_LANDevice = o_RXTX_Connection_LANDevice = (RXTX_Connection_LANDevice)o_RXTX_Connection;
                InetAddress o_InetAddress = this.m_RXTX_Connection_LANDevice.getInetAddress();
                this.m_Address = o_InetAddress == null ? "" : o_InetAddress.getHostAddress();
                this.m_Port = this.m_RXTX_Connection_LANDevice.getPort();
                this.checkInetAddress(this.m_Address, this.m_Port);
            } else {
                this.m_RXTX_Connection_LANDevice = null;
            }
            this.m_RXTX_Device.addPropertyChangeListener(this);
        }
        this.refreshGUI();
    }

    private void checkInetAddress(InetAddress p_InetAddress, int p_Port) {
        this.m_Port = p_Port;
        if (p_InetAddress == null) {
            this.checkInetAddress("", p_Port);
            return;
        }
        this.checkInetAddress(p_InetAddress.getHostAddress(), p_Port);
    }

    private void checkInetAddress(final String p_Address, final int p_Port) {
        this.m_Address = "";
        this.m_HostName = "---";
        this.m_Port = p_Port;
        this.setRemark(REMARK_CHECK_INETADDRESS);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    InetAddress o_InetAddress = InetAddress.getByName(p_Address);
                    JPanel_LANDevice_Settings.this.m_Address = o_InetAddress.getHostAddress();
                    JPanel_LANDevice_Settings.this.m_HostName = "---";
                    boolean boolReachable = RXTX_Connection_LANDevice.isReachable(p_Address, p_Port);
                    if (!boolReachable) {
                        JPanel_LANDevice_Settings.this.setError(ERROR_INETADDRESSNOTREACHABLE);
                    } else {
                        JPanel_LANDevice_Settings.this.m_HostName = o_InetAddress.getHostName();
                        JPanel_LANDevice_Settings.this.setRemark(REMARK_INETADDRESS_REACHABLE);
                    }
                }
                catch (Exception e) {
                    StringBuilder o_StringBuilder = new StringBuilder();
                    o_StringBuilder.append("<html>");
                    o_StringBuilder.append("<center>");
                    o_StringBuilder.append(ERROR_INETADDRESSNOTREACHABLE);
                    o_StringBuilder.append("<br>");
                    o_StringBuilder.append("<br>");
                    o_StringBuilder.append(e.getMessage());
                    o_StringBuilder.append("</center>");
                    o_StringBuilder.append("</html>");
                    JPanel_LANDevice_Settings.this.setError(o_StringBuilder.toString());
                }
                JPanel_LANDevice_Settings.this.refreshGUI();
            }
        });
    }

    private void setRemark(String p_Remark) {
        if (p_Remark == null) {
            return;
        }
        this.jLabel_Error.setForeground(Color.WHITE);
        this.jLabel_Error.setText(p_Remark);
    }

    private void setError(String p_Error) {
        if (p_Error == null) {
            return;
        }
        this.jLabel_Error.setForeground(Color.RED);
        this.jLabel_Error.setText(p_Error);
    }

    public void refreshGUI() {
        this.jTextField_InetAddress.setEnabled(false);
        this.jButton_CheckAddress.setEnabled(false);
        this.jTextField_Port.setEnabled(false);
        if (this.m_RXTX_Connection_LANDevice == null || this.m_RXTX_Device == null) {
            this.jTextField_InetAddress.setText("");
            this.jTextField_Port.setText("0");
            this.jButton_Connect.setVisible(false);
            this.jButton_Disconnect.setVisible(false);
            this.jLabel_RXTX_Device.setText("");
            this.setRemark("");
            return;
        }
        this.jLabel_RXTX_Device.setText(this.m_RXTX_Device.getName());
        this.jTextField_InetAddress.setText(this.m_Address);
        this.jTextField_Port.setText(String.valueOf(this.m_Port));
        this.jLabel_HostName.setText(this.m_HostName);
        if (this.m_RXTX_Connection_LANDevice.getIsConnected()) {
            this.jButton_Connect.setVisible(false);
            this.jButton_Disconnect.setVisible(true);
        } else {
            this.jTextField_InetAddress.setEnabled(true);
            this.jButton_CheckAddress.setEnabled(true);
            this.jTextField_Port.setEnabled(true);
            this.jButton_Connect.setVisible(true);
            this.jButton_Disconnect.setVisible(false);
        }
    }

    private void jButton_ConnectActionPerformed(ActionEvent evt) {
        if (this.m_RXTX_Connection_LANDevice != null) {
            this.m_RXTX_Connection_LANDevice.setManuallyDisconnected(false);
            this.m_RXTX_Connection_LANDevice.setInetAddress(this.jTextField_InetAddress.getText());
            this.m_RXTX_Connection_LANDevice.setPort(Integer.valueOf(this.jTextField_Port.getText()));
            if (this.m_RXTX_Connection_LANDevice.connect()) {
                if (this.m_JDialog != null) {
                    this.m_JDialog.repaint();
                    this.m_JDialog.setVisible(false);
                    this.setRXTX_Device(null);
                }
            } else {
                this.checkInetAddress(this.m_Address, this.m_Port);
            }
        }
    }

    private void jButton_DisconnectActionPerformed(ActionEvent evt) {
        Container o_Container;
        if (this.m_RXTX_Connection_LANDevice != null) {
            this.m_RXTX_Connection_LANDevice.disconnect();
            this.m_RXTX_Connection_LANDevice.setManuallyDisconnected(true);
        }
        if (this.m_JDialog != null && (o_Container = this.m_JDialog.getParent()) != null) {
            o_Container.repaint();
        }
        this.refreshGUI();
    }

    private void jTextField_InetAddressKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.m_Address = this.jTextField_InetAddress.getText();
        }
    }

    private void jTextField_InetAddressFocusLost(FocusEvent evt) {
        this.m_Address = this.jTextField_InetAddress.getText();
    }

    private void jTextField_PortKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.m_Port = Integer.valueOf(this.jTextField_Port.getText());
        }
    }

    private void jTextField_PortFocusLost(FocusEvent evt) {
        this.m_Port = Integer.valueOf(this.jTextField_Port.getText());
    }

    private void jButton_CheckAddressActionPerformed(ActionEvent evt) {
        this.checkInetAddress(this.m_Address, this.m_Port);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.refreshGUI();
    }

    public void eventCommSerialPortConnection(int p_ConnectionStatus) {
    }

    public void eventCommSerialPortComm(CommSerialPortEvent p_CommSerialPortEvent) {
    }

    public void eventCommSerialPortDataReceived(byte[] p_BytesReadenAll, int p_DataLenght) {
    }

    public void eventCommSerialPortException(Exception p_Exception) {
        this.jLabel_Error.setText(p_Exception.getMessage());
    }
}

