/*
 * Decompiled with CFR 0.152.
 */
package LANPackage;

import RXTX_Package.RXTX_Connection_LANDevice;
import SPITLibraryPackage.SPIT_Message;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.util.ArrayList;

public class LANServer {
    public static String s_ServerComputerName = "";
    public static int s_LocalPort = 15130;
    private DatagramSocket m_DatagramSocket;
    private final Object m_SyncSendMessage = new Object();
    private boolean m_StopServer;
    private ArrayList<RXTX_Connection_LANDevice> m_RXTX_Connection_LANDevices;
    private final Object m_SyncConnections = new Object();
    private ArrayList<DatagramPacket> m_Send_DatagramPackets;
    private Runnable m_Send_Runnable;
    private Thread m_SendThread;
    private Runnable m_RunnableReceive;
    private static final Object s_SyncServer = new Object();
    public static LANServer s_SelfReference = new LANServer();

    public LANServer() {
        this.initMembers();
        this.initRunnableSend();
        this.initRunnableReceive();
        this.startServer();
    }

    private void initMembers() {
        this.m_Send_DatagramPackets = new ArrayList();
        this.m_StopServer = true;
        try {
            s_ServerComputerName = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            s_ServerComputerName = "";
        }
        this.m_RXTX_Connection_LANDevices = new ArrayList();
    }

    public static void close() {
        if (s_SelfReference != null) {
            s_SelfReference.closeInstance();
        }
    }

    public void closeInstance() {
        this.stopServer();
    }

    public static void setLocalPort(int p_LocalPort) {
        if (s_SelfReference == null) {
            return;
        }
        s_SelfReference.stopServer();
        s_LocalPort = p_LocalPort;
        s_SelfReference.startServer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRXTX_Connection_LANDevice(RXTX_Connection_LANDevice p_RXTX_Connection_LANDevice) {
        if (p_RXTX_Connection_LANDevice == null) {
            return;
        }
        Object object = this.m_SyncConnections;
        synchronized (object) {
            if (this.m_RXTX_Connection_LANDevices.contains(p_RXTX_Connection_LANDevice)) {
                return;
            }
            this.m_RXTX_Connection_LANDevices.add(p_RXTX_Connection_LANDevice);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRXTX_Connection_LANDevice(RXTX_Connection_LANDevice p_RXTX_Connection_LANDevice) {
        if (p_RXTX_Connection_LANDevice == null) {
            return;
        }
        Object object = this.m_SyncConnections;
        synchronized (object) {
            this.m_RXTX_Connection_LANDevices.remove(p_RXTX_Connection_LANDevice);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsRXTX_Connection_LANDevice(RXTX_Connection_LANDevice p_RXTX_Connection_LANDevice) {
        if (p_RXTX_Connection_LANDevice == null) {
            return false;
        }
        Object object = this.m_SyncConnections;
        synchronized (object) {
            return this.m_RXTX_Connection_LANDevices.contains(p_RXTX_Connection_LANDevice);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RXTX_Connection_LANDevice getRXTX_Connection_LANDevice(InetAddress p_ClientInetAddress, int p_ClientPort) {
        if (p_ClientInetAddress == null) {
            return null;
        }
        Object object = this.m_SyncConnections;
        synchronized (object) {
            for (int intConnection = 0; intConnection < this.m_RXTX_Connection_LANDevices.size(); ++intConnection) {
                RXTX_Connection_LANDevice o_RXTX_Connection_LANDevice = this.m_RXTX_Connection_LANDevices.get(intConnection);
                if (o_RXTX_Connection_LANDevice == null || !p_ClientInetAddress.equals(o_RXTX_Connection_LANDevice.getInetAddress()) || p_ClientPort != o_RXTX_Connection_LANDevice.getPort()) continue;
                return o_RXTX_Connection_LANDevice;
            }
        }
        return null;
    }

    private void initRunnableReceive() {
        this.m_RunnableReceive = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                byte[] o_BytesReceived = new byte[512];
                while (!LANServer.this.m_StopServer) {
                    int intClientPort;
                    InetAddress o_ClientInetAddress;
                    RXTX_Connection_LANDevice o_RXTX_Connection_LANDevice;
                    Object object = s_SyncServer;
                    synchronized (object) {
                        if (LANServer.this.m_DatagramSocket == null || LANServer.this.m_DatagramSocket.isClosed()) {
                            LANServer.this.m_StopServer = true;
                            continue;
                        }
                    }
                    DatagramPacket o_DatagramPacket = new DatagramPacket(o_BytesReceived, o_BytesReceived.length);
                    try {
                        LANServer.this.m_DatagramSocket.receive(o_DatagramPacket);
                    }
                    catch (SocketTimeoutException e_SocketTimeoutException) {
                        o_DatagramPacket = null;
                        continue;
                    }
                    catch (Exception e) {
                        LANServer.this.m_StopServer = true;
                        o_DatagramPacket = null;
                    }
                    if (o_DatagramPacket == null || (o_RXTX_Connection_LANDevice = LANServer.this.getRXTX_Connection_LANDevice(o_ClientInetAddress = o_DatagramPacket.getAddress(), intClientPort = o_DatagramPacket.getPort())) == null) continue;
                    o_RXTX_Connection_LANDevice.eventLANDataReceived(o_DatagramPacket);
                }
            }
        };
    }

    public static boolean sendMessage(RXTX_Connection_LANDevice p_RXTX_Connection_LANDevices, byte[] p_MessageBytes, int p_MessageLength) {
        if (p_RXTX_Connection_LANDevices == null) {
            return false;
        }
        if (!s_SelfReference.containsRXTX_Connection_LANDevice(p_RXTX_Connection_LANDevices)) {
            return false;
        }
        if (p_MessageBytes == null) {
            return false;
        }
        if (p_MessageLength <= 0) {
            return false;
        }
        if (p_MessageBytes.length < p_MessageLength) {
            return false;
        }
        InetAddress o_InetAddress = p_RXTX_Connection_LANDevices.getInetAddress();
        int intPort = p_RXTX_Connection_LANDevices.getPort();
        if (o_InetAddress == null) {
            return false;
        }
        DatagramSocket o_DatagramSocket = s_SelfReference.getDatagramSocket();
        if (o_DatagramSocket == null) {
            return false;
        }
        if (o_DatagramSocket.isClosed()) {
            return false;
        }
        byte[] o_DataBytes = new byte[p_MessageLength];
        System.arraycopy(p_MessageBytes, 0, o_DataBytes, 0, o_DataBytes.length);
        DatagramPacket o_DatagramPacket = new DatagramPacket(o_DataBytes, o_DataBytes.length, o_InetAddress, intPort);
        boolean boolSended = s_SelfReference.addDatagramPacketToSend(o_DatagramPacket);
        return boolSended;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addDatagramPacketToSend(DatagramPacket p_DatagramPacket) {
        if (p_DatagramPacket == null) {
            return false;
        }
        Object object = s_SyncServer;
        synchronized (object) {
            if (this.m_StopServer || this.m_DatagramSocket == null || this.m_DatagramSocket.isClosed()) {
                return false;
            }
            this.m_Send_DatagramPackets.add(p_DatagramPacket);
            s_SyncServer.notifyAll();
        }
        return true;
    }

    private void initRunnableSend() {
        this.m_Send_Runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object;
                while (!LANServer.this.m_StopServer) {
                    DatagramPacket o_DatagramPacket;
                    object = s_SyncServer;
                    synchronized (object) {
                        if (LANServer.this.m_Send_DatagramPackets.size() <= 0) {
                            try {
                                s_SyncServer.wait(2000L);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            if (LANServer.this.m_DatagramSocket == null || LANServer.this.m_DatagramSocket.isClosed()) {
                                break;
                            }
                        }
                        if (LANServer.this.m_StopServer) {
                            try {
                                for (int intMessage = 0; intMessage < LANServer.this.m_Send_DatagramPackets.size(); ++intMessage) {
                                    o_DatagramPacket = (DatagramPacket)LANServer.this.m_Send_DatagramPackets.get(intMessage);
                                    LANServer.this.m_DatagramSocket.send(o_DatagramPacket);
                                }
                            }
                            catch (Exception intMessage) {
                                // empty catch block
                            }
                            LANServer.this.m_Send_DatagramPackets.clear();
                            continue;
                        }
                        if (LANServer.this.m_Send_DatagramPackets.size() <= 0) {
                            continue;
                        }
                    }
                    o_DatagramPacket = null;
                    object = s_SyncServer;
                    synchronized (object) {
                        if (LANServer.this.m_Send_DatagramPackets.size() > 0) {
                            o_DatagramPacket = (DatagramPacket)LANServer.this.m_Send_DatagramPackets.get(0);
                            try {
                                LANServer.this.m_DatagramSocket.send(o_DatagramPacket);
                            }
                            catch (Exception e) {
                                System.out.println("SPITServer m_Send_Runnable sendDatagramm to: " + o_DatagramPacket.getAddress() + " Error:");
                                System.out.println("     " + e.getMessage());
                            }
                            LANServer.this.m_Send_DatagramPackets.remove(0);
                            SPIT_Message.addEmpty((byte[])o_DatagramPacket.getData());
                        }
                    }
                }
                object = s_SyncServer;
                synchronized (object) {
                    LANServer.this.m_Send_DatagramPackets.clear();
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startServer() {
        if (!this.m_StopServer) {
            return;
        }
        this.m_StopServer = false;
        Object object = s_SyncServer;
        synchronized (object) {
            try {
                this.m_DatagramSocket = new DatagramSocket(s_LocalPort);
                try {
                    this.m_DatagramSocket.setSendBufferSize(65024);
                    this.m_DatagramSocket.setReceiveBufferSize(65024);
                }
                catch (Exception exception) {}
            }
            catch (Exception e) {
                this.m_DatagramSocket = null;
                this.m_StopServer = true;
                return;
            }
        }
        this.m_SendThread = new Thread(this.m_Send_Runnable);
        this.m_SendThread.start();
        Thread o_Thread = new Thread(this.m_RunnableReceive);
        o_Thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopServer() {
        this.m_StopServer = true;
        Object object = s_SyncServer;
        synchronized (object) {
            s_SyncServer.notifyAll();
        }
        this.closeDatagramSocket();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeDatagramSocket() {
        Object object = s_SyncServer;
        synchronized (object) {
            this.m_StopServer = true;
            s_SyncServer.notifyAll();
        }
        try {
            if (this.m_SendThread != null) {
                this.m_SendThread.join(2000L);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_SendThread = null;
        object = s_SyncServer;
        synchronized (object) {
            try {
                if (this.m_DatagramSocket != null) {
                    this.m_DatagramSocket.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_DatagramSocket = null;
        }
    }

    public boolean isStarted() {
        return this.m_DatagramSocket != null;
    }

    public String getComputerName() {
        return s_ServerComputerName;
    }

    public DatagramSocket getDatagramSocket() {
        return this.m_DatagramSocket;
    }

    public Object getSyncSendMessage() {
        return this.m_SyncSendMessage;
    }
}

