#!/bin/bash
#This script installs the liveSHOW software

#---- Declare path settings ----

SOURCE_APPFOLDER="SPIT_RXTX"
SOURCE_APPPATH=`dirname "$0"`

DEST_APPNAME="liveSHOW_RXTX"
DEST_APPFOLDER="$SOURCE_APPFOLDER"
DEST_APPSPATH="$HOME/.local/share/liveSHOWApps"

#Path to applications menu
DEST_MENUPATH="$HOME/.local/share/applications"
#Path to Desktop
desktopVar=$(cat $HOME/.config/user-dirs.dirs | grep "XDG_DESKTOP_DIR")
DEST_DESKTOPPATH="${desktopVar[@]/XDG_DESKTOP_DIR='"$HOME'/$HOME}"
DEST_DESKTOPPATH="${DEST_DESKTOPPATH[@]/'"'/''}"
#Path to autostart
DEST_AUTOSTARTPATH="$HOME/.config/autostart"

#---- Copy the program files ----

echo "Copy app directory from $SOURCE_APPPATH/$SOURCE_APPFOLDER to $DEST_APPSPATH"
mkdir -p "$DEST_APPSPATH"
cp -r "$SOURCE_APPPATH/$SOURCE_APPFOLDER" "$DEST_APPSPATH"
echo "app directory is copied"

#---- Create .desktop file - menu items ----

DESKTOP_FILE="$DEST_APPSPATH/$DEST_APPFOLDER/$DEST_APPNAME.desktop"
echo "create menu and desktop items .desktop file"

cat > $DESKTOP_FILE << EOM
[Desktop Entry]
Version=1.0
Name=$DEST_APPNAME
Comment=Start $DEST_APPNAME
Icon=$DEST_APPSPATH/$DEST_APPFOLDER/icon.png
Exec="$DEST_APPSPATH/$DEST_APPFOLDER/Start.sh"
Type=Application
StartupNotify=false
Terminal=false
Categories=AudioVideo
EOM

#---- Make Start.sh executable ----
chmod +x $DEST_APPSPATH/$DEST_APPFOLDER/Start.sh

#---- Make autostarts sh executable ----
chmod +x $SOURCE_APPPATH/makeautostart_$DEST_APPNAME.sh
chmod +x $SOURCE_APPPATH/removeautostart_$DEST_APPNAME.sh
chmod +x $SOURCE_APPPATH/Uninstall_$DEST_APPNAME.sh


#---- Copy desktopfile to menu ----
echo "copy .desktop file to menu: $DEST_MENUPATH"
cp "$DESKTOP_FILE" "$DEST_MENUPATH"
chmod +x $DEST_MENUPATH/$DEST_APPNAME.desktop
#---- Copy desktopfile to desktop ----
echo "copy .desktop file to desktop: $DEST_DESKTOPPATH"
cp "$DESKTOP_FILE" "$DEST_DESKTOPPATH"
chmod +x $DEST_DESKTOPPATH/$DEST_APPNAME.desktop
echo "$DEST_APPNAME sucessfully installed"


#---- Set the user rights for dialout ----
sudo usermod -a -G uucp $USER
sudo usermod -a -G dialout $USER
sudo usermod -a -G lock $USER
sudo usermod -a -G tty $USER
echo "User rights for serial comm are set"