/*
 * Decompiled with CFR 0.152.
 */
package SwingTextPackage;

import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import javax.swing.text.JTextComponent;

public class DocumentFilter_Long
extends DocumentFilter {
    private boolean m_AllowEmptyString;
    private boolean m_AllowNegativeNumbers;
    private long m_MinValue;
    private long m_MaxValue;
    private AbstractDocument m_AbstractDocument;

    public DocumentFilter_Long(AbstractDocument p_Document) {
        this.initMembers();
        this.m_AbstractDocument = p_Document;
        if (p_Document != null) {
            this.m_AbstractDocument.setDocumentFilter(this);
        }
    }

    public DocumentFilter_Long(JTextComponent p_TextComponent) {
        this.initMembers();
        AbstractDocument o_AbstractDocument = p_TextComponent == null ? null : (AbstractDocument)p_TextComponent.getDocument();
        this.m_AbstractDocument = o_AbstractDocument;
        if (o_AbstractDocument != null) {
            o_AbstractDocument.setDocumentFilter(this);
        }
    }

    private void initMembers() {
        this.m_AllowEmptyString = false;
        this.m_AllowNegativeNumbers = true;
        this.m_MinValue = Long.MIN_VALUE;
        this.m_MaxValue = Long.MAX_VALUE;
    }

    public AbstractDocument getDocument() {
        return this.m_AbstractDocument;
    }

    public void setAllowEmptyString(boolean p_AllowEmptyString) {
        this.m_AllowEmptyString = p_AllowEmptyString;
    }

    public void setAllowNegativeNumbers(boolean p_AllowNegativeNumbers) {
        this.m_AllowNegativeNumbers = p_AllowNegativeNumbers;
    }

    public void setMaxValue(long p_MaxValue) {
        this.m_MaxValue = p_MaxValue;
    }

    public void setMinValue(long p_MinValue) {
        this.m_MinValue = p_MinValue;
    }

    @Override
    public void insertString(DocumentFilter.FilterBypass p_FilterBypass, int p_Offset, String p_String, AttributeSet p_AttributeSet) throws BadLocationException {
        if (p_String == null) {
            return;
        }
        boolean boolOK = false;
        long longValue = 0L;
        try {
            String stringDocument;
            AbstractDocument o_Document = (AbstractDocument)p_FilterBypass.getDocument();
            if (o_Document == null) {
                return;
            }
            if (!this.m_AllowNegativeNumbers && p_String.contains("-")) {
                return;
            }
            int intDocumentLength = o_Document.getLength();
            if (intDocumentLength <= 0) {
                stringDocument = p_String;
            } else {
                stringDocument = o_Document.getText(0, o_Document.getLength());
                stringDocument = stringDocument.substring(0, p_Offset) + p_String + stringDocument.substring(p_Offset, stringDocument.length());
            }
            if (stringDocument.length() <= 0 && this.m_AllowEmptyString) {
                super.insertString(p_FilterBypass, p_Offset, p_String, p_AttributeSet);
                return;
            }
            longValue = Long.parseLong(stringDocument);
            if (!boolOK) {
                if (!this.m_AllowNegativeNumbers && longValue < 0L) {
                    return;
                }
                boolOK = true;
            }
            if (longValue > this.m_MaxValue) {
                super.replace(p_FilterBypass, 0, intDocumentLength, String.valueOf(this.m_MaxValue), p_AttributeSet);
                return;
            }
            if (boolOK) {
                super.insertString(p_FilterBypass, p_Offset, p_String, p_AttributeSet);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void replace(DocumentFilter.FilterBypass p_FilterBypass, int p_Offset, int p_Length, String p_String, AttributeSet p_AttributeSet) throws BadLocationException {
        if (p_String == null) {
            return;
        }
        boolean boolOK = false;
        try {
            String stringDocument;
            AbstractDocument o_Document = (AbstractDocument)p_FilterBypass.getDocument();
            if (o_Document == null) {
                return;
            }
            if (!this.m_AllowNegativeNumbers && p_String.contains("-")) {
                return;
            }
            int intDocumentLenght = o_Document.getLength();
            stringDocument = intDocumentLenght <= 0 ? p_String : (p_Offset + p_Length <= (stringDocument = o_Document.getText(0, intDocumentLenght)).length() ? stringDocument.substring(0, p_Offset) + p_String + stringDocument.substring(p_Offset + p_Length) : stringDocument.substring(0, p_Offset) + p_String);
            if (stringDocument.length() <= 0 && this.m_AllowEmptyString) {
                super.replace(p_FilterBypass, p_Offset, p_Length, p_String, p_AttributeSet);
                return;
            }
            long longValue = Long.parseLong(stringDocument);
            if (!boolOK) {
                longValue = Long.parseLong(stringDocument);
                if (!this.m_AllowNegativeNumbers && longValue < 0L) {
                    return;
                }
                boolOK = true;
            }
            if (longValue > this.m_MaxValue) {
                super.replace(p_FilterBypass, 0, intDocumentLenght, String.valueOf(this.m_MaxValue), p_AttributeSet);
                return;
            }
            if (p_Length > intDocumentLenght) {
                return;
            }
            super.replace(p_FilterBypass, p_Offset, p_Length, p_String, p_AttributeSet);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Long getValue(String p_ValueString) {
        try {
            long longValue = Long.valueOf(p_ValueString);
            return longValue;
        }
        catch (Exception e) {
            return null;
        }
    }
}

