/*
 * Decompiled with CFR 0.152.
 */
package RXTX_Package;

import CommListModelPackage.ListModel_SerialPorts;
import LiveCommSerial.CommSerialPortConnection;
import LiveCommSerial.CommSerialPortEvent;
import LiveCommSerial.CommSerialPortEventListener;
import RXTX_Package.RXTX_Connection;
import RXTX_Package.RXTX_Device;
import com.fazecast.jSerialComm.SerialPort;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;

public class RXTX_Connection_CommDevice
extends RXTX_Connection
implements CommSerialPortEventListener {
    public static final int SOFTWAREVERSION = 1;
    public static ListModel_SerialPorts s_ListModel_SerialPorts = new ListModel_SerialPorts();
    private static final String PARAM_DIVIDER = ";";
    private int COMM_BAUDRATE = 9600;
    public static int CONNECTION_NONE = 0;
    public static int CONNECTION_CONNECTED = 1;
    private CommSerialPortConnection m_CommSerialPortConnection;
    private int m_ConnectionStatus;
    private String m_CommPortName;
    private int m_CommBaudrate;
    private int m_CommDataBits;
    private int m_CommParity;
    private int m_CommStopBits;
    private final Object m_SyncConnection = new Object();

    public RXTX_Connection_CommDevice(RXTX_Device p_RXTX_Device) {
        super(p_RXTX_Device);
        this.initMembers();
        if (p_RXTX_Device != null) {
            p_RXTX_Device.setRXTX_Connection(this);
        }
    }

    private void initMembers() {
        this.m_CommPortName = "";
        this.m_CommBaudrate = this.COMM_BAUDRATE;
        this.m_CommDataBits = 8;
        this.m_CommParity = 0;
        this.m_CommStopBits = 1;
        this.m_ConnectionStatus = CONNECTION_NONE;
        this.m_CommSerialPortConnection = new CommSerialPortConnection();
    }

    public void setComm_Port(String p_CommPortName) {
        this.m_CommPortName = p_CommPortName;
    }

    public String getComm_Port() {
        return this.m_CommPortName;
    }

    public void setComm_BaudRate(int p_BaudRate) {
        this.m_CommBaudrate = p_BaudRate;
    }

    public int getComm_BaudRate() {
        return this.m_CommBaudrate;
    }

    public boolean setComm_DataBits(int p_DataBits) {
        if (p_DataBits == this.m_CommDataBits) {
            return false;
        }
        switch (p_DataBits) {
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                this.m_CommDataBits = p_DataBits;
                return true;
            }
        }
        return false;
    }

    public int getComm_DataBits() {
        return this.m_CommDataBits;
    }

    public boolean setComm_StopBits(int p_StopBits) {
        if (p_StopBits == this.m_CommStopBits) {
            return false;
        }
        switch (p_StopBits) {
            case 1: 
            case 2: 
            case 3: {
                this.m_CommStopBits = p_StopBits;
                return true;
            }
        }
        return false;
    }

    public int getComm_StopBits() {
        return this.m_CommStopBits;
    }

    public boolean setComm_Parity(int p_Parity) {
        if (p_Parity == this.m_CommParity) {
            return false;
        }
        switch (p_Parity) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.m_CommParity = p_Parity;
                return true;
            }
        }
        return false;
    }

    public int getComm_Parity() {
        return this.m_CommParity;
    }

    public boolean setConnectionParameters(String p_ConnectionParameters) {
        String[] arrayParams = p_ConnectionParameters.split(PARAM_DIVIDER);
        if (arrayParams.length < 2) {
            return false;
        }
        this.m_CommPortName = arrayParams[0];
        try {
            this.m_CommBaudrate = Integer.valueOf(arrayParams[1]);
            if (arrayParams.length > 2) {
                this.setComm_DataBits(Integer.valueOf(arrayParams[2]));
            }
            if (arrayParams.length > 3) {
                this.setComm_Parity(Integer.valueOf(arrayParams[3]));
            }
            if (arrayParams.length > 4) {
                this.setComm_StopBits(Integer.valueOf(arrayParams[4]));
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    public String getConnectionString() {
        SerialPort o_SerialPort = null;
        if (this.m_CommSerialPortConnection != null) {
            o_SerialPort = this.m_CommSerialPortConnection.getCommPort();
        }
        if (o_SerialPort == null) {
            return this.m_CommPortName;
        }
        StringBuilder o_StringBuilder = new StringBuilder();
        o_StringBuilder.append(o_SerialPort.getPortDescription());
        o_StringBuilder.append(" (");
        o_StringBuilder.append(o_SerialPort.getSystemPortName());
        o_StringBuilder.append(")");
        return o_StringBuilder.toString();
    }

    @Override
    public boolean connect() {
        RXTX_Connection_CommDevice.refreshCommPorts();
        CommSerialPortConnection o_CommSerialPortConnection = this.m_CommSerialPortConnection;
        if (o_CommSerialPortConnection == null) {
            return false;
        }
        System.out.println(this.getClass().getSimpleName() + " connect() Param: Port " + this.m_CommPortName + "Baud " + this.m_CommBaudrate);
        o_CommSerialPortConnection.addCommSerialPortEventListener((CommSerialPortEventListener)this);
        boolean boolConnected = o_CommSerialPortConnection.connect(this.m_CommPortName, this.m_CommBaudrate, this.getComm_DataBits(), this.getComm_StopBits(), this.getComm_Parity());
        if (!boolConnected) {
            o_CommSerialPortConnection.removeCommSerialPortEventListener((CommSerialPortEventListener)this);
        }
        return boolConnected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean disconnect() {
        Object object = this.m_SyncConnection;
        synchronized (object) {
            CommSerialPortConnection o_CommSerialPortConnection = this.m_CommSerialPortConnection;
            if (o_CommSerialPortConnection == null) {
                return true;
            }
            System.out.println(this.getClass().getSimpleName() + " disconnect");
            o_CommSerialPortConnection.disconnect();
            o_CommSerialPortConnection.removeCommSerialPortEventListener((CommSerialPortEventListener)this);
        }
        return true;
    }

    @Override
    public boolean getIsConnected() {
        if (this.m_CommSerialPortConnection == null) {
            return false;
        }
        return this.m_CommSerialPortConnection.isConnected();
    }

    public CommSerialPortConnection getCommSerialPortConnection() {
        return this.m_CommSerialPortConnection;
    }

    public void eventCommSerialPortConnection(int p_ConnectionStatus) {
        if (this.m_RXTX_Device != null) {
            this.m_RXTX_Device.eventConnectionStatus(p_ConnectionStatus);
        }
        System.out.println("eventCommSerialPortConnection " + p_ConnectionStatus);
    }

    public void eventCommSerialPortComm(CommSerialPortEvent p_CommSerialPortEvent) {
    }

    public void eventCommSerialPortDataReceived(byte[] p_BytesReadenAll, int p_DataLenght) {
        if (this.m_RXTX_Device != null) {
            this.m_RXTX_Device.eventDataReceived(p_BytesReadenAll, p_DataLenght);
        }
    }

    public void eventCommSerialPortException(Exception p_Exception) {
        System.out.println("eventCommSerialPortException");
        System.out.println(p_Exception.getMessage());
    }

    public static void refreshCommPorts() {
        ArrayList o_SerialPorts = CommSerialPortConnection.getSerialPorts();
        s_ListModel_SerialPorts.clear();
        for (int intPort = 0; intPort < o_SerialPorts.size(); ++intPort) {
            SerialPort o_SerialPort = (SerialPort)o_SerialPorts.get(intPort);
            if (o_SerialPort == null) continue;
            s_ListModel_SerialPorts.add(o_SerialPorts.get(intPort));
        }
    }

    @Override
    public boolean sendMessage(byte[] p_MessageBytes, int p_DataLenght) {
        if (this.m_CommSerialPortConnection == null || !this.m_CommSerialPortConnection.isConnected()) {
            return false;
        }
        this.m_CommSerialPortConnection.write(p_MessageBytes, p_DataLenght);
        return true;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(1);
        out.writeUTF(this.m_CommPortName);
        out.writeInt(this.m_CommBaudrate);
        out.writeInt(this.m_CommDataBits);
        out.writeInt(this.m_CommParity);
        out.writeInt(this.m_CommStopBits);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int intSoftwareVersion = in.readInt();
        this.m_CommPortName = in.readUTF();
        this.m_CommBaudrate = in.readInt();
        this.m_CommDataBits = in.readInt();
        this.m_CommParity = in.readInt();
        this.m_CommStopBits = in.readInt();
    }
}

