/*
 * Decompiled with CFR 0.152.
 */
package LanguageTools.EditPackage;

import LanguageTools.EditPackage.LiveLanguageEditTable;
import LanguageTools.EditPackage.LiveLanguageEditTableModel;
import LanguageTools.FlagsPackage.LiveLanguageFlagModel;
import LanguageTools.HelpPackage.LiveLanguageFrame_Help;
import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LanguageTools.LiveLanguagePackage.LiveLanguageListener;
import LanguageTools.LiveLanguagePackage.LiveLanguageString;
import LanguageTools.LocalePackage.LiveLangageLocaleHandling;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;

public class LiveLanguageEditFrame
extends JFrame
implements LiveLanguageListener,
ListSelectionListener,
ActionListener {
    LiveLanguageEditTable m_Table;
    LiveLanguageFlagModel m_LiveLanguageFlagModel;
    private String m_StringConfirmDeleteRowHeader;
    private String m_StringConfirmDeleteRowContent;
    public static String m_StringWarningEditColumn0;
    @LiveLanguageString
    private String m_StringConfirmSafeOnCloseHeader;
    @LiveLanguageString
    private String m_StringConfirmSafeOnCloseContent;
    @LiveLanguageString
    private String m_StringConfirmDeleteHeader;
    @LiveLanguageString
    private String m_StringConfirmDeleteContent;
    private int m_FirstSearchRow;
    private LiveLanguageFrame_Help m_Frame_Help;
    private JButton jButton_AddLanguage;
    private JButton jButton_DeleteLanguage;
    private JButton jButton_Help;
    private JButton jButton_Load;
    private JButton jButton_RemoveLanguage;
    private JButton jButton_RowAddAbove;
    private JButton jButton_RowAddBelow;
    private JButton jButton_RowDelete;
    private JButton jButton_RowDown;
    private JButton jButton_RowUp;
    private JButton jButton_RowZoomMinus;
    private JButton jButton_RowZoomPlus;
    private JButton jButton_Save;
    private JButton jButton_Search;
    private JComboBox jComboBox_Language1;
    private JPanel jPanelEditLanguageFile;
    private JScrollPane jScrollPaneTable;
    private JToolBar.Separator jSeparator1;
    private JToolBar.Separator jSeparator2;
    private JToolBar.Separator jSeparator3;
    private JTextField jTextField_Search;
    private JToolBar jToolBar1;
    private JToolBar jToolBar2;
    private JToolBar jToolBar3;

    public LiveLanguageEditFrame() {
        this.initComponents();
        this.initMembers();
    }

    private void initMembers() {
        this.setControlsEnabled(false);
        this.m_LiveLanguageFlagModel = new LiveLanguageFlagModel(LiveLangageLocaleHandling.getAvailableLocales());
        this.jComboBox_Language1.setModel(this.m_LiveLanguageFlagModel);
        this.jComboBox_Language1.setRenderer(new LiveLanguageFlagModel.LiveImageTextListCellRenderer());
        this.jComboBox_Language1.setSelectedIndex(0);
        this.m_Table = new LiveLanguageEditTable();
        this.jScrollPaneTable.setViewportView(this.m_Table);
        this.m_Table.getSelectionModel().addListSelectionListener(this);
        this.setEditRowEnable(false);
        this.jComboBox_Language1.addActionListener(this);
        this.m_StringConfirmDeleteRowHeader = "delete row";
        this.m_StringConfirmDeleteRowContent = "<html>Do you really want to delete the row?<br>This may make the langagefile inconsistently!</html>";
        m_StringWarningEditColumn0 = "<html>Changes in this column may make the langagefile inconsistently!<br>The changes affects all languages!</html>";
        this.m_StringConfirmSafeOnCloseHeader = "save changes";
        this.m_StringConfirmSafeOnCloseContent = "<html>You have made changes!<br>Do you want to save the changes?</html>";
        this.m_StringConfirmDeleteHeader = "Delete ";
        this.m_StringConfirmDeleteContent = "<html>Do you really want to delete this language?</html>";
        LiveLanguage.addLanguageListener(this, LiveLanguageEditFrame.class.getSimpleName());
        this.m_FirstSearchRow = 0;
    }

    public LiveLanguageEditTable getLanguageEditTable() {
        return this.m_Table;
    }

    public LiveLanguageEditTableModel getLiveLanguageEditTableModel() {
        return this.m_Table.getModel();
    }

    public void showSelectedRow() {
        int intIndex = this.m_Table.getSelectedRow();
        if (intIndex < 0) {
            return;
        }
        intIndex = this.m_Table.convertRowIndexToView(intIndex);
        JViewport o_JViewport = (JViewport)this.m_Table.getParent();
        Rectangle o_CellRect = this.m_Table.getCellRect(intIndex, 0, true);
        Rectangle o_ViewportRect = o_JViewport.getViewRect();
        if (o_CellRect.x < o_ViewportRect.y || o_CellRect.y + o_CellRect.height > o_ViewportRect.y + o_ViewportRect.height) {
            o_CellRect.setLocation(o_CellRect.x - o_ViewportRect.x, o_CellRect.y - o_ViewportRect.y);
            int intCenterY = (o_ViewportRect.height - o_CellRect.height) / 2;
            if (o_CellRect.y < intCenterY) {
                intCenterY = -intCenterY;
            }
            o_CellRect.translate(o_CellRect.x, intCenterY);
            o_JViewport.scrollRectToVisible(o_CellRect);
        }
    }

    private void initComponents() {
        this.jPanelEditLanguageFile = new JPanel();
        this.jScrollPaneTable = new JScrollPane();
        this.jToolBar1 = new JToolBar();
        this.jButton_Load = new JButton();
        this.jButton_Save = new JButton();
        this.jSeparator2 = new JToolBar.Separator();
        this.jButton_RowAddAbove = new JButton();
        this.jButton_RowAddBelow = new JButton();
        this.jButton_RowDelete = new JButton();
        this.jButton_RowUp = new JButton();
        this.jButton_RowDown = new JButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.jButton_RowZoomPlus = new JButton();
        this.jButton_RowZoomMinus = new JButton();
        this.jSeparator3 = new JToolBar.Separator();
        this.jButton_Help = new JButton();
        this.jToolBar2 = new JToolBar();
        this.jComboBox_Language1 = new JComboBox();
        this.jButton_AddLanguage = new JButton();
        this.jButton_RemoveLanguage = new JButton();
        this.jButton_DeleteLanguage = new JButton();
        this.jToolBar3 = new JToolBar();
        this.jTextField_Search = new JTextField();
        this.jButton_Search = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(400, 500));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                LiveLanguageEditFrame.this.formWindowClosing(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.jPanelEditLanguageFile.setBackground(new Color(0, 0, 0));
        this.jPanelEditLanguageFile.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanelEditLanguageFile.add((Component)this.jScrollPaneTable, gridBagConstraints);
        this.jToolBar1.setBackground(Color.darkGray);
        this.jToolBar1.setBorder(null);
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setRollover(true);
        this.jButton_Load.setIcon(new ImageIcon(this.getClass().getResource("/LanguageTools/EditPackage/IconLoad.png")));
        this.jButton_Load.setToolTipText("load language file");
        this.jButton_Load.setBorder(BorderFactory.createBevelBorder(0));
        this.jButton_Load.setContentAreaFilled(false);
        this.jButton_Load.setFocusable(false);
        this.jButton_Load.setHorizontalTextPosition(0);
        this.jButton_Load.setMaximumSize(new Dimension(40, 40));
        this.jButton_Load.setMinimumSize(new Dimension(40, 40));
        this.jButton_Load.setPreferredSize(new Dimension(40, 40));
        this.jButton_Load.setPressedIcon(new ImageIcon(this.getClass().getResource("/LanguageTools/EditPackage/IconPressed.png")));
        this.jButton_Load.setVerticalTextPosition(3);
        this.jButton_Load.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveLanguageEditFrame.this.jButton_LoadActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_Load);
        this.jButton_Save.setIcon(new ImageIcon(this.getClass().getResource("/LanguageTools/EditPackage/IconSaveAll.png")));
        this.jButton_Save.setToolTipText("save all");
        this.jButton_Save.setBorder(BorderFactory.createBevelBorder(0));
        this.jButton_Save.setContentAreaFilled(false);
        this.jButton_Save.setFocusable(false);
        this.jButton_Save.setHorizontalTextPosition(0);
        this.jButton_Save.setMaximumSize(new Dimension(40, 40));
        this.jButton_Save.setMinimumSize(new Dimension(40, 40));
        this.jButton_Save.setPreferredSize(new Dimension(40, 40));
        this.jButton_Save.setPressedIcon(new ImageIcon(this.getClass().getResource("/LanguageTools/EditPackage/IconPressed.png")));
        this.jButton_Save.setVerticalTextPosition(3);
        this.jButton_Save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveLanguageEditFrame.this.jButton_SaveActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_Save);
        this.jSeparator2.setMaximumSize(new Dimension(40, Short.MAX_VALUE));
        this.jSeparator2.setPreferredSize(new Dimension(10, 0));
        this.jToolBar1.add(this.jSeparator2);
        this.jButton_RowAddAbove.setIcon(new ImageIcon(this.getClass().getResource("/LanguageTools/EditPackage/IconRowAddAbove.png")));
        this.jButton_RowAddAbove.setToolTipText("add row above");
        this.jButton_RowAddAbove.setBorder(BorderFactory.createBevelBorder(0));
        this.jButton_RowAddAbove.setContentAreaFilled(false);
        this.jButton_RowAddAbove.setFocusable(false);
        this.jButton_RowAddAbove.setHorizontalTextPosition(0);
        this.jButton_RowAddAbove.setMaximumSize(new Dimension(40, 40));
        this.jButton_RowAddAbove.setMinimumSize(new Dimension(40, 40));
        this.jButton_RowAddAbove.setPreferredSize(new Dimension(40, 40));
        this.jButton_RowAddAbove.setPressedIcon(new ImageIcon(this.getClass().getResource("/LanguageTools/EditPackage/IconPressed.png")));
        this.jButton_RowAddAbove.setVerticalTextPosition(3);
        this.jButton_RowAddAbove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveLanguageEditFrame.this.jButton_RowAddAboveActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_RowAddAbove);
        this.jButton_RowAddBelow.setIcon(new ImageIcon(this.getClass().getResource("/LanguageTools/EditPackage/IconRowAddBelow.png")));
        this.jButton_RowAddBelow.setToolTipText("add row below");
        this.jButton_RowAddBelow.setBorder(BorderFactory.createBevelBorder(0));
        this.jButton_RowAddBelow.setContentAreaFilled(false);
        this.jButton_RowAddBelow.setFocusable(false);
        this.jButton_RowAddBelow.setHorizontalTextPosition(0);
        this.jButton_RowAddBelow.setMaximumSize(new Dimension(40, 40));
        this.jButton_RowAddBelow.setMinimumSize(new Dimension(40, 40));
        this.jButton_RowAddBelow.setPreferredSize(new Dimension(40, 40));
        this.jButton_RowAddBelow.setPressedIcon(new ImageIcon(this.getClass().getResource("/LanguageTools/EditPackage/IconPressed.png")));
        this.jButton_RowAddBelow.setVerticalTextPosition(3);
        this.jButton_RowAddBelow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveLanguageEditFrame.this.jButton_RowAddBelowActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_RowAddBelow);
        this.jButton_RowDelete.setIcon(new ImageIcon(this.getClass().getResource("/LanguageTools/EditPackage/IconRowCancel.png")));
        this.jButton_RowDelete.setToolTipText("remove selected row");
        this.jButton_RowDelete.setBorder(BorderFactory.createBevelBorder(0));
        this.jButton_RowDelete.setContentAreaFilled(false);
        this.jButton_RowDelete.setFocusable(false);
        this.jButton_RowDelete.setHorizontalTextPosition(0);
        this.jButton_RowDelete.setMaximumSize(new Dimension(40, 40));
        this.jButton_RowDelete.setMinimumSize(new Dimension(40, 40));
        this.jButton_RowDelete.setPreferredSize(new Dimension(40, 40));
        this.jButton_RowDelete.setPressedIcon(new ImageIcon(this.getClass().getResource("/LanguageTools/EditPackage/IconPressed.png")));
        this.jButton_RowDelete.setVerticalTextPosition(3);
        this.jButton_RowDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveLanguageEditFrame.this.jButton_RowDeleteActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_RowDelete);
        this.jButton_RowUp.setIcon(new ImageIcon(this.getClass().getResource("/LanguageTools/EditPackage/IconArrowUp.png")));
        this.jButton_RowUp.setToolTipText("move selected row upwards");
        this.jButton_RowUp.setBorder(BorderFactory.createBevelBorder(0));
        this.jButton_RowUp.setContentAreaFilled(false);
        this.jButton_RowUp.setFocusable(false);
        this.jButton_RowUp.setHorizontalTextPosition(0);
        this.jButton_RowUp.setMaximumSize(new Dimension(40, 40));
        this.jButton_RowUp.setMinimumSize(new Dimension(40, 40));
        this.jButton_RowUp.setPreferredSize(new Dimension(40, 40));
        this.jButton_RowUp.setPressedIcon(new ImageIcon(this.getClass().getResource("/LanguageTools/EditPackage/IconPressed.png")));
        this.jButton_RowUp.setVerticalTextPosition(3);
        this.jButton_RowUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveLanguageEditFrame.this.jButton_RowUpActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_RowUp);
        this.jButton_RowDown.setIcon(new ImageIcon(this.getClass().getResource("/LanguageTools/EditPackage/IconArrowDown.png")));
        this.jButton_RowDown.setToolTipText("move selected row downwards");
        this.jButton_RowDown.setBorder(BorderFactory.createBevelBorder(0));
        this.jButton_RowDown.setContentAreaFilled(false);
        this.jButton_RowDown.setFocusable(false);
        this.jButton_RowDown.setHorizontalTextPosition(0);
        this.jButton_RowDown.setMaximumSize(new Dimension(40, 40));
        this.jButton_RowDown.setMinimumSize(new Dimension(40, 40));
        this.jButton_RowDown.setPreferredSize(new Dimension(40, 40));
        this.jButton_RowDown.setPressedIcon(new ImageIcon(this.getClass().getResource("/LanguageTools/EditPackage/IconPressed.png")));
        this.jButton_RowDown.setVerticalTextPosition(3);
        this.jButton_RowDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveLanguageEditFrame.this.jButton_RowDownActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_RowDown);
        this.jToolBar1.add(this.jSeparator1);
        this.jButton_RowZoomPlus.setIcon(new ImageIcon(this.getClass().getResource("/LanguageTools/EditPackage/IconZoomOut.png")));
        this.jButton_RowZoomPlus.setToolTipText("zoom plus");
        this.jButton_RowZoomPlus.setBorder(BorderFactory.createBevelBorder(0));
        this.jButton_RowZoomPlus.setContentAreaFilled(false);
        this.jButton_RowZoomPlus.setFocusable(false);
        this.jButton_RowZoomPlus.setHorizontalTextPosition(0);
        this.jButton_RowZoomPlus.setMaximumSize(new Dimension(40, 40));
        this.jButton_RowZoomPlus.setMinimumSize(new Dimension(40, 40));
        this.jButton_RowZoomPlus.setPreferredSize(new Dimension(40, 40));
        this.jButton_RowZoomPlus.setPressedIcon(new ImageIcon(this.getClass().getResource("/LanguageTools/EditPackage/IconPressed.png")));
        this.jButton_RowZoomPlus.setVerticalTextPosition(3);
        this.jButton_RowZoomPlus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveLanguageEditFrame.this.jButton_RowZoomPlusActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_RowZoomPlus);
        this.jButton_RowZoomMinus.setIcon(new ImageIcon(this.getClass().getResource("/LanguageTools/EditPackage/IconZoomIn.png")));
        this.jButton_RowZoomMinus.setToolTipText("zoom minus");
        this.jButton_RowZoomMinus.setBorder(BorderFactory.createBevelBorder(0));
        this.jButton_RowZoomMinus.setContentAreaFilled(false);
        this.jButton_RowZoomMinus.setFocusable(false);
        this.jButton_RowZoomMinus.setHorizontalTextPosition(0);
        this.jButton_RowZoomMinus.setMaximumSize(new Dimension(40, 40));
        this.jButton_RowZoomMinus.setMinimumSize(new Dimension(40, 40));
        this.jButton_RowZoomMinus.setPreferredSize(new Dimension(40, 40));
        this.jButton_RowZoomMinus.setPressedIcon(new ImageIcon(this.getClass().getResource("/LanguageTools/EditPackage/IconPressed.png")));
        this.jButton_RowZoomMinus.setVerticalTextPosition(3);
        this.jButton_RowZoomMinus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveLanguageEditFrame.this.jButton_RowZoomMinusActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_RowZoomMinus);
        this.jSeparator3.setMaximumSize(new Dimension(40, Short.MAX_VALUE));
        this.jSeparator3.setPreferredSize(new Dimension(10, 0));
        this.jToolBar1.add(this.jSeparator3);
        this.jButton_Help.setIcon(new ImageIcon(this.getClass().getResource("/LanguageTools/EditPackage/IconHelp.png")));
        this.jButton_Help.setToolTipText("zoom minus");
        this.jButton_Help.setBorder(BorderFactory.createBevelBorder(0));
        this.jButton_Help.setContentAreaFilled(false);
        this.jButton_Help.setFocusable(false);
        this.jButton_Help.setHorizontalTextPosition(0);
        this.jButton_Help.setMaximumSize(new Dimension(40, 40));
        this.jButton_Help.setMinimumSize(new Dimension(40, 40));
        this.jButton_Help.setPreferredSize(new Dimension(40, 40));
        this.jButton_Help.setPressedIcon(new ImageIcon(this.getClass().getResource("/LanguageTools/EditPackage/IconPressed.png")));
        this.jButton_Help.setVerticalTextPosition(3);
        this.jButton_Help.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveLanguageEditFrame.this.jButton_HelpActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_Help);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanelEditLanguageFile.add((Component)this.jToolBar1, gridBagConstraints);
        this.jToolBar2.setBackground(Color.darkGray);
        this.jToolBar2.setBorder(null);
        this.jToolBar2.setFloatable(false);
        this.jToolBar2.setRollover(true);
        this.jComboBox_Language1.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBox_Language1.setPreferredSize(new Dimension(150, 20));
        this.jToolBar2.add(this.jComboBox_Language1);
        this.jButton_AddLanguage.setIcon(new ImageIcon(this.getClass().getResource("/LanguageTools/EditPackage/IconAdd.png")));
        this.jButton_AddLanguage.setToolTipText("add language");
        this.jButton_AddLanguage.setBorder(BorderFactory.createBevelBorder(0));
        this.jButton_AddLanguage.setContentAreaFilled(false);
        this.jButton_AddLanguage.setFocusable(false);
        this.jButton_AddLanguage.setHorizontalTextPosition(0);
        this.jButton_AddLanguage.setMaximumSize(new Dimension(40, 40));
        this.jButton_AddLanguage.setMinimumSize(new Dimension(40, 40));
        this.jButton_AddLanguage.setPreferredSize(new Dimension(40, 40));
        this.jButton_AddLanguage.setPressedIcon(new ImageIcon(this.getClass().getResource("/LanguageTools/EditPackage/IconPressed.png")));
        this.jButton_AddLanguage.setVerticalTextPosition(3);
        this.jButton_AddLanguage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveLanguageEditFrame.this.jButton_AddLanguageActionPerformed(evt);
            }
        });
        this.jToolBar2.add(this.jButton_AddLanguage);
        this.jButton_RemoveLanguage.setIcon(new ImageIcon(this.getClass().getResource("/LanguageTools/EditPackage/IconRemove.png")));
        this.jButton_RemoveLanguage.setToolTipText("remove language from table");
        this.jButton_RemoveLanguage.setBorder(BorderFactory.createBevelBorder(0));
        this.jButton_RemoveLanguage.setContentAreaFilled(false);
        this.jButton_RemoveLanguage.setFocusable(false);
        this.jButton_RemoveLanguage.setHorizontalTextPosition(0);
        this.jButton_RemoveLanguage.setMaximumSize(new Dimension(40, 40));
        this.jButton_RemoveLanguage.setMinimumSize(new Dimension(40, 40));
        this.jButton_RemoveLanguage.setPreferredSize(new Dimension(40, 40));
        this.jButton_RemoveLanguage.setPressedIcon(new ImageIcon(this.getClass().getResource("/LanguageTools/EditPackage/IconPressed.png")));
        this.jButton_RemoveLanguage.setVerticalTextPosition(3);
        this.jButton_RemoveLanguage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveLanguageEditFrame.this.jButton_RemoveLanguageActionPerformed(evt);
            }
        });
        this.jToolBar2.add(this.jButton_RemoveLanguage);
        this.jButton_DeleteLanguage.setIcon(new ImageIcon(this.getClass().getResource("/LanguageTools/EditPackage/IconCancel.png")));
        this.jButton_DeleteLanguage.setToolTipText("remove language from table");
        this.jButton_DeleteLanguage.setBorder(BorderFactory.createBevelBorder(0));
        this.jButton_DeleteLanguage.setContentAreaFilled(false);
        this.jButton_DeleteLanguage.setFocusable(false);
        this.jButton_DeleteLanguage.setHorizontalTextPosition(0);
        this.jButton_DeleteLanguage.setMaximumSize(new Dimension(40, 40));
        this.jButton_DeleteLanguage.setMinimumSize(new Dimension(40, 40));
        this.jButton_DeleteLanguage.setPreferredSize(new Dimension(40, 40));
        this.jButton_DeleteLanguage.setPressedIcon(new ImageIcon(this.getClass().getResource("/LanguageTools/EditPackage/IconPressed.png")));
        this.jButton_DeleteLanguage.setVerticalTextPosition(3);
        this.jButton_DeleteLanguage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveLanguageEditFrame.this.jButton_DeleteLanguageActionPerformed(evt);
            }
        });
        this.jToolBar2.add(this.jButton_DeleteLanguage);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanelEditLanguageFile.add((Component)this.jToolBar2, gridBagConstraints);
        this.jToolBar3.setBackground(Color.darkGray);
        this.jToolBar3.setBorder(null);
        this.jToolBar3.setFloatable(false);
        this.jToolBar3.setRollover(true);
        this.jTextField_Search.setFont(new Font("Tahoma", 0, 12));
        this.jTextField_Search.setMargin(new Insets(4, 4, 4, 4));
        this.jTextField_Search.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                LiveLanguageEditFrame.this.jTextField_SearchKeyPressed(evt);
            }
        });
        this.jToolBar3.add(this.jTextField_Search);
        this.jButton_Search.setIcon(new ImageIcon(this.getClass().getResource("/LanguageTools/EditPackage/IconSearch.png")));
        this.jButton_Search.setToolTipText("search");
        this.jButton_Search.setBorder(BorderFactory.createBevelBorder(0));
        this.jButton_Search.setContentAreaFilled(false);
        this.jButton_Search.setFocusable(false);
        this.jButton_Search.setHorizontalTextPosition(0);
        this.jButton_Search.setMaximumSize(new Dimension(40, 40));
        this.jButton_Search.setMinimumSize(new Dimension(40, 40));
        this.jButton_Search.setPreferredSize(new Dimension(40, 40));
        this.jButton_Search.setPressedIcon(new ImageIcon(this.getClass().getResource("/LanguageTools/EditPackage/IconPressed.png")));
        this.jButton_Search.setVerticalTextPosition(3);
        this.jButton_Search.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveLanguageEditFrame.this.jButton_SearchActionPerformed(evt);
            }
        });
        this.jToolBar3.add(this.jButton_Search);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanelEditLanguageFile.add((Component)this.jToolBar3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jPanelEditLanguageFile, gridBagConstraints);
        this.pack();
    }

    private void jButton_AddLanguageActionPerformed(ActionEvent evt) {
        LiveLanguageFlagModel.LanguageFlagItem o_FlagItem = (LiveLanguageFlagModel.LanguageFlagItem)this.jComboBox_Language1.getSelectedItem();
        if (o_FlagItem == null) {
            return;
        }
        Locale o_Locale = o_FlagItem.getLocale();
        if (o_Locale == null) {
            return;
        }
        this.m_Table.getModel().addLanguage(o_Locale);
    }

    public void setLanguageFile(File p_File) {
        if (this.m_Table.getModel().getHasChanged() && this.showOptionSave()) {
            this.m_Table.getModel().saveLanguages();
        }
        this.setControlsEnabled(false);
        this.setEditRowEnable(false);
        if (this.m_Table.getModel().setLanguageFile(p_File)) {
            this.setControlsEnabled(true);
            this.setTitle(this.m_Table.getModel().getLanguageDefaultFile().getPath());
        } else {
            this.setTitle("");
        }
    }

    private void setControlsEnabled(boolean p_Enabled) {
        this.jButton_Load.setEnabled(true);
        this.jButton_Help.setEnabled(true);
        this.jButton_Save.setEnabled(p_Enabled);
        this.jButton_RowZoomPlus.setEnabled(p_Enabled);
        this.jButton_RowZoomMinus.setEnabled(p_Enabled);
        this.jButton_DeleteLanguage.setEnabled(p_Enabled);
        this.jButton_AddLanguage.setEnabled(p_Enabled);
        this.jButton_RemoveLanguage.setEnabled(p_Enabled);
        this.jComboBox_Language1.setEnabled(p_Enabled);
    }

    private void jButton_RowAddAboveActionPerformed(ActionEvent evt) {
        this.m_Table.getModel().addRow(this.m_Table.getSelectedRow(), true);
    }

    private void jButton_RowDeleteActionPerformed(ActionEvent evt) {
        int intLine = this.m_Table.getSelectedRow();
        if (intLine < 0) {
            return;
        }
        int intAnswer = JOptionPane.showConfirmDialog(this, this.m_StringConfirmDeleteRowContent, this.m_StringConfirmDeleteRowHeader, 0);
        if (intAnswer == 0) {
            this.m_Table.getModel().deleteRow(intLine);
        }
    }

    private void jButton_LoadActionPerformed(ActionEvent evt) {
        File o_ActualDirectory = null;
        JFileChooser o_FileChooser = new JFileChooser("");
        o_FileChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.getName().contains(".lng")) {
                    return true;
                }
                return f.isDirectory();
            }

            @Override
            public String getDescription() {
                return "LanguageFile";
            }
        });
        if (this.m_Table.getModel().m_LanguageParentDirectory == null) {
            if (LiveLanguage.s_DefaultLanguageFolder != null) {
                o_ActualDirectory = new File(System.getProperty("user.dir"));
            }
        } else {
            o_ActualDirectory = this.m_Table.getModel().m_LanguageParentDirectory;
        }
        o_FileChooser.setCurrentDirectory(o_ActualDirectory);
        int returnVal = o_FileChooser.showOpenDialog(this);
        if (returnVal == 0) {
            File o_File = o_FileChooser.getSelectedFile();
            this.setLanguageFile(o_File);
        }
    }

    private void jButton_SaveActionPerformed(ActionEvent evt) {
        if (this.m_Table.getEditing()) {
            this.m_Table.cancelEditing();
        }
        this.m_Table.getModel().saveLanguages();
        LiveLanguage.selectLanguage(null);
    }

    private void jButton_RowUpActionPerformed(ActionEvent evt) {
        int intSelectedRow = this.m_Table.getSelectedRow();
        if (intSelectedRow < 0) {
            return;
        }
        if (intSelectedRow == 0) {
            return;
        }
        this.m_Table.getModel().moveRowUp(intSelectedRow);
        if (intSelectedRow == 0) {
            this.m_Table.getSelectionModel().setSelectionInterval(intSelectedRow, intSelectedRow);
        } else {
            this.m_Table.getSelectionModel().setSelectionInterval(intSelectedRow - 1, intSelectedRow - 1);
        }
    }

    private void jButton_RowDownActionPerformed(ActionEvent evt) {
        int intSelectedRow = this.m_Table.getSelectedRow();
        if (intSelectedRow < 0) {
            return;
        }
        if (intSelectedRow >= this.m_Table.getModel().getRowCount() - 1) {
            return;
        }
        this.m_Table.getModel().moveRowDown(intSelectedRow);
        if (intSelectedRow >= this.m_Table.getModel().getRowCount() - 1) {
            this.m_Table.getSelectionModel().setSelectionInterval(intSelectedRow, intSelectedRow);
        } else {
            this.m_Table.getSelectionModel().setSelectionInterval(intSelectedRow + 1, intSelectedRow + 1);
        }
    }

    private void jButton_RowAddBelowActionPerformed(ActionEvent evt) {
        this.m_Table.getModel().addRow(this.m_Table.getSelectedRow(), false);
    }

    private void jButton_RemoveLanguageActionPerformed(ActionEvent evt) {
        LiveLanguageFlagModel.LanguageFlagItem o_FlagItem = (LiveLanguageFlagModel.LanguageFlagItem)this.jComboBox_Language1.getSelectedItem();
        if (o_FlagItem == null) {
            return;
        }
        Locale o_Locale = o_FlagItem.getLocale();
        if (o_Locale == null) {
            return;
        }
        if (this.m_Table.getEditing()) {
            this.m_Table.cancelEditing();
        }
        if (this.m_Table.getModel().getHasChanged(o_Locale) && this.showOptionSave()) {
            this.m_Table.getModel().saveLanguageColumn(o_Locale);
        }
        this.m_Table.getModel().removeLanguage(o_Locale);
    }

    private void formWindowClosing(WindowEvent evt) {
        boolean boolModelChanged;
        if (this.m_Table.getEditing()) {
            this.m_Table.cancelEditing();
        }
        if ((boolModelChanged = this.m_Table.getModel().getHasChanged()) && this.showOptionSave()) {
            this.m_Table.getModel().saveLanguages();
        }
        LiveLanguage.removeLanguageListener(this);
        System.exit(0);
    }

    private void removeQuotes() {
        LiveLanguageEditTableModel o_Model = this.m_Table.getModel();
        for (int intRow = 0; intRow < o_Model.getRowCount(); ++intRow) {
            for (int intCol = 0; intCol < o_Model.getColumnCount(); ++intCol) {
                String stringValue = (String)o_Model.getValueAt(intRow, intCol);
                if (stringValue == null || stringValue.length() <= 0) continue;
                int intFirstIndex = stringValue.startsWith("\"") ? 1 : 0;
                int intLastIndex = stringValue.lastIndexOf("\"");
                if (intLastIndex < 0) {
                    intLastIndex = stringValue.length();
                }
                if (intFirstIndex <= 0 && intLastIndex >= stringValue.length()) continue;
                String stringNewValue = stringValue.substring(intFirstIndex, intLastIndex);
                o_Model.setValueAt(stringNewValue, intRow, intCol);
            }
        }
        o_Model.fireTableDataChanged();
    }

    private void jButton_SearchActionPerformed(ActionEvent evt) {
        this.search();
    }

    private void jTextField_SearchKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.search();
        } else {
            this.m_FirstSearchRow = 0;
        }
    }

    private void jButton_RowZoomPlusActionPerformed(ActionEvent evt) {
        int intRowHeight = this.m_Table.getRowHeight();
        this.m_Table.setRowHeight(intRowHeight += 7);
        this.showSelectedRow();
    }

    private void jButton_RowZoomMinusActionPerformed(ActionEvent evt) {
        int intRowHeight = this.m_Table.getRowHeight();
        if ((intRowHeight -= 7) < this.m_Table.getFont().getSize() + 4) {
            intRowHeight = this.m_Table.getFont().getSize() + 4;
        }
        this.m_Table.setRowHeight(intRowHeight);
        this.showSelectedRow();
    }

    private void jButton_HelpActionPerformed(ActionEvent evt) {
        if (this.m_Frame_Help == null) {
            this.m_Frame_Help = new LiveLanguageFrame_Help();
        }
        this.m_Frame_Help.setFileBase("LiveLanguageHelp");
        this.m_Frame_Help.setVisible(true);
    }

    private void jButton_DeleteLanguageActionPerformed(ActionEvent evt) {
        LiveLanguageFlagModel.LanguageFlagItem o_FlagItem = (LiveLanguageFlagModel.LanguageFlagItem)this.jComboBox_Language1.getSelectedItem();
        if (o_FlagItem == null) {
            return;
        }
        Locale o_Locale = o_FlagItem.getLocale();
        if (o_Locale == null) {
            return;
        }
        if (!this.showOptionDelete(o_FlagItem)) {
            return;
        }
        if (this.m_Table.getEditing()) {
            this.m_Table.cancelEditing();
        }
        this.m_Table.getModel().deleteLanguage(o_Locale);
    }

    public boolean showOptionDelete(LiveLanguageFlagModel.LanguageFlagItem p_FlagItem) {
        if (p_FlagItem == null) {
            return false;
        }
        int intAnswer = JOptionPane.showConfirmDialog(this, this.m_StringConfirmSafeOnCloseContent, this.m_StringConfirmSafeOnCloseHeader + p_FlagItem.getDisplayLanguage(), 0);
        return intAnswer == 0;
    }

    public boolean showOptionSave() {
        int intAnswer = JOptionPane.showConfirmDialog(this, this.m_StringConfirmSafeOnCloseContent, this.m_StringConfirmSafeOnCloseHeader, 0);
        return intAnswer == 0;
    }

    private void search() {
        int intRow;
        String stringSearch = this.jTextField_Search.getText();
        if (stringSearch.length() <= 0) {
            return;
        }
        boolean boolFound = false;
        LiveLanguageEditTableModel o_Model = this.m_Table.getModel();
        if (this.m_FirstSearchRow >= o_Model.getRowCount()) {
            this.m_FirstSearchRow = 0;
        }
        for (intRow = this.m_FirstSearchRow; intRow < o_Model.getRowCount(); ++intRow) {
            for (int intCol = 0; intCol < o_Model.getColumnCount(); ++intCol) {
                String stringContent = (String)o_Model.getValueAt(intRow, intCol);
                if (stringContent == null || stringContent.length() <= 0 || !stringContent.toLowerCase().contains(stringSearch.toLowerCase())) continue;
                boolFound = true;
                break;
            }
            if (boolFound) break;
        }
        if (!boolFound) {
            this.m_FirstSearchRow = 0;
            return;
        }
        this.m_FirstSearchRow = intRow + 1;
        int intIndex = this.m_Table.convertRowIndexToView(intRow);
        this.m_Table.setRowSelectionInterval(intIndex, intIndex);
        this.showSelectedRow();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.jComboBox_Language1) {
            LiveLanguageFlagModel.LanguageFlagItem o_FlagItem = (LiveLanguageFlagModel.LanguageFlagItem)this.jComboBox_Language1.getSelectedItem();
            if (o_FlagItem == null) {
                return;
            }
            Locale o_Locale = o_FlagItem.getLocale();
            if (o_Locale == null) {
                return;
            }
            LiveLanguage.selectLanguage(o_Locale);
            this.applyComponentOrientation(LiveLangageLocaleHandling.getComponentOrientation(o_Locale));
            this.m_Table.setComponentOrientation(LiveLangageLocaleHandling.getComponentOrientation(o_Locale));
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getSource() == this.m_Table.getSelectionModel()) {
            int intSelectedIndex = this.m_Table.getSelectedRow();
            if (intSelectedIndex < 0) {
                this.setEditRowEnable(false);
            } else {
                this.setEditRowEnable(true);
            }
            return;
        }
    }

    private void setEditRowEnable(boolean p_Enabled) {
        this.jButton_RowUp.setEnabled(p_Enabled);
        this.jButton_RowDown.setEnabled(p_Enabled);
        this.jButton_RowAddAbove.setEnabled(p_Enabled);
        this.jButton_RowAddBelow.setEnabled(p_Enabled);
        this.jButton_RowAddAbove.setEnabled(p_Enabled);
        this.jButton_RowDelete.setEnabled(p_Enabled);
    }

    public String languageGetFileNameBasis() {
        return "LiveLanguageEditFrame";
    }

    @Override
    public void eventLanguageChanged(Locale p_OldLanguage, Locale p_SelectedLanguage) {
    }
}

