/*
 * Decompiled with CFR 0.152.
 */
package LanguageTools.HelpPackage;

import LanguageTools.LiveLanguagePackage.LiveLanguage;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.InternalFrameEvent;
import javax.swing.text.html.HTMLEditorKit;

public class LiveLanguageFrame_Help
extends JFrame
implements HyperlinkListener,
WindowFocusListener {
    public static String HELPFILE_PATH = "Help";
    public static final int FLAG_TUTORIAL = 0;
    public static final int FLAG_CONTEXT = 3;
    public static final int FLAG_ABOUT = 4;
    private int m_HelpFlag;
    private boolean m_HelpFlagChanged;
    private ArrayList<URL> m_Urls;
    private int m_URLIndex;
    private Object m_ActualFocusObject;
    private Object m_NewFocusObject;
    private JButton jButton_About;
    private JButton jButton_Back;
    private JButton jButton_Next;
    private JEditorPane jEditorPane_Help;
    private JPanel jPanel_Content;
    private JScrollPane jScrollPane1;

    public LiveLanguageFrame_Help() {
        this.initMembers();
        this.initComponents();
        this.initComponentsFurther();
        this.refresh();
        this.refreshButtons();
    }

    private void initMembers() {
        this.m_ActualFocusObject = null;
        this.m_NewFocusObject = null;
        this.m_HelpFlag = -1;
        this.m_HelpFlagChanged = true;
        this.m_Urls = new ArrayList();
        this.m_URLIndex = -1;
    }

    private void initComponents() {
        this.jPanel_Content = new JPanel();
        this.jButton_Back = new JButton();
        this.jButton_Next = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jEditorPane_Help = new JEditorPane();
        this.jButton_About = new JButton();
        this.setTitle("Help");
        this.setBackground(new Color(51, 51, 51));
        this.setPreferredSize(new Dimension(600, 400));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent evt) {
                LiveLanguageFrame_Help.this.formComponentShown(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.jPanel_Content.setBackground(new Color(0, 0, 0));
        this.jPanel_Content.setLayout(new GridBagLayout());
        this.jButton_Back.setIcon(new ImageIcon(this.getClass().getResource("/LanguageTools/HelpPackage/Icon_Document_Back_32.png")));
        this.jButton_Back.setToolTipText("");
        this.jButton_Back.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jButton_Back.setBorderPainted(false);
        this.jButton_Back.setContentAreaFilled(false);
        this.jButton_Back.setMargin(new Insets(-1, -1, -1, -1));
        this.jButton_Back.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveLanguageFrame_Help.this.jButton_BackActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Content.add((Component)this.jButton_Back, gridBagConstraints);
        this.jButton_Next.setIcon(new ImageIcon(this.getClass().getResource("/LanguageTools/HelpPackage/Icon_Document_Next_32.png")));
        this.jButton_Next.setToolTipText("");
        this.jButton_Next.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jButton_Next.setBorderPainted(false);
        this.jButton_Next.setContentAreaFilled(false);
        this.jButton_Next.setMargin(new Insets(-1, -1, -1, -1));
        this.jButton_Next.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveLanguageFrame_Help.this.jButton_NextActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Content.add((Component)this.jButton_Next, gridBagConstraints);
        this.jEditorPane_Help.setBackground(new Color(204, 204, 204));
        this.jScrollPane1.setViewportView(this.jEditorPane_Help);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel_Content.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jButton_About.setIcon(new ImageIcon(this.getClass().getResource("/LanguageTools/HelpPackage/Icon_Document.png")));
        this.jButton_About.setToolTipText("");
        this.jButton_About.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jButton_About.setBorderPainted(false);
        this.jButton_About.setContentAreaFilled(false);
        this.jButton_About.setMargin(new Insets(-1, -1, -1, -1));
        this.jButton_About.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LiveLanguageFrame_Help.this.jButton_AboutActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Content.add((Component)this.jButton_About, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jPanel_Content, gridBagConstraints);
        this.pack();
    }

    private void formComponentShown(ComponentEvent evt) {
        this.refresh();
    }

    private void jButton_BackActionPerformed(ActionEvent evt) {
        if (this.m_URLIndex > 0 && this.m_URLIndex < this.m_Urls.size()) {
            --this.m_URLIndex;
            URL o_Url = this.m_Urls.get(this.m_URLIndex);
            this.setURL(o_Url, false);
        }
        this.refreshButtons();
    }

    private void jButton_NextActionPerformed(ActionEvent evt) {
        if (this.m_URLIndex < this.m_Urls.size() - 1 && this.m_URLIndex >= 0) {
            ++this.m_URLIndex;
            URL o_Url = this.m_Urls.get(this.m_URLIndex);
            this.setURL(o_Url, false);
        }
        this.refreshButtons();
    }

    private void jButton_AboutActionPerformed(ActionEvent evt) {
        this.setFileBase("_About");
    }

    private void initComponentsFurther() {
        ImageIcon o_ImageIcon = new ImageIcon(this.getClass().getResource("/LanguageTools/HelpPackage/IconHelp.png"));
        this.setIconImage(o_ImageIcon.getImage());
        HTMLEditorKit o_HTMLEditorKit = new HTMLEditorKit();
        this.jEditorPane_Help.setEditorKit(o_HTMLEditorKit);
        this.jEditorPane_Help.setContentType("text/html");
        this.jEditorPane_Help.addHyperlinkListener(this);
    }

    public void setActualFocus(Object p_FocusObject) {
        this.m_NewFocusObject = p_FocusObject;
        if (this.isVisible()) {
            this.refresh();
        }
    }

    public void setHelpFlag(int p_HelpFlag) {
        if (p_HelpFlag < 0) {
            return;
        }
        if (p_HelpFlag > 4) {
            return;
        }
        if (this.m_HelpFlag == p_HelpFlag) {
            return;
        }
        this.m_HelpFlag = p_HelpFlag;
        this.m_HelpFlagChanged = true;
        this.refresh();
    }

    private void refresh() {
        switch (this.m_HelpFlag) {
            case 0: {
                if (!this.m_HelpFlagChanged) {
                    return;
                }
                this.setFileBase("_Tutorial");
                break;
            }
            case 3: {
                this.refreshContext();
                break;
            }
            case 4: {
                if (!this.m_HelpFlagChanged) {
                    return;
                }
                this.setFileBase("_About");
            }
        }
        this.m_HelpFlagChanged = false;
    }

    private void refreshContext() {
        if (this.m_ActualFocusObject == this.m_NewFocusObject && this.m_NewFocusObject != null) {
            return;
        }
        if (this.m_NewFocusObject instanceof LiveLanguageFrame_Help) {
            return;
        }
        String stringFileBaseName = null;
        if (this.m_NewFocusObject == null) {
            stringFileBaseName = "HelpContext";
        }
        this.m_ActualFocusObject = this.m_NewFocusObject;
        if (stringFileBaseName == null) {
            return;
        }
        this.setFileBase(stringFileBaseName);
    }

    private void refreshButtons() {
        if (this.m_URLIndex > 0) {
            this.jButton_Back.setEnabled(true);
        } else {
            this.jButton_Back.setEnabled(false);
        }
        if (this.m_URLIndex < this.m_Urls.size() - 1) {
            this.jButton_Next.setEnabled(true);
        } else {
            this.jButton_Next.setEnabled(false);
        }
    }

    public void setFileBase(String p_FileBase) {
        String stringLanguage = LiveLanguage.getLanguage(LiveLanguage.getLocaleActual());
        File o_File = new File(HELPFILE_PATH + "/" + HELPFILE_PATH + "_" + stringLanguage + "/" + p_FileBase + ".html");
        if (!o_File.exists()) {
            o_File = new File(HELPFILE_PATH + "/" + HELPFILE_PATH + "/" + p_FileBase + ".html");
        }
        try {
            URL o_Url = o_File.toURI().toURL();
            this.setURL(o_Url, true);
        }
        catch (Exception urlException) {
            boolean bl = false;
        }
    }

    public void setURL(URL p_Url, boolean p_New) {
        URL o_Url = null;
        if (p_Url == null) {
            try {
                File o_File = new File("Help/_About.html");
                o_Url = o_File.toURI().toURL();
            }
            catch (Exception exception) {}
        } else {
            o_Url = p_Url;
        }
        if (o_Url == null) {
            return;
        }
        try {
            this.jEditorPane_Help.setEditable(false);
            this.jEditorPane_Help.setPage(o_Url);
            if (this.m_Urls.size() > 0) {
                if (this.m_Urls.get(this.m_Urls.size() - 1).equals(o_Url)) {
                    return;
                }
                if (p_New) {
                    for (int intUrl = this.m_Urls.size() - 1; intUrl > this.m_URLIndex; --intUrl) {
                        this.m_Urls.remove(intUrl);
                    }
                }
            }
            if (p_New) {
                this.m_Urls.add(o_Url);
                this.m_URLIndex = this.m_Urls.size() - 1;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.refreshButtons();
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            this.setURL(e.getURL(), true);
        }
    }

    @Override
    public void windowGainedFocus(final WindowEvent e) {
        Runnable o_Runnable = new Runnable(){

            @Override
            public void run() {
                LiveLanguageFrame_Help.this.setActualFocus(e.getSource());
            }
        };
        EventQueue.invokeLater(o_Runnable);
    }

    @Override
    public void windowLostFocus(WindowEvent e) {
    }

    public void frameActivated(final InternalFrameEvent e) {
        Runnable o_Runnable = new Runnable(){

            @Override
            public void run() {
                LiveLanguageFrame_Help.this.setActualFocus(e.getSource());
            }
        };
        EventQueue.invokeLater(o_Runnable);
    }
}

