/*
 * Decompiled with CFR 0.152.
 */
package SPITClientGUI;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.event.MouseInputListener;

public class JLabel_ResizeFrame
extends JLabel
implements ComponentListener,
MouseInputListener {
    public static Dimension SIZE = new Dimension(32, 32);
    private Container m_Container;
    private Rectangle m_ContainerBounds;
    private Point m_MouseClickPoint;

    public JLabel_ResizeFrame() {
        this.initMembers();
        this.initComponents();
    }

    public JLabel_ResizeFrame(Container p_Container) {
        this();
        this.setContainer(p_Container);
    }

    private void initMembers() {
        this.m_ContainerBounds = new Rectangle();
        this.m_MouseClickPoint = new Point();
    }

    private void initComponents() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/ResizeFrame.png")));
        this.setCursor(Cursor.getPredefinedCursor(5));
        this.setMinimumSize(SIZE);
        this.setMaximumSize(SIZE);
        this.setPreferredSize(SIZE);
    }

    public void setContainer(Container p_Container) {
        if (this.m_Container != null) {
            this.m_Container.removeComponentListener(this);
        }
        this.m_Container = p_Container;
        if (this.m_Container != null) {
            this.m_ContainerBounds.height = this.m_Container.getHeight();
            this.m_ContainerBounds.width = this.m_Container.getWidth();
            this.m_ContainerBounds.x = this.m_Container.getX();
            this.m_ContainerBounds.y = this.m_Container.getY();
            this.m_Container.addComponentListener(this);
        }
    }

    @Override
    public void componentResized(ComponentEvent e) {
        Component o_Component = e.getComponent();
        this.m_ContainerBounds.height = o_Component.getHeight();
        this.m_ContainerBounds.width = o_Component.getWidth();
        this.m_ContainerBounds.x = o_Component.getX();
        this.m_ContainerBounds.y = o_Component.getY();
    }

    @Override
    public void componentMoved(ComponentEvent e) {
        Component o_Component = e.getComponent();
        this.m_ContainerBounds.x = o_Component.getX();
        this.m_ContainerBounds.y = o_Component.getY();
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.m_Container == null) {
            return;
        }
        this.m_MouseClickPoint.x = e.getX();
        this.m_MouseClickPoint.y = e.getY();
        this.m_ContainerBounds.height = this.m_Container.getHeight();
        this.m_ContainerBounds.width = this.m_Container.getWidth();
        this.m_ContainerBounds.x = this.m_Container.getX();
        this.m_ContainerBounds.y = this.m_Container.getY();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.setCursor(Cursor.getPredefinedCursor(5));
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.m_Container == null) {
            return;
        }
        try {
            Thread.sleep(20L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        int intX = e.getX();
        int intY = e.getY();
        Dimension o_MinDimension = this.m_Container.getMinimumSize();
        int intNewHeight = this.m_ContainerBounds.height + intY - this.m_MouseClickPoint.y;
        int intNewWidth = this.m_ContainerBounds.width + intX - this.m_MouseClickPoint.x;
        if (intNewHeight < o_MinDimension.height) {
            intNewHeight = o_MinDimension.height;
        }
        if (intNewWidth < o_MinDimension.width) {
            intNewWidth = o_MinDimension.width;
        }
        this.m_ContainerBounds.height = intNewHeight;
        this.m_ContainerBounds.width = intNewWidth;
        this.m_Container.setBounds(this.m_ContainerBounds);
        this.m_Container.revalidate();
        this.m_Container.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }
}

