/*
 * Decompiled with CFR 0.152.
 */
package RXTX_Package;

import CommListModelPackage.ListModel_SerialPorts;
import LANPackage.LANServer;
import RXTX_Package.RXTX_Connection;
import RXTX_Package.RXTX_Device;
import SwingModelPackage.SinglePropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.DatagramPacket;
import java.net.InetAddress;

public class RXTX_Connection_LANDevice
extends RXTX_Connection {
    public static final int SOFTWAREVERSION = 1;
    public static final int REACHABLE_TIMEOUT = 3000;
    public static ListModel_SerialPorts s_ListModel_SerialPorts = new ListModel_SerialPorts();
    private static final String PARAM_DIVIDER = ";";
    private int COMM_BAUDRATE = 9600;
    public static int CONNECTION_NONE = 0;
    public static int CONNECTION_CONNECTED = 1;
    private InetAddress m_InetAddress;
    private int m_Port;
    private String m_HostName;
    private int m_MessageNumber_Send;
    private int m_MessageNumber_Received;
    private final Object m_SyncMessageNumber = new Object();
    private final Object m_SyncConnection = new Object();

    public RXTX_Connection_LANDevice(RXTX_Device p_RXTX_Device) {
        super(p_RXTX_Device);
        this.initMembers();
        if (p_RXTX_Device != null) {
            p_RXTX_Device.setRXTX_Connection(this);
        }
    }

    private void initMembers() {
        this.m_InetAddress = null;
        this.m_HostName = "";
        this.m_Port = 0;
        this.m_SinglePropertyChangeSupport = new SinglePropertyChangeSupport(this);
        this.m_MessageNumber_Send = 1;
        this.m_MessageNumber_Received = -1;
    }

    public void setPort(int p_Port) {
        this.m_Port = p_Port;
    }

    public int getPort() {
        return this.m_Port;
    }

    public boolean setInetAddress(String p_Name) {
        if (p_Name == null || p_Name.length() <= 0) {
            this.m_InetAddress = null;
            return false;
        }
        try {
            InetAddress o_InetAddress;
            this.m_InetAddress = o_InetAddress = InetAddress.getByName(p_Name);
        }
        catch (Exception e) {
            this.m_InetAddress = null;
        }
        return this.m_InetAddress != null;
    }

    public InetAddress getInetAddress() {
        return this.m_InetAddress;
    }

    @Override
    public boolean connect() {
        LANServer.s_SelfReference.removeRXTX_Connection_LANDevice(this);
        this.m_RXTX_Device.eventConnectionStatus(CONNECTION_NONE);
        if (this.m_InetAddress == null) {
            return false;
        }
        if (!RXTX_Connection_LANDevice.isReachable(this.m_InetAddress.getHostAddress(), this.m_Port)) {
            return false;
        }
        this.m_HostName = this.m_InetAddress.getHostName();
        LANServer.s_SelfReference.addRXTX_Connection_LANDevice(this);
        this.m_RXTX_Device.eventConnectionStatus(CONNECTION_CONNECTED);
        return true;
    }

    @Override
    public boolean disconnect() {
        this.m_HostName = "";
        LANServer.s_SelfReference.removeRXTX_Connection_LANDevice(this);
        this.m_RXTX_Device.eventConnectionStatus(CONNECTION_NONE);
        return true;
    }

    @Override
    public boolean getIsConnected() {
        return LANServer.s_SelfReference.containsRXTX_Connection_LANDevice(this);
    }

    public static boolean isReachable(String p_Address, int p_ClientPort) {
        InetAddress o_InetAddress;
        try {
            o_InetAddress = InetAddress.getByName(p_Address);
        }
        catch (Exception e) {
            return false;
        }
        String stringHostName = o_InetAddress.getHostName();
        return true;
    }

    public void eventLANDataReceived(DatagramPacket p_DatagramPacket) {
        if (p_DatagramPacket == null) {
            return;
        }
        if (this.m_RXTX_Device != null) {
            this.m_RXTX_Device.eventDataReceived(p_DatagramPacket.getData(), p_DatagramPacket.getLength());
        }
    }

    @Override
    public String getConnectionString() {
        if (this.m_InetAddress == null) {
            return "-";
        }
        StringBuilder o_StringBuilder = new StringBuilder();
        o_StringBuilder.append(this.m_HostName);
        o_StringBuilder.append(" ");
        o_StringBuilder.append(this.m_InetAddress.getHostAddress());
        o_StringBuilder.append(" (");
        o_StringBuilder.append(this.m_Port);
        o_StringBuilder.append(")");
        return o_StringBuilder.toString();
    }

    @Override
    public boolean sendMessage(byte[] p_MessageBytes, int p_DataLenght) {
        return LANServer.sendMessage(this, p_MessageBytes, p_DataLenght);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(1);
        if (this.m_InetAddress == null) {
            out.writeUTF("");
        } else {
            out.writeUTF(this.m_InetAddress.getHostAddress());
        }
        out.writeInt(this.m_Port);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int intSoftwareVersion = in.readInt();
        String stringInetAddress = in.readUTF();
        this.m_Port = in.readInt();
        this.setInetAddress(stringInetAddress);
    }
}

