/*
 * Decompiled with CFR 0.152.
 */
package RXTX_Package;

import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LanguageTools.LiveLanguagePackage.LiveLanguageString;
import RXTX_Package.RXTX_Device;
import SwingModelPackage.SinglePropertyChangeSupport;
import SwingModelPackage.TableAndListModel;
import SwingTextPackage.TextComparator;
import SwingToolTipPackage.PopUpToolTip;
import java.beans.PropertyChangeListener;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.charset.Charset;
import java.util.ArrayList;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;

public class RXTXMessageObject
implements RXTX_Device.RXTXMessageListener,
Externalizable {
    public static final int SOFTWAREVERSION = 1;
    public static final String PROP_CHANGED = "propChanged";
    public static Charset s_Charset = Charset.forName("ISO-8859-15");
    public static String RXTXMESSAGECOMMAND_STRINGDIVIDER = " - ";
    private RXTXMessageCommandTableModel m_RXTXMessageCommandTableModel;
    private boolean m_IsLeraning;
    private final Object m_SyncMessageStrings = new Object();
    private SinglePropertyChangeSupport m_SinglePropertyChangeSupport;
    private StringBuilder m_StringBuilder = new StringBuilder();

    public RXTXMessageObject() {
        LiveLanguage.addLanguageListener((Object)this, null);
        this.initMembers();
    }

    private void initMembers() {
        this.m_SinglePropertyChangeSupport = new SinglePropertyChangeSupport(this);
        this.m_RXTXMessageCommandTableModel = new RXTXMessageCommandTableModel();
        this.m_IsLeraning = false;
    }

    public void close() {
        if (this.m_RXTXMessageCommandTableModel != null) {
            // empty if block
        }
    }

    public RXTXMessageCommandTableModel getRXTXMessageCommandTableModel() {
        return this.m_RXTXMessageCommandTableModel;
    }

    public void setVisible_UseValue(boolean p_Visible_UseValue) {
        this.m_RXTXMessageCommandTableModel.setVisible_UseValue(p_Visible_UseValue);
    }

    public boolean addRXTXMessageCommand(byte[] p_CommandBytes, int p_DataLenght, boolean p_UseValue) {
        if (p_CommandBytes == null || p_DataLenght <= 0) {
            return false;
        }
        if (this.m_RXTXMessageCommandTableModel.getCommand(p_CommandBytes, p_DataLenght) != null) {
            return false;
        }
        RXTXMessageCommand o_RXTXMessageCommand = new RXTXMessageCommand();
        o_RXTXMessageCommand.setCommand(p_CommandBytes, p_DataLenght);
        o_RXTXMessageCommand.setUseValue(p_UseValue);
        return this.addRXTXMessageCommand(o_RXTXMessageCommand);
    }

    public boolean addRXTXMessageCommand(RXTXMessageCommand p_RXTXMessageCommand) {
        boolean boolAdded = false;
        if (this.m_RXTXMessageCommandTableModel.getCommand(p_RXTXMessageCommand.getCommandBytes(), p_RXTXMessageCommand.getCommandLength()) != null) {
            return false;
        }
        boolAdded = this.m_RXTXMessageCommandTableModel.addCommand(p_RXTXMessageCommand);
        if (boolAdded) {
            this.notifyChanged();
        }
        return boolAdded;
    }

    public boolean removeRXTXMessageCommand(RXTXMessageCommand p_RXTXMessageCommand) {
        if (p_RXTXMessageCommand == null) {
            return false;
        }
        boolean boolRemoved = this.m_RXTXMessageCommandTableModel.removeCommand(p_RXTXMessageCommand);
        if (boolRemoved) {
            this.notifyChanged();
        }
        return boolRemoved;
    }

    public int getRXTXMessageCommandCount() {
        return this.m_RXTXMessageCommandTableModel.size();
    }

    public RXTXMessageCommand getRXTXMessageCommand(int p_Index) {
        if (p_Index < 0) {
            return null;
        }
        return (RXTXMessageCommand)this.m_RXTXMessageCommandTableModel.get(p_Index);
    }

    public boolean containsRXTXMessageCommand(byte[] p_CommandBytes, int p_DataLength) {
        RXTXMessageCommand o_RXTXMessageCommand = this.m_RXTXMessageCommandTableModel.getCommand(p_CommandBytes, p_DataLength);
        return o_RXTXMessageCommand != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getStringRepresentation() {
        if (this.m_RXTXMessageCommandTableModel.size() <= 0) {
            return "";
        }
        this.m_StringBuilder.delete(0, this.m_StringBuilder.length());
        Object object = this.m_SyncMessageStrings;
        synchronized (object) {
            for (int intMessageCommand = 0; intMessageCommand < this.m_RXTXMessageCommandTableModel.size(); ++intMessageCommand) {
                RXTXMessageCommand o_RXTXMessageCommand = (RXTXMessageCommand)this.m_RXTXMessageCommandTableModel.get(intMessageCommand);
                if (o_RXTXMessageCommand == null) continue;
                switch (RXTXMessageCommandTableModel.s_RenderType) {
                    case 0: {
                        this.m_StringBuilder.append(o_RXTXMessageCommand.getString_Text());
                        break;
                    }
                    case 1: {
                        this.m_StringBuilder.append(o_RXTXMessageCommand.getString_Bytes());
                        break;
                    }
                    default: {
                        this.m_StringBuilder.append(o_RXTXMessageCommand.getString_Bytes());
                    }
                }
                if (intMessageCommand >= this.m_RXTXMessageCommandTableModel.size() - 1) continue;
                this.m_StringBuilder.append(RXTXMESSAGECOMMAND_STRINGDIVIDER);
            }
        }
        return this.m_StringBuilder.toString();
    }

    public String getToolTipText() {
        return this.getStringRepresentation();
    }

    public boolean isSet() {
        return this.m_RXTXMessageCommandTableModel.size() > 0;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        if (out == null) {
            return;
        }
        out.writeInt(1);
        int intCommandCount = this.getRXTXMessageCommandCount();
        out.writeInt(intCommandCount);
        for (int intCommand = 0; intCommand < intCommandCount; ++intCommand) {
            RXTXMessageCommand o_RXTXMessageCommand = this.getRXTXMessageCommand(intCommand);
            if (o_RXTXMessageCommand == null) continue;
            o_RXTXMessageCommand.writeExternal(out);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int intSoftwareVersion = in.readInt();
        int intCommandCount = in.readInt();
        for (int intCommand = 0; intCommand < intCommandCount; ++intCommand) {
            RXTXMessageCommand o_Command = new RXTXMessageCommand();
            o_Command.readExternal(in);
            this.addRXTXMessageCommand(o_Command);
        }
    }

    public void setLearning(boolean p_IsLearning) {
        this.m_IsLeraning = p_IsLearning;
    }

    public boolean getLearning() {
        return this.m_IsLeraning;
    }

    @Override
    public void eventMessageReceived(RXTX_Device p_RXTX_Device, byte[] p_CommandBytes, int p_DataLenght) {
        if (!this.m_IsLeraning) {
            return;
        }
        this.addRXTXMessageCommand(p_CommandBytes, p_DataLenght, false);
    }

    public void addPropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
        if (p_PropertyChangeListener == null) {
            return;
        }
        this.m_SinglePropertyChangeSupport.addPropertyChangeListener(p_PropertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
        if (p_PropertyChangeListener == null) {
            return;
        }
        this.m_SinglePropertyChangeSupport.removePropertyChangeListener(p_PropertyChangeListener);
    }

    protected void notifyChanged() {
        this.m_SinglePropertyChangeSupport.firePropertyChange(PROP_CHANGED, null, this);
    }

    public static byte[] getBytesFromString(String p_ByteString, boolean p_ShowBytes) throws NumberFormatException {
        if (p_ByteString == null || p_ByteString.length() <= 0) {
            return new byte[0];
        }
        String[] o_StringArray = (p_ByteString = p_ByteString.trim()).split(" ");
        if (o_StringArray.length <= 0) {
            return new byte[0];
        }
        ArrayList<Byte> o_Bytes = new ArrayList<Byte>(o_StringArray.length);
        for (int intElement = 0; intElement < o_StringArray.length; ++intElement) {
            Byte o_Byte;
            String stringElement = o_StringArray[intElement];
            if (stringElement.length() <= 0) continue;
            if (p_ShowBytes) {
                try {
                    o_Byte = RXTXMessageObject.getByteFromString(stringElement);
                }
                catch (Exception e) {
                    o_Byte = 0;
                }
            } else {
                try {
                    o_Byte = (byte)(Integer.parseInt(stringElement) & 0xFF);
                }
                catch (Exception e) {
                    o_Byte = 0;
                }
            }
            o_Bytes.add(o_Byte);
        }
        byte[] o_ResultBytes = new byte[o_Bytes.size()];
        for (int intByte = 0; intByte < o_Bytes.size(); ++intByte) {
            o_ResultBytes[intByte] = (Byte)o_Bytes.get(intByte);
        }
        return o_ResultBytes;
    }

    public static byte getByteFromString(String p_ByteString) throws NumberFormatException {
        try {
            int intResult = Integer.parseInt(p_ByteString, 16);
            return (byte)(intResult & 0xFF);
        }
        catch (Exception e) {
            throw new NumberFormatException("Not a byte: " + p_ByteString);
        }
    }

    public static String getStringFromByteArray(byte[] p_Bytes, int p_Length, boolean p_ShowBytes) {
        if (p_Bytes == null || p_Bytes.length <= 0 || p_Length <= 0) {
            return "";
        }
        StringBuilder o_StringBuilder = new StringBuilder();
        if (p_Length > p_Bytes.length) {
            p_Length = p_Bytes.length;
        }
        for (int intByte = 0; intByte < p_Length; ++intByte) {
            byte o_Byte = p_Bytes[intByte];
            if (p_ShowBytes) {
                try {
                    o_StringBuilder.append(String.format("%02X", o_Byte));
                }
                catch (Exception e) {
                    o_StringBuilder.append("00");
                }
            } else {
                try {
                    o_StringBuilder.append(String.valueOf(o_Byte & 0xFF));
                }
                catch (Exception e) {
                    o_StringBuilder.append("00");
                }
            }
            if (intByte >= p_Bytes.length - 1) continue;
            o_StringBuilder.append(" ");
        }
        return o_StringBuilder.toString();
    }

    public static class RXTXMessageCommandTableModel
    extends TableAndListModel<RXTXMessageCommand> {
        public static final int COLUMCOUNT = 2;
        public static final int COLUMN_COMMAND = 0;
        public static final int COLUMN_USEVALUE = 1;
        public static final int COLUMN_USEVALUE_WIDTH = 64;
        @LiveLanguageString
        public static String COLUMN_COMMAND_NAME = "Commands";
        @LiveLanguageString
        public static String COLUMN_USEVALUE_NAME = "value";
        @LiveLanguageString
        public static String TOOLTIP_COLUMN_USEVALUE = "append actual value of trigger to command";
        public static final int RENDERTYPE_TEXT = 0;
        public static final int RENDERTYPE_BYTES = 1;
        public static int s_RenderType = 0;
        private TableColumnModel o_TableColumnModel;
        private boolean m_VisisbleUseValue;
        private TableRowSorter m_TableRowSorter;

        public static void setRenderType(int p_RenderType) {
            if (p_RenderType != 0 && p_RenderType != 1) {
                return;
            }
            s_RenderType = p_RenderType;
        }

        public RXTXMessageCommandTableModel() {
            super(false);
            this.initMembers();
            LiveLanguage.addLanguageListener((Object)this, (String)"SPIT_RXTX");
        }

        private void initMembers() {
            this.o_TableColumnModel = null;
            this.m_TableRowSorter = new TableRowSorter<RXTXMessageCommandTableModel>(this);
            this.m_VisisbleUseValue = false;
        }

        public void finishJTable(JTable p_JTable) {
            if (p_JTable == null) {
                return;
            }
            this.m_TableRowSorter.setComparator(0, new TextComparator.StringComparator_Normal());
            super.finishJTable(p_JTable, this.m_TableRowSorter, null);
            this.o_TableColumnModel = p_JTable.getColumnModel();
            TableColumn o_TableColumn = this.o_TableColumnModel.getColumn(0);
            if (o_TableColumn != null) {
                TableAndListModel.TableCellEditorRenderer_String o_TableCellEditorRenderer_String = new TableAndListModel.TableCellEditorRenderer_String();
                o_TableCellEditorRenderer_String.setToolTipText_Automatic(1);
                o_TableCellEditorRenderer_String.setToolTipTextAt(true, true);
                o_TableColumn.setCellEditor(o_TableCellEditorRenderer_String);
                o_TableColumn.setCellRenderer(o_TableCellEditorRenderer_String);
            }
            if ((o_TableColumn = this.o_TableColumnModel.getColumn(1)) != null) {
                TableAndListModel.TableCellEditorRenderer_CheckBox o_TableCellEditorRenderer_CheckBox = new TableAndListModel.TableCellEditorRenderer_CheckBox();
                o_TableCellEditorRenderer_CheckBox.setToolTipText(TOOLTIP_COLUMN_USEVALUE);
                o_TableCellEditorRenderer_CheckBox.setToolTipTextAt(true, true);
                o_TableColumn.setCellEditor(o_TableCellEditorRenderer_CheckBox);
                o_TableColumn.setCellRenderer(o_TableCellEditorRenderer_CheckBox);
                this.setVisible_UseValue(this.m_VisisbleUseValue);
            }
            p_JTable.setComponentPopupMenu(PopUpToolTip.getSelfReference());
        }

        public void setVisible_UseValue(boolean p_Visible_UseValue) {
            this.m_VisisbleUseValue = p_Visible_UseValue;
            if (this.o_TableColumnModel == null) {
                return;
            }
            TableColumn o_TableColumn = this.o_TableColumnModel.getColumn(1);
            if (o_TableColumn != null) {
                if (this.m_VisisbleUseValue) {
                    o_TableColumn.setMinWidth(64);
                    o_TableColumn.setMaxWidth(64);
                    o_TableColumn.setWidth(64);
                } else {
                    o_TableColumn.setMinWidth(0);
                    o_TableColumn.setMaxWidth(0);
                    o_TableColumn.setWidth(0);
                }
            }
        }

        public boolean addCommand(RXTXMessageCommand p_RXTXMessageCommand) {
            if (p_RXTXMessageCommand == null) {
                return false;
            }
            return super.addElement(p_RXTXMessageCommand);
        }

        public boolean removeCommand(RXTXMessageCommand p_RXTXMessageCommand) {
            if (p_RXTXMessageCommand == null) {
                return false;
            }
            return super.removeElement(p_RXTXMessageCommand);
        }

        public RXTXMessageCommand getCommand(byte[] p_CommandBytes, int p_Datalength) {
            if (p_CommandBytes == null || p_Datalength <= 0) {
                return null;
            }
            for (int intCommand = 0; intCommand < this.size(); ++intCommand) {
                int intCommandLegth;
                RXTXMessageCommand o_RXTXMessageCommand = (RXTXMessageCommand)this.getElementAt(intCommand);
                if (o_RXTXMessageCommand == null || p_Datalength != (intCommandLegth = o_RXTXMessageCommand.getCommandLength())) continue;
                byte[] arrayCommandBytes = o_RXTXMessageCommand.getCommandBytes();
                boolean boolEquals = true;
                for (int intByte = 0; intByte < p_Datalength; ++intByte) {
                    if (p_CommandBytes[intByte] == arrayCommandBytes[intByte]) continue;
                    boolEquals = false;
                    break;
                }
                if (!boolEquals) continue;
                return o_RXTXMessageCommand;
            }
            return null;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int p_ColumnModel) {
            switch (p_ColumnModel) {
                case 0: {
                    return COLUMN_COMMAND_NAME;
                }
                case 1: {
                    return COLUMN_USEVALUE_NAME;
                }
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int p_RowModel, int p_ColumnModel) {
            return true;
        }

        @Override
        public Object getValue(RXTXMessageCommand p_Element, int p_ColumnIndex) {
            if (p_Element == null) {
                return "";
            }
            switch (p_ColumnIndex) {
                case 0: {
                    switch (s_RenderType) {
                        case 0: {
                            return p_Element.getString_Text();
                        }
                        case 1: {
                            return p_Element.getString_Bytes();
                        }
                    }
                    break;
                }
                case 1: {
                    return p_Element.getUseValue();
                }
            }
            return "";
        }

        @Override
        public void setValue(RXTXMessageCommand p_Element, Object value, int p_ColumnIndex) {
            switch (p_ColumnIndex) {
                case 0: {
                    switch (s_RenderType) {
                        case 0: {
                            p_Element.setString_Text((String)value);
                            break;
                        }
                        case 1: {
                            p_Element.setString_Bytes((String)value);
                        }
                    }
                    break;
                }
                case 1: {
                    p_Element.setUseValue((Boolean)value);
                }
            }
        }
    }

    public static class RXTXMessageCommand
    implements Externalizable {
        public static final int SOFTWAREVERSION = 1;
        public static String s_ValueString = "0000000";
        public static final String NEWCOMMAND = "NEW";
        private byte[] m_CommandBytes;
        private int m_CommandLength;
        private byte[] m_CommandToSend_Bytes;
        private int m_CommandToSend_Length;
        private boolean m_UseValue;
        private int m_ValuePPM;
        private String m_String_Bytes;
        private String m_String_Text;
        private StringBuilder m_StringBuilder;

        public RXTXMessageCommand() {
            this.initMembers();
        }

        private void initMembers() {
            this.m_String_Bytes = "";
            this.m_String_Text = "";
            this.m_UseValue = false;
            this.m_ValuePPM = 0;
            this.m_CommandLength = 0;
            this.m_CommandBytes = new byte[512];
            this.m_CommandToSend_Length = 0;
            this.m_CommandToSend_Bytes = new byte[1024];
            this.m_StringBuilder = new StringBuilder();
        }

        public void setCommand(byte[] p_CommandBytes, int p_CommandLenght) {
            if (p_CommandBytes == null || p_CommandLenght <= 0) {
                return;
            }
            if (p_CommandLenght > this.m_CommandBytes.length) {
                this.m_CommandBytes = new byte[p_CommandLenght];
            }
            this.m_CommandLength = p_CommandLenght;
            for (int intByte = 0; intByte < p_CommandLenght; ++intByte) {
                this.m_CommandBytes[intByte] = p_CommandBytes[intByte];
            }
            this.m_String_Text = new String(p_CommandBytes, 0, p_CommandLenght);
            this.m_String_Bytes = RXTXMessageObject.getStringFromByteArray(p_CommandBytes, p_CommandLenght, true);
        }

        public byte[] getCommandBytes() {
            return this.m_CommandBytes;
        }

        public int getCommandLength() {
            return this.m_CommandLength;
        }

        public byte[] getCommandToSend_Bytes() {
            this.m_CommandToSend_Length = this.m_CommandLength;
            System.arraycopy(this.m_CommandBytes, 0, this.m_CommandToSend_Bytes, 0, this.m_CommandLength);
            if (this.m_UseValue) {
                String stringValue = String.valueOf(this.m_ValuePPM);
                this.m_StringBuilder.delete(0, this.m_StringBuilder.length());
                if (stringValue.length() < s_ValueString.length()) {
                    this.m_StringBuilder.append(s_ValueString.substring(0, s_ValueString.length() - stringValue.length()));
                    this.m_StringBuilder.append(stringValue);
                    stringValue = this.m_StringBuilder.toString();
                }
                byte[] arrayValue = stringValue.getBytes(s_Charset);
                for (int intByte = 0; intByte < arrayValue.length; ++intByte) {
                    this.m_CommandToSend_Bytes[this.m_CommandToSend_Length] = arrayValue[intByte];
                    ++this.m_CommandToSend_Length;
                }
            }
            return this.m_CommandToSend_Bytes;
        }

        public int getCommandToSend_Length() {
            return this.m_CommandToSend_Length;
        }

        public void setString_Text(String p_Command_Text) {
            if (p_Command_Text == null || p_Command_Text.length() <= 0) {
                return;
            }
            byte[] arrayCommandbytes = p_Command_Text.getBytes(s_Charset);
            this.setCommand(arrayCommandbytes, arrayCommandbytes.length);
        }

        public void setString_Bytes(String p_Command_Bytes) {
            byte[] arrayCommandBytes;
            if (p_Command_Bytes == null || p_Command_Bytes.length() <= 0) {
                return;
            }
            try {
                arrayCommandBytes = RXTXMessageObject.getBytesFromString(p_Command_Bytes, true);
            }
            catch (Exception e) {
                return;
            }
            this.setCommand(arrayCommandBytes, arrayCommandBytes.length);
        }

        public String getString_Text() {
            return this.m_String_Text;
        }

        public String getString_Bytes() {
            return this.m_String_Bytes;
        }

        public void setUseValue(boolean p_UseValue) {
            if (this.m_UseValue == p_UseValue) {
                return;
            }
            this.m_UseValue = p_UseValue;
        }

        public boolean getUseValue() {
            return this.m_UseValue;
        }

        public void setValuePPM(int p_ValuePPM) {
            this.m_ValuePPM = p_ValuePPM;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(1);
            out.writeInt(this.m_CommandLength);
            for (int intByte = 0; intByte < this.m_CommandLength; ++intByte) {
                out.writeByte(this.m_CommandBytes[intByte]);
            }
            out.writeBoolean(this.m_UseValue);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int intSoftwareVeersion = in.readInt();
            int intCommandLegth = in.readInt();
            byte[] arrayComandBytes = new byte[intCommandLegth];
            for (int intByte = 0; intByte < intCommandLegth; ++intByte) {
                arrayComandBytes[intByte] = in.readByte();
            }
            this.m_UseValue = in.readBoolean();
            this.setCommand(arrayComandBytes, intCommandLegth);
        }
    }
}

