/*
 * Decompiled with CFR 0.152.
 */
package ServerAutoDetect_Swing_Package;

import ServerAutoDetectPackage.ServerAutoDetect;
import SwingModelPackage.TableAndListModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.net.InetAddress;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;

public class DetectedServer_TableModel
extends TableAndListModel<ServerAutoDetect.DetectedServer>
implements ServerAutoDetect.ServerAutoDetect_Listener {
    public static final int COLUMNCOUNT = 3;
    public static final int COLUMNINDEX_SERVERCOMPUTERNAME = 0;
    public static final int COLUMNINDEX_SERVERIP = 1;
    public static final int COLUMNINDEX_SERVERPROJECTNAME = 2;
    public static String COLUMNNAME_SERVERCOMPUTERNAME = "Computer";
    public static String COLUMNNAME_SERVERIP = "IP";
    public static String COLUMNNAME_SERVERPROJECTNAME = "Project";

    public DetectedServer_TableModel() {
        super(false);
        this.initMembers();
    }

    private void initMembers() {
    }

    public int getColumnCount() {
        return 3;
    }

    public String getColumnName(int col) {
        if (col < 0) {
            return "";
        }
        if (col >= 3) {
            return "";
        }
        switch (col) {
            case 0: {
                return COLUMNNAME_SERVERCOMPUTERNAME;
            }
            case 1: {
                return COLUMNNAME_SERVERIP;
            }
            case 2: {
                return COLUMNNAME_SERVERPROJECTNAME;
            }
        }
        return "";
    }

    public boolean isCellEditable(int row, int col) {
        return false;
    }

    public Object getValue(ServerAutoDetect.DetectedServer p_DetectedServer, int p_ColumnIndex) {
        if (p_ColumnIndex < 0) {
            return "";
        }
        if (p_ColumnIndex >= 3) {
            return "";
        }
        if (p_DetectedServer == null) {
            return "";
        }
        switch (p_ColumnIndex) {
            case 0: {
                return p_DetectedServer.getComputerName();
            }
            case 1: {
                return p_DetectedServer.getServerIP();
            }
            case 2: {
                return p_DetectedServer.getServerProjectName();
            }
        }
        return "";
    }

    public void setValue(ServerAutoDetect.DetectedServer p_Element, Object value, int p_ColumnIndex) {
    }

    public void eventDetectedServer_Added(ServerAutoDetect.DetectedServer p_DetectedServer) {
        this.addElement(p_DetectedServer);
    }

    public void eventDetectedServer_Changed(ServerAutoDetect.DetectedServer p_DetectedServer) {
        this.changedElement(p_DetectedServer);
    }

    public void eventDetectedServer_Removed(ServerAutoDetect.DetectedServer p_DetectedServer) {
        this.removeElement(p_DetectedServer);
    }

    public static class DetectedServer_ListCellRenderer
    extends DefaultListCellRenderer {
        protected static final Border SAFE_NO_FOCUS_BORDER = new EmptyBorder(1, 1, 1, 1);
        protected static final Border DEFAULT_NO_FOCUS_BORDER = new EmptyBorder(1, 1, 1, 1);
        protected static final Border SELECTED_BORDER = new LineBorder(Color.BLUE, 2, true);
        private Dimension m_PreferredDimension;
        private StringBuffer m_StringBuffer;
        private boolean m_ShowServerTaskID;
        private boolean m_ShowServerTaskName;
        private boolean m_ShowComputerName;
        private boolean m_ShowServerIP;
        private boolean m_ShowServerPort;
        private boolean m_ShowServerProjectName;
        private boolean m_ShowServerAddition;

        public DetectedServer_ListCellRenderer() {
            this.initMembers();
        }

        public DetectedServer_ListCellRenderer(boolean p_ShowServerTaskID, boolean p_ShowServerTaskName, boolean p_ShowComputerName, boolean p_ShowServerIP, boolean p_ShowServerPort, boolean p_ShowServerProjectName, boolean p_ShowServerAddition) {
            this.initMembers();
            this.m_ShowServerTaskID = p_ShowServerTaskID;
            this.m_ShowServerTaskName = p_ShowServerTaskName;
            this.m_ShowComputerName = p_ShowComputerName;
            this.m_ShowServerIP = p_ShowServerIP;
            this.m_ShowServerPort = p_ShowServerPort;
            this.m_ShowServerProjectName = p_ShowServerProjectName;
            this.m_ShowServerAddition = p_ShowServerAddition;
        }

        private void initMembers() {
            this.m_PreferredDimension = new Dimension(60, 28);
            this.m_StringBuffer = new StringBuffer();
            this.m_ShowServerTaskID = false;
            this.m_ShowServerTaskName = false;
            this.m_ShowComputerName = true;
            this.m_ShowServerIP = false;
            this.m_ShowServerPort = true;
            this.m_ShowServerProjectName = true;
            this.m_ShowServerAddition = true;
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setComponentOrientation(list.getComponentOrientation());
            Color o_Background = null;
            Color o_Foreground = null;
            o_Background = list.getBackground();
            o_Foreground = list.getForeground();
            if (isSelected) {
                if (list.hasFocus()) {
                    o_Background = UIManager.getColor("List.selectionBackground");
                    o_Foreground = UIManager.getColor("List.selectionForeground");
                } else {
                    o_Background = UIManager.getColor("List.selectionInactiveBackground");
                    o_Foreground = UIManager.getColor("List.selectionInactiveForeground");
                }
            }
            this.setForeground(o_Foreground);
            this.setBackground(o_Background);
            if (isSelected) {
                // empty if block
            }
            if (value == null || !(value instanceof ServerAutoDetect.DetectedServer)) {
                this.setText("...");
            } else {
                String stringAddition;
                ServerAutoDetect.DetectedServer o_DetectedServer = (ServerAutoDetect.DetectedServer)value;
                InetAddress o_InetAddress = o_DetectedServer.getFirstInetAddress();
                this.m_StringBuffer.delete(0, this.m_StringBuffer.length());
                if (this.m_ShowServerTaskID) {
                    this.m_StringBuffer.append(o_DetectedServer.getServerTaskID());
                    this.m_StringBuffer.append(" ");
                }
                if (this.m_ShowServerTaskName) {
                    this.m_StringBuffer.append(o_DetectedServer.getServerTaskName());
                    this.m_StringBuffer.append(" ");
                }
                if (this.m_ShowComputerName) {
                    this.m_StringBuffer.append(o_DetectedServer.getComputerName());
                    this.m_StringBuffer.append(" ");
                }
                if (this.m_ShowServerIP || this.m_ShowServerPort) {
                    this.m_StringBuffer.append(" (");
                    if (this.m_ShowServerIP && o_InetAddress != null) {
                        this.m_StringBuffer.append(o_InetAddress.getHostAddress());
                        this.m_StringBuffer.append("  ");
                    }
                    if (this.m_ShowServerPort) {
                        this.m_StringBuffer.append(o_DetectedServer.getServerPort());
                    }
                    this.m_StringBuffer.append(") ");
                }
                if (this.m_ShowServerProjectName) {
                    this.m_StringBuffer.append(o_DetectedServer.getServerProjectName());
                    this.m_StringBuffer.append("  ");
                }
                if (this.m_ShowServerAddition && (stringAddition = o_DetectedServer.getServerAddition()) != null && stringAddition.length() > 0) {
                    this.m_StringBuffer.append(stringAddition);
                    this.m_StringBuffer.append(" ");
                }
                this.setIcon(null);
                if (this.m_StringBuffer.length() > 2) {
                    this.m_StringBuffer.delete(this.m_StringBuffer.length() - 1, this.m_StringBuffer.length());
                }
                this.setText(this.m_StringBuffer.toString());
                this.m_StringBuffer.delete(0, this.m_StringBuffer.length());
                this.m_StringBuffer.append("<html>");
                int intInetAddressCount = o_DetectedServer.getInetAddressCount();
                for (int intAddress = 0; intAddress < intInetAddressCount; ++intAddress) {
                    o_InetAddress = o_DetectedServer.getInetAddress(intAddress);
                    if (o_InetAddress == null) continue;
                    this.m_StringBuffer.append(o_InetAddress.getHostAddress());
                    if (intAddress >= intInetAddressCount - 1) continue;
                    this.m_StringBuffer.append("<br>");
                }
                this.m_StringBuffer.append("</html>");
                this.setToolTipText(this.m_StringBuffer.toString());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            Border border = null;
            if (isSelected) {
                border = SELECTED_BORDER;
            }
            if (border == null) {
                border = this.getNoFocusBorder();
            }
            this.setPreferredSize(this.m_PreferredDimension);
            return this;
        }

        private Border getNoFocusBorder() {
            Border border = null;
            if (System.getSecurityManager() != null) {
                if (border != null) {
                    return border;
                }
                return SAFE_NO_FOCUS_BORDER;
            }
            if (border != null && (noFocusBorder == null || noFocusBorder == DEFAULT_NO_FOCUS_BORDER)) {
                return border;
            }
            return noFocusBorder;
        }
    }
}

