/*
 * Decompiled with CFR 0.152.
 */
package LanguageTools.EditPackage;

import LanguageTools.EditPackage.LiveLanguageEditFrame;
import LanguageTools.EditPackage.LiveLanguageEditTableModel;
import LanguageTools.LiveLanguagePackage.LiveLanguage;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Locale;
import javax.swing.DefaultCellEditor;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class LiveLanguageEditTable
extends JTable {
    public static Cursor m_ResizeCursor = Cursor.getPredefinedCursor(8);
    private LiveLanguageEditTableModel m_TableEditLanguageModel;
    private LiveLanguageTableCellEditor m_TableCellEditor;
    private LiveLanguageTableCellRenderer m_TableCellRenderer;
    private LiveLanguageTableHeaderRenderer m_TableHeaderRenderer;
    private TableColumnModel m_ColumnModel;
    private Color m_ColorColumn0;
    private boolean m_EditChanged;
    private boolean m_Editing;

    public LiveLanguageEditTable() {
        this.initMembers();
    }

    private void initMembers() {
        this.m_TableEditLanguageModel = new LiveLanguageEditTableModel();
        super.setModel(this.m_TableEditLanguageModel);
        super.setRowSelectionAllowed(true);
        super.setColumnSelectionAllowed(false);
        super.setSelectionMode(0);
        super.setAutoCreateColumnsFromModel(true);
        this.m_ColorColumn0 = new Color(255, 200, 200);
        this.m_ColumnModel = super.getColumnModel();
        this.m_TableHeaderRenderer = new LiveLanguageTableHeaderRenderer();
        JTextField o_JTextField = new JTextField();
        this.m_TableCellEditor = new LiveLanguageTableCellEditor();
        this.m_TableCellRenderer = new LiveLanguageTableCellRenderer();
        this.m_EditChanged = false;
        this.m_Editing = false;
        super.setAutoResizeMode(4);
        this.setFont(new Font("Tahoma", 0, 12));
        this.setRowHeight(16);
    }

    @Override
    public TableCellRenderer getCellRenderer(int p_Row, int p_Column) {
        return this.m_TableCellRenderer;
    }

    @Override
    public TableCellEditor getCellEditor(int p_Row, int p_Column) {
        return this.m_TableCellEditor;
    }

    @Override
    public void columnAdded(TableColumnModelEvent e) {
        super.columnAdded(e);
        TableColumnModel o_TableColumnModel = super.getColumnModel();
        if (o_TableColumnModel == null) {
            return;
        }
        TableColumn o_Column = o_TableColumnModel.getColumn(e.getToIndex());
        if (o_Column == null) {
            return;
        }
        o_Column.setHeaderRenderer(this.m_TableHeaderRenderer);
    }

    @Override
    public void columnRemoved(TableColumnModelEvent e) {
        super.columnRemoved(e);
    }

    @Override
    public LiveLanguageEditTableModel getModel() {
        return this.m_TableEditLanguageModel;
    }

    public boolean getHasChanged() {
        return this.m_EditChanged;
    }

    public boolean getEditing() {
        return this.m_Editing;
    }

    public void cancelEditing() {
        int intSelectedRow = this.getSelectedRow();
        int intSelectedColumn = this.getSelectedColumn();
        if (intSelectedRow < 0) {
            return;
        }
        if (intSelectedColumn < 0) {
            return;
        }
        DefaultCellEditor o_CellEditor = (DefaultCellEditor)this.getCellEditor(intSelectedRow, intSelectedColumn);
        Object o_Object = o_CellEditor.getCellEditorValue();
        o_CellEditor.cancelCellEditing();
        this.setValueAt(o_Object, intSelectedRow, intSelectedColumn);
    }

    public class TableRowResizer
    extends MouseInputAdapter {
        private int m_MouseYOffset;
        private int m_ResizingRow;
        private Cursor m_OtherCursor = m_ResizeCursor;
        private JTable m_JTable;

        public TableRowResizer(JTable p_JTable) {
            this.m_JTable = p_JTable;
            p_JTable.addMouseListener(this);
            p_JTable.addMouseMotionListener(this);
        }

        private int getResizingRow(Point p_Point) {
            if (p_Point == null) {
                return -1;
            }
            return this.getResizingRow(p_Point, this.m_JTable.rowAtPoint(p_Point));
        }

        private int getResizingRow(Point p_Point, int p_Row) {
            if (p_Row == -1) {
                return -1;
            }
            int intCol = this.m_JTable.columnAtPoint(p_Point);
            if (intCol == -1) {
                return -1;
            }
            Rectangle o_Rectabgle = this.m_JTable.getCellRect(p_Row, intCol, true);
            o_Rectabgle.grow(0, -3);
            if (o_Rectabgle.contains(p_Point)) {
                return -1;
            }
            int intMidPoint = o_Rectabgle.y + o_Rectabgle.height / 2;
            int intRowIndex = p_Point.y < intMidPoint ? p_Row - 1 : p_Row;
            return intRowIndex;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            Point p = e.getPoint();
            int intRow = this.getResizingRow(p);
            if (intRow < 0) {
                return;
            }
            this.m_ResizingRow = intRow;
            this.m_MouseYOffset = p.y - this.m_JTable.getRowHeight(this.m_ResizingRow);
        }

        private void swapCursor() {
            Cursor tmpCursor = this.m_JTable.getCursor();
            this.m_JTable.setCursor(this.m_OtherCursor);
            this.m_OtherCursor = tmpCursor;
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (this.getResizingRow(e.getPoint()) >= 0 != (this.m_JTable.getCursor() == m_ResizeCursor)) {
                this.swapCursor();
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            int intMouseY = e.getY();
            if (this.m_ResizingRow >= 0) {
                int newHeight = intMouseY - this.m_MouseYOffset;
                if (newHeight > 12) {
                    this.m_JTable.setRowHeight(newHeight);
                }
                this.m_JTable.getSelectionModel().setSelectionInterval(this.m_ResizingRow, this.m_ResizingRow);
            }
        }
    }

    public class LiveLanguageTableCellEditor
    extends DefaultCellEditor {
        private Component m_Component;
        private int m_CountWarnings;
        private String m_ActualObject;

        public LiveLanguageTableCellEditor() {
            super(new JTextField());
            this.m_Component = super.getComponent();
        }

        @Override
        public Component getTableCellEditorComponent(JTable p_Table, Object p_Value, boolean p_IsSelected, int p_RowIndex, int p_ColIndex) {
            if (p_ColIndex == 0) {
                if (this.m_CountWarnings < 1) {
                    JOptionPane.showMessageDialog(null, LiveLanguageEditFrame.m_StringWarningEditColumn0, "", 2);
                    ++this.m_CountWarnings;
                }
                this.m_Component.setBackground(LiveLanguageEditTable.this.m_ColorColumn0);
            } else {
                this.m_Component.setBackground(Color.WHITE);
            }
            this.m_Component.setComponentOrientation(p_Table.getComponentOrientation());
            this.m_ActualObject = p_Value.toString();
            LiveLanguageEditTable.this.m_Editing = true;
            return super.getTableCellEditorComponent(p_Table, p_Value, p_IsSelected, p_RowIndex, p_ColIndex);
        }

        @Override
        public Object getCellEditorValue() {
            String o_Object = super.getCellEditorValue().toString();
            if (!o_Object.equals(this.m_ActualObject)) {
                LiveLanguageEditTable.this.m_EditChanged = true;
            }
            LiveLanguageEditTable.this.m_Editing = false;
            return o_Object;
        }
    }

    public class LiveLanguageTableHeaderRenderer
    extends JLabel
    implements TableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            String stringText = table.getColumnName(col);
            this.setText(stringText);
            if (col >= 2) {
                Locale o_Locale = LiveLanguageEditTable.this.m_TableEditLanguageModel.getLocaleFromIndex(col);
                this.setIcon(LiveLanguage.getFlag(o_Locale));
            } else {
                this.setIcon(null);
            }
            return this;
        }
    }

    public class LiveLanguageTableCellRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component o_Component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            o_Component.setComponentOrientation(table.getComponentOrientation());
            int intHeight = o_Component.getHeight();
            if (intHeight <= 0) {
                intHeight = table.getRowHeight();
            }
            LiveLanguageEditTable.this.setRowHeight(row, intHeight);
            return o_Component;
        }
    }
}

