/*
 * Decompiled with CFR 0.152.
 */
package SPITModelPackage;

import SPITActionPackage.SPIT_ActionStatus;
import SPITLibraryPackage.SPIT_Object_Interface;
import SPITLibraryPackage.SPIT_TypeDescription;
import SPITLibraryPackage.SPIT_Type_Interface;
import SPITModelPackage.SPIT_ObjectModel;
import SPITModelPackage.SPIT_TypeModel;
import SwingModelPackage.TableAndListModel;
import SwingTextPackage.TextComparator;
import SwingToolTipPackage.PopUpToolTip;
import java.awt.Color;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Comparator;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.RowFilter;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;

public class RemoteSPITObjectTableModel
extends TableAndListModel<SPIT_Object_Interface>
implements PropertyChangeListener {
    public static final int COLUMNCOUNT = 4;
    public static final int COLUMNINDEX_SPITTYPEGROUPNAME = 0;
    public static final int COLUMNINDEX_SPITTYPENAME = 1;
    public static final int COLUMNINDEX_OBJECTNAME = 2;
    public static final int COLUMNINDEX_OBJECTPLAYVALUE = 3;
    public static String COLUMN_SPITTYPEGROUPNAME = "Group";
    public static String COLUMN_OBJECTNAME = "Name";
    public static String COLUMN_OBJECTPLAYVALUE = "Value %";
    public static String COLUMN_SPITTYPENAME = SPIT_TypeDescription.DEFAULTNAME;
    public static boolean s_LanguageLoaded = false;
    private TableRowSorter m_TableRowSorter;
    private SPITRowFilter m_SPITRowFilter;
    private final Object m_SyncObject = new Object();

    public RemoteSPITObjectTableModel() {
        super(false);
        this.initMembers();
    }

    private void initMembers() {
        this.m_TableRowSorter = new TableRowSorter<RemoteSPITObjectTableModel>(this);
        this.m_SPITRowFilter = new SPITRowFilter(this);
    }

    public TableRowSorter<RemoteSPITObjectTableModel> createTableRowSorter() {
        TableRowSorter<RemoteSPITObjectTableModel> o_TableRowSorter = new TableRowSorter<RemoteSPITObjectTableModel>(this);
        o_TableRowSorter.setComparator(2, (Comparator<?>)new TextComparator.StringComparator_Normal());
        return o_TableRowSorter;
    }

    public SPITRowFilter createRowFilter() {
        SPITRowFilter o_SPITRowFilter = new SPITRowFilter(this);
        return o_SPITRowFilter;
    }

    public void finishJTable(JTable p_JTable) {
        if (p_JTable == null) {
            return;
        }
        this.finishJTable(p_JTable, this.createRowFilter());
    }

    public void finishJTable(JTable p_JTable, RowFilter p_RowFilter) {
        RemoteSPITObjectTableCellRenderer o_TableCellEditorRenderer_String;
        if (p_JTable == null) {
            return;
        }
        super.finishJTable(p_JTable, this.createTableRowSorter(), p_RowFilter);
        TableColumnModel o_TableColumnModel = p_JTable.getColumnModel();
        TableColumn o_TableColumn = o_TableColumnModel.getColumn(0);
        if (o_TableColumn != null) {
            o_TableCellEditorRenderer_String = new RemoteSPITObjectTableCellRenderer();
            o_TableCellEditorRenderer_String.setToolTipText_Automatic(1);
            o_TableCellEditorRenderer_String.setToolTipTextAt(false, true);
            o_TableColumn.setCellEditor((TableCellEditor)((Object)o_TableCellEditorRenderer_String));
            o_TableColumn.setCellRenderer((TableCellRenderer)((Object)o_TableCellEditorRenderer_String));
        }
        if ((o_TableColumn = o_TableColumnModel.getColumn(1)) != null) {
            o_TableCellEditorRenderer_String = new RemoteSPITObjectTableCellRenderer();
            o_TableCellEditorRenderer_String.setToolTipText_Automatic(1);
            o_TableCellEditorRenderer_String.setToolTipTextAt(false, true);
            o_TableColumn.setCellEditor((TableCellEditor)((Object)o_TableCellEditorRenderer_String));
            o_TableColumn.setCellRenderer((TableCellRenderer)((Object)o_TableCellEditorRenderer_String));
        }
        if ((o_TableColumn = o_TableColumnModel.getColumn(2)) != null) {
            o_TableCellEditorRenderer_String = new RemoteSPITObjectTableCellRenderer();
            o_TableCellEditorRenderer_String.setToolTipText_Automatic(1);
            o_TableCellEditorRenderer_String.setToolTipTextAt(false, true);
            o_TableColumn.setCellEditor((TableCellEditor)((Object)o_TableCellEditorRenderer_String));
            o_TableColumn.setCellRenderer((TableCellRenderer)((Object)o_TableCellEditorRenderer_String));
        }
        if ((o_TableColumn = o_TableColumnModel.getColumn(3)) != null) {
            o_TableColumn.setMinWidth(80);
            o_TableColumn.setMaxWidth(80);
            o_TableColumn.setPreferredWidth(80);
            o_TableColumn.setResizable(false);
            TableAndListModel.TableCellEditorRenderer_Integer o_TableCellEditorRenderer_Integer = new TableAndListModel.TableCellEditorRenderer_Integer();
            o_TableCellEditorRenderer_Integer.setAllowNegativeNumbers(false);
            o_TableCellEditorRenderer_Integer.setToolTipText_Automatic(1);
            o_TableCellEditorRenderer_Integer.setToolTipTextAt(false, true);
            o_TableColumn.setCellEditor((TableCellEditor)o_TableCellEditorRenderer_Integer);
            o_TableColumn.setCellRenderer((TableCellRenderer)o_TableCellEditorRenderer_Integer);
        }
        p_JTable.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.m_SyncObject;
        synchronized (object) {
            super.clear();
        }
    }

    public boolean contains(String p_ID) {
        if (p_ID == null) {
            return false;
        }
        SPIT_Object_Interface o_SPIT_Object_Interface = this.getSPIT_Object(p_ID);
        return o_SPIT_Object_Interface != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SPIT_Object_Interface getSPIT_Object(String p_ID) {
        Object object = this.m_SyncObject;
        synchronized (object) {
            for (int intType = 0; intType < this.size(); ++intType) {
                SPIT_Object_Interface o_SPIT_Object_Interface = (SPIT_Object_Interface)this.get(intType);
                if (o_SPIT_Object_Interface == null || !p_ID.equals(o_SPIT_Object_Interface.getID())) continue;
                return o_SPIT_Object_Interface;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addSPIT_Object(SPIT_Object_Interface p_SPIT_Object_Interface) {
        if (p_SPIT_Object_Interface == null) {
            return false;
        }
        Object object = this.m_SyncObject;
        synchronized (object) {
            if (this.addElement(p_SPIT_Object_Interface)) {
                p_SPIT_Object_Interface.addPropertyChangeListener(this);
            } else {
                this.changedElement(p_SPIT_Object_Interface);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeSPIT_Object(SPIT_Object_Interface p_SPIT_Object_Interface) {
        boolean boolRemoved;
        if (p_SPIT_Object_Interface == null) {
            return false;
        }
        Object object = this.m_SyncObject;
        synchronized (object) {
            boolRemoved = this.removeElement(p_SPIT_Object_Interface);
            if (boolRemoved) {
                p_SPIT_Object_Interface.removePropertyChangeListener(this);
            }
        }
        return boolRemoved;
    }

    public void addSelectedSPIT_Object(JTable p_JTable, SPIT_Object_Interface p_SPIT_Object_Interface) {
        if (p_JTable == null) {
            return;
        }
        if (p_SPIT_Object_Interface == null) {
            return;
        }
        super.addSelectedElement(p_JTable, (Object)p_SPIT_Object_Interface);
    }

    public void removeSelectedSPIT_Object(JTable p_JTable, SPIT_Object_Interface p_SPIT_Object_Interface) {
        if (p_JTable == null) {
            return;
        }
        if (p_SPIT_Object_Interface == null) {
            return;
        }
        super.removeSelectedElement(p_JTable, (Object)p_SPIT_Object_Interface);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SPIT_Object_Interface getSPIT_Object(int p_Index) {
        if (p_Index < 0) {
            return null;
        }
        Object object = this.m_SyncObject;
        synchronized (object) {
            return (SPIT_Object_Interface)this.get(p_Index);
        }
    }

    public int getColumnCount() {
        return 4;
    }

    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return COLUMN_SPITTYPEGROUPNAME;
            }
            case 2: {
                return COLUMN_OBJECTNAME;
            }
            case 3: {
                return COLUMN_OBJECTPLAYVALUE;
            }
            case 1: {
                return COLUMN_SPITTYPENAME;
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValue(SPIT_Object_Interface p_SPIT_Object_Interface, int columnIndex) {
        if (p_SPIT_Object_Interface == null) {
            return "";
        }
        String stringValue = "";
        Object object = this.m_SyncObject;
        synchronized (object) {
            SPIT_ActionStatus o_SPIT_ActionStatus = p_SPIT_Object_Interface.getSPIT_ActionStatus();
            SPIT_Type_Interface o_SPIT_Type_Interface = p_SPIT_Object_Interface.getSPIT_Type();
            switch (columnIndex) {
                case 0: {
                    if (o_SPIT_Type_Interface == null) {
                        return "";
                    }
                    stringValue = o_SPIT_Type_Interface.getGroupName();
                    break;
                }
                case 2: {
                    stringValue = p_SPIT_Object_Interface.getName();
                    break;
                }
                case 3: {
                    if (o_SPIT_ActionStatus == null) {
                        return "";
                    }
                    if (o_SPIT_ActionStatus.getPlayValue() == 0) {
                        stringValue = "";
                        break;
                    }
                    stringValue = String.valueOf((int)((float)o_SPIT_ActionStatus.getPlayValue() * ((float)p_SPIT_Object_Interface.getValueFactor() / 1000000.0f) / 10000.0f));
                    break;
                }
                case 1: {
                    if (o_SPIT_Type_Interface == null) {
                        return "";
                    }
                    stringValue = o_SPIT_Type_Interface.getName();
                }
            }
            return stringValue;
        }
    }

    public boolean isCellEditable(int row, int col) {
        switch (col) {
            case 0: {
                return false;
            }
            case 2: {
                return false;
            }
            case 3: {
                return false;
            }
            case 1: {
                return false;
            }
        }
        return false;
    }

    public void setValue(SPIT_Object_Interface p_SPIT_Object_Interface, Object value, int col) {
        if (p_SPIT_Object_Interface == null) {
            return;
        }
        if (!(value instanceof String)) {
            return;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() instanceof SPIT_Object_Interface) {
            SPIT_Object_Interface o_SPIT_Object_Interface = (SPIT_Object_Interface)evt.getSource();
            if ("paramchanged".equals(evt.getPropertyName())) {
                this.changedElement(o_SPIT_Object_Interface);
            }
            if ("confirmed".equals(evt.getPropertyName())) {
                this.changedElement(o_SPIT_Object_Interface);
            }
        }
    }

    public static class RemoteSPITObjectTableCellRenderer
    extends TableAndListModel.TableCellEditorRenderer_String {
        public static Color s_NotConfirmedColor = new Color(255, 0, 0);
        public static Color s_FIXEDColor = new Color(0, 100, 0);

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JComponent o_JComponent = (JComponent)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (table.getModel() instanceof SPIT_TypeModel) {
                SPIT_Object_Interface o_SPIT_Object_Interface;
                SPIT_ObjectModel o_SPITObjectTableModel = (SPIT_ObjectModel)((Object)table.getModel());
                try {
                    int intRowModel = table.convertRowIndexToModel(row);
                    o_SPIT_Object_Interface = (SPIT_Object_Interface)o_SPITObjectTableModel.getElementAt(intRowModel);
                }
                catch (Exception e) {
                    o_SPIT_Object_Interface = null;
                }
                if (o_SPIT_Object_Interface != null) {
                    if (!o_SPIT_Object_Interface.getConfirmed()) {
                        o_JComponent.setBackground(s_NotConfirmedColor);
                    } else if (o_SPIT_Object_Interface.getFixed()) {
                        o_JComponent.setBackground(s_FIXEDColor);
                    }
                }
            }
            return o_JComponent;
        }
    }

    public static class SPITRowFilter
    extends RowFilter<SPIT_Object_Interface, Integer> {
        private RemoteSPITObjectTableModel m_RemoteSPITObjectTableModel;
        private String m_FilterString;

        public SPITRowFilter(RemoteSPITObjectTableModel p_SPIT_ObjectModel) {
            this.initMembers();
            this.m_RemoteSPITObjectTableModel = p_SPIT_ObjectModel;
        }

        private void initMembers() {
            this.m_FilterString = null;
        }

        public void setFilterString(String p_FilterString) {
            this.m_FilterString = p_FilterString == null ? "" : p_FilterString.toLowerCase();
            if (this.m_RemoteSPITObjectTableModel != null) {
                this.m_RemoteSPITObjectTableModel.fireTableDataChanged();
            }
        }

        @Override
        public boolean include(RowFilter.Entry entry) {
            if (this.m_RemoteSPITObjectTableModel == null) {
                return false;
            }
            int intRow = (Integer)entry.getIdentifier();
            SPIT_Object_Interface o_SPIT_Object_Interface = this.m_RemoteSPITObjectTableModel.getSPIT_Object(intRow);
            if (o_SPIT_Object_Interface == null) {
                return false;
            }
            if (this.m_FilterString == null) {
                return true;
            }
            if (this.m_FilterString.length() <= 0) {
                return true;
            }
            if (o_SPIT_Object_Interface.getName().toLowerCase().contains(this.m_FilterString)) {
                return true;
            }
            SPIT_Type_Interface o_SPIT_Type_Interface = o_SPIT_Object_Interface.getSPIT_Type();
            if (o_SPIT_Type_Interface == null) {
                return false;
            }
            if (o_SPIT_Type_Interface.getGroupName().toLowerCase().contains(this.m_FilterString)) {
                return true;
            }
            return o_SPIT_Type_Interface.getName().toLowerCase().contains(this.m_FilterString);
        }
    }
}

