/*
 * Decompiled with CFR 0.152.
 */
package LanguageTools.LiveLanguagePackage;

import LanguageTools.LiveLanguagePackage.LiveLanguage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.PropertyResourceBundle;

public class LiveLanguageResourceBundle {
    protected PropertyResourceBundle m_PropertyResourceBundle = null;
    protected FileInputStream m_FileInputStream = null;
    protected InputStreamReader m_InputStreamReader = null;
    protected boolean m_Valid = false;

    public LiveLanguageResourceBundle() {
        this.initMembers();
    }

    public LiveLanguageResourceBundle(File p_File) {
        this.initMembers();
        this.loadFile(p_File);
    }

    private void initMembers() {
        this.m_PropertyResourceBundle = null;
        this.m_FileInputStream = null;
        this.m_InputStreamReader = null;
        this.m_Valid = false;
    }

    public boolean loadFile(File p_File) {
        if (p_File == null) {
            return false;
        }
        if (!p_File.exists()) {
            return false;
        }
        try {
            this.m_FileInputStream = new FileInputStream(p_File);
            this.m_InputStreamReader = new InputStreamReader((InputStream)this.m_FileInputStream, LiveLanguage.DEFAULTCHARSET_FILE);
            this.m_PropertyResourceBundle = new PropertyResourceBundle(this.m_InputStreamReader);
            this.m_Valid = true;
        }
        catch (Exception e) {
            this.close();
            this.m_Valid = false;
        }
        return this.m_Valid;
    }

    public void close() {
        if (this.m_PropertyResourceBundle != null) {
            PropertyResourceBundle.clearCache();
        }
        try {
            if (this.m_InputStreamReader != null) {
                this.m_InputStreamReader.close();
            }
            if (this.m_FileInputStream != null) {
                this.m_FileInputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean isValid() {
        return this.m_Valid;
    }

    public PropertyResourceBundle getPropertyResourceBundle() {
        return this.m_PropertyResourceBundle;
    }
}

