/*
 * Decompiled with CFR 0.152.
 */
package uk.co.xfactorylibrarians.coremidi4j;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Sequencer;
import javax.sound.midi.Synthesizer;
import javax.sound.midi.spi.MidiDeviceProvider;
import uk.co.xfactorylibrarians.coremidi4j.CoreMidiClient;
import uk.co.xfactorylibrarians.coremidi4j.CoreMidiDestination;
import uk.co.xfactorylibrarians.coremidi4j.CoreMidiDeviceInfo;
import uk.co.xfactorylibrarians.coremidi4j.CoreMidiException;
import uk.co.xfactorylibrarians.coremidi4j.CoreMidiNotification;
import uk.co.xfactorylibrarians.coremidi4j.CoreMidiOutputPort;
import uk.co.xfactorylibrarians.coremidi4j.CoreMidiSource;
import uk.co.xfactorylibrarians.coremidi4j.Loader;

public class CoreMidiDeviceProvider
extends MidiDeviceProvider
implements CoreMidiNotification {
    private static final int DEVICE_MAP_SIZE = 20;
    private static final MidiProperties midiProperties = new MidiProperties();

    private synchronized void initialise() throws CoreMidiException {
        if (midiProperties.client == null) {
            midiProperties.client = new CoreMidiClient("Core MIDI Provider");
            midiProperties.output = midiProperties.client.outputPortCreate("Core Midi Provider Output");
            this.buildDeviceMap();
        }
    }

    public CoreMidiDeviceProvider() throws CoreMidiException {
        if (CoreMidiDeviceProvider.isLibraryLoaded()) {
            if (midiProperties.client == null) {
                this.initialise();
            }
            midiProperties.client.addNotificationListener(this);
        }
    }

    private void buildDeviceMap() throws CoreMidiException {
        MidiDevice existingDevice;
        int uniqueID;
        int endPointReference;
        int i;
        HashSet<Integer> devicesSeen = new HashSet<Integer>();
        for (i = 0; i < this.getNumberOfSources(); ++i) {
            endPointReference = this.getSource(i);
            uniqueID = this.getUniqueID(endPointReference);
            devicesSeen.add(uniqueID);
            if (!midiProperties.deviceMap.containsKey(uniqueID)) {
                midiProperties.deviceMap.put(uniqueID, new CoreMidiSource(this.getMidiDeviceInfo(endPointReference)));
                continue;
            }
            existingDevice = (CoreMidiSource)midiProperties.deviceMap.get(uniqueID);
            ((CoreMidiSource)existingDevice).updateDeviceInfo(this.getMidiDeviceInfo(endPointReference));
        }
        for (i = 0; i < this.getNumberOfDestinations(); ++i) {
            endPointReference = this.getDestination(i);
            uniqueID = this.getUniqueID(endPointReference);
            devicesSeen.add(uniqueID);
            if (!midiProperties.deviceMap.containsKey(uniqueID)) {
                midiProperties.deviceMap.put(uniqueID, new CoreMidiDestination(this.getMidiDeviceInfo(endPointReference)));
                continue;
            }
            existingDevice = (CoreMidiDestination)midiProperties.deviceMap.get(uniqueID);
            ((CoreMidiDestination)existingDevice).updateDeviceInfo(this.getMidiDeviceInfo(endPointReference));
        }
        HashSet devicesInMap = new HashSet(midiProperties.deviceMap.keySet());
        for (Integer uniqueID2 : devicesInMap) {
            if (devicesSeen.contains(uniqueID2)) continue;
            MidiDevice vanishedDevice = (MidiDevice)midiProperties.deviceMap.remove(uniqueID2);
            try {
                if (vanishedDevice instanceof CoreMidiSource) {
                    ((CoreMidiSource)vanishedDevice).deviceDisappeared();
                    continue;
                }
                vanishedDevice.close();
            }
            catch (Exception e) {
                System.err.println("Problem trying to clean up vanished MIDI device " + vanishedDevice + ": " + e);
                e.printStackTrace();
            }
        }
    }

    static CoreMidiClient getMIDIClient() throws CoreMidiException {
        if (midiProperties.client == null) {
            new CoreMidiDeviceProvider().initialise();
        }
        return midiProperties.client;
    }

    static CoreMidiOutputPort getOutputPort() {
        if (midiProperties.output == null) {
            try {
                new CoreMidiDeviceProvider().initialise();
            }
            catch (CoreMidiException e) {
                e.printStackTrace();
            }
        }
        return midiProperties.output;
    }

    @Override
    public MidiDevice.Info[] getDeviceInfo() {
        if (midiProperties.deviceMap == null) {
            return new MidiDevice.Info[0];
        }
        MidiDevice.Info[] info = new MidiDevice.Info[midiProperties.deviceMap.size()];
        Iterator iterator = midiProperties.deviceMap.values().iterator();
        int counter = 0;
        while (iterator.hasNext()) {
            MidiDevice device = (MidiDevice)iterator.next();
            info[counter] = device.getDeviceInfo();
            ++counter;
        }
        return info;
    }

    @Override
    public MidiDevice getDevice(MidiDevice.Info info) throws IllegalArgumentException {
        if (!this.isDeviceSupported(info)) {
            throw new IllegalArgumentException();
        }
        return (MidiDevice)midiProperties.deviceMap.get(((CoreMidiDeviceInfo)info).getEndPointUniqueID());
    }

    @Override
    public boolean isDeviceSupported(MidiDevice.Info info) {
        boolean foundDevice = false;
        if (midiProperties.deviceMap != null && info instanceof CoreMidiDeviceInfo && midiProperties.deviceMap.containsKey(((CoreMidiDeviceInfo)info).getEndPointUniqueID())) {
            foundDevice = true;
        }
        return foundDevice;
    }

    @Override
    public void midiSystemUpdated() throws CoreMidiException {
        this.buildDeviceMap();
    }

    public static void addNotificationListener(CoreMidiNotification listener) throws CoreMidiException {
        if (!CoreMidiDeviceProvider.isLibraryLoaded()) {
            throw new CoreMidiException("libCoreMidi4J.dylib could not be loaded, CoreMIDI4J is not active.");
        }
        if (midiProperties.client == null) {
            new CoreMidiDeviceProvider().initialise();
        }
        midiProperties.client.addNotificationListener(listener);
    }

    public static void removeNotificationListener(CoreMidiNotification listener) throws CoreMidiException {
        if (!CoreMidiDeviceProvider.isLibraryLoaded()) {
            throw new CoreMidiException("libCoreMidi4J.dylib could not be loaded, CoreMIDI4J is not active.");
        }
        if (midiProperties.client == null) {
            new CoreMidiDeviceProvider().initialise();
        }
        midiProperties.client.removeNotificationListener(listener);
    }

    public static boolean isLibraryLoaded() throws CoreMidiException {
        return Loader.isAvailable();
    }

    public static String getLibraryVersion() {
        return Package.getPackage("uk.co.xfactorylibrarians.coremidi4j").getImplementationVersion();
    }

    public static MidiDevice.Info[] getMidiDeviceInfo() {
        MidiDevice.Info[] allInfo = MidiSystem.getMidiDeviceInfo();
        try {
            if (CoreMidiDeviceProvider.isLibraryLoaded()) {
                ArrayList<MidiDevice.Info> workingDevices = new ArrayList<MidiDevice.Info>(allInfo.length);
                for (MidiDevice.Info candidate : allInfo) {
                    try {
                        MidiDevice device = MidiSystem.getMidiDevice(candidate);
                        if (!(device instanceof Sequencer) && !(device instanceof Synthesizer) && !(device instanceof CoreMidiDestination) && !(device instanceof CoreMidiSource)) continue;
                        workingDevices.add(candidate);
                    }
                    catch (MidiUnavailableException e) {
                        System.err.println("Problem obtaining MIDI device which supposedly exists:" + e.getMessage());
                    }
                }
                return workingDevices.toArray(new MidiDevice.Info[workingDevices.size()]);
            }
        }
        catch (CoreMidiException e) {
            System.err.println("Problem trying to determine native library status:" + e.getMessage());
        }
        return allInfo;
    }

    private native int getNumberOfSources();

    private native int getNumberOfDestinations();

    private native int getSource(int var1) throws CoreMidiException;

    private native int getDestination(int var1) throws CoreMidiException;

    private native int getUniqueID(int var1) throws CoreMidiException;

    private native CoreMidiDeviceInfo getMidiDeviceInfo(int var1) throws CoreMidiException;

    static {
        try {
            Loader.load();
        }
        catch (Throwable t) {
            System.err.println("Unable to load native library, CoreMIDI4J will stay inactive: " + t);
        }
    }

    private static final class MidiProperties {
        private CoreMidiClient client;
        private CoreMidiOutputPort output;
        private final Map<Integer, MidiDevice> deviceMap = new LinkedHashMap<Integer, MidiDevice>(20);

        private MidiProperties() {
        }
    }
}

