/*
 * Decompiled with CFR 0.152.
 */
package SPITClientGUI;

import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LanguageTools.LiveLanguagePackage.LiveLanguageString;
import MIDIPackage.SPITRemote_MidiObject;
import MIDIPackage.SPITTrigger_MidiObject;
import MIDIPackage.SPIT_MidiObject;
import SPITActionPackage.SPIT_ActionStatus;
import SPITClientPackage.SPIT_Client;
import SPITLibraryPackage.SPIT_Object_Interface;
import SPITLibraryPackage.SPIT_TypeDescription;
import SPITLibraryPackage.SPIT_Type_Interface;
import SwingModelPackage.TableAndListModel;
import SwingToolTipPackage.JLabel_RightClickToolTip;
import SwingToolTipPackage.PopUpToolTip;
import ToolsPackage.EventQueueHandler;
import ToolsPackage.MidiTools;
import ToolsPackage.TimeTools;
import java.awt.Color;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Comparator;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.RowFilter;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;

public class SPITRemote_MidiObjectTableModel
extends TableAndListModel<SPIT_MidiObject>
implements PropertyChangeListener {
    public static final int COLUMNCOUNT = 6;
    public static final int COLUMNINDEX_SPITTYPEGROUPNAME = 0;
    public static final int COLUMNINDEX_SPITTYPENAME = 1;
    public static final int COLUMNINDEX_OBJECTNAME = 2;
    public static final int COLUMNINDEX_SPITOBJECTFRAMESTART = 3;
    public static final int COLUMNINDEX_OBJECTPLAYVALUE = 4;
    public static final int COLUMNINDEX_MIDI_IN = 5;
    @LiveLanguageString
    public static String COLUMN_SPITTYPEGROUPNAME = "Group";
    @LiveLanguageString
    public static String COLUMN_SPITTYPENAME = SPIT_TypeDescription.DEFAULTNAME;
    @LiveLanguageString
    public static String COLUMN_OBJECTNAME = "Name";
    @LiveLanguageString
    public static String COLUMN_SPITOBJECTFRAMESTART = "Name";
    @LiveLanguageString
    public static String COLUMN_OBJECTPLAYVALUE = "Value %";
    @LiveLanguageString
    public static String COLUMN_MIDI = "MIDI";
    public static boolean s_LanguageLoaded = false;
    private TableRowSorter m_TableRowSorter;
    private SPITRowFilter m_SPITRowFilter;
    private final Object m_SyncObject = new Object();
    private StringBuilder m_StringBuilder;
    public SPITRemote_MidiObjectTableModel m_SelfeReference = this;

    public SPITRemote_MidiObjectTableModel() {
        super(false);
        this.initMembers();
        LiveLanguage.addLanguageListener((Object)this, (String)"Midi_Client");
    }

    private void initMembers() {
        this.m_TableRowSorter = new TableRowSorter<SPITRemote_MidiObjectTableModel>(this);
        this.m_StringBuilder = new StringBuilder();
    }

    public void finishJTable(JTable p_JTable) {
        SPITRemote_MidiObjectRenderer o_TableCellEditorRenderer_String;
        if (p_JTable == null) {
            return;
        }
        this.m_TableRowSorter.setComparator(2, new StringComparator_Normal());
        this.m_TableRowSorter.setComparator(3, new StringComparator_Time());
        this.m_SPITRowFilter = new SPITRowFilter(this);
        super.finishJTable(p_JTable, this.m_TableRowSorter, (RowFilter)this.m_SPITRowFilter);
        TableColumnModel o_TableColumnModel = p_JTable.getColumnModel();
        TableColumn o_TableColumn = o_TableColumnModel.getColumn(2);
        if (o_TableColumn != null) {
            o_TableCellEditorRenderer_String = new SPITRemote_MidiObjectRenderer();
            o_TableCellEditorRenderer_String.setToolTipText_Automatic(0);
            o_TableCellEditorRenderer_String.setToolTipTextAt(false, true);
            o_TableColumn.setCellEditor((TableCellEditor)((Object)o_TableCellEditorRenderer_String));
            o_TableColumn.setCellRenderer((TableCellRenderer)((Object)o_TableCellEditorRenderer_String));
        }
        if ((o_TableColumn = o_TableColumnModel.getColumn(0)) != null) {
            o_TableCellEditorRenderer_String = new SPITRemote_MidiObjectRenderer();
            o_TableCellEditorRenderer_String.setToolTipText_Automatic(0);
            o_TableCellEditorRenderer_String.setToolTipTextAt(false, true);
            o_TableColumn.setCellEditor((TableCellEditor)((Object)o_TableCellEditorRenderer_String));
            o_TableColumn.setCellRenderer((TableCellRenderer)((Object)o_TableCellEditorRenderer_String));
        }
        if ((o_TableColumn = o_TableColumnModel.getColumn(1)) != null) {
            o_TableCellEditorRenderer_String = new SPITRemote_MidiObjectRenderer();
            o_TableCellEditorRenderer_String.setToolTipText_Automatic(0);
            o_TableCellEditorRenderer_String.setToolTipTextAt(false, true);
            o_TableColumn.setCellEditor((TableCellEditor)((Object)o_TableCellEditorRenderer_String));
            o_TableColumn.setCellRenderer((TableCellRenderer)((Object)o_TableCellEditorRenderer_String));
        }
        if ((o_TableColumn = o_TableColumnModel.getColumn(3)) != null) {
            o_TableColumn.setMinWidth(110);
            o_TableColumn.setMaxWidth(110);
            o_TableColumn.setPreferredWidth(110);
            o_TableColumn.setResizable(false);
            TableAndListModel.TableCellEditorRenderer_Time o_TableCellEditorRenderer_Time = new TableAndListModel.TableCellEditorRenderer_Time();
            o_TableCellEditorRenderer_Time.setToolTipText_Automatic(1);
            o_TableCellEditorRenderer_Time.setToolTipTextAt(false, true);
            o_TableColumn.setCellEditor((TableCellEditor)o_TableCellEditorRenderer_Time);
            o_TableColumn.setCellRenderer((TableCellRenderer)o_TableCellEditorRenderer_Time);
        }
        if ((o_TableColumn = o_TableColumnModel.getColumn(4)) != null) {
            o_TableColumn.setMinWidth(80);
            o_TableColumn.setMaxWidth(80);
            o_TableColumn.setPreferredWidth(80);
            o_TableColumn.setResizable(false);
            TableAndListModel.TableCellEditorRenderer_Integer o_TableCellEditorRenderer_Integer = new TableAndListModel.TableCellEditorRenderer_Integer();
            o_TableCellEditorRenderer_Integer.setAllowNegativeNumbers(false);
            o_TableCellEditorRenderer_Integer.setToolTipText_Automatic(1);
            o_TableCellEditorRenderer_Integer.setToolTipTextAt(false, true);
            o_TableColumn.setCellEditor((TableCellEditor)o_TableCellEditorRenderer_Integer);
            o_TableColumn.setCellRenderer((TableCellRenderer)o_TableCellEditorRenderer_Integer);
        }
        if ((o_TableColumn = o_TableColumnModel.getColumn(5)) != null) {
            o_TableColumn.setPreferredWidth(80);
            o_TableCellEditorRenderer_String = new TableAndListModel.TableCellEditorRenderer_String();
            o_TableCellEditorRenderer_String.setToolTipText_Automatic(1);
            o_TableCellEditorRenderer_String.setToolTipTextAt(false, true);
            o_TableColumn.setCellEditor((TableCellEditor)((Object)o_TableCellEditorRenderer_String));
            o_TableColumn.setCellRenderer((TableCellRenderer)((Object)o_TableCellEditorRenderer_String));
        }
        p_JTable.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.m_SyncObject;
        synchronized (object) {
            super.clear();
        }
    }

    public void filter(String p_FilterString) {
        if (this.m_SPITRowFilter == null) {
            return;
        }
        this.m_SPITRowFilter.setFilterString(p_FilterString);
    }

    public boolean contains(String p_ID) {
        if (p_ID == null) {
            return false;
        }
        SPIT_MidiObject o_SPIT_MidiObject = this.getSPIT_MidiObject(p_ID);
        return o_SPIT_MidiObject != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SPIT_MidiObject getSPIT_MidiObject(String p_ID) {
        Object object = this.m_SyncObject;
        synchronized (object) {
            for (int intType = 0; intType < this.size(); ++intType) {
                SPIT_MidiObject o_SPIT_MidiObject = (SPIT_MidiObject)this.get(intType);
                if (o_SPIT_MidiObject == null || !p_ID.equals(o_SPIT_MidiObject.getID())) continue;
                return o_SPIT_MidiObject;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addSPIT_MidiObject(SPIT_MidiObject p_SPIT_MidiObject) {
        if (p_SPIT_MidiObject == null) {
            return false;
        }
        if (!(p_SPIT_MidiObject instanceof SPIT_MidiObject)) {
            return false;
        }
        Object object = this.m_SyncObject;
        synchronized (object) {
            if (this.contains(p_SPIT_MidiObject.getID())) {
                this.changedElement(p_SPIT_MidiObject);
                return false;
            }
            this.add(p_SPIT_MidiObject);
            SPIT_Object_Interface o_SPIT_Object_Interface = p_SPIT_MidiObject.getSPIT_Object_Interface();
            if (o_SPIT_Object_Interface != null) {
                o_SPIT_Object_Interface.addPropertyChangeListener(this);
                SPIT_Type_Interface o_SPIT_Type_Interface = o_SPIT_Object_Interface.getSPIT_Type();
                if (o_SPIT_Type_Interface != null) {
                    o_SPIT_Type_Interface.addPropertyChangeListener(this);
                }
            }
            p_SPIT_MidiObject.addPropertyChangeListener(this);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeSPIT_MidiObject(SPIT_MidiObject p_SPIT_MidiObject) {
        boolean boolRemoved;
        if (p_SPIT_MidiObject == null) {
            return false;
        }
        Object object = this.m_SyncObject;
        synchronized (object) {
            boolRemoved = this.remove(p_SPIT_MidiObject);
            SPIT_Object_Interface o_SPIT_Object_Interface = p_SPIT_MidiObject.getSPIT_Object_Interface();
            if (o_SPIT_Object_Interface != null) {
                o_SPIT_Object_Interface.removePropertyChangeListener(this);
                SPIT_Type_Interface o_SPIT_Type_Interface = o_SPIT_Object_Interface.getSPIT_Type();
                if (o_SPIT_Type_Interface != null) {
                    o_SPIT_Type_Interface.removePropertyChangeListener(this);
                }
            }
            p_SPIT_MidiObject.removePropertyChangeListener(this);
        }
        return boolRemoved;
    }

    public void addSelectedSPIT_MidiObject(JTable p_JTable, SPIT_MidiObject p_SPIT_MidiObject) {
        if (p_JTable == null) {
            return;
        }
        if (p_SPIT_MidiObject == null) {
            return;
        }
        super.addSelectedElement(p_JTable, (Object)p_SPIT_MidiObject);
    }

    public void removeSelectedSPIT_MidiObject(JTable p_JTable, SPIT_MidiObject p_SPIT_MidiObject) {
        if (p_JTable == null) {
            return;
        }
        if (p_SPIT_MidiObject == null) {
            return;
        }
        super.removeSelectedElement(p_JTable, (Object)p_SPIT_MidiObject);
    }

    public SPIT_MidiObject getSPIT_MidiObject(int p_Index) {
        if (p_Index < 0) {
            return null;
        }
        return (SPIT_MidiObject)super.get(p_Index);
    }

    public int getColumnCount() {
        return 6;
    }

    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return COLUMN_SPITTYPEGROUPNAME;
            }
            case 1: {
                return COLUMN_SPITTYPENAME;
            }
            case 2: {
                return COLUMN_OBJECTNAME;
            }
            case 3: {
                return COLUMN_SPITOBJECTFRAMESTART;
            }
            case 4: {
                return COLUMN_OBJECTPLAYVALUE;
            }
            case 5: {
                return COLUMN_MIDI;
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValue(SPIT_MidiObject p_SPIT_MidiObject, int columnIndex) {
        String stringValue = "";
        Object o_MIDI_MessageObject = null;
        Object object = this.m_SyncObject;
        synchronized (object) {
            if (p_SPIT_MidiObject == null) {
                return stringValue;
            }
            SPIT_ActionStatus o_SPIT_ActionStatus = p_SPIT_MidiObject.getSPIT_ActionStatus();
            SPIT_Type_Interface o_SPIT_Type_Interface = p_SPIT_MidiObject.getSPIT_Type();
            SPIT_Object_Interface o_SPIT_Object_Interface = p_SPIT_MidiObject.getSPIT_Object_Interface();
            switch (columnIndex) {
                case 0: {
                    if (o_SPIT_Type_Interface == null) {
                        return "";
                    }
                    stringValue = o_SPIT_Type_Interface.getGroupName();
                    break;
                }
                case 1: {
                    if (o_SPIT_Type_Interface == null) {
                        return "";
                    }
                    stringValue = o_SPIT_Type_Interface.getName();
                    break;
                }
                case 2: {
                    stringValue = p_SPIT_MidiObject.getName();
                    break;
                }
                case 3: {
                    if (o_SPIT_Object_Interface == null || SPIT_Client.s_SelfReference.getServerFramesPerSecond() <= 0 || o_SPIT_Object_Interface.getFrameStart() <= 0L) {
                        stringValue = "";
                        break;
                    }
                    long longMilliSeconds = (long)(1000.0 * (double)o_SPIT_Object_Interface.getFrameStart() / (double)SPIT_Client.s_SelfReference.getServerFramesPerSecond());
                    stringValue = TimeTools.getTimeStringFromMillis((long)longMilliSeconds);
                    break;
                }
                case 4: {
                    if (o_SPIT_ActionStatus.getPlayValue() == 0) {
                        stringValue = "";
                        break;
                    }
                    stringValue = String.valueOf((int)((float)o_SPIT_ActionStatus.getPlayValue() * ((float)p_SPIT_MidiObject.getValueFactor() / 1000000.0f) / 10000.0f));
                    break;
                }
                case 5: {
                    o_MIDI_MessageObject = p_SPIT_MidiObject instanceof SPITRemote_MidiObject ? p_SPIT_MidiObject.getMIDI_MessageObject() : (p_SPIT_MidiObject instanceof SPITTrigger_MidiObject ? ((SPITTrigger_MidiObject)p_SPIT_MidiObject).getMIDI_MessageObject(0) : null);
                    if (o_MIDI_MessageObject == null) {
                        stringValue = "";
                        break;
                    }
                    if (o_MIDI_MessageObject.isSet()) {
                        if (o_MIDI_MessageObject.getTypeSub() == 3) {
                            this.m_StringBuilder.delete(0, this.m_StringBuilder.length());
                            this.m_StringBuilder.append("MTC ");
                            if (o_MIDI_MessageObject.getUseTimecodeManual()) {
                                long longMidiTimeSet = o_MIDI_MessageObject.getMidiTimecode().getTimeTrigger();
                                this.m_StringBuilder.append(TimeTools.getTimeStringFromMillis((long)longMidiTimeSet));
                            }
                            stringValue = this.m_StringBuilder.toString();
                            break;
                        }
                        stringValue = o_MIDI_MessageObject.getMessageBytesString();
                        break;
                    }
                    stringValue = "";
                }
            }
            return stringValue;
        }
    }

    public boolean isCellEditable(int row, int col) {
        switch (col) {
            case 0: {
                return false;
            }
            case 2: {
                return false;
            }
            case 3: {
                return false;
            }
            case 4: {
                return false;
            }
            case 1: {
                return false;
            }
            case 5: {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(SPIT_MidiObject p_SPIT_MidiObject, Object value, int col) {
        SPIT_Object_Interface o_SPIT_Object_Interface;
        if (!(value instanceof String)) {
            return;
        }
        Object object = this.m_SyncObject;
        synchronized (object) {
            if (p_SPIT_MidiObject == null) {
                return;
            }
            o_SPIT_Object_Interface = p_SPIT_MidiObject.getSPIT_Object_Interface();
            if (o_SPIT_Object_Interface == null) {
                return;
            }
        }
        switch (col) {
            case 2: {
                String stringValue = (String)value;
                o_SPIT_Object_Interface.setName(stringValue);
                break;
            }
            case 5: {
                String stringValue = ((String)value).trim();
                Object o_MIDI_MessageObject = p_SPIT_MidiObject instanceof SPITRemote_MidiObject ? p_SPIT_MidiObject.getMIDI_MessageObject() : (p_SPIT_MidiObject instanceof SPITTrigger_MidiObject ? ((SPITTrigger_MidiObject)p_SPIT_MidiObject).getMIDI_MessageObject(0) : null);
                if (o_MIDI_MessageObject == null) {
                    return;
                }
                if (stringValue.toLowerCase().startsWith("mtc")) {
                    if (stringValue.length() > 3) {
                        long longTime = TimeTools.getMillisecondsFromString((String)stringValue.substring(3, stringValue.length()));
                        p_SPIT_MidiObject.setManuallyMidiTimecode_Trigger(longTime);
                        p_SPIT_MidiObject.setManuallyUseTimecodeManual(true);
                    } else {
                        p_SPIT_MidiObject.setManuallyUseTimecodeManual(false);
                    }
                } else {
                    byte[] o_Bytes = MidiTools.getBytesFromString((String)stringValue, (boolean)true);
                    p_SPIT_MidiObject.setMessageBytes(o_Bytes, 0);
                }
                p_SPIT_MidiObject.notifyChangedOutside(0);
                break;
            }
            default: {
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() instanceof SPIT_Object_Interface) {
            SPIT_MidiObject o_SPIT_MidiObject;
            SPIT_Object_Interface o_SPIT_Object_Interface = (SPIT_Object_Interface)evt.getSource();
            if ("paramchanged".equals(evt.getPropertyName())) {
                SPIT_MidiObject o_SPIT_MidiObject2 = this.getSPIT_MidiObject(o_SPIT_Object_Interface.getID());
                if (o_SPIT_MidiObject2 != null) {
                    this.changedElement(o_SPIT_MidiObject2);
                    this.sort();
                }
            } else if ("confirmed".equals(evt.getPropertyName()) && (o_SPIT_MidiObject = this.getSPIT_MidiObject(o_SPIT_Object_Interface.getID())) != null) {
                this.changedElement(o_SPIT_MidiObject);
                this.sort();
            }
        } else if (evt.getSource() instanceof SPIT_Type_Interface) {
            SPIT_Type_Interface o_SPIT_Type_Interface = (SPIT_Type_Interface)evt.getSource();
            Object object = this.m_SyncObject;
            synchronized (object) {
                for (int intObject = 0; intObject < this.size(); ++intObject) {
                    SPIT_MidiObject o_SPIT_MidiObject = (SPIT_MidiObject)this.get(intObject);
                    if (o_SPIT_MidiObject == null || o_SPIT_MidiObject.getSPIT_Type() != o_SPIT_Type_Interface) continue;
                    this.changedElement(o_SPIT_MidiObject);
                }
                this.sort();
            }
        } else if (evt.getSource() instanceof SPIT_MidiObject) {
            SPIT_MidiObject o_SPIT_MidiObject = (SPIT_MidiObject)evt.getSource();
            if ("midiObjectChanged".equals(evt.getPropertyName())) {
                this.changedElement(o_SPIT_MidiObject);
                this.sort();
            }
        }
    }

    public void sort() {
        EventQueueHandler.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    if (SPITRemote_MidiObjectTableModel.this.size() > 0) {
                        SPITRemote_MidiObjectTableModel.this.m_TableRowSorter.sort();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    public static class SPITRemote_MidiObjectRenderer
    extends TableAndListModel.TableCellEditorRenderer_String {
        public static Color s_NotConfirmedColor = new Color(100, 0, 0);

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel_RightClickToolTip o_JLabel = (JLabel_RightClickToolTip)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (table.getModel() instanceof SPITRemote_MidiObjectTableModel) {
                SPITRemote_MidiObject o_SPITRemote_MidiObject;
                SPITRemote_MidiObjectTableModel o_TableModel = (SPITRemote_MidiObjectTableModel)((Object)table.getModel());
                try {
                    int intRowModel = table.convertRowIndexToModel(row);
                    o_SPITRemote_MidiObject = (SPITRemote_MidiObject)o_TableModel.getElementAt(intRowModel);
                }
                catch (Exception e) {
                    o_SPITRemote_MidiObject = null;
                    Object var11_13 = null;
                }
                if (o_SPITRemote_MidiObject != null) {
                    String stringToolTip;
                    SPIT_Object_Interface o_SPIT_Object_Interface = o_SPITRemote_MidiObject.getSPIT_Object_Interface();
                    if (o_SPIT_Object_Interface == null || !o_SPIT_Object_Interface.getConfirmed()) {
                        o_JLabel.setBackground(s_NotConfirmedColor);
                    }
                    if ((stringToolTip = o_SPITRemote_MidiObject.getToolTipText()).length() > 0) {
                        o_JLabel.setToolTipText(stringToolTip);
                        o_JLabel.setToolTipText_RightClick(stringToolTip);
                    } else {
                        o_JLabel.setToolTipText(null);
                        o_JLabel.setToolTipText_RightClick(null);
                    }
                }
            }
            return o_JLabel;
        }
    }

    public static class SPITRowFilter
    extends RowFilter<SPIT_MidiObject, Integer> {
        private SPITRemote_MidiObjectTableModel m_SPITRemote_MidiObjectTableModel;
        private String m_FilterString;

        public SPITRowFilter(SPITRemote_MidiObjectTableModel p_SPITRemote_MidiObjectTableModel) {
            this.initMembers();
            this.m_SPITRemote_MidiObjectTableModel = p_SPITRemote_MidiObjectTableModel;
        }

        private void initMembers() {
            this.m_FilterString = null;
        }

        public void setFilterString(String p_FilterString) {
            this.m_FilterString = p_FilterString == null ? "" : p_FilterString.toLowerCase();
            if (this.m_SPITRemote_MidiObjectTableModel != null) {
                this.m_SPITRemote_MidiObjectTableModel.fireTableDataChanged();
            }
        }

        @Override
        public boolean include(RowFilter.Entry entry) {
            if (this.m_SPITRemote_MidiObjectTableModel == null) {
                return false;
            }
            if (this.m_FilterString == null) {
                return true;
            }
            if (this.m_FilterString.length() <= 0) {
                return true;
            }
            int intRow = (Integer)entry.getIdentifier();
            SPIT_MidiObject o_SPIT_MidiObject = this.m_SPITRemote_MidiObjectTableModel.getSPIT_MidiObject(intRow);
            if (o_SPIT_MidiObject == null) {
                return false;
            }
            SPIT_Type_Interface o_SPIT_Type_Interface = o_SPIT_MidiObject.getSPIT_Type();
            if (o_SPIT_Type_Interface == null) {
                return false;
            }
            if (o_SPIT_Type_Interface.getGroupName().toLowerCase().contains(this.m_FilterString)) {
                return true;
            }
            if (o_SPIT_Type_Interface.getName().toLowerCase().contains(this.m_FilterString)) {
                return true;
            }
            if (o_SPIT_MidiObject.getName().toLowerCase().contains(this.m_FilterString)) {
                return true;
            }
            return o_SPIT_MidiObject.getMIDI_MessageObject().getMessageBytesString().contains(this.m_FilterString);
        }
    }

    public static class StringComparator_Time
    implements Comparator<String> {
        @Override
        public int compare(String o1, String o2) {
            Long milli2;
            Long milli1;
            if (o1 == null || o2 == null) {
                return 0;
            }
            try {
                milli1 = TimeTools.getMillisecondsFromString((String)o1);
                milli2 = TimeTools.getMillisecondsFromString((String)o2);
            }
            catch (Exception e) {
                return 0;
            }
            return milli1.compareTo(milli2);
        }
    }

    public static class StringComparator_NumericInteger
    implements Comparator<String> {
        @Override
        public int compare(String o1, String o2) {
            Integer int2;
            Integer int1;
            if (o1 == null || o2 == null) {
                return 0;
            }
            try {
                int1 = Integer.valueOf(o1.trim());
                int2 = Integer.valueOf(o2.trim());
            }
            catch (Exception e) {
                return 0;
            }
            return int1.compareTo(int2);
        }
    }

    public static class StringComparator_Normal
    implements Comparator<String> {
        @Override
        public int compare(String o1, String o2) {
            if (o1 == null || o2 == null) {
                return 0;
            }
            return o1.compareToIgnoreCase(o2);
        }
    }
}

