/*
 * Decompiled with CFR 0.152.
 */
package SPITClientGUI;

import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LanguageTools.LiveLanguagePackage.LiveLanguageString;
import MIDIPackage.MidiDeviceWrapper;
import SwingModelPackage.TableAndListModel;
import SwingToolTipPackage.PopUpToolTip;
import ToolsPackage.EventQueueHandler;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Comparator;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;

public class MidiDevices_TableModel
extends TableAndListModel<MidiDeviceWrapper>
implements PropertyChangeListener {
    public static final int COLUMNCOUNT = 4;
    public static final int COLUMNINDEX_OPENED = 0;
    public static final int COLUMNINDEX_NAME = 1;
    public static final int COLUMNINDEX_VENDOR = 2;
    public static final int COLUMNINDEX_DESCRIPTION = 3;
    @LiveLanguageString
    public static String COLUMN_OPENED = "Open";
    @LiveLanguageString
    public static String COLUMN_NAME = "Name";
    @LiveLanguageString
    public static String COLUMN_VENDOR = "Vendor";
    @LiveLanguageString
    public static String COLUMN_DESCRIPTION = "Description";
    public static double FRAMESPERSECOND = 44100.0;
    private final Object m_SyncObject = new Object();

    public MidiDevices_TableModel() {
        super(false);
        this.initMembers();
        LiveLanguage.addLanguageListener((Object)this, (String)"Midi_Client");
    }

    private void initMembers() {
    }

    public void finishJTable(JTable p_JTable) {
        TableAndListModel.TableCellEditorRenderer_String o_TableCellEditorRenderer_String;
        if (p_JTable == null) {
            return;
        }
        TableRowSorter<MidiDevices_TableModel> o_TableRowSorter = new TableRowSorter<MidiDevices_TableModel>(this);
        o_TableRowSorter.setComparator(3, new StringComparator_Normal());
        super.finishJTable(p_JTable, o_TableRowSorter, null);
        TableColumnModel o_TableColumnModel = p_JTable.getColumnModel();
        TableColumn o_TableColumn = o_TableColumnModel.getColumn(0);
        if (o_TableColumn != null) {
            o_TableColumn.setMinWidth(100);
            o_TableColumn.setMaxWidth(100);
            o_TableColumn.setPreferredWidth(100);
            o_TableColumn.setResizable(false);
            TableAndListModel.TableCellEditorRenderer_CheckBox o_TableCellEditorRenderer_CheckBox = new TableAndListModel.TableCellEditorRenderer_CheckBox();
            o_TableCellEditorRenderer_CheckBox.setToolTipText_Automatic(0);
            o_TableCellEditorRenderer_CheckBox.setToolTipTextAt(true, true);
            o_TableColumn.setCellEditor((TableCellEditor)o_TableCellEditorRenderer_CheckBox);
            o_TableColumn.setCellRenderer((TableCellRenderer)o_TableCellEditorRenderer_CheckBox);
        }
        if ((o_TableColumn = o_TableColumnModel.getColumn(1)) != null) {
            o_TableCellEditorRenderer_String = new TableAndListModel.TableCellEditorRenderer_String();
            o_TableCellEditorRenderer_String.setToolTipText_Automatic(1);
            o_TableCellEditorRenderer_String.setToolTipTextAt(false, true);
            o_TableColumn.setCellEditor((TableCellEditor)o_TableCellEditorRenderer_String);
            o_TableColumn.setCellRenderer((TableCellRenderer)o_TableCellEditorRenderer_String);
        }
        if ((o_TableColumn = o_TableColumnModel.getColumn(2)) != null) {
            o_TableCellEditorRenderer_String = new TableAndListModel.TableCellEditorRenderer_String();
            o_TableCellEditorRenderer_String.setToolTipText_Automatic(1);
            o_TableCellEditorRenderer_String.setToolTipTextAt(false, true);
            o_TableColumn.setCellEditor((TableCellEditor)o_TableCellEditorRenderer_String);
            o_TableColumn.setCellRenderer((TableCellRenderer)o_TableCellEditorRenderer_String);
        }
        if ((o_TableColumn = o_TableColumnModel.getColumn(3)) != null) {
            o_TableCellEditorRenderer_String = new TableAndListModel.TableCellEditorRenderer_String();
            o_TableCellEditorRenderer_String.setToolTipText_Automatic(1);
            o_TableCellEditorRenderer_String.setToolTipTextAt(false, true);
            o_TableColumn.setCellEditor((TableCellEditor)o_TableCellEditorRenderer_String);
            o_TableColumn.setCellRenderer((TableCellRenderer)o_TableCellEditorRenderer_String);
        }
        p_JTable.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
    }

    public void clear() {
        super.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<MidiDeviceWrapper> getMIDIDevices() {
        ArrayList o_MIDIDevices;
        Object object = this.m_SyncObject;
        synchronized (object) {
            o_MIDIDevices = this.getElementArrayList_Safe();
        }
        return o_MIDIDevices;
    }

    public boolean addMIDIDevice(MidiDeviceWrapper p_MidiDeviceWrapper) {
        if (p_MidiDeviceWrapper == null) {
            return false;
        }
        if (super.add((Object)p_MidiDeviceWrapper)) {
            p_MidiDeviceWrapper.addPropertyChangeListener((PropertyChangeListener)this);
            return true;
        }
        return false;
    }

    public boolean removeMIDIDevice(MidiDeviceWrapper p_MidiDeviceWrapper) {
        if (p_MidiDeviceWrapper == null) {
            return false;
        }
        if (super.remove((Object)p_MidiDeviceWrapper)) {
            p_MidiDeviceWrapper.removePropertyChangeListener((PropertyChangeListener)this);
            return true;
        }
        return false;
    }

    public MidiDeviceWrapper getMIDIDevice(int p_Index) {
        return (MidiDeviceWrapper)super.get(p_Index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MidiDeviceWrapper getMIDIDevice(Object p_MidiDevice) {
        if (p_MidiDevice == null) {
            return null;
        }
        Object object = this.m_SyncObject;
        synchronized (object) {
            for (int intMidiDevice = 0; intMidiDevice < this.size(); ++intMidiDevice) {
                Object o_MidiDevice;
                MidiDeviceWrapper o_MidiDeviceWrapper = (MidiDeviceWrapper)this.get(intMidiDevice);
                if (o_MidiDeviceWrapper == null || (o_MidiDevice = o_MidiDeviceWrapper.getMidiDevice()) != p_MidiDevice) continue;
                return o_MidiDeviceWrapper;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MidiDeviceWrapper getMIDIDevice(String p_MidiDeviceID) {
        if (p_MidiDeviceID == null) {
            return null;
        }
        Object object = this.m_SyncObject;
        synchronized (object) {
            for (int intMidiDevice = 0; intMidiDevice < this.size(); ++intMidiDevice) {
                MidiDeviceWrapper o_MidiDeviceWrapper = (MidiDeviceWrapper)this.get(intMidiDevice);
                if (o_MidiDeviceWrapper == null) continue;
                Object o_MidiDevice = o_MidiDeviceWrapper.getMidiDevice();
                if (!p_MidiDeviceID.equals(o_MidiDeviceWrapper.getID())) continue;
                return o_MidiDeviceWrapper;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MidiDeviceWrapper getMIDIDevice(String p_Name, String p_ManufacturerName, String p_Description) {
        Object object = this.m_SyncObject;
        synchronized (object) {
            for (int intMidiDevice = 0; intMidiDevice < this.size(); ++intMidiDevice) {
                MidiDeviceWrapper o_MidiDeviceWrapper = (MidiDeviceWrapper)this.get(intMidiDevice);
                if (o_MidiDeviceWrapper == null || p_Name != null && !o_MidiDeviceWrapper.getInterfaceName().equals(p_Name) || p_ManufacturerName != null && !o_MidiDeviceWrapper.getManufacturerName().equals(p_ManufacturerName) || p_Description != null && !o_MidiDeviceWrapper.getDescription().equals(p_Description)) continue;
                return o_MidiDeviceWrapper;
            }
            return null;
        }
    }

    public int getColumnCount() {
        return 4;
    }

    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return COLUMN_OPENED;
            }
            case 1: {
                return COLUMN_NAME;
            }
            case 2: {
                return COLUMN_VENDOR;
            }
            case 3: {
                return COLUMN_DESCRIPTION;
            }
        }
        return "";
    }

    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return Boolean.class;
        }
        return String.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValue(MidiDeviceWrapper p_MidiDeviceWrapper, int columnIndex) {
        String stringValue = "";
        Object object = this.m_SyncObject;
        synchronized (object) {
            switch (columnIndex) {
                case 0: {
                    if (p_MidiDeviceWrapper == null) {
                        return false;
                    }
                    return p_MidiDeviceWrapper.getSelected();
                }
                case 1: {
                    if (p_MidiDeviceWrapper == null) {
                        stringValue = "";
                    }
                    stringValue = p_MidiDeviceWrapper.getInterfaceName();
                    break;
                }
                case 2: {
                    if (p_MidiDeviceWrapper == null) {
                        stringValue = "";
                    }
                    stringValue = p_MidiDeviceWrapper.getManufacturerName();
                    break;
                }
                case 3: {
                    if (p_MidiDeviceWrapper == null) {
                        stringValue = "";
                    }
                    stringValue = p_MidiDeviceWrapper.getDescription();
                }
            }
            return stringValue;
        }
    }

    public boolean isCellEditable(int row, int col) {
        switch (col) {
            case 0: {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(MidiDeviceWrapper p_MidiDeviceWrapper, Object value, int col) {
        Object object = this.m_SyncObject;
        synchronized (object) {
            if (p_MidiDeviceWrapper == null) {
                return;
            }
        }
        switch (col) {
            case 0: {
                if (!(value instanceof Boolean)) {
                    return;
                }
                boolean boolSelected = (Boolean)value;
                p_MidiDeviceWrapper.setSelected(boolSelected);
            }
        }
    }

    @Override
    public void propertyChange(final PropertyChangeEvent evt) {
        if (evt.getSource() instanceof MidiDeviceWrapper) {
            MidiDeviceWrapper o_MidiDeviceWrapper = (MidiDeviceWrapper)evt.getSource();
            if ("propertyselectionChanged".equals(evt.getPropertyName())) {
                this.changedElement(o_MidiDeviceWrapper);
            } else if ("propertyclosed".equals(evt.getPropertyName())) {
                EventQueueHandler.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MidiDevices_TableModel.this.removeMIDIDevice((MidiDeviceWrapper)evt.getSource());
                    }
                });
            } else if ("propertyconnection".equals(evt.getPropertyName())) {
                this.changedElement(o_MidiDeviceWrapper);
            }
        }
    }

    public static class StringComparator_NumericInteger
    implements Comparator<String> {
        @Override
        public int compare(String o1, String o2) {
            Integer int2;
            Integer int1;
            if (o1 == null || o2 == null) {
                return 0;
            }
            try {
                int1 = Integer.valueOf(o1.trim());
                int2 = Integer.valueOf(o2.trim());
            }
            catch (Exception e) {
                return 0;
            }
            return int1.compareTo(int2);
        }
    }

    public static class StringComparator_Normal
    implements Comparator<String> {
        @Override
        public int compare(String o1, String o2) {
            if (o1 == null || o2 == null) {
                return 0;
            }
            return o1.compareToIgnoreCase(o2);
        }
    }
}

