/*
 * Decompiled with CFR 0.152.
 */
package SPITClientGUI;

import LanguageTools.LiveLanguagePackage.LiveLanguage;
import SwingToolTipPackage.PopUpToolTip;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.UIManager;

public class JPanel_MidiByte
extends JPanel {
    private String m_Name;
    private byte m_Byte;
    private int m_ByteMinValue;
    private int m_ByteMaxValue;
    private boolean m_ShowByteValue;
    private Color m_ColorBytes;
    private Color m_ColorIntegers;
    private int m_OffsetInteger;
    private ArrayList<ByteChangeListener> m_ByteChangeListeners;
    private final Object m_SyncListener = new Object();
    private JButton jButton_Minus;
    private JButton jButton_Plus;
    private JLabel jLabel_Name;
    private JTextField jTextField_Byte;

    public JPanel_MidiByte() {
        this.initMembers();
        this.initComponents();
        this.initComponentsFurther();
        LiveLanguage.addLanguageListener((Object)this, (String)"Midi_Client");
        this.refreshGUI();
    }

    private void initMembers() {
        this.m_ByteChangeListeners = new ArrayList();
        this.m_ShowByteValue = true;
        this.m_Byte = 0;
        this.m_ByteMinValue = 0;
        this.m_ByteMaxValue = 255;
        this.m_OffsetInteger = 0;
        this.m_ColorBytes = UIManager.getColor("TextField.foreground");
        this.m_ColorIntegers = Color.BLUE;
        this.m_Name = "ByteField";
    }

    public static String getStringFromByte(byte p_Byte) {
        return String.format("%02X", p_Byte);
    }

    public static byte getByteFromString(String p_ByteString) throws NumberFormatException {
        try {
            int intResult = Integer.parseInt(p_ByteString, 16);
            return (byte)(intResult & 0xFF);
        }
        catch (Exception e) {
            throw new NumberFormatException("Not a byte: " + p_ByteString);
        }
    }

    public static String getStringIntFromByte(byte p_Byte) {
        int intResult = p_Byte & 0xFF;
        return String.valueOf(intResult);
    }

    private void initComponents() {
        this.jTextField_Byte = new JTextField();
        this.jButton_Plus = new JButton();
        this.jButton_Minus = new JButton();
        this.jLabel_Name = new JLabel();
        this.setMinimumSize(new Dimension(150, 24));
        this.setPreferredSize(new Dimension(150, 24));
        this.setLayout(new GridBagLayout());
        this.jTextField_Byte.setHorizontalAlignment(0);
        this.jTextField_Byte.setText("00");
        this.jTextField_Byte.setToolTipText("");
        this.jTextField_Byte.setMinimumSize(new Dimension(40, 24));
        this.jTextField_Byte.setName("");
        this.jTextField_Byte.setPreferredSize(new Dimension(40, 24));
        this.jTextField_Byte.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                JPanel_MidiByte.this.jTextField_ByteFocusLost(evt);
            }
        });
        this.jTextField_Byte.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                JPanel_MidiByte.this.jTextField_ByteKeyPressed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jTextField_Byte, gridBagConstraints);
        this.jButton_Plus.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Icon_Plus.png")));
        this.jButton_Plus.setToolTipText("");
        this.jButton_Plus.setContentAreaFilled(false);
        this.jButton_Plus.setMargin(new Insets(2, 2, 2, 2));
        this.jButton_Plus.setMaximumSize(new Dimension(24, 24));
        this.jButton_Plus.setMinimumSize(new Dimension(24, 24));
        this.jButton_Plus.setPreferredSize(new Dimension(24, 24));
        this.jButton_Plus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanel_MidiByte.this.jButton_PlusActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.add((Component)this.jButton_Plus, gridBagConstraints);
        this.jButton_Minus.setIcon(new ImageIcon(this.getClass().getResource("/IconsPackage/Icon_Minus.png")));
        this.jButton_Minus.setToolTipText("");
        this.jButton_Minus.setContentAreaFilled(false);
        this.jButton_Minus.setMargin(new Insets(2, 2, 2, 2));
        this.jButton_Minus.setMaximumSize(new Dimension(24, 24));
        this.jButton_Minus.setMinimumSize(new Dimension(24, 24));
        this.jButton_Minus.setPreferredSize(new Dimension(24, 24));
        this.jButton_Minus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanel_MidiByte.this.jButton_MinusActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.add((Component)this.jButton_Minus, gridBagConstraints);
        this.jLabel_Name.setHorizontalAlignment(4);
        this.jLabel_Name.setText("jLabel1");
        this.jLabel_Name.setMaximumSize(new Dimension(80, 24));
        this.jLabel_Name.setMinimumSize(new Dimension(80, 24));
        this.jLabel_Name.setName("");
        this.jLabel_Name.setPreferredSize(new Dimension(80, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        this.add((Component)this.jLabel_Name, gridBagConstraints);
    }

    private void initComponentsFurther() {
        this.jTextField_Byte.setToolTipText(null);
        this.jButton_Plus.setToolTipText(null);
        this.jButton_Minus.setToolTipText(null);
        this.jTextField_Byte.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
    }

    private void refreshGUI() {
        this.jLabel_Name.setText(this.m_Name);
        if (this.m_ShowByteValue) {
            this.jTextField_Byte.setText(JPanel_MidiByte.getStringFromByte(this.m_Byte));
            this.jTextField_Byte.setForeground(this.m_ColorBytes);
        } else {
            this.jTextField_Byte.setText(String.valueOf((this.m_Byte & 0xFF) + this.m_OffsetInteger));
            this.jTextField_Byte.setForeground(this.m_ColorIntegers);
        }
    }

    public void setByteValues(boolean p_ShowByteValues) {
        if (this.m_ShowByteValue == p_ShowByteValues) {
            return;
        }
        this.m_ShowByteValue = p_ShowByteValues;
        this.refreshGUI();
        this.firePropertyChange("byteValues", !this.m_ShowByteValue, this.m_ShowByteValue);
    }

    public boolean getBytesValues() {
        return this.m_ShowByteValue;
    }

    public void setByteOffsetInteger(int p_Offset) {
        if (this.m_OffsetInteger == p_Offset) {
            return;
        }
        int oldValue = this.m_OffsetInteger;
        this.m_OffsetInteger = p_Offset;
        this.refreshGUI();
        this.firePropertyChange("byteOffsetInteger", oldValue, this.m_OffsetInteger);
    }

    public int getByteOffsetInteger() {
        return this.m_OffsetInteger;
    }

    public void setByteMinValue(int p_ByteMinValue) {
        if (p_ByteMinValue < 0) {
            p_ByteMinValue = 0;
        }
        if (p_ByteMinValue > 255) {
            p_ByteMinValue = 255;
        }
        int oldValueMin = this.getByteMinValue();
        this.m_ByteMinValue = p_ByteMinValue;
        if ((this.m_Byte & 0xFF) < this.m_ByteMinValue) {
            byte oldValue = this.m_Byte;
            this.m_Byte = (byte)(this.m_ByteMinValue & 0xFF);
            this.refreshGUI();
            this.notifyManuallyChanged(oldValue);
            this.firePropertyChange("byteMinValue", oldValueMin, this.m_ByteMinValue);
        }
        if (this.m_ByteMaxValue < this.m_ByteMinValue) {
            this.setByteMaxValue(this.m_ByteMinValue);
        }
    }

    public int getByteMinValue() {
        return this.m_ByteMinValue;
    }

    public void setByteMaxValue(int p_ByteMaxValue) {
        if (p_ByteMaxValue < 0) {
            p_ByteMaxValue = 0;
        }
        if (p_ByteMaxValue > 255) {
            p_ByteMaxValue = 255;
        }
        int oldValueMax = this.getByteMaxValue();
        this.m_ByteMaxValue = p_ByteMaxValue;
        if ((this.m_Byte & 0xFF) > this.m_ByteMaxValue) {
            byte oldValue = this.m_Byte;
            this.m_Byte = (byte)(this.m_ByteMaxValue & 0xFF);
            this.refreshGUI();
            this.notifyManuallyChanged(oldValue);
            this.firePropertyChange("byteMaxValue", oldValueMax, this.m_ByteMaxValue);
        }
        if (this.m_ByteMinValue > this.m_ByteMaxValue) {
            this.setByteMinValue(this.m_ByteMaxValue);
        }
    }

    public int getByteMaxValue() {
        return this.m_ByteMaxValue;
    }

    public void setByteManually(byte p_Byte) {
        byte oldValue = this.m_Byte;
        this.setByteInt(p_Byte & 0xFF);
        if (oldValue != this.m_Byte) {
            this.notifyManuallyChanged(oldValue);
        }
    }

    public void setByteIntManually(int p_Int) {
        byte oldValue = this.m_Byte;
        this.setByteInt(p_Int);
        if (oldValue != this.m_Byte) {
            this.notifyManuallyChanged(oldValue);
        }
    }

    public void setByte(byte p_Byte) {
        this.setByteInt(p_Byte & 0xFF);
    }

    public byte getByte() {
        return this.m_Byte;
    }

    public void setByteInt(int p_Int) {
        byte oldValueByte = this.m_Byte;
        int oldValueInt = this.m_Byte & 0xFF;
        if (p_Int < this.m_ByteMinValue) {
            p_Int = this.m_ByteMinValue;
        } else if (p_Int > this.m_ByteMaxValue) {
            p_Int = this.m_ByteMaxValue;
        }
        this.m_Byte = (byte)(p_Int & 0xFF);
        this.refreshGUI();
        this.firePropertyChange("byteInt", oldValueInt, this.m_Byte & 0xFF);
        this.firePropertyChange("byte", oldValueByte, this.m_Byte);
    }

    public int getByteInt() {
        return this.m_Byte & 0xFF;
    }

    public void setByteLabel(String p_Name) {
        if (p_Name == null) {
            return;
        }
        String oldValue = this.m_Name;
        this.m_Name = p_Name;
        this.firePropertyChange("byteLabel", oldValue, this.m_Name);
        this.refreshGUI();
    }

    public String getByteLabel() {
        return this.m_Name;
    }

    private void jTextField_ByteFocusLost(FocusEvent evt) {
        try {
            int intByteValue;
            if (this.m_ShowByteValue) {
                byte o_ByteNew = JPanel_MidiByte.getByteFromString(this.jTextField_Byte.getText());
                intByteValue = o_ByteNew & 0xFF;
            } else {
                intByteValue = Integer.parseInt(this.jTextField_Byte.getText());
                intByteValue -= this.m_OffsetInteger;
            }
            this.setByteIntManually(intByteValue);
        }
        catch (Exception e) {
            this.refreshGUI();
        }
    }

    private void jTextField_ByteKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            try {
                int intByteValue;
                if (this.m_ShowByteValue) {
                    byte o_ByteNew = JPanel_MidiByte.getByteFromString(this.jTextField_Byte.getText());
                    intByteValue = o_ByteNew & 0xFF;
                } else {
                    intByteValue = Integer.parseInt(this.jTextField_Byte.getText());
                    intByteValue -= this.m_OffsetInteger;
                }
                this.setByteIntManually(intByteValue);
            }
            catch (Exception e) {
                this.refreshGUI();
            }
        }
    }

    private void jButton_PlusActionPerformed(ActionEvent evt) {
        int intValue = this.m_Byte & 0xFF;
        this.setByteIntManually(++intValue);
    }

    private void jButton_MinusActionPerformed(ActionEvent evt) {
        int intValue = this.m_Byte & 0xFF;
        this.setByteIntManually(--intValue);
    }

    @Override
    public void setEnabled(boolean p_Enabled) {
        this.jTextField_Byte.setEnabled(p_Enabled);
        this.jButton_Minus.setEnabled(p_Enabled);
        this.jButton_Plus.setEnabled(p_Enabled);
        super.setEnabled(p_Enabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addByteChangeListener(ByteChangeListener p_ByteChangeListener) {
        if (p_ByteChangeListener == null) {
            return;
        }
        Object object = this.m_SyncListener;
        synchronized (object) {
            if (this.m_ByteChangeListeners.contains(p_ByteChangeListener)) {
                return;
            }
            this.m_ByteChangeListeners.add(p_ByteChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeByteChangeListener(ByteChangeListener p_ByteChangeListener) {
        if (p_ByteChangeListener == null) {
            return;
        }
        Object object = this.m_SyncListener;
        synchronized (object) {
            this.m_ByteChangeListeners.remove(p_ByteChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyManuallyChanged(byte p_OldValue) {
        ArrayList<ByteChangeListener> o_ByteChangeListeners;
        Object object = this.m_SyncListener;
        synchronized (object) {
            if (this.m_ByteChangeListeners.size() <= 0) {
                return;
            }
            o_ByteChangeListeners = new ArrayList<ByteChangeListener>(this.m_ByteChangeListeners.size());
            o_ByteChangeListeners.addAll(this.m_ByteChangeListeners);
        }
        for (int intListener = 0; intListener < o_ByteChangeListeners.size(); ++intListener) {
            ByteChangeListener o_ByteChangeListener = (ByteChangeListener)o_ByteChangeListeners.get(intListener);
            o_ByteChangeListener.eventManuallyChanged(this, p_OldValue, this.m_Byte);
        }
    }

    public static interface ByteChangeListener {
        public void eventManuallyChanged(JPanel_MidiByte var1, byte var2, byte var3);
    }
}

