/*
 * Decompiled with CFR 0.152.
 */
package MIDIPackage;

import MIDIPackage.MIDI_MessageObject;
import MIDIPackage.SPITRemote_MidiObject;
import SPITActionPackage.SPIT_ActionStatus;
import SPITClientPackage.SPIT_Client;
import SPITLibraryPackage.SPIT_ClientInterface;
import SPITLibraryPackage.SPIT_Object_Interface;
import SPITLibraryPackage.SPIT_Type_Interface;
import SwingModelPackage.SinglePropertyChangeSupport;
import java.beans.PropertyChangeListener;

public class SPIT_MidiObject {
    public static final int MIDIOBJECTPOSITION_START = 0;
    public static final int MIDIOBJECTPOSITION_CONTINOUS = 1;
    public static final int MIDIOBJECTPOSITION_END = 2;
    public static boolean s_IsLearning = false;
    public static final String PROP_CHANGED = "midiObjectChanged";
    public static final String PROP_CHANGEDOUTSIDE = "midiObjectChangedOutside";
    protected SPIT_ClientInterface m_SPIT_Client;
    protected SPIT_Object_Interface m_SPIT_Object_Interface;
    protected MIDI_MessageObject m_MIDI_MessageObject;
    protected SinglePropertyChangeSupport m_SinglePropertyChangeSupport;

    public static void setIsLearning(boolean p_IsLearning) {
        s_IsLearning = p_IsLearning;
    }

    public SPIT_MidiObject(SPIT_ClientInterface p_SPIT_Client) {
        this.initMembers();
        this.m_SPIT_Client = p_SPIT_Client;
    }

    public SPIT_MidiObject(SPIT_Client p_SPIT_Client, SPIT_Object_Interface p_SPIT_Object) {
        this.initMembers();
        this.m_SPIT_Client = p_SPIT_Client;
        this.m_SPIT_Object_Interface = p_SPIT_Object;
    }

    private void initMembers() {
        this.m_SinglePropertyChangeSupport = new SinglePropertyChangeSupport((Object)this);
    }

    public void close() {
        this.m_SPIT_Object_Interface = null;
        this.m_SPIT_Client = null;
        if (this.m_MIDI_MessageObject != null) {
            // empty if block
        }
        this.m_MIDI_MessageObject = null;
    }

    public SPIT_Object_Interface getSPIT_Object_Interface() {
        return this.m_SPIT_Object_Interface;
    }

    public String getID() {
        if (this.m_SPIT_Object_Interface == null) {
            return "";
        }
        return this.m_SPIT_Object_Interface.getID();
    }

    public String getName() {
        if (this.m_SPIT_Object_Interface == null) {
            return "";
        }
        return this.m_SPIT_Object_Interface.getName();
    }

    public String getToolTipText() {
        SPIT_Object_Interface o_SPIT_Object_Interface = this.m_SPIT_Object_Interface;
        if (o_SPIT_Object_Interface == null) {
            return "";
        }
        StringBuilder o_StringBuilder = new StringBuilder();
        o_StringBuilder.append("<html>");
        o_StringBuilder.append("<center>");
        o_StringBuilder.append("<b>");
        o_StringBuilder.append(o_SPIT_Object_Interface.getName());
        o_StringBuilder.append("</b>");
        o_StringBuilder.append("<br>");
        o_StringBuilder.append("<br>");
        SPIT_Type_Interface o_SPIT_Type_Interface = this.getSPIT_Type();
        if (o_SPIT_Type_Interface != null) {
            o_StringBuilder.append(o_SPIT_Type_Interface.getGroupName());
            o_StringBuilder.append("<br>");
            o_StringBuilder.append(o_SPIT_Type_Interface.getName());
            o_StringBuilder.append("<br>");
        }
        o_StringBuilder.append("<br>");
        o_StringBuilder.append(o_SPIT_Object_Interface.getRemark());
        o_StringBuilder.append("<br>");
        o_StringBuilder.append("</center>");
        o_StringBuilder.append("</html>");
        return o_StringBuilder.toString();
    }

    public SPIT_Type_Interface getSPIT_Type() {
        if (this.m_SPIT_Object_Interface == null) {
            return null;
        }
        return this.m_SPIT_Object_Interface.getSPIT_Type();
    }

    public byte getValueUse() {
        if (this.m_SPIT_Object_Interface == null) {
            return 0;
        }
        return this.m_SPIT_Object_Interface.getValueUse();
    }

    public SPIT_ActionStatus getSPIT_ActionStatus() {
        if (this.m_SPIT_Object_Interface == null) {
            return null;
        }
        return this.m_SPIT_Object_Interface.getSPIT_ActionStatus();
    }

    public int getValueFactor() {
        if (this.m_SPIT_Object_Interface == null) {
            return 1000000;
        }
        return this.m_SPIT_Object_Interface.getValueFactor();
    }

    public void setMessageBytes(byte[] p_MessageBytes) {
        MIDI_MessageObject o_MIDI_MessageObject = this.m_MIDI_MessageObject;
        if (o_MIDI_MessageObject == null) {
            return;
        }
        o_MIDI_MessageObject.setMessageBytes(p_MessageBytes);
        this.notifyChanged();
    }

    public void setMessageBytes(byte[] p_MessageBytes, int p_MidiObjectPosition) {
        if (p_MidiObjectPosition != 0) {
            return;
        }
        this.setMessageBytes(p_MessageBytes);
    }

    public byte[] getMessageBytes() {
        MIDI_MessageObject o_MIDI_MessageObject = this.m_MIDI_MessageObject;
        if (o_MIDI_MessageObject == null) {
            return null;
        }
        return o_MIDI_MessageObject.getMessageBytes();
    }

    public void setManuallyMidiTimecode_Trigger(long p_Milliseconds) {
        MIDI_MessageObject o_MIDI_MessageObject = this.m_MIDI_MessageObject;
        if (o_MIDI_MessageObject == null) {
            return;
        }
        if (this instanceof SPITRemote_MidiObject && this.getValueUse() != 0) {
            this.notifyChanged();
            return;
        }
        o_MIDI_MessageObject.setManuallyMidiTimecode_Trigger(p_Milliseconds);
        this.notifyChanged();
    }

    public long getMidiTimecode_Trigger() {
        MIDI_MessageObject o_MIDI_MessageObject = this.m_MIDI_MessageObject;
        if (o_MIDI_MessageObject == null) {
            return -1L;
        }
        return o_MIDI_MessageObject.getMidiTimecode_Trigger();
    }

    public void setManuallyUseTimecodeManual(boolean p_UseTimecodeManual) {
        MIDI_MessageObject o_MIDI_MessageObject = this.m_MIDI_MessageObject;
        if (o_MIDI_MessageObject == null) {
            return;
        }
        if (this instanceof SPITRemote_MidiObject && this.getValueUse() != 0) {
            this.notifyChanged();
            return;
        }
        o_MIDI_MessageObject.setManuallyUseTimecodeManual(p_UseTimecodeManual);
        this.notifyChanged();
    }

    public boolean getUseTimecodeManual() {
        MIDI_MessageObject o_MIDI_MessageObject = this.m_MIDI_MessageObject;
        if (o_MIDI_MessageObject == null) {
            return false;
        }
        return o_MIDI_MessageObject.getUseTimecodeManual();
    }

    public void setUseTriggerObjectValue(boolean p_UseValueFromTrigger) {
        MIDI_MessageObject o_MIDI_MessageObject = this.m_MIDI_MessageObject;
        if (o_MIDI_MessageObject == null) {
            return;
        }
        o_MIDI_MessageObject.setUseTriggerObjectValue(p_UseValueFromTrigger);
        this.notifyChanged();
    }

    public boolean getUseTriggerObjectValue() {
        MIDI_MessageObject o_MIDI_MessageObject = this.m_MIDI_MessageObject;
        if (o_MIDI_MessageObject == null) {
            return false;
        }
        return o_MIDI_MessageObject.getUseTriggerObjectValue();
    }

    public MIDI_MessageObject getMIDI_MessageObject() {
        return this.m_MIDI_MessageObject;
    }

    public void setSPITOperator(int p_Operator) {
        MIDI_MessageObject o_MIDI_MessageObject = this.m_MIDI_MessageObject;
        if (o_MIDI_MessageObject == null) {
            return;
        }
        if (o_MIDI_MessageObject.setSPITOperator(p_Operator)) {
            this.notifyChanged();
        }
        this.notifyChanged();
    }

    public int getSPITOperator() {
        MIDI_MessageObject o_MIDI_MessageObject = this.m_MIDI_MessageObject;
        if (o_MIDI_MessageObject == null) {
            return 2;
        }
        return o_MIDI_MessageObject.getSPITOperator();
    }

    public void setSPITThreshhold(float p_Treshhold) {
        this.setSPITThreshhold((int)(p_Treshhold * 1000000.0f));
    }

    public void setSPITThreshhold(int p_Treshhold) {
        MIDI_MessageObject o_MIDI_MessageObject = this.m_MIDI_MessageObject;
        if (o_MIDI_MessageObject == null) {
            return;
        }
        if (o_MIDI_MessageObject.setThreshhold(p_Treshhold)) {
            this.notifyChanged();
        }
    }

    public float getSPITTreshhold() {
        MIDI_MessageObject o_MIDI_MessageObject = this.m_MIDI_MessageObject;
        if (o_MIDI_MessageObject == null) {
            return 0.0f;
        }
        return o_MIDI_MessageObject.getThreshhold();
    }

    public float getSPITTreshhold_Float() {
        MIDI_MessageObject o_MIDI_MessageObject = this.m_MIDI_MessageObject;
        if (o_MIDI_MessageObject == null) {
            return 0.0f;
        }
        return o_MIDI_MessageObject.getSPITThreshhold_Float();
    }

    public int getSPITValueUsage() {
        MIDI_MessageObject o_MIDI_MessageObject = this.m_MIDI_MessageObject;
        if (o_MIDI_MessageObject == null) {
            return 0;
        }
        return o_MIDI_MessageObject.getSPITValueUsage();
    }

    public void setSPITValueUsage(int p_ValueUsage) {
        MIDI_MessageObject o_MIDI_MessageObject = this.m_MIDI_MessageObject;
        if (o_MIDI_MessageObject == null) {
            return;
        }
        if (o_MIDI_MessageObject.setSPITValueUseage(p_ValueUsage)) {
            this.notifyChanged();
        }
    }

    public float getSPITInDecreasePC() {
        MIDI_MessageObject o_MIDI_MessageObject = this.m_MIDI_MessageObject;
        if (o_MIDI_MessageObject == null) {
            return 0.5f;
        }
        return o_MIDI_MessageObject.getSPITInDecreasePC();
    }

    public void setSPITInDecreasePC(float p_InDecreasePC) {
        MIDI_MessageObject o_MIDI_MessageObject = this.m_MIDI_MessageObject;
        if (o_MIDI_MessageObject == null) {
            return;
        }
        if (o_MIDI_MessageObject.setSPITInDecreasePC(p_InDecreasePC)) {
            this.notifyChanged();
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
        if (p_PropertyChangeListener == null) {
            return;
        }
        this.m_SinglePropertyChangeSupport.addPropertyChangeListener(p_PropertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
        if (p_PropertyChangeListener == null) {
            return;
        }
        this.m_SinglePropertyChangeSupport.removePropertyChangeListener(p_PropertyChangeListener);
    }

    protected void notifyChanged() {
        this.m_SinglePropertyChangeSupport.firePropertyChange(PROP_CHANGED, null, (Object)this);
    }

    public void notifyChangedOutside(int p_MidiObjectPosition) {
        this.m_SinglePropertyChangeSupport.fireIndexedPropertyChange(PROP_CHANGEDOUTSIDE, p_MidiObjectPosition, null, (Object)this);
    }

    public boolean isSet() {
        return false;
    }
}

