/*
 * Decompiled with CFR 0.152.
 */
package MIDIPackage;

import MIDIPackage.MIDI_Devices;
import MIDIPackage.MIDI_MessageObject;
import MIDIPackage.MidiDeviceWrapper;
import MIDIPackage.MidiMessageSender;
import SPITClientGUI.SPITType_MidiObjectTableModel;
import SPITClientPackage.SPIT_Client;
import SPITClientPackage.SPIT_Type;
import SPITLibraryPackage.SPIT_ClientInterface;
import SPITLibraryPackage.SPIT_Type_Interface;
import SwingModelPackage.SinglePropertyChangeSupport;
import ToolsPackage.EventQueueHandler;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.HashMap;

public class SPITType_MidiObject
implements MIDI_MessageObject.MessageContainer,
MidiMessageSender.MidiMessageDeviceContainer,
PropertyChangeListener,
Externalizable {
    public static final int SOFTWAREVERSION = 2;
    public static SPITType_MidiObjectTableModel s_SPITType_MidiObjectTableModel = new SPITType_MidiObjectTableModel();
    public static final String PROP_CHANGED = "midiObjectChanged";
    public static final String PROP_CHANGEDOUTSIDE = "midiObjectChangedOutside";
    public static final String PROP_MIDIDEVICELISTCHANGED = "midiDeviceChanged";
    SPIT_ClientInterface m_SPIT_ClientInterface;
    SPIT_Type_Interface m_SPIT_Type_Interface;
    protected MIDI_MessageObject m_MIDI_MessageObject_Start;
    protected MIDI_MessageObject m_MIDI_MessageObject_Continous;
    protected MIDI_MessageObject m_MIDI_MessageObject_End;
    protected int m_MidiObjectPosition;
    protected ArrayList<String> m_MidiDeviceIDs;
    protected final Object m_SyncMidiDevices = new Object();
    protected SinglePropertyChangeSupport m_SinglePropertyChangeSupport;
    public static HashMap<String, MIDI_MessageObject> s_MIDI_MessageObjects_Start = new HashMap();
    public static HashMap<String, MIDI_MessageObject> s_MIDI_MessageObjects_Continous = new HashMap();
    public static HashMap<String, MIDI_MessageObject> s_MIDI_MessageObjects_End = new HashMap();
    public static HashMap<String, ArrayList<String>> s_Trash_MidiDeviceIds = new HashMap();

    public static void clearTrash() {
        s_MIDI_MessageObjects_Start.clear();
        s_MIDI_MessageObjects_Continous.clear();
        s_MIDI_MessageObjects_End.clear();
        s_Trash_MidiDeviceIds.clear();
    }

    public static void addSPITType_MidiObject(SPIT_ClientInterface p_SPIT_Client, SPIT_Type_Interface p_SPIT_Type_Interface) {
        if (p_SPIT_Type_Interface == null) {
            return;
        }
        if (s_SPITType_MidiObjectTableModel.contains(p_SPIT_Type_Interface.getID())) {
            return;
        }
        SPITType_MidiObject o_SPITType_MidiObject = new SPITType_MidiObject(p_SPIT_Client, p_SPIT_Type_Interface);
        s_SPITType_MidiObjectTableModel.addSPITType_MidiObject(o_SPITType_MidiObject);
    }

    public static void addSPITType_MidiObject_ReadExternal(SPIT_ClientInterface p_SPIT_Client, SPITType_MidiObject p_SPITType_MidiObject) {
        if (p_SPITType_MidiObject == null) {
            return;
        }
        if (s_SPITType_MidiObjectTableModel.contains(p_SPITType_MidiObject.getID())) {
            return;
        }
        s_SPITType_MidiObjectTableModel.addSPITType_MidiObject(p_SPITType_MidiObject);
    }

    public static void removeSPITType_MidiObject(SPIT_Type_Interface p_SPIT_Type_Interface) {
        if (p_SPIT_Type_Interface == null) {
            return;
        }
        SPITType_MidiObject o_SPITType_MidiObject = s_SPITType_MidiObjectTableModel.getSPITType_MidiObject(p_SPIT_Type_Interface.getID());
        if (o_SPITType_MidiObject == null) {
            return;
        }
        s_SPITType_MidiObjectTableModel.removeSPITType_MidiObject(o_SPITType_MidiObject);
    }

    public static int getSPITType_MidiObjectCount() {
        return s_SPITType_MidiObjectTableModel.size();
    }

    public static SPITType_MidiObject getSPITType_MidiObject(int p_Index) {
        SPITType_MidiObject o_SPITType_MidiObject = s_SPITType_MidiObjectTableModel.getSPITType_MidiObject(p_Index);
        return o_SPITType_MidiObject;
    }

    public static SPITType_MidiObject getSPITType_MidiObject(String p_SPIT_Type_ID) {
        if (p_SPIT_Type_ID == null) {
            return null;
        }
        SPITType_MidiObject o_SPITType_MidiObject = s_SPITType_MidiObjectTableModel.getSPITType_MidiObject(p_SPIT_Type_ID);
        return o_SPITType_MidiObject;
    }

    public static void save(ObjectOutput out) throws IOException {
        SPITType_MidiObject.saveSPITTType_MidiObjects(out);
    }

    public static void load(ObjectInput in) throws IOException, ClassNotFoundException {
        SPITType_MidiObject.loadSPITType_MidiObjects(in);
    }

    public static void saveSPITTType_MidiObjects(ObjectOutput out) throws IOException {
        SPITType_MidiObject o_SPITType_MidiObject;
        int intType;
        int intSPITTypeCount = s_SPITType_MidiObjectTableModel.size();
        ArrayList<SPITType_MidiObject> o_SPITType_MidiObjects = new ArrayList<SPITType_MidiObject>(intSPITTypeCount);
        for (intType = 0; intType < intSPITTypeCount; ++intType) {
            o_SPITType_MidiObject = s_SPITType_MidiObjectTableModel.getSPITType_MidiObject(intType);
            if (o_SPITType_MidiObject == null) continue;
            o_SPITType_MidiObjects.add(o_SPITType_MidiObject);
        }
        out.writeInt(2);
        out.writeInt(o_SPITType_MidiObjects.size());
        for (intType = 0; intType < o_SPITType_MidiObjects.size(); ++intType) {
            o_SPITType_MidiObject = (SPITType_MidiObject)o_SPITType_MidiObjects.get(intType);
            o_SPITType_MidiObject.writeExternal(out);
        }
    }

    public static void loadSPITType_MidiObjects(ObjectInput in) throws IOException, ClassNotFoundException {
        int intSoftwareVersion = in.readInt();
        int intObjectCount = in.readInt();
        ArrayList<SPITType_MidiObject> o_SPITType_MidiObjects = new ArrayList<SPITType_MidiObject>(intObjectCount);
        for (int intType = 0; intType < intObjectCount; ++intType) {
            SPITType_MidiObject o_SPITType_MidiObject = new SPITType_MidiObject(SPIT_Client.s_SelfReference);
            o_SPITType_MidiObject.readExternal(in);
            o_SPITType_MidiObjects.add(o_SPITType_MidiObject);
        }
    }

    public SPITType_MidiObject(SPIT_ClientInterface p_SPIT_ClientInterface) {
        this.initMembers();
        this.m_SPIT_ClientInterface = p_SPIT_ClientInterface;
    }

    public SPITType_MidiObject(SPIT_ClientInterface p_SPIT_ClientInterface, SPIT_Type_Interface p_SPIT_Type_Interface) {
        this.initMembers();
        this.initMIDI_MessageObjects(p_SPIT_Type_Interface.getID());
        this.m_SPIT_ClientInterface = p_SPIT_ClientInterface;
        this.m_SPIT_Type_Interface = p_SPIT_Type_Interface;
        this.m_SPIT_Type_Interface.addPropertyChangeListener(this);
    }

    private void initMembers() {
        this.m_MidiDeviceIDs = new ArrayList();
        this.m_SinglePropertyChangeSupport = new SinglePropertyChangeSupport((Object)this);
        this.m_MidiObjectPosition = 0;
    }

    private void initMIDI_MessageObjects(String p_ID) {
        ArrayList<String> o_Midi_DeviceIDs;
        this.m_MIDI_MessageObject_Start = s_MIDI_MessageObjects_Start.get(p_ID);
        if (this.m_MIDI_MessageObject_Start == null) {
            this.m_MIDI_MessageObject_Start = new MIDI_MessageObject();
        }
        this.m_MIDI_MessageObject_Continous = s_MIDI_MessageObjects_Continous.get(p_ID);
        if (this.m_MIDI_MessageObject_Continous == null) {
            this.m_MIDI_MessageObject_Continous = new MIDI_MessageObject();
        }
        this.m_MIDI_MessageObject_End = s_MIDI_MessageObjects_End.get(p_ID);
        if (this.m_MIDI_MessageObject_End == null) {
            this.m_MIDI_MessageObject_End = new MIDI_MessageObject();
        }
        if ((o_Midi_DeviceIDs = s_Trash_MidiDeviceIds.get(p_ID)) != null) {
            for (int intDevice = 0; intDevice < o_Midi_DeviceIDs.size(); ++intDevice) {
                String stringDeviceID = o_Midi_DeviceIDs.get(intDevice);
                if (stringDeviceID == null || this.m_MidiDeviceIDs.contains(stringDeviceID)) continue;
                this.m_MidiDeviceIDs.add(stringDeviceID);
            }
        }
    }

    public void close() {
        ArrayList<String> o_MidiDeviceIDs;
        if (this.m_SPIT_Type_Interface != null) {
            this.m_SPIT_Type_Interface.removePropertyChangeListener(this);
        }
        if (this.m_MIDI_MessageObject_Start != null) {
            s_MIDI_MessageObjects_Start.put(this.getID(), this.m_MIDI_MessageObject_Start);
            this.m_MIDI_MessageObject_Start = null;
        }
        if (this.m_MIDI_MessageObject_Continous != null) {
            s_MIDI_MessageObjects_Continous.put(this.getID(), this.m_MIDI_MessageObject_Continous);
            this.m_MIDI_MessageObject_Continous = null;
        }
        if (this.m_MIDI_MessageObject_End != null) {
            s_MIDI_MessageObjects_End.put(this.getID(), this.m_MIDI_MessageObject_End);
            this.m_MIDI_MessageObject_End = null;
        }
        if ((o_MidiDeviceIDs = s_Trash_MidiDeviceIds.get(this.getID())) == null) {
            o_MidiDeviceIDs = new ArrayList();
        }
        o_MidiDeviceIDs.clear();
        o_MidiDeviceIDs.addAll(this.m_MidiDeviceIDs);
        s_Trash_MidiDeviceIds.put(this.getID(), o_MidiDeviceIDs);
        this.m_SinglePropertyChangeSupport.clear();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(2);
        this.m_SPIT_Type_Interface.writeExternal(out);
        this.m_MIDI_MessageObject_Start.writeExternal(out);
        this.m_MIDI_MessageObject_Continous.writeExternal(out);
        this.m_MIDI_MessageObject_End.writeExternal(out);
        out.writeInt(this.m_MidiDeviceIDs.size());
        for (int intID = 0; intID < this.m_MidiDeviceIDs.size(); ++intID) {
            out.writeUTF(this.m_MidiDeviceIDs.get(intID));
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int intSoftwareVersion = in.readInt();
        SPIT_Type o_SPIT_Type = new SPIT_Type();
        o_SPIT_Type.readExternal(in);
        this.m_SPIT_Type_Interface = o_SPIT_Type;
        this.m_SPIT_Type_Interface.addPropertyChangeListener(this);
        this.initMIDI_MessageObjects(o_SPIT_Type.getID());
        this.m_MIDI_MessageObject_Start.readExternal(in);
        this.m_MIDI_MessageObject_Continous.readExternal(in);
        this.m_MIDI_MessageObject_End.readExternal(in);
        if (intSoftwareVersion >= 2) {
            int intMidiDeviceIDCount = in.readInt();
            for (int intID = 0; intID < intMidiDeviceIDCount; ++intID) {
                String stringID = in.readUTF();
                this.m_MidiDeviceIDs.add(stringID);
            }
        } else {
            EventQueueHandler.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ArrayList<MidiDeviceWrapper> o_MidiDeviceWrappers = MIDI_Devices.getMidiDeviceWrappers_Trigger();
                    for (int intID = 0; intID < MIDI_Devices.s_SelectedDeviceIDs_Trigger.size(); ++intID) {
                        String stringID = MIDI_Devices.s_SelectedDeviceIDs_Trigger.get(intID);
                        SPITType_MidiObject.this.m_MidiDeviceIDs.add(stringID);
                    }
                    for (int intDevice = 0; intDevice < o_MidiDeviceWrappers.size(); ++intDevice) {
                        MidiDeviceWrapper o_MidiDeviceWrapper = o_MidiDeviceWrappers.get(intDevice);
                        if (o_MidiDeviceWrapper == null || !o_MidiDeviceWrapper.getSelected()) continue;
                        SPITType_MidiObject.this.m_MidiDeviceIDs.add(o_MidiDeviceWrapper.getID());
                    }
                }
            });
        }
        this.m_SPIT_Type_Interface.addPropertyChangeListener(this);
        SPITType_MidiObject.addSPITType_MidiObject_ReadExternal(SPIT_Client.s_SelfReference, this);
    }

    public String getID() {
        if (this.m_SPIT_Type_Interface == null) {
            return "";
        }
        return this.m_SPIT_Type_Interface.getID();
    }

    public String getName() {
        if (this.m_SPIT_Type_Interface == null) {
            return "";
        }
        return this.m_SPIT_Type_Interface.getName();
    }

    public SPIT_Type_Interface getSPIT_Type_Interface() {
        return this.m_SPIT_Type_Interface;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMidiDevice(MidiDeviceWrapper p_MidiDeviceWrapper) {
        if (p_MidiDeviceWrapper == null) {
            return;
        }
        Object object = this.m_SyncMidiDevices;
        synchronized (object) {
            if (this.m_MidiDeviceIDs.contains(p_MidiDeviceWrapper)) {
                return;
            }
            this.m_MidiDeviceIDs.add(p_MidiDeviceWrapper.getID());
        }
        this.m_SinglePropertyChangeSupport.firePropertyChange(PROP_MIDIDEVICELISTCHANGED, null, (Object)p_MidiDeviceWrapper.getID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMidiDevice(MidiDeviceWrapper p_MidiDeviceWrapper) {
        if (p_MidiDeviceWrapper == null) {
            return;
        }
        Object object = this.m_SyncMidiDevices;
        synchronized (object) {
            if (!this.m_MidiDeviceIDs.remove(p_MidiDeviceWrapper.getID())) {
                return;
            }
        }
        this.m_SinglePropertyChangeSupport.firePropertyChange(PROP_MIDIDEVICELISTCHANGED, (Object)p_MidiDeviceWrapper.getID(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMidiDevice(String p_MidiDeviceID) {
        if (p_MidiDeviceID == null) {
            return;
        }
        Object object = this.m_SyncMidiDevices;
        synchronized (object) {
            if (!this.m_MidiDeviceIDs.remove(p_MidiDeviceID)) {
                return;
            }
        }
        this.m_SinglePropertyChangeSupport.firePropertyChange(PROP_MIDIDEVICELISTCHANGED, (Object)p_MidiDeviceID, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearMidiDevices() {
        Object object = this.m_SyncMidiDevices;
        synchronized (object) {
            if (this.m_MidiDeviceIDs.size() <= 0) {
                return;
            }
            this.m_MidiDeviceIDs.clear();
        }
        this.m_SinglePropertyChangeSupport.firePropertyChange(PROP_MIDIDEVICELISTCHANGED, (Object)"", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLearnedMidiDevice(MidiDeviceWrapper p_MidiDeviceWrapper) {
        if (p_MidiDeviceWrapper == null) {
            return;
        }
        String stringLearnedDeviceID = p_MidiDeviceWrapper.getDeviceType() == 1 ? p_MidiDeviceWrapper.getID() : p_MidiDeviceWrapper.getID();
        MidiDeviceWrapper o_MidiDeviceWrapper_Trigger = MIDI_Devices.getMIDIDevice_Trigger(stringLearnedDeviceID);
        if (o_MidiDeviceWrapper_Trigger == null) {
            o_MidiDeviceWrapper_Trigger = MIDI_Devices.getMidiDeviceWrapper_Trigger(p_MidiDeviceWrapper.getInterfaceName(), p_MidiDeviceWrapper.getManufacturerName(), null);
        }
        if (o_MidiDeviceWrapper_Trigger == null) {
            return;
        }
        Object object = this.m_SyncMidiDevices;
        synchronized (object) {
            if (this.m_MidiDeviceIDs.size() == 1 && this.m_MidiDeviceIDs.get(0).equals(o_MidiDeviceWrapper_Trigger.getID())) {
                return;
            }
            this.m_MidiDeviceIDs.clear();
        }
        this.addMidiDevice(o_MidiDeviceWrapper_Trigger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsMidiDevice(MidiDeviceWrapper p_MidiDeviceWrapper) {
        if (p_MidiDeviceWrapper == null) {
            return false;
        }
        Object object = this.m_SyncMidiDevices;
        synchronized (object) {
            if (this.m_MidiDeviceIDs.contains(p_MidiDeviceWrapper.getID())) {
                return true;
            }
        }
        return false;
    }

    public int getMidiDeviceCount() {
        return this.m_MidiDeviceIDs.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMidiDeviceID(int p_Index) {
        if (p_Index < 0) {
            return null;
        }
        Object object = this.m_SyncMidiDevices;
        synchronized (object) {
            if (p_Index >= this.m_MidiDeviceIDs.size()) {
                return null;
            }
            return this.m_MidiDeviceIDs.get(p_Index);
        }
    }

    public ArrayList<String> getMidiDeviceIDs() {
        return this.m_MidiDeviceIDs;
    }

    public void eventMidiDeviceAdded(MidiDeviceWrapper p_MidiDeviceWrapper) {
        if (p_MidiDeviceWrapper == null) {
            return;
        }
        this.m_SinglePropertyChangeSupport.firePropertyChange(PROP_MIDIDEVICELISTCHANGED, null, (Object)p_MidiDeviceWrapper.getID());
    }

    public void eventMidiDeviceRemoved(MidiDeviceWrapper p_MidiDeviceWrapper) {
        if (p_MidiDeviceWrapper == null) {
            return;
        }
        this.m_SinglePropertyChangeSupport.firePropertyChange(PROP_MIDIDEVICELISTCHANGED, null, (Object)p_MidiDeviceWrapper.getID());
    }

    public void setMidiObjectPosition(int p_Position) {
        this.m_MidiObjectPosition = p_Position;
        this.notifyChanged();
    }

    public int getMidiObjectPosition() {
        return this.m_MidiObjectPosition;
    }

    public MIDI_MessageObject getMIDI_MessageObject() {
        if (this.m_MidiObjectPosition < 0 || this.m_MidiObjectPosition > 2) {
            return null;
        }
        return this.getMIDI_MessageObject(this.m_MidiObjectPosition);
    }

    public MIDI_MessageObject getMIDI_MessageObject(int p_MidiObjectPosition) {
        switch (p_MidiObjectPosition) {
            case 0: {
                return this.m_MIDI_MessageObject_Start;
            }
            case 1: {
                return this.m_MIDI_MessageObject_Continous;
            }
            case 2: {
                return this.m_MIDI_MessageObject_End;
            }
        }
        return this.m_MIDI_MessageObject_Continous;
    }

    public void setMessageBytes(byte[] p_MessageBytes) {
        this.setMessageBytes(p_MessageBytes, this.m_MidiObjectPosition);
    }

    public void setMessageBytes(byte[] p_MessageBytes, int p_MidiObjectPosition) {
        MIDI_MessageObject o_MIDI_MessageObject = this.getMIDI_MessageObject(p_MidiObjectPosition);
        if (o_MIDI_MessageObject != null) {
            o_MIDI_MessageObject.setMessageBytes(p_MessageBytes);
        }
        this.notifyChanged();
    }

    public byte[] getMessageBytes() {
        return this.getMessageBytes(this.m_MidiObjectPosition);
    }

    public byte[] getMessageBytes(int p_MidiObjectPosition) {
        MIDI_MessageObject o_MIDI_MessageObject = this.getMIDI_MessageObject(p_MidiObjectPosition);
        if (o_MIDI_MessageObject != null) {
            return o_MIDI_MessageObject.getMessageBytes();
        }
        return null;
    }

    public void setManuallyMidiTimecode_Trigger(long p_Milliseconds, int p_MidiObjectPosition) {
        MIDI_MessageObject o_MIDI_MessageObject = this.getMIDI_MessageObject(p_MidiObjectPosition);
        o_MIDI_MessageObject.setManuallyMIDI_ElementShort(MIDI_MessageObject.s_MIDI_ElementShort_Timecode);
        o_MIDI_MessageObject.setMidiTimeCode_Trigger(p_Milliseconds);
    }

    public void setMidiTimecode_Trigger(long p_Milliseconds) {
        this.setMidiTimecode(p_Milliseconds, this.m_MidiObjectPosition);
    }

    public long getMidiTimecode_Trigger() {
        return this.getMidiTimecode_Trigger(this.m_MidiObjectPosition);
    }

    public long getMidiTimecode_Trigger(int p_MidiObjectPosition) {
        MIDI_MessageObject o_MIDI_MessageObject = this.getMIDI_MessageObject(p_MidiObjectPosition);
        if (o_MIDI_MessageObject != null) {
            return o_MIDI_MessageObject.getMidiTimecode_Trigger();
        }
        return -1L;
    }

    public void setMidiTimecode(long p_Milliseconds, int p_MidiObjectPosition) {
        MIDI_MessageObject o_MIDI_MessageObject = this.getMIDI_MessageObject(p_MidiObjectPosition);
        if (o_MIDI_MessageObject != null) {
            o_MIDI_MessageObject.setMidiTimeCode_Trigger(p_Milliseconds);
        }
        this.notifyChanged();
    }

    public void setMidiTimecode_ObjectStart(long p_Milliseconds) {
        this.setMidiTimecode_ObjectStart(p_Milliseconds, this.m_MidiObjectPosition);
    }

    public void setMidiTimecode_ObjectStart(long p_Milliseconds, int p_MidiObjectPosition) {
        MIDI_MessageObject o_MIDI_MessageObject = this.getMIDI_MessageObject(p_MidiObjectPosition);
        if (o_MIDI_MessageObject != null) {
            o_MIDI_MessageObject.setMidiTimecode_ObjectStart(p_Milliseconds);
        }
        this.notifyChanged();
    }

    public long getMidiTimecode_ObjectStart() {
        return this.getMidiTimecode_ObjectStart(this.m_MidiObjectPosition);
    }

    public long getMidiTimecode_ObjectStart(int p_MidiObjectPosition) {
        MIDI_MessageObject o_MIDI_MessageObject = this.getMIDI_MessageObject(p_MidiObjectPosition);
        if (o_MIDI_MessageObject != null) {
            return o_MIDI_MessageObject.getMidiTimecode_ObjectStart();
        }
        return -1L;
    }

    public void setManuallyUseTimecodeManual(boolean p_UseTimecodeManual) {
        MIDI_MessageObject o_MIDI_MessageObject = this.getMIDI_MessageObject(0);
        if (o_MIDI_MessageObject.getTypeSub() != 3) {
            o_MIDI_MessageObject.setManuallyMIDI_ElementShort(MIDI_MessageObject.s_MIDI_ElementShort_Timecode);
        }
        this.setUseTimecodeManual(p_UseTimecodeManual, this.m_MidiObjectPosition);
        this.notifyChanged();
    }

    public void setUseTimecodeManual(boolean p_UseTimecodeManual) {
        this.setUseTimecodeManual(p_UseTimecodeManual, this.m_MidiObjectPosition);
    }

    public void setUseTimecodeManual(boolean p_UseTimecodeManual, int p_MidiObjectPosition) {
        MIDI_MessageObject o_MIDI_MessageObject = this.getMIDI_MessageObject(p_MidiObjectPosition);
        if (o_MIDI_MessageObject != null) {
            o_MIDI_MessageObject.setUseTimecodeManual(p_UseTimecodeManual);
        }
        this.notifyChanged();
    }

    public boolean getUseTimecodeManual() {
        return this.getUseTimecodeManual(this.m_MidiObjectPosition);
    }

    public boolean getUseTimecodeManual(int p_MidiObjectPosition) {
        MIDI_MessageObject o_MIDI_MessageObject = this.getMIDI_MessageObject(p_MidiObjectPosition);
        if (o_MIDI_MessageObject != null) {
            return o_MIDI_MessageObject.getUseTimecodeManual();
        }
        return false;
    }

    public void setUseTriggerObjectValue(boolean p_UseValueFromTrigger) {
        MIDI_MessageObject o_MIDI_MessageObject = this.getMIDI_MessageObject(this.m_MidiObjectPosition);
        if (o_MIDI_MessageObject != null) {
            o_MIDI_MessageObject.setUseTriggerObjectValue(p_UseValueFromTrigger);
        }
    }

    public boolean getUseTriggerObjectValue() {
        MIDI_MessageObject o_MIDI_MessageObject = this.getMIDI_MessageObject(this.m_MidiObjectPosition);
        if (o_MIDI_MessageObject != null) {
            return o_MIDI_MessageObject.getUseTriggerObjectValue();
        }
        return false;
    }

    public void setSPITOperator(int p_Operator) {
        MIDI_MessageObject o_MIDI_MessageObject = this.getMIDI_MessageObject();
        if (o_MIDI_MessageObject == null) {
            return;
        }
        if (o_MIDI_MessageObject.setSPITOperator(p_Operator)) {
            this.notifyChanged();
        }
        this.notifyChanged();
    }

    public int getSPITOperator() {
        MIDI_MessageObject o_MIDI_MessageObject = this.getMIDI_MessageObject();
        if (o_MIDI_MessageObject == null) {
            return 2;
        }
        return o_MIDI_MessageObject.getSPITOperator();
    }

    public void setSPITThreshhold(float p_Treshhold) {
        this.setSPITThreshhold((int)(p_Treshhold * 1000000.0f));
    }

    public void setSPITThreshhold(int p_Treshhold) {
        MIDI_MessageObject o_MIDI_MessageObject = this.getMIDI_MessageObject();
        if (o_MIDI_MessageObject == null) {
            return;
        }
        if (o_MIDI_MessageObject.setThreshhold(p_Treshhold)) {
            this.notifyChanged();
        }
    }

    public float getSPITTreshhold() {
        MIDI_MessageObject o_MIDI_MessageObject = this.getMIDI_MessageObject();
        if (o_MIDI_MessageObject == null) {
            return 0.0f;
        }
        return o_MIDI_MessageObject.getThreshhold();
    }

    public float getSPITTreshhold_Float() {
        MIDI_MessageObject o_MIDI_MessageObject = this.getMIDI_MessageObject();
        if (o_MIDI_MessageObject == null) {
            return 0.0f;
        }
        return o_MIDI_MessageObject.getSPITThreshhold_Float();
    }

    public int getSPITValueUsage() {
        MIDI_MessageObject o_MIDI_MessageObject = this.getMIDI_MessageObject();
        if (o_MIDI_MessageObject == null) {
            return 0;
        }
        return o_MIDI_MessageObject.getSPITValueUsage();
    }

    public void setSPITValueUsage(int p_ValueUsage) {
        MIDI_MessageObject o_MIDI_MessageObject = this.getMIDI_MessageObject();
        if (o_MIDI_MessageObject == null) {
            return;
        }
        if (o_MIDI_MessageObject.setSPITValueUseage(p_ValueUsage)) {
            this.notifyChanged();
        }
    }

    public float getSPITInDecreasePC() {
        MIDI_MessageObject o_MIDI_MessageObject = this.getMIDI_MessageObject();
        if (o_MIDI_MessageObject == null) {
            return 0.5f;
        }
        return o_MIDI_MessageObject.getSPITInDecreasePC();
    }

    public void setSPITInDecreasePC(float p_InDecreasePC) {
        MIDI_MessageObject o_MIDI_MessageObject = this.getMIDI_MessageObject();
        if (o_MIDI_MessageObject == null) {
            return;
        }
        if (o_MIDI_MessageObject.setSPITInDecreasePC(p_InDecreasePC)) {
            this.notifyChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSet() {
        if (this.m_MidiDeviceIDs.size() <= 0) {
            return false;
        }
        Object object = this.m_SyncMidiDevices;
        synchronized (object) {
            for (int intDevice = 0; intDevice < this.m_MidiDeviceIDs.size(); ++intDevice) {
                String stringMidiDeviceID = this.m_MidiDeviceIDs.get(intDevice);
                MidiDeviceWrapper o_MidiDeviceWrapper = MIDI_Devices.getMidiDeviceWrapper_Trigger(stringMidiDeviceID);
                if (o_MidiDeviceWrapper == null) {
                    return false;
                }
                if (o_MidiDeviceWrapper.getSelected() && o_MidiDeviceWrapper.getIsConnected()) continue;
                return false;
            }
        }
        if (this.m_MIDI_MessageObject_Start != null && this.m_MIDI_MessageObject_Start.isSet()) {
            return true;
        }
        if (this.m_MIDI_MessageObject_Continous != null && this.m_MIDI_MessageObject_Continous.isSet()) {
            return true;
        }
        return this.m_MIDI_MessageObject_End != null && this.m_MIDI_MessageObject_End.isSet();
    }

    public void addPropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
        if (p_PropertyChangeListener == null) {
            return;
        }
        this.m_SinglePropertyChangeSupport.addPropertyChangeListener(p_PropertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
        if (p_PropertyChangeListener == null) {
            return;
        }
        this.m_SinglePropertyChangeSupport.removePropertyChangeListener(p_PropertyChangeListener);
    }

    protected void notifyChanged() {
        this.m_SinglePropertyChangeSupport.firePropertyChange(PROP_CHANGED, null, (Object)this);
    }

    public void notifyChangedOutside(int p_MidiObjectPosition) {
        this.m_SinglePropertyChangeSupport.fireIndexedPropertyChange(PROP_CHANGEDOUTSIDE, p_MidiObjectPosition, null, (Object)this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() instanceof SPIT_Type_Interface) {
            if ("paramchanged".equals(evt.getPropertyName())) {
                this.notifyChanged();
            }
            if ("closed".equals(evt.getPropertyName())) {
                SPITType_MidiObject.removeSPITType_MidiObject(this.m_SPIT_Type_Interface);
                this.close();
            }
        }
    }

    public String getToolTipText() {
        StringBuilder o_StringBuilder = new StringBuilder();
        o_StringBuilder.append("<html>");
        o_StringBuilder.append("<center>");
        SPIT_Type_Interface o_SPIT_Type_Interface = this.getSPIT_Type_Interface();
        if (o_SPIT_Type_Interface != null) {
            o_StringBuilder.append(o_SPIT_Type_Interface.getGroupName());
            o_StringBuilder.append("<br>");
        }
        o_StringBuilder.append("<b>");
        o_StringBuilder.append(this.getName());
        o_StringBuilder.append("</b>");
        o_StringBuilder.append("<br>");
        o_StringBuilder.append("</center>");
        o_StringBuilder.append("</html>");
        return o_StringBuilder.toString();
    }
}

