/*
 * Decompiled with CFR 0.152.
 */
package MIDIPackage;

import MIDIPackage.MIDI_Devices;
import MIDIPackage.MIDI_MessageObject;
import MIDIPackage.MidiDeviceWrapper;
import MIDIPackage.MidiMessageListener;
import SwingModelPackage.SinglePropertyChangeSupport;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.SysexMessage;
import javax.sound.midi.Transmitter;
import uk.co.xfactorylibrarians.coremidi4j.CoreMidiDeviceProvider;

public class MidiDevice_Midi
implements MidiDeviceWrapper {
    private static final Object s_SyncRefreshDevices = new Object();
    public static int s_RefreshDevicesWaitTime = 2000;
    private static ArrayList<MidiDevice> s_DetectedMidiDevices = new ArrayList();
    private MidiDevice m_MidiDevice;
    private String m_MidiDeviceID;
    private Receiver m_ReceiverOut;
    private Receiver m_ReceiverIn;
    private MidiMessageListener m_MidiMessageListener;
    private int m_DeviceType;
    private boolean m_Selected;
    private SinglePropertyChangeSupport m_PropertyChangeSupport;
    private static Runnable s_RunnableRefreshDevices;
    private static Thread s_ThreadRefreshDevices;
    private static boolean s_StopRefreshDevices;

    public MidiDevice_Midi(MidiDevice p_MidiDevice, int p_DeviceType) {
        this.initMembers();
        this.m_DeviceType = p_DeviceType;
        this.m_MidiDevice = p_MidiDevice;
        this.m_MidiDeviceID = MidiDevice_Midi.getMidiDeviceID(this.m_MidiDevice);
    }

    private void initMembers() {
        this.m_Selected = false;
        this.m_MidiMessageListener = null;
        this.m_PropertyChangeSupport = new SinglePropertyChangeSupport((Object)this);
    }

    public void close() {
        this.m_PropertyChangeSupport.firePropertyChange("propertyclosed", null, (Object)this);
        this.m_PropertyChangeSupport.clear();
        Receiver o_ReceiverIn = this.m_ReceiverIn;
        if (o_ReceiverIn != null) {
            o_ReceiverIn.close();
        }
        if (this.m_MidiDevice != null) {
            try {
                if (this.m_MidiDevice.isOpen()) {
                    this.m_MidiDevice.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public MidiDevice getMidiDevice() {
        return this.m_MidiDevice;
    }

    public void setDeviceType(int p_DeviceType) {
        if (this.m_DeviceType == p_DeviceType) {
            return;
        }
        this.m_DeviceType = p_DeviceType;
    }

    public int getDeviceType() {
        return this.m_DeviceType;
    }

    public boolean getSelected() {
        return this.m_Selected;
    }

    public void setSelected(boolean p_Selected) {
        if (this.m_Selected == p_Selected) {
            return;
        }
        this.m_Selected = p_Selected;
        MidiDevice o_MidiDevice = this.m_MidiDevice;
        if (o_MidiDevice != null) {
            if (this.m_Selected) {
                try {
                    if (!o_MidiDevice.isOpen()) {
                        o_MidiDevice.open();
                    }
                    if (this.m_DeviceType == 0 || this.m_DeviceType == 2) {
                        this.m_ReceiverOut = o_MidiDevice.getReceiver();
                    }
                    if (this.m_DeviceType == 1 || this.m_DeviceType == 2) {
                        Transmitter o_Transmitter = o_MidiDevice.getTransmitter();
                        this.m_ReceiverIn = new MidiReceiver(this);
                        o_Transmitter.setReceiver(this.m_ReceiverIn);
                    }
                }
                catch (Exception e) {
                    o_MidiDevice.close();
                    this.m_Selected = false;
                    this.m_ReceiverOut = null;
                }
            } else if (o_MidiDevice.isOpen()) {
                Receiver o_Receiver = this.m_ReceiverOut;
                if (o_Receiver != null) {
                    this.m_ReceiverOut = null;
                }
                if ((o_Receiver = this.m_ReceiverIn) != null) {
                    o_Receiver.close();
                    this.m_ReceiverIn = null;
                }
            }
        }
        if (this.m_DeviceType == 0 || this.m_DeviceType == 2) {
            MIDI_Devices.setSelectedDeviceID_Trigger(this, this.m_Selected);
            if (this.m_Selected) {
                MIDI_Devices.s_SPIType_MidiDevices_TableModel.addMIDIDevice(this);
            } else {
                MIDI_Devices.s_SPIType_MidiDevices_TableModel.removeMIDIDevice(this);
            }
        }
        if (this.m_DeviceType == 1 || this.m_DeviceType == 2) {
            MIDI_Devices.setSelectedDeviceID_Remote(this, this.m_Selected);
        }
        this.m_PropertyChangeSupport.firePropertyChange("propertyselectionChanged", !this.m_Selected, this.m_Selected);
    }

    public MidiDevice.Info getDeviceInfo() {
        MidiDevice o_MidiDevice = this.m_MidiDevice;
        if (o_MidiDevice == null) {
            return null;
        }
        return o_MidiDevice.getDeviceInfo();
    }

    public String getID() {
        return this.m_MidiDeviceID;
    }

    public String getInterfaceName() {
        if (this.m_MidiDevice == null) {
            return "";
        }
        MidiDevice.Info o_Info = this.m_MidiDevice.getDeviceInfo();
        if (o_Info == null) {
            return "";
        }
        String stringValue = o_Info.getName();
        if (stringValue.startsWith("CoreMIDI4J - ")) {
            stringValue = stringValue.substring("CoreMIDI4J - ".length(), stringValue.length());
        }
        return stringValue;
    }

    public String getManufacturerName() {
        if (this.m_MidiDevice == null) {
            return "";
        }
        MidiDevice.Info o_Info = this.m_MidiDevice.getDeviceInfo();
        if (o_Info == null) {
            return "";
        }
        return o_Info.getVendor();
    }

    public String getDescription() {
        if (this.m_MidiDevice == null) {
            return "";
        }
        MidiDevice.Info o_Info = this.m_MidiDevice.getDeviceInfo();
        if (o_Info == null) {
            return "";
        }
        return o_Info.getDescription();
    }

    public void eventMidiMessageReceived(byte[] p_MessageBytes) {
        if (p_MessageBytes == null) {
            return;
        }
        MidiMessageListener o_MidiMessageListener = this.m_MidiMessageListener;
        if (o_MidiMessageListener == null) {
            return;
        }
        if (!this.m_Selected) {
            return;
        }
        o_MidiMessageListener.eventMidiMessageReceived((MidiDeviceWrapper)this, p_MessageBytes);
    }

    public void setMidiMessageListener(MidiMessageListener p_MessageListener) {
        this.m_MidiMessageListener = p_MessageListener;
    }

    public void send(MIDI_MessageObject p_MIDI_MessageObject, long p_TimeStamp) {
        if (p_MIDI_MessageObject == null) {
            return;
        }
        if (!(p_MIDI_MessageObject instanceof MIDI_MessageObject)) {
            return;
        }
        if (!this.m_Selected) {
            return;
        }
        Receiver o_ReceiverOut = this.m_ReceiverOut;
        if (o_ReceiverOut != null) {
            MidiMessage o_MidiMessage = MidiDevice_Midi.prepareMidiMessage(p_MIDI_MessageObject);
            if (o_MidiMessage == null) {
                return;
            }
            o_ReceiverOut.send(o_MidiMessage, p_TimeStamp);
        }
    }

    private static MidiMessage prepareMidiMessage(MIDI_MessageObject p_MIDI_MessageObject) {
        if (p_MIDI_MessageObject == null) {
            return null;
        }
        MidiMessage o_MidiMessage = null;
        try {
            switch (p_MIDI_MessageObject.getType()) {
                case 1: {
                    if (p_MIDI_MessageObject.getShortStatusByte() == 0) {
                        return null;
                    }
                    o_MidiMessage = new ShortMessage(p_MIDI_MessageObject.getShortStatusByte() & 0xFF, (int)(p_MIDI_MessageObject.getShortData1ToSend() & 0xFF), (int)(p_MIDI_MessageObject.getShortData2ToSend() & 0xFF));
                    break;
                }
                case 2: {
                    if (p_MIDI_MessageObject.getSysexManufacturer() == 0) {
                        return null;
                    }
                    byte[] o_DataBytes = p_MIDI_MessageObject.getMessageBytesToSend();
                    if (o_DataBytes == null || o_DataBytes.length <= 0) {
                        o_MidiMessage = null;
                        break;
                    }
                    o_MidiMessage = new SysexMessage(o_DataBytes, o_DataBytes.length);
                    break;
                }
                default: {
                    o_MidiMessage = null;
                    break;
                }
            }
        }
        catch (Exception e) {
            System.out.println("MidiDevices sendMidiMessage Error: " + e.toString());
            return null;
        }
        return o_MidiMessage;
    }

    public static String getMidiDeviceID(MidiDevice p_MidiDevice) {
        if (p_MidiDevice == null) {
            return "";
        }
        MidiDevice.Info o_Info = p_MidiDevice.getDeviceInfo();
        if (o_Info == null) {
            return "";
        }
        StringBuilder o_StringBuilder = new StringBuilder();
        String stringName = o_Info.getName();
        if (o_Info.getName().startsWith("CoreMIDI4J - ")) {
            o_StringBuilder.append(stringName.substring("CoreMIDI4J - ".length(), stringName.length()));
        } else {
            o_StringBuilder.append(stringName);
        }
        o_StringBuilder.append(" ");
        o_StringBuilder.append(o_Info.getVendor());
        o_StringBuilder.append(" ");
        o_StringBuilder.append(o_Info.getDescription());
        return o_StringBuilder.toString();
    }

    public void addPropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
        if (p_PropertyChangeListener == null) {
            return;
        }
        this.m_PropertyChangeSupport.addPropertyChangeListener(p_PropertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
        if (p_PropertyChangeListener == null) {
            return;
        }
        this.m_PropertyChangeSupport.removePropertyChangeListener(p_PropertyChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeAll() {
        MidiDevice_Midi.stopAutoDetect_MidiDevices();
        Thread o_Thread = s_ThreadRefreshDevices;
        if (o_Thread != null) {
            try {
                o_Thread.join(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Object object = s_SyncRefreshDevices;
        synchronized (object) {
            s_DetectedMidiDevices.clear();
        }
    }

    public static void startAutoDetect_MidiDevices() {
        if (s_RunnableRefreshDevices == null) {
            s_RunnableRefreshDevices = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object;
                    while (!s_StopRefreshDevices) {
                        MidiDevice_Midi.fetchMidiDevices();
                        object = s_SyncRefreshDevices;
                        synchronized (object) {
                            try {
                                long longWaitStart;
                                for (long longWaitTime = (long)s_RefreshDevicesWaitTime; longWaitTime > 0L && !s_StopRefreshDevices; longWaitTime -= System.nanoTime() / 1000000L - longWaitStart) {
                                    longWaitStart = System.nanoTime() / 1000000L;
                                    s_SyncRefreshDevices.wait(longWaitTime);
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    object = s_SyncRefreshDevices;
                    synchronized (object) {
                        s_ThreadRefreshDevices = null;
                    }
                }
            };
        }
        s_ThreadRefreshDevices = new Thread(s_RunnableRefreshDevices);
        s_StopRefreshDevices = false;
        s_ThreadRefreshDevices.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopAutoDetect_MidiDevices() {
        s_StopRefreshDevices = true;
        Object object = s_SyncRefreshDevices;
        synchronized (object) {
            s_SyncRefreshDevices.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fetchMidiDevices() {
        int intDevice;
        Object object;
        MidiDeviceWrapper o_MidiDeviceWrapper_Found;
        MidiDevice.Info[] o_MIDIDevicInfos;
        try {
            o_MIDIDevicInfos = CoreMidiDeviceProvider.getMidiDeviceInfo();
            if (o_MIDIDevicInfos == null) {
                return;
            }
        }
        catch (Exception e) {
            Object o_MIDIDevicInfos2 = null;
            return;
        }
        ArrayList<MidiDeviceWrapper> o_LostDeviceWrappers_Trigger = MIDI_Devices.getMidiDeviceWrappers_Trigger();
        ArrayList<MidiDeviceWrapper> o_LostDeviceWrappers_Remote = MIDI_Devices.getMidiDeviceWrappers_Remote();
        for (int intInfo = 0; intInfo < o_MIDIDevicInfos.length; ++intInfo) {
            boolean boolNew;
            MidiDevice o_MidiDevice;
            o_MidiDeviceWrapper_Found = null;
            MidiDevice_Midi o_MidiDeviceWrapper_New = null;
            MidiDevice o_MidiDevice_Remote = null;
            MidiDevice o_MidiDevice_Trigger = null;
            MidiDevice.Info o_Info = o_MIDIDevicInfos[intInfo];
            if (o_Info == null) continue;
            try {
                o_MidiDevice = MidiSystem.getMidiDevice(o_Info);
                if (o_MidiDevice == null) continue;
                object = s_SyncRefreshDevices;
                synchronized (object) {
                    if (!s_DetectedMidiDevices.contains(o_MidiDevice)) {
                        s_DetectedMidiDevices.add(o_MidiDevice);
                        boolNew = true;
                    } else {
                        boolNew = false;
                    }
                }
            }
            catch (Exception e) {
                continue;
            }
            if (o_MidiDevice.getMaxTransmitters() == 0 && o_MidiDevice.getMaxReceivers() == 0) {
                o_MidiDeviceWrapper_Found = MIDI_Devices.getMIDIDevice_Trigger(o_MidiDevice);
                o_LostDeviceWrappers_Trigger.remove(o_MidiDeviceWrapper_Found);
                o_MidiDeviceWrapper_Found = MIDI_Devices.getMIDIDevice_Remote(o_MidiDevice);
                o_LostDeviceWrappers_Remote.remove(o_MidiDeviceWrapper_Found);
            }
            if (o_MidiDevice.getMaxTransmitters() != 0) {
                o_MidiDeviceWrapper_Found = MIDI_Devices.getMIDIDevice_Remote(o_MidiDevice);
                if (o_MidiDeviceWrapper_Found != null) {
                    o_LostDeviceWrappers_Remote.remove(o_MidiDeviceWrapper_Found);
                    continue;
                }
                o_MidiDeviceWrapper_Found = MIDI_Devices.getMidiDeviceWrapper_Remote(MidiDevice_Midi.getMidiDeviceID(o_MidiDevice));
                if (o_MidiDeviceWrapper_Found != null) {
                    o_LostDeviceWrappers_Remote.remove(o_MidiDeviceWrapper_Found);
                    o_MidiDevice_Remote = o_MidiDevice;
                } else {
                    o_MidiDeviceWrapper_New = new MidiDevice_Midi(o_MidiDevice, 1);
                    MIDI_Devices.addMidiDeviceWrapper_Remote(o_MidiDeviceWrapper_New);
                    MIDI_Devices.checkConnectInfoID_Remote(o_MidiDeviceWrapper_New);
                }
            }
            if (o_MidiDevice.getMaxReceivers() != 0) {
                o_MidiDeviceWrapper_Found = MIDI_Devices.getMIDIDevice_Trigger(o_MidiDevice);
                if (o_MidiDeviceWrapper_Found != null) {
                    o_LostDeviceWrappers_Trigger.remove(o_MidiDeviceWrapper_Found);
                    continue;
                }
                o_MidiDeviceWrapper_Found = MIDI_Devices.getMidiDeviceWrapper_Trigger(MidiDevice_Midi.getMidiDeviceID(o_MidiDevice));
                if (o_MidiDeviceWrapper_Found != null) {
                    o_LostDeviceWrappers_Trigger.remove(o_MidiDeviceWrapper_Found);
                    o_MidiDevice_Trigger = o_MidiDevice;
                } else {
                    o_MidiDeviceWrapper_New = new MidiDevice_Midi(o_MidiDevice, 0);
                    MIDI_Devices.addMidiDeviceWrapper_Trigger(o_MidiDeviceWrapper_New);
                    MIDI_Devices.checkConnectInfoID_Trigger(o_MidiDeviceWrapper_New);
                }
            }
            if (o_MidiDevice_Remote != null && boolNew) {
                object = s_SyncRefreshDevices;
                synchronized (object) {
                    s_DetectedMidiDevices.remove(o_MidiDevice_Remote);
                }
                o_MidiDevice_Remote.close();
            }
            if (o_MidiDevice_Trigger == null || !boolNew) continue;
            object = s_SyncRefreshDevices;
            synchronized (object) {
                s_DetectedMidiDevices.remove(o_MidiDevice_Trigger);
            }
            o_MidiDevice_Trigger.close();
        }
        for (intDevice = 0; intDevice < o_LostDeviceWrappers_Trigger.size(); ++intDevice) {
            o_MidiDeviceWrapper_Found = o_LostDeviceWrappers_Trigger.get(intDevice);
            if (!(o_MidiDeviceWrapper_Found instanceof MidiDevice_Midi)) continue;
            object = s_SyncRefreshDevices;
            synchronized (object) {
                s_DetectedMidiDevices.remove(o_MidiDeviceWrapper_Found.getMidiDevice());
            }
            o_MidiDeviceWrapper_Found.close();
        }
        for (intDevice = 0; intDevice < o_LostDeviceWrappers_Remote.size(); ++intDevice) {
            o_MidiDeviceWrapper_Found = o_LostDeviceWrappers_Remote.get(intDevice);
            if (!(o_MidiDeviceWrapper_Found instanceof MidiDevice_Midi)) continue;
            object = s_SyncRefreshDevices;
            synchronized (object) {
                s_DetectedMidiDevices.remove(o_MidiDeviceWrapper_Found.getMidiDevice());
            }
            o_MidiDeviceWrapper_Found.close();
        }
        o_LostDeviceWrappers_Trigger.clear();
        o_LostDeviceWrappers_Remote.clear();
    }

    public boolean isRemovable() {
        return false;
    }

    public boolean hasProperties() {
        return false;
    }

    public void showPropertyDialog() {
    }

    public boolean getIsConnected() {
        return true;
    }

    public static class MidiReceiver
    implements Receiver {
        private MidiDevice_Midi m_MidiDevice_Midi;

        public MidiReceiver(MidiDevice_Midi p_MidiDevice) {
            this.m_MidiDevice_Midi = p_MidiDevice;
        }

        @Override
        public void send(MidiMessage p_MidiMessage, long p_TimeStamp) {
            if (p_MidiMessage == null) {
                return;
            }
            MidiDevice_Midi o_MidiDevice_Midi = this.m_MidiDevice_Midi;
            if (o_MidiDevice_Midi == null) {
                return;
            }
            o_MidiDevice_Midi.eventMidiMessageReceived(p_MidiMessage.getMessage());
        }

        @Override
        public void close() {
            this.m_MidiDevice_Midi = null;
        }
    }
}

