/*
 * Decompiled with CFR 0.152.
 */
package SPITClientPackage;

import SPITClientPackage.SPIT_Client;
import SPITLibraryPackage.SPIT_ClientInterface;
import SPITLibraryPackage.SPIT_Message;
import TimerPackage.JavaTimer;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;

public class SPIT_ClientSocket {
    private SPIT_Client m_SPITClient;
    private DatagramSocket m_DatagramSocket;
    private InetAddress m_ClientInetAddress;
    private int m_ClientPort;
    private InetAddress m_ServerInetAddress;
    private int m_ServerPort;
    private Runnable m_RunnableReceive;
    private boolean m_StopReceive;
    private Thread m_ThreadReceive;
    private Runnable m_RunnableSend;
    private boolean m_StopSend;
    private Thread m_ThreadSend;
    private final Object m_SyncSendMessage = new Object();
    private final Object m_SyncReceiveMessage = new Object();
    private JavaTimer m_JavaTimer;

    public SPIT_ClientSocket(SPIT_Client p_SPITClient) {
        this.initMembers();
        this.m_SPITClient = p_SPITClient;
    }

    private void initMembers() {
        this.m_DatagramSocket = null;
        this.m_ServerInetAddress = null;
        this.m_ServerPort = 0;
        this.m_ClientInetAddress = null;
        this.m_ClientPort = 0;
        this.m_JavaTimer = new JavaTimer();
        this.m_StopReceive = true;
        this.m_StopSend = true;
        this.initRunnableSend();
        this.initRunnableReceive();
    }

    public void close() {
        if (this.m_JavaTimer != null) {
            this.m_JavaTimer.close();
            this.m_JavaTimer = null;
        }
    }

    public boolean connect(InetAddress p_ServerInetAddress, int p_ServerPort, String p_ClientIP, int p_ClientPort, String p_LoginName, String p_LoginPassword) {
        InetSocketAddress o_InetSocketAddress;
        if (p_ServerInetAddress == null) {
            return false;
        }
        if (p_ServerPort < 0 || p_ServerPort > 65535) {
            return false;
        }
        if (p_ClientPort > 65535) {
            return false;
        }
        this.disconnect();
        SPIT_Client o_SPIT_Client = this.m_SPITClient;
        if (o_SPIT_Client == null) {
            return false;
        }
        o_SPIT_Client.printReport("--- Try Connection ---", "SPIT_ClientSocket try connect to: " + p_ServerInetAddress);
        try {
            this.m_ServerInetAddress = p_ServerInetAddress;
            this.m_ServerPort = p_ServerPort;
            o_InetSocketAddress = new InetSocketAddress(p_ClientIP, p_ClientPort);
            this.m_DatagramSocket = new DatagramSocket(o_InetSocketAddress);
        }
        catch (Exception e) {
            this.m_ServerInetAddress = null;
            this.m_ServerPort = 0;
            this.m_ClientInetAddress = null;
            this.m_ClientPort = 0;
            this.m_DatagramSocket = null;
            o_SPIT_Client.printReport("--- Connection failed ---", "SPIT_ClientSocket connect ERROR: " + e.getMessage());
            return false;
        }
        try {
            this.m_DatagramSocket.setSendBufferSize(524288);
            this.m_DatagramSocket.setReceiveBufferSize(524288);
        }
        catch (Exception e) {
            boolean bl = false;
        }
        this.m_ClientInetAddress = o_InetSocketAddress.getAddress();
        this.m_ClientPort = o_InetSocketAddress.getPort();
        o_SPIT_Client.resetMessageNumberReceived();
        this.m_StopSend = false;
        this.m_ThreadSend = new Thread(this.m_RunnableSend);
        this.m_ThreadSend.start();
        this.m_StopReceive = false;
        this.m_ThreadReceive = new Thread(this.m_RunnableReceive);
        this.m_ThreadReceive.start();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean disconnect() {
        this.m_StopReceive = true;
        Object object = this.m_SyncReceiveMessage;
        synchronized (object) {
            this.m_SyncReceiveMessage.notifyAll();
        }
        DatagramSocket o_DatagramSocket = this.m_DatagramSocket;
        if (o_DatagramSocket == null) {
            return true;
        }
        if (o_DatagramSocket.isClosed()) {
            this.m_DatagramSocket = null;
            return true;
        }
        this.m_StopSend = true;
        object = this.m_SyncSendMessage;
        synchronized (object) {
            this.m_SyncSendMessage.notifyAll();
        }
        if (this.m_ThreadSend != null) {
            try {
                this.m_ThreadSend.join(3000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_ThreadSend = null;
        }
        object = this.m_SyncSendMessage;
        synchronized (object) {
            try {
                if (this.m_DatagramSocket != null) {
                    this.m_DatagramSocket.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_DatagramSocket = null;
        }
        SPIT_Client o_SPITClientInterface = this.m_SPITClient;
        if (o_SPITClientInterface != null) {
            o_SPITClientInterface.printReport("--- Disconnect ---", "SPIT_ClientSocket disconnnected  from Server: " + this.m_ServerInetAddress);
        }
        return true;
    }

    private void initRunnableReceive() {
        this.m_RunnableReceive = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                byte[] o_BytesReceived = new byte[512];
                DatagramPacket o_DatagramPacket = new DatagramPacket(o_BytesReceived, o_BytesReceived.length);
                while (!SPIT_ClientSocket.this.m_StopReceive) {
                    Object object = SPIT_ClientSocket.this.m_SyncReceiveMessage;
                    synchronized (object) {
                        if (SPIT_ClientSocket.this.m_DatagramSocket == null || SPIT_ClientSocket.this.m_DatagramSocket.isClosed()) {
                            SPIT_ClientSocket.this.m_StopReceive = true;
                            continue;
                        }
                    }
                    try {
                        SPIT_ClientSocket.this.m_DatagramSocket.receive(o_DatagramPacket);
                    }
                    catch (SocketTimeoutException e_SocketTimeoutException) {
                        continue;
                    }
                    catch (Exception e) {
                        SPIT_ClientSocket.this.m_StopReceive = true;
                        continue;
                    }
                    SPIT_Client o_SPITClient = SPIT_ClientSocket.this.m_SPITClient;
                    SPIT_Message o_SPIT_Message = SPIT_Message.createSPIT_Message(o_DatagramPacket.getData(), o_DatagramPacket.getLength());
                    if (o_SPIT_Message == null) continue;
                    SPIT_Message.Header o_SPIT_Message_Header = o_SPIT_Message.getHeader();
                    if (o_SPIT_Message_Header == null) {
                        o_SPIT_Message = null;
                        continue;
                    }
                    SPIT_Message.OPPart o_SPIT_Message_OPPart = o_SPIT_Message.getOPPart();
                    if (o_SPIT_Message_OPPart == null) {
                        o_SPIT_Message = null;
                        continue;
                    }
                    if (o_SPITClient == null) continue;
                    o_SPITClient.checkParseSPIT_Message(o_SPIT_Message);
                }
            }
        };
    }

    public int getPort() {
        DatagramSocket o_DatagramSocket = this.m_DatagramSocket;
        if (o_DatagramSocket == null) {
            return 0;
        }
        return this.m_ClientPort;
    }

    public String getIPAddress() {
        DatagramSocket o_DatagramSocket = this.m_DatagramSocket;
        if (o_DatagramSocket == null) {
            return "";
        }
        if (this.m_ClientInetAddress == null) {
            return "";
        }
        String stringIPAddress = SPIT_Client.cleanIPAddress(this.m_ClientInetAddress.getHostAddress());
        return stringIPAddress;
    }

    public InetAddress getInetAddress() {
        DatagramSocket o_DatagramSocket = this.m_DatagramSocket;
        if (o_DatagramSocket == null) {
            return null;
        }
        return this.m_ClientInetAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Exception sendSPIT_Message(SPIT_Message p_SPIT_Message) {
        Exception o_Exception = null;
        if (p_SPIT_Message == null) {
            o_Exception = new SPIT_ClientInterface.Exception_SendSPIT_Message("sendSPIT_Message SPIT_Message is null");
            return o_Exception;
        }
        byte[] o_BytesMessage = p_SPIT_Message.getMessageBytes();
        if (o_BytesMessage == null) {
            o_Exception = new SPIT_ClientInterface.Exception_SendSPIT_Message("sendSPIT_Message SPIT_Message has no MessageBytes");
            return o_Exception;
        }
        byte[] o_BytesSend = SPIT_Message.getDataBytes(p_SPIT_Message.getMessageBytesCount());
        try {
            System.arraycopy(o_BytesMessage, 0, o_BytesSend, 0, o_BytesSend.length);
        }
        catch (Exception e) {
            o_Exception = new SPIT_ClientInterface.Exception_SendSPIT_Message("sendSPIT_Message arraycopy MessageBytes to DatagramPacket array: " + e.getMessage());
            return o_Exception;
        }
        DatagramPacket o_DatagramPacket = new DatagramPacket(o_BytesSend, p_SPIT_Message.getMessageBytesCount(), this.m_ServerInetAddress, this.m_ServerPort);
        Object object = this.m_SyncSendMessage;
        synchronized (object) {
            if (this.m_DatagramSocket == null || this.m_DatagramSocket.isClosed()) {
                o_Exception = new SPIT_ClientInterface.Exception_SendSPIT_Message("sendSPIT_Message DatagramSocket is closed");
                return o_Exception;
            }
            try {
                this.m_DatagramSocket.send(o_DatagramPacket);
            }
            catch (Exception e) {
                o_Exception = e;
            }
        }
        return o_Exception;
    }

    public void sleepSend() {
        JavaTimer o_JavaTimer = this.m_JavaTimer;
        if (o_JavaTimer != null) {
            o_JavaTimer.sleep(5L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifySend() {
        Object object = this.m_SyncSendMessage;
        synchronized (object) {
            this.m_SyncSendMessage.notifyAll();
        }
    }

    private void initRunnableSend() {
        this.m_RunnableSend = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object;
                while (!SPIT_ClientSocket.this.m_StopSend) {
                    object = SPIT_ClientSocket.this.m_SyncSendMessage;
                    synchronized (object) {
                        boolean boolFound = false;
                        boolean boolWaitForConfirmReceive = false;
                        SPIT_Client o_SPITClientInterface = SPIT_ClientSocket.this.m_SPITClient;
                        SPIT_Message o_SPIT_Message = o_SPITClientInterface.getNextSPIT_MessageToSend();
                        if (o_SPITClientInterface.getWaitForConfirmReceive()) {
                            boolWaitForConfirmReceive = true;
                        }
                        if (o_SPIT_Message != null) {
                            boolFound = true;
                            Exception o_Exception = SPIT_ClientSocket.this.sendSPIT_Message(o_SPIT_Message);
                            if (o_Exception == null) {
                                o_SPITClientInterface.successSendSPIT_Message(o_SPIT_Message);
                            } else {
                                o_SPITClientInterface.errorSendSPIT_Message(o_SPIT_Message, o_Exception);
                            }
                            try {
                                if (SPIT_ClientSocket.this.m_JavaTimer != null) {
                                    SPIT_ClientSocket.this.m_JavaTimer.sleep(1L);
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if (SPIT_ClientSocket.this.m_StopSend && !boolFound) {
                            break;
                        }
                        if (!boolFound && !boolWaitForConfirmReceive) {
                            try {
                                SPIT_ClientSocket.this.m_SyncSendMessage.wait(2000L);
                            }
                            catch (Exception exception) {}
                        } else if (!boolFound && boolWaitForConfirmReceive) {
                            try {
                                SPIT_ClientSocket.this.m_SyncSendMessage.wait(200L);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                }
                object = SPIT_ClientSocket.this.m_SyncSendMessage;
                synchronized (object) {
                    try {
                        if (SPIT_ClientSocket.this.m_DatagramSocket != null) {
                            SPIT_ClientSocket.this.m_DatagramSocket.close();
                            SPIT_ClientSocket.this.m_DatagramSocket = null;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        };
    }

    public InetAddress getServerInetAddress() {
        return this.m_ServerInetAddress;
    }

    public String getServerHostAddress() {
        if (this.m_ServerInetAddress == null) {
            return "";
        }
        String stringIPAddress = SPIT_Client.cleanIPAddress(this.m_ServerInetAddress.getHostAddress());
        return stringIPAddress;
    }

    public int getServerPort() {
        return this.m_ServerPort;
    }
}

