/*
 * Decompiled with CFR 0.152.
 */
package SPITClientPackage;

import SPITActionPackage.SPIT_ActionPlayer;
import SPITClientPackage.SPIT_ClientSocket;
import SPITClientPackage.SPIT_Object;
import SPITClientPackage.SPIT_Type;
import SPITLibraryPackage.SPIT_ClientInterface;
import SPITLibraryPackage.SPIT_ClientListener;
import SPITLibraryPackage.SPIT_Message;
import SPITLibraryPackage.SPIT_Object_Interface;
import SPITLibraryPackage.SPIT_Type_Interface;
import SPITLibraryPackage.SPIT_Watchdog;
import SPITModelPackage.SPIT_ObjectModel;
import SPITModelPackage.SPIT_TypeModel;
import SPITRemotePackage.SPITRemote;
import SwingModelPackage.SinglePropertyChangeSupport;
import TimerPackage.JavaTimer;
import java.beans.PropertyChangeListener;
import java.net.InetAddress;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.UUID;

public class SPIT_Client
implements SPIT_ClientInterface {
    public static boolean s_DEBUGON = false;
    public static final int SEND_WAITTIME_NORMAL = 1;
    public static final int SEND_WAITTIME_MUCHMESSAGES = 5;
    public static int s_ConfirmMessagesAfter = 10;
    public static int s_MAX_OVERTAKING_SPIT_MESSAGES = 10;
    private int m_MessageNumber_Send;
    private int m_MessageNumber_Received;
    private int m_ConfirmMessagesAfter;
    private int m_MessageNumber_Confirmed_Received;
    private int m_MessageNumber_Confirmed_Send;
    private ArrayList<SPIT_Message> m_SPIT_MessagesToSend;
    private int m_SPITMessageToSend_Attempts = 0;
    private final Object m_SyncSpitMessagesToSend = new Object();
    private ArrayList<SPIT_Message> m_SPIT_MessagesSended;
    private boolean m_WaitForConfirmReceived = false;
    private long m_WaitForConfirmReceived_Start = -1L;
    private final Object m_SyncMessageNumber = new Object();
    private String m_ID;
    private String m_ClientComputerName;
    private String m_ClientLoginName;
    private String m_ClientLoginPassword;
    private String m_Name;
    private String m_ServerID;
    private String m_ServerComputerName;
    private String m_ServerName;
    private String m_ServerProjectID;
    private String m_ServerProjectName;
    private int m_ServerStepTime;
    private int m_ServerFramesPerSecond;
    private boolean m_Connected;
    private boolean m_Closed;
    private final Object m_SyncClose = new Object();
    private String m_ProjectID;
    private String m_ProjectName;
    private boolean m_IsLoadingProject;
    private boolean m_TransferringProject;
    private ArrayList<SPIT_Message> m_OvertakingSPIT_Messages;
    private SPIT_ClientSocket m_SPIT_ClientSocket;
    private SPIT_Watchdog m_SPIT_Watchdog;
    private JavaTimer m_JavaTimer;
    private ArrayList<SPIT_ClientListener> m_SPITClientListeners;
    private final Object m_SyncListener = new Object();
    public static SPIT_Client s_SelfReference;
    private static SinglePropertyChangeSupport s_SinglePropertyChangeSupport;
    public static boolean s_IsLoadingProject;

    public static SinglePropertyChangeSupport getPropertyChangeSupport() {
        return s_SinglePropertyChangeSupport;
    }

    public SPIT_Client(String p_ClientName) {
        s_SelfReference = this;
        this.initMembers();
        this.m_Name = p_ClientName;
        this.m_SPIT_ClientSocket = new SPIT_ClientSocket(this);
    }

    private void initMembers() {
        this.m_Closed = false;
        this.m_ID = UUID.randomUUID().toString();
        this.m_MessageNumber_Send = 1;
        this.m_MessageNumber_Received = -1;
        this.m_MessageNumber_Confirmed_Received = -1;
        this.m_MessageNumber_Confirmed_Send = -1;
        this.m_ClientLoginName = "";
        this.m_ClientLoginPassword = "";
        this.m_ProjectID = "";
        this.m_ProjectName = "";
        this.m_IsLoadingProject = false;
        this.m_ServerID = "";
        this.m_Name = this.getClass().getSimpleName();
        try {
            this.m_ClientComputerName = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            this.m_ClientComputerName = "";
        }
        this.m_ServerComputerName = "";
        this.m_ServerName = "";
        this.m_ServerProjectID = "";
        this.m_ServerProjectName = "";
        this.m_ServerStepTime = -1;
        this.m_Connected = false;
        this.m_SPITClientListeners = new ArrayList();
        this.m_SPIT_Watchdog = new SPIT_Watchdog(this);
        this.m_SPIT_MessagesToSend = new ArrayList();
        this.m_ConfirmMessagesAfter = 0;
        this.m_SPIT_MessagesSended = new ArrayList();
        this.m_OvertakingSPIT_Messages = new ArrayList();
        this.m_SPITMessageToSend_Attempts = 0;
        this.m_WaitForConfirmReceived = false;
        this.m_WaitForConfirmReceived_Start = -1L;
        this.m_JavaTimer = new JavaTimer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.m_SyncClose;
        synchronized (object) {
            if (this.m_Closed) {
                return;
            }
            this.m_Closed = true;
        }
        SPIT_Client.eventCloseProject_Client(this.m_ProjectID);
        this.disconnect(false);
        if (this.m_SPIT_ClientSocket != null) {
            this.m_SPIT_ClientSocket.close();
        }
    }

    public boolean connect(InetAddress p_ServerInetAddress, int p_ServerPort, String p_ClientIP, int p_ClientPort, String p_LoginName, String p_LoginPassword) {
        boolean boolConnectTry_OK = this.m_SPIT_ClientSocket.connect(p_ServerInetAddress, p_ServerPort, p_ClientIP, p_ClientPort, p_LoginName, p_LoginPassword);
        if (boolConnectTry_OK) {
            this.setClientConnectionParams(this.m_ID, p_LoginName, p_LoginPassword);
            this.setConfirmAfter((byte)0);
            SPIT_Message o_SPIT_Message_Connect = SPIT_Message.createConnect(this.getClientComputerName(), this.getName(), p_LoginName, p_LoginPassword, SPIT_Client.cleanIPAddress(p_ServerInetAddress.getHostAddress()), p_ServerPort);
            o_SPIT_Message_Connect.getHeader().setServerID(this.m_ServerID);
            o_SPIT_Message_Connect.getHeader().setClientID(this.m_ID);
            o_SPIT_Message_Connect.getHeader().setMessageNumber((byte)0);
            this.m_MessageNumber_Send = 1;
            this.m_WaitForConfirmReceived = false;
            this.m_SPIT_ClientSocket.sendSPIT_Message(o_SPIT_Message_Connect);
        } else {
            this.setClientConnectionParams(this.m_ID, "", "");
        }
        return boolConnectTry_OK;
    }

    public boolean connectConfirmed(InetAddress p_ServerInetAddress, int p_ServerPort, String p_ClientIP, int p_ClientPort, String p_LoginName, String p_LoginPassword) {
        boolean boolConnectTry_OK = this.m_SPIT_ClientSocket.connect(p_ServerInetAddress, p_ServerPort, p_ClientIP, p_ClientPort, p_LoginName, p_LoginPassword);
        if (boolConnectTry_OK) {
            this.setClientConnectionParams(this.m_ID, p_LoginName, p_LoginPassword);
            this.setConfirmAfter((byte)s_ConfirmMessagesAfter);
            SPIT_Message o_SPIT_Message_Connect = SPIT_Message.createConnectConfirm(this.getClientComputerName(), this.getName(), p_LoginName, p_LoginPassword, SPIT_Client.cleanIPAddress(p_ServerInetAddress.getHostAddress()), p_ServerPort, (byte)this.m_ConfirmMessagesAfter);
            o_SPIT_Message_Connect.getHeader().setServerID(this.m_ServerID);
            o_SPIT_Message_Connect.getHeader().setClientID(this.m_ID);
            o_SPIT_Message_Connect.getHeader().setMessageNumber((byte)0);
            this.m_MessageNumber_Send = 1;
            this.m_WaitForConfirmReceived = false;
            this.m_SPIT_ClientSocket.sendSPIT_Message(o_SPIT_Message_Connect);
        } else {
            this.setClientConnectionParams(this.m_ID, "", "");
        }
        return boolConnectTry_OK;
    }

    @Override
    public void setClientConnectionParams(String p_ClientID, String p_ClientLoginName, String p_ClientLoginPassword) {
        this.m_ClientLoginName = p_ClientLoginName;
        this.m_ClientLoginPassword = p_ClientLoginPassword;
    }

    public boolean disconnect(boolean p_ConnectionLost) {
        if (this.m_SPIT_ClientSocket == null) {
            return false;
        }
        this.setConnected(false);
        this.sendDisconnect();
        this.clearSPIT_MessagesToSend();
        this.m_SPIT_Watchdog.stopWatchdog();
        SPIT_Type.unconfirmeAll();
        SPIT_Object.unconfirmeAll();
        SPITRemote.unconfirmeAll();
        boolean boolDisconnected = this.m_SPIT_ClientSocket.disconnect();
        this.notifyDisconnected(p_ConnectionLost);
        this.m_TransferringProject = false;
        this.setClientConnectionParams(this.m_ID, "", "");
        return boolDisconnected;
    }

    public boolean sendDisconnect() {
        SPIT_ClientSocket o_SPITClientSocket = this.m_SPIT_ClientSocket;
        if (o_SPITClientSocket != null) {
            SPIT_Message o_SPIT_Message = SPIT_Message.createDisconnect();
            o_SPIT_Message.getHeader().setServerID(this.getServerID());
            o_SPIT_Message.getHeader().setClientID(this.getClientID());
            o_SPIT_Message.getHeader().setMessageNumber((byte)0);
            if (o_SPITClientSocket.sendSPIT_Message(o_SPIT_Message) == null) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void setConnected(boolean p_Connected) {
        this.m_Connected = p_Connected;
    }

    @Override
    public boolean isConnected() {
        return this.m_Connected;
    }

    @Override
    public String getClientID() {
        return this.m_ID;
    }

    @Override
    public String getClientLoginName() {
        return this.m_ClientLoginName;
    }

    @Override
    public String getClientLoginPassword() {
        return this.m_ClientLoginPassword;
    }

    @Override
    public String getClientComputerName() {
        return this.m_ClientComputerName;
    }

    public void setName(String p_ClientName) {
        if (p_ClientName == null) {
            p_ClientName = this.getClass().getSimpleName();
        }
        this.m_Name = p_ClientName;
    }

    @Override
    public String getName() {
        return this.m_Name;
    }

    @Override
    public String getServerIP() {
        SPIT_ClientSocket o_SPIT_ClientSocket = this.m_SPIT_ClientSocket;
        if (o_SPIT_ClientSocket == null) {
            return "";
        }
        return o_SPIT_ClientSocket.getServerHostAddress();
    }

    @Override
    public int getServerPort() {
        SPIT_ClientSocket o_SPIT_ClientSocket = this.m_SPIT_ClientSocket;
        if (o_SPIT_ClientSocket == null) {
            return 0;
        }
        return o_SPIT_ClientSocket.getServerPort();
    }

    @Override
    public String getServerID() {
        return this.m_ServerID;
    }

    @Override
    public String getServerComputerName() {
        return this.m_ServerComputerName;
    }

    @Override
    public void setServerProjectName(String p_ServerProjectName) {
        if (p_ServerProjectName == null) {
            p_ServerProjectName = "";
        }
        this.m_ServerProjectName = p_ServerProjectName;
    }

    @Override
    public String getServerProjectName() {
        return this.m_ServerProjectName;
    }

    @Override
    public String getServerName() {
        return this.m_ServerName;
    }

    @Override
    public int getServerStepTime() {
        return this.m_ServerStepTime;
    }

    @Override
    public int getServerFramesPerSecond() {
        return this.m_ServerFramesPerSecond;
    }

    @Override
    public InetAddress getInetAddress() {
        SPIT_ClientSocket o_SPIT_ClientSocket = this.m_SPIT_ClientSocket;
        if (o_SPIT_ClientSocket == null) {
            return null;
        }
        return o_SPIT_ClientSocket.getInetAddress();
    }

    @Override
    public String getIPAddress() {
        SPIT_ClientSocket o_SPIT_ClientSocket = this.m_SPIT_ClientSocket;
        if (o_SPIT_ClientSocket == null) {
            return "";
        }
        return o_SPIT_ClientSocket.getIPAddress();
    }

    @Override
    public int getPort() {
        SPIT_ClientSocket o_Spit_ClientSocket = this.m_SPIT_ClientSocket;
        if (o_Spit_ClientSocket == null) {
            return 0;
        }
        return o_Spit_ClientSocket.getPort();
    }

    public SPIT_ClientSocket getSPIT_ClientSocket() {
        return this.m_SPIT_ClientSocket;
    }

    @Override
    public void setClientProjectID(String p_ProjectID) {
        if (p_ProjectID == null) {
            p_ProjectID = "";
        }
        if (this.m_ProjectID.equals(p_ProjectID)) {
            return;
        }
        this.m_ProjectID = p_ProjectID;
    }

    @Override
    public String getClientProjectID() {
        return this.m_ProjectID;
    }

    @Override
    public void setClientProjectName(String p_ProjectName) {
        if (p_ProjectName == null) {
            p_ProjectName = "";
        }
        if (this.m_ProjectName.equals(p_ProjectName)) {
            return;
        }
        this.m_ProjectName = p_ProjectName;
        SPIT_Message o_SPIT_Message = SPIT_Message.createReportSPITProject(this.m_ProjectID, p_ProjectName, this.m_ServerFramesPerSecond);
        this.sendSPIT_Message(o_SPIT_Message);
    }

    @Override
    public String getClientProjectName() {
        return this.m_ProjectName;
    }

    public void setIsLoadingProject(boolean p_IsLoadingProject) {
        this.m_IsLoadingProject = p_IsLoadingProject;
    }

    public boolean getIsLoadingProject() {
        return this.m_IsLoadingProject;
    }

    @Override
    public void setConfirmAfter(byte p_ConfirmAfter) {
        this.m_ConfirmMessagesAfter = p_ConfirmAfter & 0xFF;
        if (s_MAX_OVERTAKING_SPIT_MESSAGES < this.m_ConfirmMessagesAfter) {
            s_MAX_OVERTAKING_SPIT_MESSAGES = this.m_ConfirmMessagesAfter;
        }
    }

    public void setConfirmAfter_Int(int p_ConfirmAfter) {
        if (p_ConfirmAfter < 0) {
            p_ConfirmAfter = 0;
        }
        if (p_ConfirmAfter > 255) {
            p_ConfirmAfter = 255;
        }
        this.m_ConfirmMessagesAfter = p_ConfirmAfter;
        if (s_MAX_OVERTAKING_SPIT_MESSAGES < this.m_ConfirmMessagesAfter) {
            s_MAX_OVERTAKING_SPIT_MESSAGES = this.m_ConfirmMessagesAfter;
        }
    }

    @Override
    public byte getConfirmAfter() {
        return (byte)(this.m_ConfirmMessagesAfter & 0xFF);
    }

    public int getConfirmAfter_Int() {
        return this.m_ConfirmMessagesAfter;
    }

    @Override
    public void resetMessageNumberReceived() {
        this.m_MessageNumber_Received = -1;
        this.m_MessageNumber_Confirmed_Received = -1;
        this.m_OvertakingSPIT_Messages.clear();
        this.m_MessageNumber_Confirmed_Send = -1;
    }

    @Override
    public int getMessageNumberReceived() {
        return this.m_MessageNumber_Received;
    }

    @Override
    public void setMessageNumberReceived(int p_MessageNumber, boolean p_SendConfirmReceivedDirect) {
        if (p_MessageNumber == 0) {
            return;
        }
        this.m_MessageNumber_Received = p_MessageNumber > 255 || p_MessageNumber < 0 ? 0 : p_MessageNumber;
        if (this.m_ConfirmMessagesAfter > 0) {
            int intDiff;
            if (this.m_MessageNumber_Confirmed_Received < 0) {
                this.m_MessageNumber_Confirmed_Received = this.m_MessageNumber_Received;
            }
            if ((intDiff = this.diffMessageNumber(this.m_MessageNumber_Confirmed_Received, this.m_MessageNumber_Received)) >= this.m_ConfirmMessagesAfter - 1 || p_SendConfirmReceivedDirect) {
                this.sendConfirmReceived(this.m_MessageNumber_Received, 0);
            }
        }
    }

    private int diffMessageNumber(int p_NumberOld, int p_NumberNew) {
        int intDiff = p_NumberNew - p_NumberOld;
        if (intDiff > 127) {
            intDiff = p_NumberNew - (p_NumberOld + 255);
        }
        if (intDiff < -127) {
            intDiff = p_NumberNew + 255 - p_NumberOld;
        }
        return intDiff;
    }

    public void sendConfirmReceived(int p_MessageNumber_Received, int p_MessageNumber_Missed) {
        SPIT_ClientSocket o_SPITClientSocket = this.m_SPIT_ClientSocket;
        if (this.m_ConfirmMessagesAfter > 0 && o_SPITClientSocket != null) {
            SPIT_Message o_SPIT_Message = SPIT_Message.createConfirmReceived((byte)p_MessageNumber_Received, (byte)p_MessageNumber_Missed);
            o_SPIT_Message.getHeader().setServerID(this.getServerID());
            o_SPIT_Message.getHeader().setClientID(this.getClientID());
            o_SPIT_Message.getHeader().setMessageNumber((byte)0);
            o_SPITClientSocket.sendSPIT_Message(o_SPIT_Message);
        }
        if (++p_MessageNumber_Received > 255) {
            p_MessageNumber_Received = 1;
        }
        this.m_MessageNumber_Confirmed_Received = p_MessageNumber_Received;
    }

    @Override
    public boolean sendSPIT_Message_ForAllClients(SPIT_Message p_SPIT_Message) {
        return true;
    }

    @Override
    public boolean sendSPIT_Message(SPIT_Message p_SPIT_Message) {
        if (p_SPIT_Message == null) {
            return false;
        }
        if (!this.isConnected()) {
            return false;
        }
        return this.addSPIT_MessageToSend(p_SPIT_Message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addSPIT_MessageToSend(SPIT_Message p_SPIT_Message) {
        if (p_SPIT_Message == null) {
            return false;
        }
        Object object = this.m_SyncSpitMessagesToSend;
        synchronized (object) {
            if (this.m_SPIT_MessagesToSend.contains(p_SPIT_Message)) {
                return true;
            }
            this.m_SPIT_MessagesToSend.add(p_SPIT_Message);
        }
        SPIT_ClientSocket o_SPITClientSocket = this.m_SPIT_ClientSocket;
        if (o_SPITClientSocket != null) {
            o_SPITClientSocket.notifySend();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SPIT_Message getNextSPIT_MessageToSend() {
        SPIT_ClientSocket o_SPITClientSocket;
        SPIT_Message o_SPIT_Message = null;
        SPIT_Message o_SPIT_Message_Resend = null;
        boolean boolResend = false;
        Object object = this.m_SyncSpitMessagesToSend;
        synchronized (object) {
            if (this.m_ConfirmMessagesAfter > 0) {
                if (this.m_SPIT_MessagesSended.size() >= this.m_ConfirmMessagesAfter) {
                    if (!this.m_WaitForConfirmReceived) {
                        this.m_WaitForConfirmReceived = true;
                        this.m_WaitForConfirmReceived_Start = System.currentTimeMillis();
                    } else if (System.currentTimeMillis() - this.m_WaitForConfirmReceived_Start > 200L) {
                        boolResend = true;
                        this.m_WaitForConfirmReceived = false;
                        this.m_WaitForConfirmReceived_Start = -1L;
                    }
                } else {
                    this.m_WaitForConfirmReceived = false;
                    this.m_WaitForConfirmReceived_Start = -1L;
                    if (this.m_SPIT_MessagesToSend.size() > 0) {
                        o_SPIT_Message = this.m_SPIT_MessagesToSend.get(0);
                    }
                }
            } else if (this.m_SPIT_MessagesToSend.size() > 0) {
                o_SPIT_Message = this.m_SPIT_MessagesToSend.get(0);
            }
        }
        if (boolResend) {
            object = this.m_SyncSpitMessagesToSend;
            synchronized (object) {
                if (this.m_ConfirmMessagesAfter > 0 && this.m_SPIT_MessagesSended.size() >= this.m_ConfirmMessagesAfter) {
                    o_SPIT_Message_Resend = this.m_SPIT_MessagesSended.get(0);
                }
            }
        }
        if (o_SPIT_Message_Resend != null && (o_SPITClientSocket = this.m_SPIT_ClientSocket) != null) {
            o_SPITClientSocket.sendSPIT_Message(o_SPIT_Message_Resend);
        }
        if (o_SPIT_Message == null) {
            return null;
        }
        object = this.m_SyncMessageNumber;
        synchronized (object) {
            o_SPIT_Message.getHeader().setServerID(this.getServerID());
            o_SPIT_Message.getHeader().setClientID(this.getClientID());
            o_SPIT_Message.getHeader().setMessageNumber((byte)this.m_MessageNumber_Send);
        }
        return o_SPIT_Message;
    }

    @Override
    public boolean getWaitForConfirmReceive() {
        return this.m_WaitForConfirmReceived;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void successSendSPIT_Message(SPIT_Message p_SPIT_Message) {
        if (p_SPIT_Message == null) {
            return;
        }
        this.m_SPITMessageToSend_Attempts = 0;
        Object object = this.m_SyncSpitMessagesToSend;
        synchronized (object) {
            this.m_SPIT_MessagesToSend.remove(p_SPIT_Message);
        }
        object = this.m_SyncMessageNumber;
        synchronized (object) {
            this.m_MessageNumber_Send = this.m_MessageNumber_Send == 255 ? 1 : ++this.m_MessageNumber_Send;
        }
        if (s_DEBUGON) {
            this.printReport("    SendedMessage", "SPIT_Message OPFlag: " + p_SPIT_Message.getOPFlag() + " MessageNumber: " + p_SPIT_Message.getMessageNumber());
        }
        object = this.m_SyncSpitMessagesToSend;
        synchronized (object) {
            if (this.m_ConfirmMessagesAfter > 0) {
                int intDiff;
                boolean boolAdd = true;
                if (this.m_MessageNumber_Confirmed_Send >= 0 && (intDiff = this.diffMessageNumber(this.m_MessageNumber_Confirmed_Send, p_SPIT_Message.getMessageNumber())) <= 0) {
                    boolAdd = false;
                }
                if (boolAdd) {
                    this.m_SPIT_MessagesSended.add(p_SPIT_Message);
                }
            } else {
                SPIT_Message.addEmpty(p_SPIT_Message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void errorSendSPIT_Message(SPIT_Message p_SPIT_Message, Exception p_Exception) {
        if (p_SPIT_Message == null) {
            return;
        }
        if (p_Exception instanceof SPIT_ClientInterface.Exception_SendSPIT_Message) {
            this.printReport("Fatal Error", "sending SPIT_Message OPFlag: " + p_SPIT_Message.getOPFlag() + p_Exception.getMessage());
            Object object = this.m_SyncSpitMessagesToSend;
            synchronized (object) {
                this.m_SPIT_MessagesToSend.remove(p_SPIT_Message);
                SPIT_Message.addEmpty(p_SPIT_Message);
            }
            return;
        }
        ++this.m_SPITMessageToSend_Attempts;
        if (this.m_SPITMessageToSend_Attempts > 10) {
            this.printReport("Fatal Error", "After " + this.m_SPITMessageToSend_Attempts + " attempts, the SPIT_Message OPFlag: " + p_SPIT_Message.getOPFlag() + " MessageNumber. " + p_SPIT_Message.getMessageNumber() + " could not be sent" + p_Exception.getMessage());
            Object object = this.m_SyncSpitMessagesToSend;
            synchronized (object) {
                this.m_SPIT_MessagesToSend.remove(p_SPIT_Message);
                SPIT_Message.addEmpty(p_SPIT_Message);
            }
            this.m_SPITMessageToSend_Attempts = 0;
        } else {
            this.printReport("commant", "Send Attempt: " + this.m_SPITMessageToSend_Attempts + " SPIT_Message OPFlag: " + p_SPIT_Message.getOPFlag() + " MessageNumber. " + p_SPIT_Message.getMessageNumber() + " could not be sent" + p_Exception.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearSPIT_MessagesToSend() {
        Object object = this.m_SyncSpitMessagesToSend;
        synchronized (object) {
            this.m_SPIT_MessagesToSend.clear();
            this.m_SPIT_MessagesSended.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void confirmReceivedSPIT_Message(SPIT_Message.ConfirmReceived p_ConfirmReceived) {
        SPIT_ClientSocket o_SPITClientSocket;
        if (p_ConfirmReceived == null) {
            return;
        }
        SPIT_Message o_SPIT_Message_Resend = null;
        Object object = this.m_SyncSpitMessagesToSend;
        synchronized (object) {
            this.m_MessageNumber_Confirmed_Send = p_ConfirmReceived.getConfirmMessageNumber_Int();
            for (int intMessage = this.m_SPIT_MessagesSended.size() - 1; intMessage >= 0; --intMessage) {
                SPIT_Message o_SPIT_Message = this.m_SPIT_MessagesSended.get(intMessage);
                int intDiff = this.diffMessageNumber(o_SPIT_Message.getMessageNumber(), p_ConfirmReceived.getConfirmMessageNumber_Int());
                if (intDiff < 0) continue;
                this.m_SPIT_MessagesSended.remove(intMessage);
                SPIT_Message.addEmpty(o_SPIT_Message);
            }
            if (s_DEBUGON) {
                this.printReport("    confirmReceivedSPIT_Message", "SPIT_Message OPFlag:" + p_ConfirmReceived.getOPFlag() + " confirmed MessageNumber: " + p_ConfirmReceived.getConfirmMessageNumber_Int());
            }
            if (this.m_SPIT_MessagesSended.size() > 0 && p_ConfirmReceived.getMissingMessageNumber_Int() > 0) {
                this.printReport("comment", "Not all sended messages are confirmed there are " + this.m_SPIT_MessagesSended.size() + " left. First not confirmed: " + this.m_SPIT_MessagesSended.get(0).getMessageNumber());
                o_SPIT_Message_Resend = this.m_SPIT_MessagesSended.get(0);
            }
        }
        if (o_SPIT_Message_Resend != null && (o_SPITClientSocket = this.m_SPIT_ClientSocket) != null) {
            this.printReport("comment", "Resend message (OPFlag: (" + o_SPIT_Message_Resend.getOPFlag() + ") MessageNumber: " + o_SPIT_Message_Resend.getMessageNumber());
            o_SPITClientSocket.sendSPIT_Message(o_SPIT_Message_Resend);
        }
        if ((o_SPITClientSocket = this.m_SPIT_ClientSocket) != null) {
            o_SPITClientSocket.notifySend();
        }
    }

    public void closeProject_Client(String p_ProjectID) {
        SPIT_Client.eventCloseProject_Client(p_ProjectID);
    }

    @Override
    public boolean checkParseSPIT_Message(SPIT_Message p_SPIT_Message) {
        int intDiff;
        if (p_SPIT_Message == null) {
            return false;
        }
        if (this.m_Closed) {
            return false;
        }
        SPIT_Message.Header o_Header = p_SPIT_Message.getHeader();
        SPIT_Message.OPPart o_OPPart = p_SPIT_Message.getOPPart();
        if (o_Header == null || o_OPPart == null) {
            this.printReport("Error", "checkParseSPIT_Message SPIT_Client parseSPIT_Message Header or OPPart wrong");
            return false;
        }
        int intActualMessageNumber = p_SPIT_Message.getMessageNumber();
        SPIT_Watchdog o_SPIT_Watchdog = this.m_SPIT_Watchdog;
        if (o_SPIT_Watchdog != null) {
            o_SPIT_Watchdog.eventWatchdogAnswer();
        }
        if (intActualMessageNumber == 0) {
            return this.parseSPIT_Message(p_SPIT_Message);
        }
        if (this.m_MessageNumber_Received < 0) {
            this.setMessageNumberReceived(intActualMessageNumber, false);
            return this.parseSPIT_Message(p_SPIT_Message);
        }
        int intNextMessageNumber = this.m_MessageNumber_Received + 1;
        if (intNextMessageNumber > 255 || intNextMessageNumber < 1) {
            intNextMessageNumber = 1;
        }
        if ((intDiff = this.diffMessageNumber(intNextMessageNumber, intActualMessageNumber)) < 0) {
            this.printReport("Comment", "checkParseSPIT_Message expected MessageNumber: " + intNextMessageNumber + " received SPIT_Message (OPFlag: " + p_SPIT_Message.getOPFlag() + ") maybe resended. MessageNmber: " + intActualMessageNumber);
            this.sendConfirmReceived(this.m_MessageNumber_Received, 0);
            return true;
        }
        if (intActualMessageNumber == intNextMessageNumber) {
            boolean boolParsed = true;
            this.setMessageNumberReceived(intActualMessageNumber, false);
            if (!this.parseSPIT_Message(p_SPIT_Message)) {
                boolParsed = false;
            }
            if (this.m_OvertakingSPIT_Messages.size() > 0) {
                this.printReport("Comment", "checkParseSPIT_Message received missing SPIT_Message: (OPFlag: " + p_SPIT_Message.getOPFlag() + ") MessageNumber: " + intActualMessageNumber);
            }
            while (this.m_OvertakingSPIT_Messages.size() > 0) {
                SPIT_Message o_OvertakingSPIT_Message;
                int intOvertakingMessageNumber;
                intNextMessageNumber = this.m_MessageNumber_Received + 1;
                if (intNextMessageNumber > 255 || intNextMessageNumber < 1) {
                    intNextMessageNumber = 1;
                }
                if ((intOvertakingMessageNumber = (o_OvertakingSPIT_Message = this.m_OvertakingSPIT_Messages.get(0)).getMessageNumber()) == intNextMessageNumber) {
                    this.printReport("Comment", "checkParseSPIT_Message       overtaking SPIT_Message" + intOvertakingMessageNumber + " (OPFlag: " + o_OvertakingSPIT_Message.getOPFlag() + ") will be handled.");
                    this.setMessageNumberReceived(intOvertakingMessageNumber, true);
                    if (!this.parseSPIT_Message(o_OvertakingSPIT_Message)) {
                        boolParsed = false;
                    }
                    this.m_OvertakingSPIT_Messages.remove(0);
                    continue;
                }
                if (this.m_ConfirmMessagesAfter <= 0) break;
                this.sendConfirmReceived(this.m_MessageNumber_Received, intNextMessageNumber);
                break;
            }
            return boolParsed;
        }
        this.printReport("Comment", " checkParseSPIT_Message  SPIT_Message " + intActualMessageNumber + " (OPFlag: " + p_SPIT_Message.getOPFlag() + ") has overtaken " + intNextMessageNumber);
        if (this.addOvertakingSPIT_Message(p_SPIT_Message, intNextMessageNumber) && this.m_ConfirmMessagesAfter > 0) {
            this.sendConfirmReceived(this.m_MessageNumber_Received, intNextMessageNumber);
        }
        return true;
    }

    public boolean addOvertakingSPIT_Message(SPIT_Message p_SPIT_Message, int p_MissedMessageNumber) {
        if (p_SPIT_Message == null) {
            return true;
        }
        boolean boolAdded = true;
        if (this.m_OvertakingSPIT_Messages.size() >= s_MAX_OVERTAKING_SPIT_MESSAGES) {
            this.printReport("Fatal Error", "---------------------------------- SPITMessage overtaking more than " + s_MAX_OVERTAKING_SPIT_MESSAGES + " messages");
            this.disconnect(true);
            return false;
        }
        int intMessageNumber = p_SPIT_Message.getHeader().getMessageNumber();
        if (intMessageNumber < p_MissedMessageNumber) {
            intMessageNumber += 255;
        }
        for (int intMessage = 0; intMessage < this.m_OvertakingSPIT_Messages.size(); ++intMessage) {
            SPIT_Message o_OvertakingSPIT_Message = this.m_OvertakingSPIT_Messages.get(intMessage);
            int intOvertakingMessageNumber = o_OvertakingSPIT_Message.getHeader().getMessageNumber();
            if (intOvertakingMessageNumber < p_MissedMessageNumber) {
                intOvertakingMessageNumber += 255;
            }
            if (intMessageNumber >= intOvertakingMessageNumber) continue;
            this.m_OvertakingSPIT_Messages.add(intMessage, p_SPIT_Message);
            return true;
        }
        this.m_OvertakingSPIT_Messages.add(p_SPIT_Message);
        return boolAdded;
    }

    public boolean parseSPIT_Message(SPIT_Message p_SPIT_Message) {
        if (p_SPIT_Message == null) {
            return false;
        }
        if (this.m_Closed) {
            return false;
        }
        boolean boolParsed = false;
        SPIT_Message.Header o_Header = p_SPIT_Message.getHeader();
        SPIT_Message.OPPart o_OPPart = p_SPIT_Message.getOPPart();
        if (o_Header == null || o_OPPart == null) {
            this.printReport("Error", "parseSPIT_Message SPIT_Client parseSPIT_Message Header or OPPart wrong");
            return false;
        }
        if (s_DEBUGON) {
            this.printReport("           parseSPIT_Message", "SPIT_Message OPFlag:" + p_SPIT_Message.getOPFlag() + " MessageNumber: " + p_SPIT_Message.getMessageNumber());
        }
        if (o_OPPart instanceof SPIT_Message.ConnectAnswer) {
            boolParsed = this.parseConnectionAnswer((SPIT_Message.ConnectAnswer)o_OPPart);
        } else if (o_OPPart instanceof SPIT_Message.ConnectAnswerConfirm) {
            boolParsed = this.parseConnectionAnswerConfirm((SPIT_Message.ConnectAnswerConfirm)o_OPPart);
        } else if (o_OPPart instanceof SPIT_Message.ConfirmReceived) {
            boolParsed = this.parseConfirmReceived((SPIT_Message.ConfirmReceived)o_OPPart);
        } else if (o_OPPart instanceof SPIT_Message.Disconnect) {
            boolParsed = this.parseDisconnect((SPIT_Message.Disconnect)o_OPPart);
        } else if (o_OPPart instanceof SPIT_Message.Watchdog) {
            boolParsed = this.parseWatchdog((SPIT_Message.Watchdog)o_OPPart);
        } else if (o_OPPart instanceof SPIT_Message.WatchdogAnswer) {
            boolParsed = this.parseWatchdogAnswer((SPIT_Message.WatchdogAnswer)o_OPPart);
        } else if (o_OPPart instanceof SPIT_Message.ReportSPITProject) {
            boolParsed = this.parseReportSPITProject_Server((SPIT_Message.ReportSPITProject)o_OPPart);
        } else if (o_OPPart instanceof SPIT_Message.CloseSPITProject) {
            boolParsed = this.parseCloseSPITProject((SPIT_Message.CloseSPITProject)o_OPPart);
        } else if (o_OPPart instanceof SPIT_Message.RequestProjectTransfer) {
            boolParsed = this.parseRequestProjectTransfer((SPIT_Message.RequestProjectTransfer)o_OPPart);
        } else if (o_OPPart instanceof SPIT_Message.StartProjectTransfer) {
            boolParsed = this.parseStartProjectTransfer((SPIT_Message.StartProjectTransfer)o_OPPart);
        } else if (o_OPPart instanceof SPIT_Message.EndProjectTransfer) {
            boolParsed = this.parseEndProjectTransfer((SPIT_Message.EndProjectTransfer)o_OPPart);
        } else if (o_OPPart instanceof SPIT_Message.ReportSPITType) {
            boolParsed = this.parseReportSPITType((SPIT_Message.ReportSPITType)o_OPPart);
        } else if (o_OPPart instanceof SPIT_Message.RemoveSPITType) {
            boolParsed = this.parseRemoveSPITType((SPIT_Message.RemoveSPITType)o_OPPart);
        } else if (o_OPPart instanceof SPIT_Message.ReportSPITObject) {
            boolParsed = this.parseReportSPITObject((SPIT_Message.ReportSPITObject)o_OPPart);
        } else if (o_OPPart instanceof SPIT_Message.RemoveSPITObject) {
            boolParsed = this.parseRemoveSPITObject((SPIT_Message.RemoveSPITObject)o_OPPart);
        } else if (o_OPPart instanceof SPIT_Message.PlaySPITStart) {
            boolParsed = this.parsePlaySPITStart((SPIT_Message.PlaySPITStart)o_OPPart);
        } else if (o_OPPart instanceof SPIT_Message.PlaySPITObject) {
            boolParsed = this.parsePlaySPITObject((SPIT_Message.PlaySPITObject)o_OPPart);
        } else if (o_OPPart instanceof SPIT_Message.PlaySPITEnd) {
            boolParsed = this.parsePlaySPITEnd((SPIT_Message.PlaySPITEnd)o_OPPart);
        } else if (o_OPPart instanceof SPIT_Message.ReportPlayStatus) {
            boolParsed = this.parseReportPlayStatus((SPIT_Message.ReportPlayStatus)o_OPPart);
        }
        SPIT_Message.addEmpty(p_SPIT_Message);
        return boolParsed;
    }

    public static boolean sendMessage(SPIT_Message p_SPIT_Message) {
        if (p_SPIT_Message == null) {
            return false;
        }
        SPIT_Client o_SPIT_Client = s_SelfReference;
        if (o_SPIT_Client == null) {
            return false;
        }
        if (o_SPIT_Client.getIsLoadingProject()) {
            return false;
        }
        if (!o_SPIT_Client.isConnected()) {
            return false;
        }
        return o_SPIT_Client.sendSPIT_Message(p_SPIT_Message);
    }

    public boolean parseConnectionAnswer(SPIT_Message.ConnectAnswer p_ConnectAnswer) {
        if (p_ConnectAnswer == null) {
            return false;
        }
        if (!p_ConnectAnswer.getConnected()) {
            this.setConnected(false);
            this.disconnect(false);
            this.printReport("--- Connection to server failed ---", "normal connection");
            return false;
        }
        SPIT_Message.Header o_Header = p_ConnectAnswer.getHeader();
        this.m_ServerID = o_Header.getServerID();
        this.m_ServerComputerName = p_ConnectAnswer.getServerComputerName();
        this.m_ServerName = p_ConnectAnswer.getServerName();
        this.m_ServerStepTime = p_ConnectAnswer.getStepTime();
        this.m_ConfirmMessagesAfter = 0;
        this.setConnected(true);
        this.startWatchdog();
        this.notifyConnected();
        this.printReport("--- Connection to server accepted ---", "normal connection");
        return true;
    }

    public boolean parseConnectionAnswerConfirm(SPIT_Message.ConnectAnswerConfirm p_ConnectAnswerConfirm) {
        if (p_ConnectAnswerConfirm == null) {
            return false;
        }
        if (!p_ConnectAnswerConfirm.getConnected()) {
            this.setConnected(false);
            this.disconnect(false);
            this.printReport("--- Connection to server  failed ---", "confirmed connection");
            return false;
        }
        SPIT_Message.Header o_Header = p_ConnectAnswerConfirm.getHeader();
        this.m_ServerID = o_Header.getServerID();
        this.m_ServerComputerName = p_ConnectAnswerConfirm.getServerComputerName();
        this.m_ServerName = p_ConnectAnswerConfirm.getServerName();
        this.m_ServerStepTime = p_ConnectAnswerConfirm.getStepTime();
        this.setConfirmAfter(p_ConnectAnswerConfirm.getConfirmAfter());
        this.setConnected(true);
        this.startWatchdog();
        this.notifyConnected();
        if (this.m_ConfirmMessagesAfter > 0) {
            this.printReport("--- Connection to server accepted ---", "confirmed connection");
        } else {
            this.printReport("--- Connection to server accepted ---", "normal connection");
        }
        return true;
    }

    public boolean parseConfirmReceived(SPIT_Message.ConfirmReceived p_ConfirmReceived) {
        if (p_ConfirmReceived == null) {
            return false;
        }
        SPIT_Watchdog o_SPIT_Watchdog = this.m_SPIT_Watchdog;
        if (o_SPIT_Watchdog != null) {
            o_SPIT_Watchdog.eventWatchdogAnswer();
        }
        this.confirmReceivedSPIT_Message(p_ConfirmReceived);
        return true;
    }

    public void sleepSend() {
        SPIT_ClientSocket o_SPITClientSocket = this.m_SPIT_ClientSocket;
        if (o_SPITClientSocket != null) {
            o_SPITClientSocket.sleepSend();
        }
    }

    public boolean parseWatchdog(SPIT_Message.Watchdog p_Watchdog) {
        if (p_Watchdog == null) {
            return false;
        }
        SPIT_Watchdog o_SPIT_Watchdog = this.m_SPIT_Watchdog;
        if (o_SPIT_Watchdog != null) {
            o_SPIT_Watchdog.eventWatchdogAnswer();
        }
        SPIT_Message o_SPIT_Message = SPIT_Message.createWatchdogAnswer();
        this.sendSPIT_Message(o_SPIT_Message);
        return true;
    }

    public boolean parseWatchdogAnswer(SPIT_Message.WatchdogAnswer p_WatchdogAnswer) {
        if (p_WatchdogAnswer == null) {
            return false;
        }
        SPIT_Watchdog o_SPIT_Watchdog = this.m_SPIT_Watchdog;
        if (o_SPIT_Watchdog != null) {
            o_SPIT_Watchdog.eventWatchdogAnswer();
        }
        return true;
    }

    @Override
    public void startWatchdog() {
        if (this.m_SPIT_Watchdog != null) {
            this.m_SPIT_Watchdog.startWatchdog();
        }
    }

    @Override
    public void stopWatchdog() {
        if (this.m_SPIT_Watchdog != null) {
            this.m_SPIT_Watchdog.stopWatchdog();
        }
    }

    @Override
    public void watchdogMissed() {
        this.printReport("Error", "Watchdog missed -> will disconnect");
        this.disconnect(true);
    }

    @Override
    public void printReport(String p_Remark, String p_Message) {
        LocalDateTime o_LocalDateTime = LocalDateTime.now();
        StringBuilder o_StringBuilder = new StringBuilder();
        o_StringBuilder.append(o_LocalDateTime.getYear());
        o_StringBuilder.append("_");
        o_StringBuilder.append(o_LocalDateTime.getMonthValue());
        o_StringBuilder.append("_");
        o_StringBuilder.append(o_LocalDateTime.getDayOfMonth());
        o_StringBuilder.append(" ");
        o_StringBuilder.append(o_LocalDateTime.getHour());
        o_StringBuilder.append(":");
        o_StringBuilder.append(o_LocalDateTime.getMinute());
        o_StringBuilder.append(":");
        o_StringBuilder.append(o_LocalDateTime.getSecond());
        o_StringBuilder.append("    ");
        o_StringBuilder.append(p_Remark);
        o_StringBuilder.append(":");
        o_StringBuilder.append(" ");
        o_StringBuilder.append("SPITClient");
        o_StringBuilder.append(" ");
        o_StringBuilder.append(this.getClientComputerName());
        o_StringBuilder.append("(");
        o_StringBuilder.append(this.getInetAddress());
        o_StringBuilder.append(")");
        o_StringBuilder.append(" ");
        if (this.isConnected()) {
            o_StringBuilder.append("connected to Server");
            o_StringBuilder.append(" ");
            o_StringBuilder.append(this.getServerComputerName());
            o_StringBuilder.append(" (");
            o_StringBuilder.append(this.getServerIP());
            o_StringBuilder.append(")");
        } else {
            o_StringBuilder.append("not connected");
            o_StringBuilder.append(" ");
        }
        o_StringBuilder.append("    ");
        o_StringBuilder.append(p_Message);
        System.out.println(o_StringBuilder.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSPITClientListener(SPIT_ClientListener p_SPITClientListener) {
        if (p_SPITClientListener == null) {
            return;
        }
        Object object = this.m_SyncListener;
        synchronized (object) {
            if (this.m_SPITClientListeners.contains(p_SPITClientListener)) {
                return;
            }
            this.m_SPITClientListeners.add(p_SPITClientListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSPITClientListener(SPIT_ClientListener p_SPITClientListener) {
        if (p_SPITClientListener == null) {
            return;
        }
        Object object = this.m_SyncListener;
        synchronized (object) {
            this.m_SPITClientListeners.remove(p_SPITClientListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyConnected() {
        ArrayList<SPIT_ClientListener> o_SPITClientListeners;
        Object object = this.m_SyncListener;
        synchronized (object) {
            o_SPITClientListeners = new ArrayList<SPIT_ClientListener>(this.m_SPITClientListeners.size());
            o_SPITClientListeners.addAll(this.m_SPITClientListeners);
        }
        for (int intListener = 0; intListener < o_SPITClientListeners.size(); ++intListener) {
            SPIT_ClientListener o_SPITClientListener = (SPIT_ClientListener)o_SPITClientListeners.get(intListener);
            o_SPITClientListener.eventConnected(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyDisconnected(boolean p_ConnectionLost) {
        ArrayList<SPIT_ClientListener> o_SPITClientListeners;
        Object object = this.m_SyncListener;
        synchronized (object) {
            o_SPITClientListeners = new ArrayList<SPIT_ClientListener>(this.m_SPITClientListeners.size());
            o_SPITClientListeners.addAll(this.m_SPITClientListeners);
        }
        for (int intListener = 0; intListener < o_SPITClientListeners.size(); ++intListener) {
            SPIT_ClientListener o_SPITClientListener = (SPIT_ClientListener)o_SPITClientListeners.get(intListener);
            o_SPITClientListener.eventDisconnected(this, p_ConnectionLost);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyServerProject() {
        ArrayList<SPIT_ClientListener> o_SPITClientListeners;
        Object object = this.m_SyncListener;
        synchronized (object) {
            o_SPITClientListeners = new ArrayList<SPIT_ClientListener>(this.m_SPITClientListeners.size());
            o_SPITClientListeners.addAll(this.m_SPITClientListeners);
        }
        for (int intListener = 0; intListener < o_SPITClientListeners.size(); ++intListener) {
            SPIT_ClientListener o_SPITClientListener = (SPIT_ClientListener)o_SPITClientListeners.get(intListener);
            o_SPITClientListener.eventServer_SPITProject(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyServerProject_Closed() {
        ArrayList<SPIT_ClientListener> o_SPITClientListeners;
        Object object = this.m_SyncListener;
        synchronized (object) {
            o_SPITClientListeners = new ArrayList<SPIT_ClientListener>(this.m_SPITClientListeners.size());
            o_SPITClientListeners.addAll(this.m_SPITClientListeners);
        }
        for (int intListener = 0; intListener < o_SPITClientListeners.size(); ++intListener) {
            SPIT_ClientListener o_SPITClientListener = (SPIT_ClientListener)o_SPITClientListeners.get(intListener);
            o_SPITClientListener.eventServer_SPITProject_Closed(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyServerProject_TransferStart() {
        ArrayList<SPIT_ClientListener> o_SPITClientListeners;
        Object object = this.m_SyncListener;
        synchronized (object) {
            o_SPITClientListeners = new ArrayList<SPIT_ClientListener>(this.m_SPITClientListeners.size());
            o_SPITClientListeners.addAll(this.m_SPITClientListeners);
        }
        for (int intListener = 0; intListener < o_SPITClientListeners.size(); ++intListener) {
            SPIT_ClientListener o_SPITClientListener = (SPIT_ClientListener)o_SPITClientListeners.get(intListener);
            o_SPITClientListener.eventServer_SPITProject_TransferStart(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyServerProject_TransferEnd() {
        ArrayList<SPIT_ClientListener> o_SPITClientListeners;
        Object object = this.m_SyncListener;
        synchronized (object) {
            o_SPITClientListeners = new ArrayList<SPIT_ClientListener>(this.m_SPITClientListeners.size());
            o_SPITClientListeners.addAll(this.m_SPITClientListeners);
        }
        for (int intListener = 0; intListener < o_SPITClientListeners.size(); ++intListener) {
            SPIT_ClientListener o_SPITClientListener = (SPIT_ClientListener)o_SPITClientListeners.get(intListener);
            o_SPITClientListener.eventServer_SPITProject_TransferEnd(this);
        }
    }

    public static String cleanIPAddress(String p_IPAddress) {
        if (p_IPAddress == null) {
            return null;
        }
        if (p_IPAddress.length() <= 0) {
            return p_IPAddress;
        }
        String stringCleanIPAddress = p_IPAddress;
        try {
            while (stringCleanIPAddress.startsWith("/")) {
                stringCleanIPAddress = stringCleanIPAddress.substring(1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            while (stringCleanIPAddress.endsWith("/")) {
                stringCleanIPAddress = stringCleanIPAddress.substring(0, stringCleanIPAddress.length() - 1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stringCleanIPAddress;
    }

    public boolean parseDisconnect(SPIT_Message.Disconnect p_Disconnect) {
        if (p_Disconnect == null) {
            return false;
        }
        this.disconnect(false);
        SPIT_Type.unconfirmeAll();
        SPIT_Object.unconfirmeAll();
        return true;
    }

    public static void eventCloseProject_Client(String p_ProjectID) {
        SPITRemote.parseCloseSPITProject_Client();
        SPIT_Object.parseCloseSPITProject_Client();
        SPIT_Type.parseCloseSPITProject_Client();
        SPIT_Message o_SPIT_Message = SPIT_Message.createCloseSPITProject(p_ProjectID);
        SPIT_Client.sendMessage(o_SPIT_Message);
    }

    public static void eventLoadProjectStart_Client() {
        SPIT_Client o_SPIT_Client = s_SelfReference;
        if (o_SPIT_Client == null) {
            return;
        }
        o_SPIT_Client.setIsLoadingProject(true);
    }

    public static void eventLoadProjectEnd_Client() {
        SPIT_Client o_SPIT_Client = s_SelfReference;
        if (o_SPIT_Client == null) {
            return;
        }
        o_SPIT_Client.setIsLoadingProject(false);
    }

    public static void eventLoadedProject_Client(String p_ProjectID, String p_ProjectName) {
        SPIT_Message o_SPIT_Message;
        String stringOldProjectName = s_SelfReference.getClientProjectName();
        s_SelfReference.setIsLoadingProject(false);
        s_SelfReference.setClientProjectID(p_ProjectID);
        s_SelfReference.setClientProjectName(p_ProjectName);
        if (stringOldProjectName.equals(p_ProjectName)) {
            o_SPIT_Message = SPIT_Message.createReportSPITProject(p_ProjectID, p_ProjectName, 0);
            SPIT_Client.sendMessage(o_SPIT_Message);
        }
        o_SPIT_Message = SPIT_Message.createRequestProjectTransfer();
        SPIT_Client.sendMessage(o_SPIT_Message);
    }

    public boolean parseReportSPITProject_Server(SPIT_Message.ReportSPITProject p_ReportSPITProject) {
        if (p_ReportSPITProject == null) {
            return false;
        }
        SPIT_Watchdog o_SPIT_Watchdog = this.m_SPIT_Watchdog;
        if (o_SPIT_Watchdog != null) {
            o_SPIT_Watchdog.eventWatchdogAnswer();
        }
        this.m_ServerProjectID = p_ReportSPITProject.getProjectID();
        this.m_ServerProjectName = p_ReportSPITProject.getProjectName();
        this.m_ServerFramesPerSecond = p_ReportSPITProject.getFramesPerSecond();
        SPIT_TypeModel.FRAMESPERSECOND = this.m_ServerFramesPerSecond;
        SPIT_ObjectModel.FRAMESPERSECOND = this.m_ServerFramesPerSecond;
        SPIT_Type.parseReportSPITProject();
        SPIT_Object.parseReportSPITProject();
        this.notifyServerProject();
        SPIT_Message o_SPIT_Message = SPIT_Message.createRequestProjectTransfer();
        this.sendSPIT_Message(o_SPIT_Message);
        o_SPIT_Message = SPIT_Message.createReportSPITProject(this.m_ProjectName, this.m_ProjectName, this.m_ServerFramesPerSecond);
        this.sendSPIT_Message(o_SPIT_Message);
        return true;
    }

    public boolean parseCloseSPITProject(SPIT_Message.CloseSPITProject p_CloseSPITProject) {
        if (p_CloseSPITProject == null) {
            return false;
        }
        SPIT_Object.parseCloseSPITProject_Server();
        SPIT_Type.parseCloseSPITProject_Server();
        SPIT_Watchdog o_SPIT_Watchdog = this.m_SPIT_Watchdog;
        if (o_SPIT_Watchdog != null) {
            o_SPIT_Watchdog.eventWatchdogAnswer();
        }
        this.m_ServerProjectID = "";
        this.m_ServerProjectName = "";
        SPIT_ActionPlayer.clearSPIT_ActionPlayers();
        this.notifyServerProject_Closed();
        return true;
    }

    private boolean parseRequestProjectTransfer(SPIT_Message.RequestProjectTransfer p_RequestProjectTransfer) {
        SPIT_Message o_SPIT_Message;
        boolean boolSended;
        if (p_RequestProjectTransfer == null) {
            return false;
        }
        SPIT_Watchdog o_SPIT_Watchdog = this.m_SPIT_Watchdog;
        if (o_SPIT_Watchdog != null) {
            o_SPIT_Watchdog.eventWatchdogAnswer();
        }
        if (!(boolSended = this.sendSPIT_Message(o_SPIT_Message = SPIT_Message.createStartProjectTransfer()))) {
            return false;
        }
        o_SPIT_Watchdog = this.m_SPIT_Watchdog;
        if (o_SPIT_Watchdog != null) {
            o_SPIT_Watchdog.eventWatchdogAnswer();
        }
        int intCount = SPIT_Type.getSPIT_TypeCount();
        for (int intType = 0; intType < intCount; ++intType) {
            SPIT_Type_Interface o_SPIT_Type_Interface = SPIT_Type.getSPIT_Type(intType);
            if (o_SPIT_Type_Interface == null) continue;
            o_SPIT_Message = SPIT_Message.createReportSPITType(o_SPIT_Type_Interface);
            boolSended = this.sendSPIT_Message(o_SPIT_Message);
            if (!boolSended) {
                return false;
            }
            o_SPIT_Watchdog = this.m_SPIT_Watchdog;
            if (o_SPIT_Watchdog != null) {
                o_SPIT_Watchdog.eventWatchdogAnswer();
            }
            this.sleepSend();
        }
        intCount = SPIT_Object.getSPIT_ObjectCount();
        for (int intObject = 0; intObject < intCount; ++intObject) {
            SPIT_Object_Interface o_SPIT_Object_Interface = SPIT_Object.getSPIT_Object(intObject);
            o_SPIT_Message = SPIT_Message.createReportSPITObject(o_SPIT_Object_Interface);
            boolSended = this.sendSPIT_Message(o_SPIT_Message);
            if (!boolSended) {
                return false;
            }
            o_SPIT_Watchdog = this.m_SPIT_Watchdog;
            if (o_SPIT_Watchdog != null) {
                o_SPIT_Watchdog.eventWatchdogAnswer();
            }
            this.sleepSend();
        }
        o_SPIT_Message = SPIT_Message.createEndProjectTransfer();
        boolSended = this.sendSPIT_Message(o_SPIT_Message);
        return boolSended;
    }

    private boolean parseStartProjectTransfer(SPIT_Message.StartProjectTransfer p_StartProjectTransfer) {
        if (p_StartProjectTransfer == null) {
            return false;
        }
        SPIT_Watchdog o_SPIT_Watchdog = this.m_SPIT_Watchdog;
        if (o_SPIT_Watchdog != null) {
            o_SPIT_Watchdog.eventWatchdogAnswer();
        }
        this.m_TransferringProject = true;
        this.notifyServerProject_TransferStart();
        return true;
    }

    private boolean parseEndProjectTransfer(SPIT_Message.EndProjectTransfer p_EndProjectTransfer) {
        if (p_EndProjectTransfer == null) {
            return false;
        }
        SPIT_Watchdog o_SPIT_Watchdog = this.m_SPIT_Watchdog;
        if (o_SPIT_Watchdog != null) {
            o_SPIT_Watchdog.eventWatchdogAnswer();
        }
        this.m_TransferringProject = false;
        this.notifyServerProject_TransferEnd();
        SPITRemote.clearUnconfirmed();
        return true;
    }

    private boolean parseReportSPITType(SPIT_Message.ReportSPITType p_ReportSPITType) {
        if (p_ReportSPITType == null) {
            return false;
        }
        SPIT_Watchdog o_SPIT_Watchdog = this.m_SPIT_Watchdog;
        if (o_SPIT_Watchdog != null) {
            o_SPIT_Watchdog.eventWatchdogAnswer();
        }
        return SPIT_Type.parseReportSPITType(p_ReportSPITType, this, this.m_TransferringProject);
    }

    private boolean parseRemoveSPITType(SPIT_Message.RemoveSPITType p_RemoveSPITType) {
        if (p_RemoveSPITType == null) {
            return false;
        }
        SPIT_Watchdog o_SPIT_Watchdog = this.m_SPIT_Watchdog;
        if (o_SPIT_Watchdog != null) {
            o_SPIT_Watchdog.eventWatchdogAnswer();
        }
        return SPIT_Type.parseRemoveSPITType(p_RemoveSPITType, null);
    }

    public boolean parseReportSPITObject(SPIT_Message.ReportSPITObject p_ReportSPITObject) {
        if (p_ReportSPITObject == null) {
            return false;
        }
        SPIT_Watchdog o_SPIT_Watchdog = this.m_SPIT_Watchdog;
        if (o_SPIT_Watchdog != null) {
            o_SPIT_Watchdog.eventWatchdogAnswer();
        }
        return SPIT_Object.parseReportSPITObject(p_ReportSPITObject, this, this.m_TransferringProject);
    }

    public boolean parseRemoveSPITObject(SPIT_Message.RemoveSPITObject p_RemoveSPITObject) {
        if (p_RemoveSPITObject == null) {
            return false;
        }
        SPIT_Watchdog o_SPIT_Watchdog = this.m_SPIT_Watchdog;
        if (o_SPIT_Watchdog != null) {
            o_SPIT_Watchdog.eventWatchdogAnswer();
        }
        return SPIT_Object.parseSPITObject_Removed(p_RemoveSPITObject, this);
    }

    public boolean parsePlaySPITStart(SPIT_Message.PlaySPITStart p_PlaySPITStart) {
        SPIT_ActionPlayer o_SPIT_ActionPlayer;
        if (p_PlaySPITStart == null) {
            return false;
        }
        SPIT_Watchdog o_SPIT_Watchdog = this.m_SPIT_Watchdog;
        if (o_SPIT_Watchdog != null) {
            o_SPIT_Watchdog.eventWatchdogAnswer();
        }
        if ((o_SPIT_ActionPlayer = SPIT_ActionPlayer.getSPIT_ActionPlayer(p_PlaySPITStart.getPlayerID())) == null) {
            o_SPIT_ActionPlayer = new SPIT_ActionPlayer(p_PlaySPITStart.getPlayerID(), p_PlaySPITStart.getPlayerName(), p_PlaySPITStart.getPlayerType());
            SPIT_ActionPlayer.addSPIT_ActionPlayer(o_SPIT_ActionPlayer);
        }
        o_SPIT_ActionPlayer.startPlayTransfer(this, p_PlaySPITStart.getPlayerIsRunning(), p_PlaySPITStart.getTime());
        return true;
    }

    public boolean parsePlaySPITObject(SPIT_Message.PlaySPITObject p_PlaySPITObject) {
        SPIT_ActionPlayer o_SPIT_ActionPlayer;
        if (p_PlaySPITObject == null) {
            return false;
        }
        SPIT_Watchdog o_SPIT_Watchdog = this.m_SPIT_Watchdog;
        if (o_SPIT_Watchdog != null) {
            o_SPIT_Watchdog.eventWatchdogAnswer();
        }
        if ((o_SPIT_ActionPlayer = SPIT_ActionPlayer.getSPIT_ActionPlayer(p_PlaySPITObject.getPlayerID())) == null) {
            return false;
        }
        SPIT_Object_Interface o_SPIT_Object_Interface = SPIT_Object.getSPIT_Object(p_PlaySPITObject.getID());
        o_SPIT_ActionPlayer.playObjectTransfer(this, o_SPIT_Object_Interface, p_PlaySPITObject.getPlayPrePosition(), p_PlaySPITObject.getFrameInsideObject(), p_PlaySPITObject.getValue(), p_PlaySPITObject.getValueFlag());
        return true;
    }

    public boolean parsePlaySPITEnd(SPIT_Message.PlaySPITEnd p_PlaySPITEnd) {
        SPIT_ActionPlayer o_SPIT_ActionPlayer;
        if (p_PlaySPITEnd == null) {
            return false;
        }
        SPIT_Watchdog o_SPIT_Watchdog = this.m_SPIT_Watchdog;
        if (o_SPIT_Watchdog != null) {
            o_SPIT_Watchdog.eventWatchdogAnswer();
        }
        if ((o_SPIT_ActionPlayer = SPIT_ActionPlayer.getSPIT_ActionPlayer(p_PlaySPITEnd.getPlayerID())) == null) {
            return false;
        }
        o_SPIT_ActionPlayer.endPlayTransfer(this);
        return true;
    }

    public boolean parseReportPlayStatus(SPIT_Message.ReportPlayStatus p_ReportPlayStatus) {
        if (p_ReportPlayStatus == null) {
            return false;
        }
        SPIT_Watchdog o_SPIT_Watchdog = this.m_SPIT_Watchdog;
        if (o_SPIT_Watchdog != null) {
            o_SPIT_Watchdog.eventWatchdogAnswer();
        }
        return SPIT_Object.parseReportPlayStatus(p_ReportPlayStatus);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
    }

    static {
        s_SinglePropertyChangeSupport = new SinglePropertyChangeSupport(SPIT_Client.class);
        s_IsLoadingProject = false;
    }
}

