/*
 * Decompiled with CFR 0.152.
 */
package ServerAutoDetectPackage;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.util.ArrayList;

public class ServerAutoDetect {
    public static final String SEARCH_ALL_SERVERS = "*";
    public static final String PRECODE = "#SAD#";
    public static final String SEPERATOR = "#,#";
    public static String LOOPBACKADDRESS_IP4 = "127.0.0.1";
    public static String MULTICASTGROUPNAME_IP6 = "ff02::1";
    public static InetAddress INETADDRESS_LOOPBACK_I\u00dc4 = null;
    public static InetAddress INETADDRESS_MULTICAST_IP6 = null;
    public static final int PORT_IP4_LOOPBACK_SPIT = 15110;
    public static final int PORT_IP4_LOOPBACK_MEDIA = 15109;
    public static final int PORT_IP4_LOOPBACK_REMOTE = 15108;
    public static final int PORT_IP6 = 15110;
    public static Charset CHARSET;
    public static int BYTEBUFFERSIZE;

    public static String cleanIPAddress(String p_IPAddress) {
        if (p_IPAddress == null) {
            return null;
        }
        if (p_IPAddress.length() <= 0) {
            return p_IPAddress;
        }
        String stringCleanIPAddress = p_IPAddress;
        try {
            while (stringCleanIPAddress.startsWith("/")) {
                stringCleanIPAddress = stringCleanIPAddress.substring(1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            while (stringCleanIPAddress.endsWith("/")) {
                stringCleanIPAddress = stringCleanIPAddress.substring(0, stringCleanIPAddress.length() - 1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stringCleanIPAddress;
    }

    public static String correctIP6Address(String p_ServerIP, String p_ClientIP) {
        String stringScopeID = "";
        String stringClientIPCorrected = p_ClientIP;
        int intPosScopeID = p_ServerIP.lastIndexOf("%");
        if (intPosScopeID > 0) {
            stringScopeID = p_ServerIP.substring(intPosScopeID, p_ServerIP.length());
            intPosScopeID = p_ClientIP.lastIndexOf("%");
            if (intPosScopeID > 0) {
                stringClientIPCorrected = p_ClientIP.substring(0, intPosScopeID);
            }
            stringClientIPCorrected = stringClientIPCorrected + stringScopeID;
        }
        return stringClientIPCorrected;
    }

    static {
        try {
            INETADDRESS_LOOPBACK_I\u00dc4 = InetAddress.getByName(LOOPBACKADDRESS_IP4);
        }
        catch (Exception e) {
            INETADDRESS_LOOPBACK_I\u00dc4 = null;
        }
        try {
            INETADDRESS_MULTICAST_IP6 = InetAddress.getByName(MULTICASTGROUPNAME_IP6);
        }
        catch (Exception e) {
            INETADDRESS_MULTICAST_IP6 = null;
        }
        CHARSET = Charset.forName("ISO-8859-15");
        BYTEBUFFERSIZE = 15000;
    }

    public static interface ServerAutoDetect_Listener {
        public void eventDetectedServer_Added(DetectedServer var1);

        public void eventDetectedServer_Changed(DetectedServer var1);

        public void eventDetectedServer_Removed(DetectedServer var1);
    }

    public static class DetectedServer {
        private String m_ServerID;
        private String m_ServerTaskID;
        private String m_ServerTaskName;
        private String m_ComputerName;
        private ArrayList<InetAddress> m_InetAddresses;
        private ArrayList<InetAddress> m_DetectedInetAddresses;
        private String m_ServerIP;
        private boolean m_ServerIsLoopback;
        private boolean m_ServerIsIP4;
        private int m_ServerPort;
        private String m_ClientIP;
        private String m_ServerAddition;
        private String m_ServerProjectName;
        private final Object m_SyncInetAddresses = new Object();
        private boolean m_Changed;
        private boolean m_ChangedContent;
        private boolean m_IsNew;

        public DetectedServer(String p_ServerID, String p_ServerTaskID, String p_ServerTaskName, String p_ServerComputerName, String p_ServerIP, int p_ServerPort, boolean p_ServerIsLoopback, boolean p_ServerIsIP4, String p_ClientIP_SendedByServer, String p_ServerAddition, String p_ServerProjectName) {
            this.initMembers();
            this.m_ServerID = p_ServerID;
            this.m_ServerTaskID = p_ServerTaskID;
            this.m_ServerTaskName = p_ServerTaskName;
            this.m_ComputerName = p_ServerComputerName;
            this.m_ServerIP = ServerAutoDetect.cleanIPAddress(p_ServerIP);
            this.m_ServerPort = p_ServerPort;
            this.m_ServerIsLoopback = p_ServerIsLoopback;
            this.m_ServerIsIP4 = p_ServerIsIP4;
            this.m_ClientIP = ServerAutoDetect.cleanIPAddress(p_ClientIP_SendedByServer);
            this.m_ClientIP = ServerAutoDetect.correctIP6Address(this.m_ServerIP, this.m_ClientIP);
            this.m_ServerAddition = p_ServerAddition;
            if (this.m_ServerAddition == null) {
                this.m_ServerAddition = "";
            }
            this.m_ServerProjectName = p_ServerProjectName;
            if (this.m_ServerProjectName == null) {
                this.m_ServerProjectName = "";
            }
        }

        private void initMembers() {
            this.m_IsNew = true;
            this.m_Changed = false;
            this.m_InetAddresses = new ArrayList(4);
            this.m_DetectedInetAddresses = new ArrayList(4);
            this.m_ServerAddition = "";
            this.m_ServerProjectName = "";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void multicastZyclusStart() {
            Object object = this.m_SyncInetAddresses;
            synchronized (object) {
                this.m_IsNew = false;
                this.m_ChangedContent = false;
                this.m_InetAddresses.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void multicastZyclusEnd() {
            Object object = this.m_SyncInetAddresses;
            synchronized (object) {
                this.m_Changed = false;
                if (this.m_IsNew) {
                    this.m_DetectedInetAddresses.clear();
                    this.m_DetectedInetAddresses.addAll(this.m_InetAddresses);
                    return;
                }
                if (this.m_DetectedInetAddresses.size() != this.m_InetAddresses.size()) {
                    this.m_Changed = true;
                    this.m_DetectedInetAddresses.clear();
                    if (this.m_InetAddresses.size() > 0) {
                        this.m_DetectedInetAddresses.addAll(this.m_InetAddresses);
                        return;
                    }
                    return;
                }
                if (this.m_InetAddresses.size() <= 0) {
                    this.m_Changed = true;
                    this.m_DetectedInetAddresses.clear();
                    return;
                }
                for (int intDetectedInetAddress = 0; intDetectedInetAddress < this.m_DetectedInetAddresses.size(); ++intDetectedInetAddress) {
                    InetAddress o_DetectedInetAddress = this.m_DetectedInetAddresses.get(intDetectedInetAddress);
                    boolean boolFound = false;
                    for (int intInetAddress = 0; intInetAddress < this.m_InetAddresses.size(); ++intInetAddress) {
                        InetAddress o_InetAddress = this.m_InetAddresses.get(intInetAddress);
                        if (!o_InetAddress.getHostAddress().equals(o_DetectedInetAddress.getHostAddress())) continue;
                        boolFound = true;
                        break;
                    }
                    if (boolFound) continue;
                    this.m_Changed = true;
                    break;
                }
                if (this.m_Changed) {
                    this.m_DetectedInetAddresses.clear();
                    this.m_DetectedInetAddresses.addAll(this.m_InetAddresses);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addServerInetAddress(InetAddress p_ServerInetAddress, String p_ClientIP) {
            if (p_ServerInetAddress == null) {
                return;
            }
            Object object = this.m_SyncInetAddresses;
            synchronized (object) {
                InetAddress o_InetAddress;
                String stringServerIP = ServerAutoDetect.cleanIPAddress(p_ServerInetAddress.getHostAddress());
                for (int intAddress = 0; intAddress < this.m_InetAddresses.size(); ++intAddress) {
                    o_InetAddress = this.m_InetAddresses.get(intAddress);
                    if (!o_InetAddress.equals(p_ServerInetAddress)) continue;
                    return;
                }
                if (p_ServerInetAddress.isLoopbackAddress()) {
                    if (this.m_ServerIsLoopback && p_ServerInetAddress instanceof Inet6Address) {
                        return;
                    }
                    if (!stringServerIP.equals(this.m_ServerIP) && !this.m_ServerIsLoopback) {
                        this.m_ServerIP = stringServerIP;
                        this.m_ClientIP = ServerAutoDetect.cleanIPAddress(p_ClientIP);
                        this.m_ServerIsLoopback = true;
                    }
                    this.m_InetAddresses.add(0, p_ServerInetAddress);
                    return;
                }
                int intFoundIndex = -1;
                if (!this.m_ServerIsLoopback) {
                    if (p_ServerInetAddress instanceof Inet4Address) {
                        if (!this.m_ServerIsIP4 && !stringServerIP.equals(this.m_ServerIP)) {
                            this.m_ServerIP = stringServerIP;
                            this.m_ClientIP = ServerAutoDetect.cleanIPAddress(p_ClientIP);
                            this.m_ServerIsIP4 = true;
                        }
                        for (int intAddress = 0; intAddress < this.m_InetAddresses.size(); ++intAddress) {
                            o_InetAddress = this.m_InetAddresses.get(intAddress);
                            if (!(o_InetAddress instanceof Inet6Address)) continue;
                            intFoundIndex = intAddress;
                            break;
                        }
                    } else if (p_ServerInetAddress instanceof Inet6Address && !this.m_ServerIsIP4) {
                        this.m_ServerIP = stringServerIP;
                        this.m_ClientIP = ServerAutoDetect.cleanIPAddress(p_ClientIP);
                        this.m_ClientIP = ServerAutoDetect.correctIP6Address(this.m_ServerIP, this.m_ClientIP);
                    }
                    if (intFoundIndex < 0) {
                        intFoundIndex = this.m_InetAddresses.size();
                    }
                    this.m_InetAddresses.add(intFoundIndex, p_ServerInetAddress);
                }
            }
        }

        public boolean isNew() {
            return this.m_IsNew;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean IsDetected() {
            Object object = this.m_SyncInetAddresses;
            synchronized (object) {
                if (this.m_DetectedInetAddresses.size() > 0) {
                    return true;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isChanged() {
            Object object = this.m_SyncInetAddresses;
            synchronized (object) {
                return this.m_Changed || this.m_ChangedContent;
            }
        }

        public void setContentChanged(boolean p_ContentChanged) {
            this.m_ChangedContent = p_ContentChanged;
        }

        public String getServerID() {
            return this.m_ServerID;
        }

        public String getServerTaskID() {
            return this.m_ServerTaskID;
        }

        public String getServerTaskName() {
            return this.m_ServerTaskName;
        }

        public String getServerAddition() {
            return this.m_ServerAddition;
        }

        public boolean setServerProjectName(String p_ServerProjectName) {
            if (p_ServerProjectName == null) {
                p_ServerProjectName = "";
            }
            if (!p_ServerProjectName.equals(this.m_ServerProjectName)) {
                this.m_ServerProjectName = p_ServerProjectName;
                this.m_ChangedContent = true;
                return true;
            }
            return false;
        }

        public String getServerProjectName() {
            return this.m_ServerProjectName;
        }

        public String getComputerName() {
            return this.m_ComputerName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public InetAddress getFirstInetAddress() {
            Object object = this.m_SyncInetAddresses;
            synchronized (object) {
                if (this.m_DetectedInetAddresses.size() <= 0) {
                    return null;
                }
                return this.m_DetectedInetAddresses.get(0);
            }
        }

        public String getFirstIP() {
            String stringIP = "";
            InetAddress o_InetAddress = this.getFirstInetAddress();
            if (o_InetAddress == null) {
                return "";
            }
            stringIP = ServerAutoDetect.cleanIPAddress(o_InetAddress.getHostAddress());
            return stringIP;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ArrayList<InetAddress> getInetAddresses() {
            ArrayList<InetAddress> o_InetAddresses;
            Object object = this.m_SyncInetAddresses;
            synchronized (object) {
                o_InetAddresses = new ArrayList<InetAddress>(this.m_DetectedInetAddresses.size());
                o_InetAddresses.addAll(this.m_DetectedInetAddresses);
            }
            return o_InetAddresses;
        }

        public int getInetAddressCount() {
            return this.m_DetectedInetAddresses.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public InetAddress getInetAddress(int p_Index) {
            if (p_Index < 0) {
                return null;
            }
            Object object = this.m_SyncInetAddresses;
            synchronized (object) {
                if (p_Index >= this.m_DetectedInetAddresses.size()) {
                    return null;
                }
                return this.m_DetectedInetAddresses.get(p_Index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean containsIP(String p_IP) {
            if (p_IP == null) {
                return false;
            }
            p_IP = p_IP.trim();
            Object object = this.m_SyncInetAddresses;
            synchronized (object) {
                for (int intInetAddress = 0; intInetAddress < this.m_DetectedInetAddresses.size(); ++intInetAddress) {
                    InetAddress o_InetAddress = this.m_DetectedInetAddresses.get(intInetAddress);
                    if (!o_InetAddress.getHostAddress().contains(p_IP)) continue;
                    return true;
                }
            }
            return false;
        }

        public String getServerIP() {
            return this.m_ServerIP;
        }

        public int getServerPort() {
            return this.m_ServerPort;
        }

        public String getClientIP() {
            return this.m_ClientIP;
        }
    }
}

