/*
 * Decompiled with CFR 0.152.
 */
package LanguageTools.LocalePackage;

import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LanguageTools.LiveLanguagePackage.LiveLanguageResourceBundle;
import java.awt.ComponentOrientation;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Locale;
import java.util.PropertyResourceBundle;

public class LiveLangageLocaleHandling {
    protected static ArrayList<Locale> m_ArrayListLocales;
    protected static ArrayList<LocaleResource> m_ArrayListLocaleResources;

    public static String getName_ReplacedPoint(String p_FileName) {
        String stringFileName = p_FileName.replace(".", "/");
        return stringFileName;
    }

    private static ArrayList<Locale> loadAvailableLocalesPropertyResourceBundle(Object p_LanguageListener) {
        PropertyResourceBundle o_PropertyResourceBundle;
        String stringFileName;
        ArrayList<Locale> o_ArrayListLocales = new ArrayList<Locale>();
        LiveLanguageResourceBundle o_LiveLanguageResourceBundle = null;
        InputStream o_InputStream = null;
        InputStreamReader o_InputStreamReader = null;
        if (p_LanguageListener == null) {
            m_ArrayListLocales = new ArrayList();
            m_ArrayListLocaleResources = new ArrayList();
        }
        if (p_LanguageListener == null) {
            stringFileName = LiveLangageLocaleHandling.getName_ReplacedPoint(LiveLangageLocaleHandling.class.getPackage().getName()) + "/iso.lng";
            o_PropertyResourceBundle = null;
            try {
                o_InputStream = LiveLangageLocaleHandling.class.getClassLoader().getResourceAsStream(stringFileName);
                o_InputStreamReader = new InputStreamReader(o_InputStream, LiveLanguage.DEFAULTCHARSET_FILE);
                o_PropertyResourceBundle = new PropertyResourceBundle(o_InputStreamReader);
            }
            catch (Exception e) {
                try {
                    if (o_PropertyResourceBundle != null) {
                        PropertyResourceBundle.clearCache();
                    }
                    if (o_InputStreamReader != null) {
                        o_InputStreamReader.close();
                    }
                    if (o_InputStream != null) {
                        o_InputStream.close();
                    }
                }
                catch (Exception eClose) {
                    // empty catch block
                }
                o_PropertyResourceBundle = null;
            }
        } else {
            stringFileName = LiveLanguage.getDefaultLanguageFolder() + File.separator + LiveLanguage.getLanguageFileBaseName(p_LanguageListener) + "_installed.lng";
            o_LiveLanguageResourceBundle = new LiveLanguageResourceBundle(new File(stringFileName));
            o_PropertyResourceBundle = !o_LiveLanguageResourceBundle.isValid() ? null : o_LiveLanguageResourceBundle.getPropertyResourceBundle();
        }
        if (o_PropertyResourceBundle == null) {
            return o_ArrayListLocales;
        }
        Enumeration<String> o_Keys = o_PropertyResourceBundle.getKeys();
        while (o_Keys.hasMoreElements()) {
            String stringKey = o_Keys.nextElement();
            if (stringKey == null || stringKey.length() > 5 || stringKey.length() < 2) continue;
            Locale o_Locale = stringKey.length() < 5 ? new Locale(stringKey.substring(0, 2)) : new Locale(stringKey.substring(0, 2), stringKey.substring(3, 5));
            if (p_LanguageListener == null) {
                m_ArrayListLocales.add(o_Locale);
            }
            o_ArrayListLocales.add(o_Locale);
            String[] o_StringValues = stringKey.split("_", -1);
            if (o_StringValues.length < 1) continue;
            String stringLanguage = o_PropertyResourceBundle.getString(o_StringValues[0]);
            String stringCountry = o_StringValues.length < 2 ? "" : o_PropertyResourceBundle.getString(stringKey);
            if (p_LanguageListener != null) continue;
            LocaleResource o_LocaleResource = new LocaleResource(stringKey, o_Locale, stringLanguage, stringCountry);
            m_ArrayListLocaleResources.add(o_LocaleResource);
        }
        try {
            if (o_PropertyResourceBundle != null) {
                PropertyResourceBundle.clearCache();
            }
            if (o_LiveLanguageResourceBundle != null) {
                o_LiveLanguageResourceBundle.close();
            }
            if (o_InputStreamReader != null) {
                o_InputStreamReader.close();
            }
            if (o_InputStream != null) {
                o_InputStream.close();
            }
        }
        catch (Exception eClose) {
            // empty catch block
        }
        return o_ArrayListLocales;
    }

    public static ArrayList<Locale> getAvailableLocales() {
        if (m_ArrayListLocales != null) {
            return m_ArrayListLocales;
        }
        LiveLangageLocaleHandling.loadAvailableLocalesPropertyResourceBundle(null);
        return m_ArrayListLocales;
    }

    public static ArrayList<Locale> getDeclaredLocales(Object p_LanguageListener) {
        if (p_LanguageListener == null) {
            if (m_ArrayListLocales != null) {
                return m_ArrayListLocales;
            }
            LiveLangageLocaleHandling.loadAvailableLocalesPropertyResourceBundle(null);
            return m_ArrayListLocales;
        }
        return LiveLangageLocaleHandling.loadAvailableLocalesPropertyResourceBundle(p_LanguageListener);
    }

    public static LocaleResource getLocaleResourceString(Locale p_Locale) {
        if (p_Locale == null) {
            return null;
        }
        if (m_ArrayListLocaleResources == null) {
            LiveLangageLocaleHandling.loadAvailableLocalesPropertyResourceBundle(null);
        }
        for (int intLocale = 0; intLocale < m_ArrayListLocaleResources.size(); ++intLocale) {
            LocaleResource o_LocaleResource = m_ArrayListLocaleResources.get(intLocale);
            if (!o_LocaleResource.m_Locale.equals(p_Locale)) continue;
            return o_LocaleResource;
        }
        return null;
    }

    public static LocaleResource getLocaleResource(String p_LocaleKey) {
        if (p_LocaleKey == null) {
            return null;
        }
        if (m_ArrayListLocaleResources == null) {
            LiveLangageLocaleHandling.loadAvailableLocalesPropertyResourceBundle(null);
        }
        for (int intLocale = 0; intLocale < m_ArrayListLocaleResources.size(); ++intLocale) {
            LocaleResource o_LocaleResource = m_ArrayListLocaleResources.get(intLocale);
            if (!o_LocaleResource.m_LocaleKey.equals(p_LocaleKey)) continue;
            return o_LocaleResource;
        }
        return null;
    }

    public static String getLocaleKeyFromLocale(Locale p_Locale) {
        if (p_Locale == null) {
            return "";
        }
        if (!LiveLangageLocaleHandling.isLocaleValid(p_Locale)) {
            return "";
        }
        return p_Locale.toString();
    }

    public static Locale getLocaleFromLocaleKey(String p_LocaleKey) {
        if (p_LocaleKey == null) {
            return null;
        }
        if (!LiveLangageLocaleHandling.isLocaleKeyAvailable(p_LocaleKey)) {
            return null;
        }
        Locale o_Locale = p_LocaleKey.length() < 5 ? new Locale(p_LocaleKey.substring(0, 2)) : new Locale(p_LocaleKey.substring(0, 2), p_LocaleKey.substring(3, 5));
        return o_Locale;
    }

    public static String getCountry(Locale p_Locale) {
        if (p_Locale == null) {
            return "";
        }
        if (!LiveLangageLocaleHandling.isLocaleValid(p_Locale)) {
            return "";
        }
        return p_Locale.getCountry();
    }

    public static String getDisplayCountry(Locale p_Locale) {
        return LiveLangageLocaleHandling.getCountryName(p_Locale);
    }

    public static String getCountryName(Locale p_Locale) {
        if (p_Locale == null) {
            return "";
        }
        LocaleResource o_LocaleResource = LiveLangageLocaleHandling.getLocaleResourceString(p_Locale);
        if (o_LocaleResource == null) {
            try {
                return p_Locale.getDisplayCountry();
            }
            catch (Exception e) {
                return "";
            }
        }
        return o_LocaleResource.m_DisplayCountry;
    }

    public static String getLanguage(Locale p_Locale) {
        if (p_Locale == null) {
            return "";
        }
        if (!LiveLangageLocaleHandling.isLocaleValid(p_Locale)) {
            return "";
        }
        return p_Locale.getLanguage();
    }

    public static String getDisplayLanguage(Locale p_Locale) {
        return LiveLangageLocaleHandling.getLanguageName(p_Locale);
    }

    public static String getLanguageName(Locale p_Locale) {
        if (p_Locale == null) {
            return "";
        }
        LocaleResource o_LocaleResource = LiveLangageLocaleHandling.getLocaleResourceString(p_Locale);
        if (o_LocaleResource == null) {
            try {
                return p_Locale.getDisplayLanguage();
            }
            catch (Exception e) {
                return "";
            }
        }
        return o_LocaleResource.m_DisplayLanguage;
    }

    public static boolean isLocaleAvailable(Locale p_Locale) {
        if (p_Locale == null) {
            return false;
        }
        LocaleResource o_LocaleResource = LiveLangageLocaleHandling.getLocaleResourceString(p_Locale);
        return o_LocaleResource != null;
    }

    public static boolean isLocaleKeyAvailable(String p_LocaleKey) {
        if (p_LocaleKey == null) {
            return false;
        }
        LocaleResource o_LocaleResource = LiveLangageLocaleHandling.getLocaleResource(p_LocaleKey);
        return o_LocaleResource != null;
    }

    public static boolean isLocaleValid(Locale p_Locale) {
        if (p_Locale == null) {
            return false;
        }
        LocaleResource o_LocaleResource = LiveLangageLocaleHandling.getLocaleResourceString(p_Locale);
        return o_LocaleResource != null;
    }

    public static boolean isLocaleKeyValid(String p_LocaleKey) {
        return LiveLangageLocaleHandling.getLocaleFromLocaleKey(p_LocaleKey) != null;
    }

    public static ComponentOrientation getComponentOrientation(Locale p_Locale) {
        if (p_Locale == null) {
            return null;
        }
        String lang = p_Locale.getLanguage();
        ComponentOrientation o_ComponentOrientation = "iw".equals(lang) || "he".equals(lang) || "ar".equals(lang) || "fa".equals(lang) || "ur".equals(lang) ? ComponentOrientation.RIGHT_TO_LEFT : ComponentOrientation.LEFT_TO_RIGHT;
        return o_ComponentOrientation;
    }

    public static ArrayList<LocaleResource> getJavaLocaleResources() {
        Locale[] o_Locales = Locale.getAvailableLocales();
        ArrayList<LocaleResource> o_ArrayListLocaleResources = new ArrayList<LocaleResource>();
        for (int intLangauge = 0; intLangauge < o_Locales.length; ++intLangauge) {
            Locale o_Locale = o_Locales[intLangauge];
            LocaleResource o_LocaleResource = new LocaleResource(o_Locale.toString(), o_Locale, o_Locale.getDisplayLanguage(), o_Locale.getDisplayCountry());
            o_ArrayListLocaleResources.add(o_LocaleResource);
        }
        return o_ArrayListLocaleResources;
    }

    public static String getJavaLocaleList() {
        Locale[] o_Locales = Locale.getAvailableLocales();
        String o_LanguageList = "";
        for (int intLangauge = 0; intLangauge < o_Locales.length; ++intLangauge) {
            Locale o_Locale = o_Locales[intLangauge];
            o_LanguageList = o_LanguageList + o_Locale.toString() + "=";
            o_LanguageList = o_LanguageList + o_Locale.getDisplayLanguage() + "=";
            o_LanguageList = o_LanguageList + o_Locale.getDisplayCountry();
            if (intLangauge >= o_Locales.length - 1) continue;
            o_LanguageList = o_LanguageList + "\n";
        }
        return o_LanguageList;
    }

    public static class LocaleResource {
        public String m_LocaleKey;
        public Locale m_Locale;
        public String m_DisplayLanguage;
        public String m_DisplayCountry;

        public LocaleResource(String p_LocaleKey, Locale p_Locale, String p_Language, String p_Country) {
            this.m_LocaleKey = p_LocaleKey;
            this.m_Locale = p_Locale;
            this.m_DisplayLanguage = p_Language;
            this.m_DisplayCountry = p_Country;
        }
    }
}

