/*
 * Decompiled with CFR 0.152.
 */
package ToolsPackage;

import java.util.ArrayList;

public class MidiTools {
    public static String getStringFromByte(byte p_Byte) {
        return String.format("%02X", p_Byte);
    }

    public static byte getByteFromString(String p_ByteString) throws NumberFormatException {
        try {
            int intResult = Integer.parseInt(p_ByteString, 16);
            return (byte)(intResult & 0xFF);
        }
        catch (Exception e) {
            throw new NumberFormatException("Not a byte: " + p_ByteString);
        }
    }

    public static String getStringFromByteArray(byte[] p_Bytes, boolean p_ShowBytes) {
        if (p_Bytes == null || p_Bytes.length <= 0) {
            return "";
        }
        StringBuilder o_StringBuilder = new StringBuilder();
        for (int intByte = 0; intByte < p_Bytes.length; ++intByte) {
            byte o_Byte = p_Bytes[intByte];
            if (p_ShowBytes) {
                try {
                    o_StringBuilder.append(String.format("%02X", o_Byte));
                }
                catch (Exception e) {
                    o_StringBuilder.append("00");
                }
            } else {
                try {
                    o_StringBuilder.append(String.valueOf(o_Byte & 0xFF));
                }
                catch (Exception e) {
                    o_StringBuilder.append("00");
                }
            }
            if (intByte >= p_Bytes.length - 1) continue;
            o_StringBuilder.append(" ");
        }
        return o_StringBuilder.toString();
    }

    public static byte[] getBytesFromString(String p_ByteString, boolean p_ShowBytes) throws NumberFormatException {
        if (p_ByteString == null || p_ByteString.length() <= 0) {
            return new byte[0];
        }
        String[] o_StringArray = (p_ByteString = p_ByteString.trim()).split(" ");
        if (o_StringArray.length <= 0) {
            return new byte[0];
        }
        ArrayList<Byte> o_Bytes = new ArrayList<Byte>(o_StringArray.length);
        for (int intElement = 0; intElement < o_StringArray.length; ++intElement) {
            Byte o_Byte;
            String stringElement = o_StringArray[intElement];
            if (stringElement.length() <= 0) continue;
            if (p_ShowBytes) {
                try {
                    o_Byte = MidiTools.getByteFromString(stringElement);
                }
                catch (Exception e) {
                    o_Byte = 0;
                }
            } else {
                try {
                    o_Byte = (byte)(Integer.parseInt(stringElement) & 0xFF);
                }
                catch (Exception e) {
                    o_Byte = 0;
                }
            }
            o_Bytes.add(o_Byte);
        }
        byte[] o_ResultBytes = new byte[o_Bytes.size()];
        for (int intByte = 0; intByte < o_Bytes.size(); ++intByte) {
            o_ResultBytes[intByte] = (Byte)o_Bytes.get(intByte);
        }
        return o_ResultBytes;
    }

    public static byte[] getDataBytesFromString(String p_ByteString, boolean p_ShowBytes) throws NumberFormatException {
        if (p_ByteString == null || p_ByteString.length() <= 0) {
            return new byte[0];
        }
        String[] o_StringArray = (p_ByteString = p_ByteString.trim()).split(" ");
        if (o_StringArray.length <= 0) {
            return new byte[0];
        }
        ArrayList<Byte> o_Bytes = new ArrayList<Byte>(o_StringArray.length);
        for (int intElement = 0; intElement < o_StringArray.length; ++intElement) {
            Byte o_Byte;
            String stringElement = o_StringArray[intElement];
            if (stringElement.length() <= 0) continue;
            if (p_ShowBytes) {
                try {
                    o_Byte = MidiTools.getByteFromString(stringElement);
                }
                catch (Exception e) {
                    o_Byte = 0;
                }
            } else {
                try {
                    o_Byte = (byte)(Integer.parseInt(stringElement) & 0xFF);
                }
                catch (Exception e) {
                    o_Byte = 0;
                }
            }
            if ((o_Byte & 0xFF) > 127) {
                o_Byte = 127;
            }
            o_Bytes.add(o_Byte);
        }
        byte[] o_ResultBytes = new byte[o_Bytes.size()];
        for (int intByte = 0; intByte < o_Bytes.size(); ++intByte) {
            o_ResultBytes[intByte] = (Byte)o_Bytes.get(intByte);
        }
        return o_ResultBytes;
    }
}

