/*
 * Decompiled with CFR 0.152.
 */
package ToolsPackage;

import ToolsPackage.FileImagePreview;
import ToolsPackage.OSChecker;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.plaf.FileChooserUI;

public class FileSelection {
    public static final ImageIcon s_ImageIcon = new ImageIcon(FileSelection.class.getResource("/IconsPackage/LiveShow_Icon_Midi.png"));
    public static Dimension s_PrefferedSize = new Dimension(600, 450);
    public static Point s_Position = new Point(-1, -1);
    public static FileSelection s_FileSelection = new FileSelection();
    private static FileSystemViewJFileChooser_Save s_FileSystemView_Save = null;
    private static FileSystemViewJFileChooser_Open s_FileSystemView_Open = null;

    public FileSelection() {
        this.initMembers();
    }

    private void initMembers() {
    }

    public static FileNameExtensionFilter createFileNameExtensionFilter(String p_Description, String ... p_Extensions) {
        if (p_Extensions == null || p_Extensions.length == 0) {
            return null;
        }
        int intPosPoint = 0;
        String[] extensions = new String[p_Extensions.length];
        for (int i = 0; i < p_Extensions.length; ++i) {
            if (p_Extensions[i] == null || p_Extensions[i].length() == 0) {
                return null;
            }
            String stringExtension = p_Extensions[i].toLowerCase(Locale.ENGLISH);
            intPosPoint = stringExtension.indexOf(".");
            extensions[i] = intPosPoint < 0 ? stringExtension : stringExtension.substring(intPosPoint + 1, stringExtension.length());
        }
        FileNameExtensionFilter o_FileNameExtensionFilter = new FileNameExtensionFilter(p_Description, extensions);
        return o_FileNameExtensionFilter;
    }

    public static void eventChooserResized(Component p_Component) {
        FileSelection.s_PrefferedSize.width = p_Component.getWidth();
        FileSelection.s_PrefferedSize.height = p_Component.getHeight();
    }

    public static void eventChooserMoved(Component p_Component) {
        FileSelection.s_Position.x = p_Component.getX();
        FileSelection.s_Position.y = p_Component.getY();
    }

    public static File showOpen(Component p_Parent, String p_Titel, File p_InitialFile, FileNameExtensionFilter p_Filter, boolean p_AllowChangeDirectory, boolean p_ShowThumbnails) {
        return FileSelection.showOpen(p_Parent, p_Titel, p_InitialFile, p_Filter, p_AllowChangeDirectory, p_ShowThumbnails, null, null, null, null);
    }

    public static File showOpen(Component p_Parent, String p_Titel, File p_InitialFile, FileNameExtensionFilter p_Filter, boolean p_AllowChangeDirectory, boolean p_ShowThumbnails, FileNameExtensionFilter p_ImageFilter, FileNameExtensionFilter p_SoundFilter, FileNameExtensionFilter p_VideoFilter, FileNameExtensionFilter p_TextFilter) {
        boolean boolUseFileDialog = false;
        boolUseFileDialog = p_ShowThumbnails ? OSChecker.getIsWindows() || OSChecker.getIsMac() : false;
        if (boolUseFileDialog) {
            return FileSelection.showOpen_FileDialog(p_Parent, p_Titel, p_InitialFile, p_Filter, p_AllowChangeDirectory, p_ShowThumbnails, p_ImageFilter, p_SoundFilter, p_VideoFilter, p_TextFilter);
        }
        return FileSelection.showOpen_JFileChooser(p_Parent, p_Titel, p_InitialFile, p_Filter, p_AllowChangeDirectory, p_ShowThumbnails, p_ImageFilter, p_SoundFilter, p_VideoFilter, p_TextFilter);
    }

    private static File showOpen_FileDialog(Component p_Parent, String p_Titel, File p_InitialFile, FileNameExtensionFilter p_Filter, boolean p_AllowChangeDirectory, boolean p_ShowThumbnails, FileNameExtensionFilter p_ImageFilter, FileNameExtensionFilter p_SoundFilter, FileNameExtensionFilter p_VideoFilter, FileNameExtensionFilter p_TextFilter) {
        FileDialog o_FileDialog_Open;
        try {
            o_FileDialog_Open = FileSelection.createFileDialog_Open(p_Parent);
        }
        catch (Exception e) {
            return null;
        }
        File o_SelectedFile = null;
        LookAndFeel o_LookAndFeel_Actual = UIManager.getLookAndFeel();
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (p_Filter != null) {
                if (OSChecker.getIsMac() || OSChecker.getIsLinux()) {
                    FileSelection.setFilterOpen_FileDialog(o_FileDialog_Open, p_Filter);
                } else {
                    StringBuilder o_StringBuilder = new StringBuilder();
                    for (int intExtension = 0; intExtension < p_Filter.getExtensions().length; ++intExtension) {
                        String stringExtension = p_Filter.getExtensions()[intExtension];
                        o_StringBuilder.append("*.");
                        o_StringBuilder.append(stringExtension);
                        if (intExtension >= p_Filter.getExtensions().length - 1) continue;
                        o_StringBuilder.append(";");
                    }
                    o_FileDialog_Open.setFile(o_StringBuilder.toString());
                }
            } else {
                o_FileDialog_Open.setFilenameFilter(null);
            }
            o_SelectedFile = FileSelection.showOpen_FileDialog(o_FileDialog_Open, p_Titel, p_InitialFile);
        }
        catch (Exception e) {
            o_SelectedFile = null;
        }
        try {
            UIManager.setLookAndFeel(o_LookAndFeel_Actual);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return o_SelectedFile;
    }

    private static File showOpen_FileDialog(FileDialog p_FileDialog_Open, String p_Titel, File p_InitialFile) {
        if (p_FileDialog_Open == null) {
            return null;
        }
        try {
            p_FileDialog_Open.setMode(0);
            if (p_Titel == null) {
                p_Titel = "";
            }
            p_FileDialog_Open.setTitle(p_Titel);
            if (p_InitialFile == null) {
                p_InitialFile = new File(System.getProperty("user.home"));
            }
            if (p_InitialFile.isDirectory()) {
                if (p_InitialFile.exists()) {
                    p_FileDialog_Open.setDirectory(p_InitialFile.getAbsolutePath());
                }
            } else if (p_InitialFile.exists()) {
                p_FileDialog_Open.setDirectory(p_InitialFile.getParent());
            }
            p_FileDialog_Open.requestFocusInWindow();
            p_FileDialog_Open.setVisible(true);
            String stringFilename = p_FileDialog_Open.getFile();
            if (stringFilename == null) {
                return null;
            }
            stringFilename = p_FileDialog_Open.getDirectory() + p_FileDialog_Open.getFile();
            return new File(stringFilename);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static FileDialog createFileDialog_Open(Component p_Parent) {
        FileDialog o_FileDialog_Open = p_Parent instanceof Frame ? new FileDialog((Frame)p_Parent) : (p_Parent instanceof Dialog ? new FileDialog((Dialog)p_Parent) : new FileDialog((Frame)null));
        o_FileDialog_Open.setIconImage(s_ImageIcon.getImage());
        o_FileDialog_Open.setMultipleMode(false);
        o_FileDialog_Open.setAlwaysOnTop(true);
        o_FileDialog_Open.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
                FileSelection.eventChooserResized((Component)e.getSource());
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                FileSelection.eventChooserMoved((Component)e.getSource());
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        });
        o_FileDialog_Open.setPreferredSize(s_PrefferedSize);
        o_FileDialog_Open.setSize(s_PrefferedSize);
        if (FileSelection.s_Position.x >= 0 && FileSelection.s_Position.y >= 0) {
            o_FileDialog_Open.setLocation(s_Position);
        }
        return o_FileDialog_Open;
    }

    private static void setFilterOpen_FileDialog(FileDialog p_FileDialog_Open, final FileNameExtensionFilter p_Filter) {
        if (p_FileDialog_Open == null) {
            return;
        }
        if (p_Filter == null) {
            return;
        }
        final ArrayList<String> o_ArrayListExtensions = new ArrayList<String>();
        String[] o_Extensions = p_Filter.getExtensions();
        for (int intExtension = 0; intExtension < o_Extensions.length; ++intExtension) {
            o_ArrayListExtensions.add(o_Extensions[intExtension]);
        }
        FilenameFilter o_ExtensionFilter = new FilenameFilter(){
            String m_Description;
            ArrayList<String> m_Extensions;
            {
                this.m_Description = p_Filter.getDescription();
                this.m_Extensions = o_ArrayListExtensions;
            }

            @Override
            public boolean accept(File dir, String name) {
                if (this.m_Extensions == null || this.m_Extensions.size() <= 0) {
                    return true;
                }
                for (int intExtension = 0; intExtension < this.m_Extensions.size(); ++intExtension) {
                    String stringExtension = this.m_Extensions.get(intExtension);
                    if (!name.toLowerCase().endsWith(stringExtension)) continue;
                    return true;
                }
                return false;
            }

            public String getDescription() {
                return this.m_Description;
            }
        };
        p_FileDialog_Open.setFilenameFilter(o_ExtensionFilter);
    }

    public static File showOpen_JFileChooser(Component p_Parent, String p_Titel, File p_InitialFile, FileNameExtensionFilter p_FileNameExtensionFilter, boolean p_AllowCHangeDirectory, boolean p_ShowThumbnails, FileNameExtensionFilter p_ImageFilter, FileNameExtensionFilter p_SoundFilter, FileNameExtensionFilter p_VideoFilter, FileNameExtensionFilter p_TextFilter) {
        JFileChooser o_JFileChooser_Open;
        LookAndFeel o_LookAndFeel_Actual = UIManager.getLookAndFeel();
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            o_JFileChooser_Open = FileSelection.createJFileChooserOpen();
        }
        catch (Exception e) {
            return null;
        }
        FileSelection.setFilterOpen_JFileChooser(o_JFileChooser_Open, p_FileNameExtensionFilter);
        if (p_ImageFilter != null || p_SoundFilter != null || p_VideoFilter != null || p_TextFilter != null) {
            o_JFileChooser_Open.setAccessory(new FileImagePreview(o_JFileChooser_Open, p_ImageFilter, p_SoundFilter, p_VideoFilter, p_TextFilter));
        }
        File o_SelectedFile = FileSelection.showOpen_JFileChooser(o_JFileChooser_Open, p_Parent, p_Titel, p_InitialFile);
        try {
            UIManager.setLookAndFeel(o_LookAndFeel_Actual);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return o_SelectedFile;
    }

    private static JFileChooser createJFileChooserOpen() {
        JFileChooser o_JFileChooser_Open = new JFileChooser(){

            @Override
            protected JDialog createDialog(Component parent) throws HeadlessException {
                boolean supportsWindowDecorations;
                FileChooserUI ui = this.getUI();
                String title = ui.getDialogTitle(this);
                this.putClientProperty("AccessibleDescription", title);
                Frame window = JOptionPane.getRootFrame();
                JDialog o_JDialog = window instanceof Frame ? new JDialog(window, title, true) : (window instanceof Dialog ? new JDialog((Dialog)((Object)window), title, true) : new JDialog((Dialog)null, title, true));
                o_JDialog.setAlwaysOnTop(true);
                o_JDialog.setComponentOrientation(this.getComponentOrientation());
                Container contentPane = o_JDialog.getContentPane();
                contentPane.setLayout(new BorderLayout());
                contentPane.add((Component)this, "Center");
                if (JDialog.isDefaultLookAndFeelDecorated() && (supportsWindowDecorations = UIManager.getLookAndFeel().getSupportsWindowDecorations())) {
                    o_JDialog.getRootPane().setWindowDecorationStyle(6);
                }
                o_JDialog.pack();
                o_JDialog.setLocationRelativeTo(parent);
                o_JDialog.setIconImage(s_ImageIcon.getImage());
                o_JDialog.addComponentListener(new ComponentListener(){

                    @Override
                    public void componentResized(ComponentEvent e) {
                        FileSelection.eventChooserResized((Component)e.getSource());
                    }

                    @Override
                    public void componentMoved(ComponentEvent e) {
                        FileSelection.eventChooserMoved((Component)e.getSource());
                    }

                    @Override
                    public void componentShown(ComponentEvent e) {
                    }

                    @Override
                    public void componentHidden(ComponentEvent e) {
                    }
                });
                o_JDialog.setPreferredSize(s_PrefferedSize);
                o_JDialog.setSize(s_PrefferedSize);
                if (FileSelection.s_Position.x >= 0 && FileSelection.s_Position.y >= 0) {
                    o_JDialog.setLocation(s_Position);
                }
                return o_JDialog;
            }
        };
        o_JFileChooser_Open.setFileSelectionMode(0);
        if (s_FileSystemView_Open == null) {
            s_FileSystemView_Open = new FileSystemViewJFileChooser_Open();
        }
        s_FileSystemView_Open.setFileChooser(o_JFileChooser_Open);
        o_JFileChooser_Open.setFileSystemView(s_FileSystemView_Open);
        o_JFileChooser_Open.setAcceptAllFileFilterUsed(false);
        o_JFileChooser_Open.setFileHidingEnabled(false);
        o_JFileChooser_Open.setMultiSelectionEnabled(false);
        return o_JFileChooser_Open;
    }

    private static void setFilterOpen_JFileChooser(JFileChooser p_JFileChooser_Open, FileNameExtensionFilter p_FileNameExtensionFilter) {
        if (p_JFileChooser_Open == null) {
            return;
        }
        p_JFileChooser_Open.resetChoosableFileFilters();
        if (p_FileNameExtensionFilter == null) {
            return;
        }
        p_JFileChooser_Open.addChoosableFileFilter(p_FileNameExtensionFilter);
    }

    private static File showOpen_JFileChooser(JFileChooser p_JFileChooser_Open, Component p_Parent, String p_Titel, File p_InitialFile) {
        if (p_JFileChooser_Open == null) {
            return null;
        }
        p_JFileChooser_Open.setFileSelectionMode(0);
        if (p_InitialFile == null || !p_InitialFile.exists()) {
            p_InitialFile = new File(System.getProperty("user.home"));
        }
        if (p_InitialFile.isDirectory()) {
            p_JFileChooser_Open.setSelectedFiles(null);
            p_JFileChooser_Open.setCurrentDirectory(p_InitialFile);
        } else {
            p_JFileChooser_Open.setSelectedFiles(null);
            p_JFileChooser_Open.setCurrentDirectory(p_InitialFile.getParentFile());
        }
        if (p_Titel == null) {
            p_Titel = "";
        }
        p_JFileChooser_Open.setDialogTitle(p_Titel);
        if (p_JFileChooser_Open.showOpenDialog(p_Parent) == 0) {
            return p_JFileChooser_Open.getSelectedFile();
        }
        return null;
    }

    private static JFileChooser createJFileChooserDirectory_Save() {
        JFileChooser o_JFileChooser = new JFileChooser(){

            @Override
            protected JDialog createDialog(Component parent) throws HeadlessException {
                JDialog o_JDialog = super.createDialog(parent);
                o_JDialog.setIconImage(s_ImageIcon.getImage());
                o_JDialog.addComponentListener(new ComponentListener(){

                    @Override
                    public void componentResized(ComponentEvent e) {
                        FileSelection.eventChooserResized((Component)e.getSource());
                    }

                    @Override
                    public void componentMoved(ComponentEvent e) {
                        FileSelection.eventChooserMoved((Component)e.getSource());
                    }

                    @Override
                    public void componentShown(ComponentEvent e) {
                    }

                    @Override
                    public void componentHidden(ComponentEvent e) {
                    }
                });
                o_JDialog.setPreferredSize(s_PrefferedSize);
                o_JDialog.setSize(s_PrefferedSize);
                if (FileSelection.s_Position.x >= 0 && FileSelection.s_Position.y >= 0) {
                    o_JDialog.setLocation(s_Position);
                }
                return o_JDialog;
            }
        };
        return o_JFileChooser;
    }

    public static File showSaveDirectory(String p_Titel, File p_InitialFile) {
        JFileChooser o_JFileChooser_Save;
        try {
            o_JFileChooser_Save = FileSelection.createJFileChooserDirectory_Save();
        }
        catch (Exception e) {
            return null;
        }
        o_JFileChooser_Save.setFileSelectionMode(1);
        if (p_InitialFile == null) {
            p_InitialFile = new File(System.getProperty("user.home"));
        }
        if (p_InitialFile.isDirectory()) {
            o_JFileChooser_Save.setCurrentDirectory(p_InitialFile);
        } else {
            o_JFileChooser_Save.setCurrentDirectory(p_InitialFile.getParentFile());
        }
        if (p_Titel == null) {
            p_Titel = "";
        }
        o_JFileChooser_Save.setDialogTitle(p_Titel);
        if (o_JFileChooser_Save.showSaveDialog(null) == 0) {
            return o_JFileChooser_Save.getSelectedFile();
        }
        return null;
    }

    public static File showSave(Component p_Parent, String p_Titel, File p_InitialFile, FileNameExtensionFilter p_FileNameExtensionFilter, boolean p_AllowChangeDir, boolean p_ShowThumbnails) {
        return FileSelection.showSave(p_Parent, p_Titel, p_InitialFile, p_FileNameExtensionFilter, p_AllowChangeDir, p_ShowThumbnails, null, null, null, null);
    }

    public static File showSave(Component p_Parent, String p_Titel, File p_InitialFile, FileNameExtensionFilter p_FileNameExtensionFilter, boolean p_AllowChangeDir, boolean p_ShowThumbnails, FileNameExtensionFilter p_ImageFilter, FileNameExtensionFilter p_SoundFilter, FileNameExtensionFilter p_VideoFilter, FileNameExtensionFilter p_TextFilter) {
        JFileChooser o_JFileChooser_Save;
        File o_SelectedFile = null;
        LookAndFeel o_LookAndFeel_Actual = UIManager.getLookAndFeel();
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            o_JFileChooser_Save = FileSelection.createJFileChooserSave();
        }
        catch (Exception e) {
            return null;
        }
        FileSelection.setFilter_Save(o_JFileChooser_Save, p_AllowChangeDir, p_FileNameExtensionFilter);
        if (p_ImageFilter != null || p_SoundFilter != null || p_VideoFilter != null || p_TextFilter != null) {
            o_JFileChooser_Save.setAccessory(new FileImagePreview(o_JFileChooser_Save, p_ImageFilter, p_SoundFilter, p_VideoFilter, p_TextFilter));
        }
        o_SelectedFile = FileSelection.showSave(o_JFileChooser_Save, p_Parent, p_Titel, p_InitialFile);
        try {
            UIManager.setLookAndFeel(o_LookAndFeel_Actual);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return o_SelectedFile;
    }

    private static JFileChooser createJFileChooserSave() {
        JFileChooser o_JFileChooser_Save = new JFileChooser(){

            @Override
            protected JDialog createDialog(Component parent) throws HeadlessException {
                boolean supportsWindowDecorations;
                FileChooserUI ui = this.getUI();
                String title = ui.getDialogTitle(this);
                this.putClientProperty("AccessibleDescription", title);
                Frame window = JOptionPane.getRootFrame();
                JDialog o_JDialog = window instanceof Frame ? new JDialog(window, title, true) : (window instanceof Dialog ? new JDialog((Dialog)((Object)window), title, true) : new JDialog((Dialog)null, title, true));
                o_JDialog.setAlwaysOnTop(true);
                o_JDialog.setComponentOrientation(this.getComponentOrientation());
                Container contentPane = o_JDialog.getContentPane();
                contentPane.setLayout(new BorderLayout());
                contentPane.add((Component)this, "Center");
                if (JDialog.isDefaultLookAndFeelDecorated() && (supportsWindowDecorations = UIManager.getLookAndFeel().getSupportsWindowDecorations())) {
                    o_JDialog.getRootPane().setWindowDecorationStyle(6);
                }
                o_JDialog.pack();
                o_JDialog.setLocationRelativeTo(parent);
                o_JDialog.setIconImage(s_ImageIcon.getImage());
                o_JDialog.addComponentListener(new ComponentListener(){

                    @Override
                    public void componentResized(ComponentEvent e) {
                        FileSelection.eventChooserResized((Component)e.getSource());
                    }

                    @Override
                    public void componentMoved(ComponentEvent e) {
                        FileSelection.eventChooserMoved((Component)e.getSource());
                    }

                    @Override
                    public void componentShown(ComponentEvent e) {
                    }

                    @Override
                    public void componentHidden(ComponentEvent e) {
                    }
                });
                o_JDialog.setPreferredSize(s_PrefferedSize);
                o_JDialog.setSize(s_PrefferedSize);
                if (FileSelection.s_Position.x >= 0 && FileSelection.s_Position.y >= 0) {
                    o_JDialog.setLocation(s_Position);
                }
                return o_JDialog;
            }
        };
        o_JFileChooser_Save.setFileSelectionMode(0);
        if (s_FileSystemView_Save == null) {
            s_FileSystemView_Save = new FileSystemViewJFileChooser_Save();
        }
        s_FileSystemView_Save.setFileChooser(o_JFileChooser_Save);
        o_JFileChooser_Save.setFileSystemView(s_FileSystemView_Save);
        o_JFileChooser_Save.setAcceptAllFileFilterUsed(false);
        o_JFileChooser_Save.setFileHidingEnabled(false);
        o_JFileChooser_Save.setMultiSelectionEnabled(false);
        return o_JFileChooser_Save;
    }

    private static void setFilter_Save(JFileChooser p_JFileChooser_Save, final boolean p_AllowChangeDir, final FileNameExtensionFilter p_FileNameExtensionFilter) {
        if (p_JFileChooser_Save == null) {
            return;
        }
        p_JFileChooser_Save.resetChoosableFileFilters();
        if (p_FileNameExtensionFilter == null) {
            return;
        }
        FileFilter o_FileFilter = new FileFilter(){
            private String m_Description;
            {
                this.m_Description = p_FileNameExtensionFilter.getDescription();
            }

            @Override
            public boolean accept(File p_File) {
                if (p_File.isDirectory()) {
                    return p_AllowChangeDir;
                }
                if (p_FileNameExtensionFilter == null) {
                    return true;
                }
                String[] o_FilterExtension = p_FileNameExtensionFilter.getExtensions();
                for (int intExtension = 0; intExtension < o_FilterExtension.length; ++intExtension) {
                    String stringExtension = o_FilterExtension[intExtension];
                    if (stringExtension.startsWith("*")) {
                        stringExtension = stringExtension.substring(1, stringExtension.length());
                    }
                    if (!p_File.getName().toLowerCase().endsWith(stringExtension)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public String getDescription() {
                return this.m_Description;
            }
        };
        p_JFileChooser_Save.addChoosableFileFilter(o_FileFilter);
    }

    private static File showSave(JFileChooser p_JFileChooser_Save, Component p_Parent, String p_Titel, File p_InitialFile) {
        if (p_JFileChooser_Save == null) {
            return null;
        }
        p_JFileChooser_Save.setFileSelectionMode(0);
        if (p_InitialFile == null) {
            p_InitialFile = new File(System.getProperty("user.home"));
        }
        if (p_InitialFile.isDirectory()) {
            p_JFileChooser_Save.setSelectedFiles(null);
            p_JFileChooser_Save.setCurrentDirectory(p_InitialFile);
        } else {
            p_JFileChooser_Save.setSelectedFile(p_InitialFile);
        }
        if (p_Titel == null) {
            p_Titel = "";
        }
        p_JFileChooser_Save.setDialogTitle(p_Titel);
        if (p_JFileChooser_Save.showSaveDialog(p_Parent) == 0) {
            return p_JFileChooser_Save.getSelectedFile();
        }
        return null;
    }

    public static class FileSystemViewJFileChooser_Save
    extends FileSystemView {
        private JFileChooser m_JFileChooser = null;

        public void setFileChooser(JFileChooser p_JFileChooser) {
            this.m_JFileChooser = p_JFileChooser;
        }

        @Override
        public File[] getFiles(File dir, boolean useFileHiding) {
            ArrayList<File> o_Files_Return = new ArrayList<File>();
            File[] o_Files = super.getFiles(dir, useFileHiding);
            FileFilter[] o_FileFilters = this.m_JFileChooser != null ? this.m_JFileChooser.getChoosableFileFilters() : null;
            if (o_FileFilters == null || o_FileFilters.length <= 0) {
                return o_Files;
            }
            block0: for (int intFile = 0; intFile < o_Files.length; ++intFile) {
                File o_File = o_Files[intFile];
                if (o_File.isDirectory()) {
                    o_Files_Return.add(o_File);
                    continue;
                }
                for (int intFileFilter = 0; intFileFilter < o_FileFilters.length; ++intFileFilter) {
                    FileFilter o_FileFilter = o_FileFilters[intFileFilter];
                    if (!o_FileFilter.accept(o_File)) continue;
                    o_Files_Return.add(o_File);
                    continue block0;
                }
            }
            return o_Files_Return.toArray(new File[o_Files_Return.size()]);
        }

        @Override
        public File createNewFolder(File containingDir) throws IOException {
            return FileSystemView.getFileSystemView().createNewFolder(containingDir);
        }
    }

    public static class FileSystemViewJFileChooser_Open
    extends FileSystemView {
        private JFileChooser m_JFileChooser = null;

        public void setFileChooser(JFileChooser p_JFileChooser) {
            this.m_JFileChooser = p_JFileChooser;
        }

        @Override
        public File[] getFiles(File dir, boolean useFileHiding) {
            ArrayList<File> o_Files_Return = new ArrayList<File>();
            File[] o_Files = super.getFiles(dir, useFileHiding);
            FileFilter[] o_FileFilters = this.m_JFileChooser != null ? this.m_JFileChooser.getChoosableFileFilters() : null;
            if (o_FileFilters == null || o_FileFilters.length <= 0) {
                return o_Files;
            }
            block0: for (int intFile = 0; intFile < o_Files.length; ++intFile) {
                File o_File = o_Files[intFile];
                if (o_File.isDirectory()) {
                    o_Files_Return.add(o_File);
                    continue;
                }
                for (int intFileFilter = 0; intFileFilter < o_FileFilters.length; ++intFileFilter) {
                    FileFilter o_FileFilter = o_FileFilters[intFileFilter];
                    if (!o_FileFilter.accept(o_File)) continue;
                    o_Files_Return.add(o_File);
                    continue block0;
                }
            }
            return o_Files_Return.toArray(new File[o_Files_Return.size()]);
        }

        @Override
        public File createNewFolder(File containingDir) throws IOException {
            return FileSystemView.getFileSystemView().createNewFolder(containingDir);
        }
    }
}

