/*
 * Decompiled with CFR 0.152.
 */
package SPITClientGUI;

import LanguageTools.LiveLanguagePackage.LiveLanguage;
import LanguageTools.LiveLanguagePackage.LiveLanguageString;
import MIDIPackage.MIDI_MessageObject;
import MIDIPackage.SPITType_MidiObject;
import SPITLibraryPackage.SPIT_TypeDescription;
import SPITLibraryPackage.SPIT_Type_Interface;
import SwingModelPackage.TableAndListModel;
import SwingTextPackage.TextComparator;
import SwingToolTipPackage.JLabel_RightClickToolTip;
import SwingToolTipPackage.PopUpToolTip;
import ToolsPackage.EventQueueHandler;
import ToolsPackage.MidiTools;
import ToolsPackage.TimeTools;
import java.awt.Color;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Comparator;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.RowFilter;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;

public class SPITType_MidiObjectTableModel
extends TableAndListModel<SPITType_MidiObject>
implements PropertyChangeListener {
    public static final int COLUMNCOUNT = 5;
    public static final int COLUMNINDEX_SPITTYPEGROUPNAME = 0;
    public static final int COLUMNINDEX_SPITTYPENAME = 1;
    public static final int COLUMNINDEX_MIDI_0 = 2;
    public static final int COLUMNINDEX_MIDI_1 = 3;
    public static final int COLUMNINDEX_MIDI_2 = 4;
    @LiveLanguageString
    public static String COLUMN_SPITTYPEGROUPNAME = "Group";
    @LiveLanguageString
    public static String COLUMN_SPITTYPENAME = SPIT_TypeDescription.DEFAULTNAME;
    @LiveLanguageString
    public static String COLUMN_MIDI_0 = "MIDI at start";
    @LiveLanguageString
    public static String COLUMN_MIDI_1 = "MIDI continous";
    @LiveLanguageString
    public static String COLUMN_MIDI_2 = "MIDI at end";
    private TableRowSorter m_TableRowSorter;
    private SPITRowFilter m_SPITRowFilter;
    private final Object m_SyncObject = new Object();
    private StringBuilder m_StringBuilder;

    public SPITType_MidiObjectTableModel() {
        super(false);
        this.initMembers();
        LiveLanguage.addLanguageListener((Object)this, (String)"Midi_Client");
    }

    private void initMembers() {
        this.m_TableRowSorter = new TableRowSorter<SPITType_MidiObjectTableModel>(this);
        this.m_StringBuilder = new StringBuilder();
    }

    public void finishJTable(JTable p_JTable) {
        SPITType_MidiObjectRenderer o_TableCellEditorRenderer_String;
        if (p_JTable == null) {
            return;
        }
        this.m_TableRowSorter.setComparator(1, (Comparator<?>)new TextComparator.StringComparator_Normal());
        this.m_SPITRowFilter = new SPITRowFilter(this);
        super.finishJTable(p_JTable, this.m_TableRowSorter, (RowFilter)this.m_SPITRowFilter);
        TableColumnModel o_TableColumnModel = p_JTable.getColumnModel();
        TableColumn o_TableColumn = o_TableColumnModel.getColumn(0);
        if (o_TableColumn != null) {
            o_TableCellEditorRenderer_String = new SPITType_MidiObjectRenderer();
            o_TableCellEditorRenderer_String.setToolTipTextAt(false, true);
            o_TableColumn.setCellEditor((TableCellEditor)((Object)o_TableCellEditorRenderer_String));
            o_TableColumn.setCellRenderer((TableCellRenderer)((Object)o_TableCellEditorRenderer_String));
        }
        if ((o_TableColumn = o_TableColumnModel.getColumn(1)) != null) {
            o_TableCellEditorRenderer_String = new SPITType_MidiObjectRenderer();
            o_TableCellEditorRenderer_String.setToolTipTextAt(false, true);
            o_TableColumn.setCellEditor((TableCellEditor)((Object)o_TableCellEditorRenderer_String));
            o_TableColumn.setCellRenderer((TableCellRenderer)((Object)o_TableCellEditorRenderer_String));
        }
        if ((o_TableColumn = o_TableColumnModel.getColumn(2)) != null) {
            o_TableColumn.setPreferredWidth(90);
            o_TableCellEditorRenderer_String = new TableAndListModel.TableCellEditorRenderer_String();
            o_TableCellEditorRenderer_String.setToolTipTextAt(false, true);
            o_TableColumn.setCellEditor((TableCellEditor)((Object)o_TableCellEditorRenderer_String));
            o_TableColumn.setCellRenderer((TableCellRenderer)((Object)o_TableCellEditorRenderer_String));
        }
        if ((o_TableColumn = o_TableColumnModel.getColumn(3)) != null) {
            o_TableColumn.setPreferredWidth(90);
            o_TableCellEditorRenderer_String = new TableAndListModel.TableCellEditorRenderer_String();
            o_TableCellEditorRenderer_String.setToolTipTextAt(false, true);
            o_TableColumn.setCellEditor((TableCellEditor)((Object)o_TableCellEditorRenderer_String));
            o_TableColumn.setCellRenderer((TableCellRenderer)((Object)o_TableCellEditorRenderer_String));
        }
        if ((o_TableColumn = o_TableColumnModel.getColumn(4)) != null) {
            o_TableColumn.setPreferredWidth(90);
            o_TableCellEditorRenderer_String = new TableAndListModel.TableCellEditorRenderer_String();
            o_TableCellEditorRenderer_String.setToolTipTextAt(false, true);
            o_TableColumn.setCellEditor((TableCellEditor)((Object)o_TableCellEditorRenderer_String));
            o_TableColumn.setCellRenderer((TableCellRenderer)((Object)o_TableCellEditorRenderer_String));
        }
        p_JTable.setComponentPopupMenu((JPopupMenu)PopUpToolTip.getSelfReference());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.m_SyncObject;
        synchronized (object) {
            super.clear();
        }
    }

    public void filter(String p_FilterString) {
        if (this.m_SPITRowFilter == null) {
            return;
        }
        this.m_SPITRowFilter.setFilterString(p_FilterString);
    }

    public boolean contains(String p_ID) {
        if (p_ID == null) {
            return false;
        }
        SPITType_MidiObject o_SPITType_MidiObject = this.getSPITType_MidiObject(p_ID);
        return o_SPITType_MidiObject != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SPITType_MidiObject getSPITType_MidiObject(String p_ID) {
        Object object = this.m_SyncObject;
        synchronized (object) {
            for (int intType = 0; intType < this.size(); ++intType) {
                SPITType_MidiObject o_SPITType_MidiObject = (SPITType_MidiObject)this.get(intType);
                if (o_SPITType_MidiObject == null || !p_ID.equals(o_SPITType_MidiObject.getID())) continue;
                return o_SPITType_MidiObject;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addSPITType_MidiObject(SPITType_MidiObject o_SPITType_MidiObject) {
        if (o_SPITType_MidiObject == null) {
            return false;
        }
        if (!(o_SPITType_MidiObject instanceof SPITType_MidiObject)) {
            return false;
        }
        Object object = this.m_SyncObject;
        synchronized (object) {
            if (this.contains(o_SPITType_MidiObject.getID())) {
                return false;
            }
            this.add(o_SPITType_MidiObject);
            SPIT_Type_Interface o_SPIT_Type_Interface = o_SPITType_MidiObject.getSPIT_Type_Interface();
            if (o_SPIT_Type_Interface != null) {
                o_SPIT_Type_Interface.addPropertyChangeListener(this);
            }
            o_SPITType_MidiObject.addPropertyChangeListener(this);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeSPITType_MidiObject(SPITType_MidiObject p_SPITType_MidiObject) {
        boolean boolRemoved;
        if (p_SPITType_MidiObject == null) {
            return false;
        }
        Object object = this.m_SyncObject;
        synchronized (object) {
            boolRemoved = this.remove(p_SPITType_MidiObject);
            SPIT_Type_Interface o_SPIT_Type_Interface = p_SPITType_MidiObject.getSPIT_Type_Interface();
            if (o_SPIT_Type_Interface != null) {
                o_SPIT_Type_Interface.removePropertyChangeListener(this);
            }
            p_SPITType_MidiObject.removePropertyChangeListener(this);
        }
        return boolRemoved;
    }

    public void addSelectedSPITType_MidiObject(JTable p_JTable, SPITType_MidiObject p_SPITType_MidiObject) {
        if (p_JTable == null) {
            return;
        }
        if (p_SPITType_MidiObject == null) {
            return;
        }
        super.addSelectedElement(p_JTable, (Object)p_SPITType_MidiObject);
    }

    public void removeSelectedSPITType_MidiObject(JTable p_JTable, SPITType_MidiObject p_SPITType_MidiObject) {
        if (p_JTable == null) {
            return;
        }
        if (p_SPITType_MidiObject == null) {
            return;
        }
        super.removeSelectedElement(p_JTable, (Object)p_SPITType_MidiObject);
    }

    public SPITType_MidiObject getSPITType_MidiObject(int p_Index) {
        return (SPITType_MidiObject)this.get(p_Index);
    }

    public int getColumnCount() {
        return 5;
    }

    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return COLUMN_SPITTYPEGROUPNAME;
            }
            case 1: {
                return COLUMN_SPITTYPENAME;
            }
            case 2: {
                return COLUMN_MIDI_0;
            }
            case 3: {
                return COLUMN_MIDI_1;
            }
            case 4: {
                return COLUMN_MIDI_2;
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValue(SPITType_MidiObject p_SPITType_MidiObject, int columnIndex) {
        String stringValue = "";
        MIDI_MessageObject o_MIDI_MessageObject = null;
        MIDI_MessageObject o_MIDI_MessageObject_Start = null;
        Object object = this.m_SyncObject;
        synchronized (object) {
            if (p_SPITType_MidiObject == null) {
                return stringValue;
            }
            SPIT_Type_Interface o_SPIT_Type_Interface = p_SPITType_MidiObject.getSPIT_Type_Interface();
            o_MIDI_MessageObject_Start = p_SPITType_MidiObject.getMIDI_MessageObject(0);
            switch (columnIndex) {
                case 0: {
                    if (o_SPIT_Type_Interface == null) {
                        return "";
                    }
                    stringValue = o_SPIT_Type_Interface.getGroupName();
                    break;
                }
                case 1: {
                    if (o_SPIT_Type_Interface == null) {
                        return "";
                    }
                    stringValue = o_SPIT_Type_Interface.getName();
                    break;
                }
                case 2: {
                    if (o_MIDI_MessageObject_Start == null) {
                        stringValue = "";
                        break;
                    }
                    if (o_MIDI_MessageObject_Start.isSet()) {
                        if (o_MIDI_MessageObject_Start.getTypeSub() == 3) {
                            this.m_StringBuilder.delete(0, this.m_StringBuilder.length());
                            this.m_StringBuilder.append("MTC ");
                            if (o_MIDI_MessageObject_Start.getUseTimecodeManual()) {
                                long longTime = o_MIDI_MessageObject_Start.getMidiTimecode().getTimeTrigger();
                                this.m_StringBuilder.append(TimeTools.getTimeStringFromMillis((long)longTime));
                            }
                            stringValue = this.m_StringBuilder.toString();
                            break;
                        }
                        stringValue = o_MIDI_MessageObject_Start.getMessageBytesString();
                        break;
                    }
                    stringValue = "";
                    break;
                }
                case 3: {
                    o_MIDI_MessageObject = p_SPITType_MidiObject.getMIDI_MessageObject(1);
                    if (o_MIDI_MessageObject == null) {
                        stringValue = "";
                        break;
                    }
                    if (o_MIDI_MessageObject.isSet()) {
                        stringValue = o_MIDI_MessageObject.getMessageBytesString();
                        break;
                    }
                    stringValue = "";
                    break;
                }
                case 4: {
                    o_MIDI_MessageObject = p_SPITType_MidiObject.getMIDI_MessageObject(2);
                    stringValue = o_MIDI_MessageObject == null ? "" : (o_MIDI_MessageObject.isSet() ? o_MIDI_MessageObject.getMessageBytesString() : "");
                }
            }
            return stringValue;
        }
    }

    public boolean isCellEditable(int row, int col) {
        switch (col) {
            case 0: {
                return false;
            }
            case 1: {
                return false;
            }
            case 2: {
                return true;
            }
            case 3: {
                return true;
            }
            case 4: {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(SPITType_MidiObject p_SPITType_MidiObject, Object value, int col) {
        if (!(value instanceof String)) {
            return;
        }
        Object object = this.m_SyncObject;
        synchronized (object) {
            if (p_SPITType_MidiObject == null) {
                return;
            }
            SPIT_Type_Interface o_SPIT_Type_Interface = p_SPITType_MidiObject.getSPIT_Type_Interface();
            if (o_SPIT_Type_Interface == null) {
                return;
            }
        }
        switch (col) {
            case 2: {
                String stringValue = ((String)value).trim();
                MIDI_MessageObject o_MIDI_MessageObject = p_SPITType_MidiObject.getMIDI_MessageObject(0);
                if (o_MIDI_MessageObject == null) {
                    return;
                }
                if (stringValue.toLowerCase().startsWith("mtc")) {
                    if (stringValue.length() > 3) {
                        long longTime = TimeTools.getMillisecondsFromString((String)stringValue.substring(3, stringValue.length()));
                        p_SPITType_MidiObject.setManuallyMidiTimecode_Trigger(longTime, 0);
                        p_SPITType_MidiObject.setManuallyUseTimecodeManual(true);
                    } else {
                        p_SPITType_MidiObject.setManuallyUseTimecodeManual(false);
                    }
                } else {
                    byte[] o_Bytes = MidiTools.getBytesFromString((String)stringValue, (boolean)true);
                    p_SPITType_MidiObject.setMessageBytes(o_Bytes, 0);
                }
                p_SPITType_MidiObject.notifyChangedOutside(0);
                break;
            }
            case 3: {
                String stringValue = (String)value;
                MIDI_MessageObject o_MIDI_MessageObject = p_SPITType_MidiObject.getMIDI_MessageObject(1);
                if (o_MIDI_MessageObject == null) {
                    return;
                }
                if (stringValue.toLowerCase().startsWith("mtc")) {
                    long longTime = stringValue.length() > 2 ? TimeTools.getMillisecondsFromString((String)stringValue.substring(2, stringValue.length())) : -1L;
                    p_SPITType_MidiObject.setManuallyMidiTimecode_Trigger(longTime, 1);
                } else {
                    byte[] o_Bytes = MidiTools.getBytesFromString((String)stringValue, (boolean)true);
                    p_SPITType_MidiObject.setMessageBytes(o_Bytes, 1);
                }
                p_SPITType_MidiObject.notifyChangedOutside(1);
                break;
            }
            case 4: {
                String stringValue = (String)value;
                MIDI_MessageObject o_MIDI_MessageObject = p_SPITType_MidiObject.getMIDI_MessageObject(2);
                if (o_MIDI_MessageObject == null) {
                    return;
                }
                if (stringValue.toLowerCase().startsWith("mtc")) {
                    long longTime = stringValue.length() > 2 ? TimeTools.getMillisecondsFromString((String)stringValue.substring(2, stringValue.length())) : -1L;
                    p_SPITType_MidiObject.setManuallyMidiTimecode_Trigger(longTime, 2);
                } else {
                    byte[] o_Bytes = MidiTools.getBytesFromString((String)stringValue, (boolean)true);
                    p_SPITType_MidiObject.setMessageBytes(o_Bytes, 2);
                }
                p_SPITType_MidiObject.notifyChangedOutside(2);
                break;
            }
            default: {
                return;
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() instanceof SPIT_Type_Interface) {
            SPITType_MidiObject o_SPITType_MidiObject;
            SPIT_Type_Interface o_SPIT_Type_Interface = (SPIT_Type_Interface)evt.getSource();
            if ("paramchanged".equals(evt.getPropertyName())) {
                SPITType_MidiObject o_SPITType_MidiObject2 = this.getSPITType_MidiObject(o_SPIT_Type_Interface.getID());
                if (o_SPITType_MidiObject2 != null) {
                    this.changedElement(o_SPITType_MidiObject2);
                    this.sort();
                }
            } else if ("confirmed".equals(evt.getPropertyName()) && (o_SPITType_MidiObject = this.getSPITType_MidiObject(o_SPIT_Type_Interface.getID())) != null) {
                this.changedElement(o_SPITType_MidiObject);
                this.sort();
            }
        } else if (evt.getSource() instanceof SPITType_MidiObject) {
            SPITType_MidiObject o_SPITType_MidiObject = (SPITType_MidiObject)evt.getSource();
            if ("midiObjectChanged".equals(evt.getPropertyName())) {
                this.changedElement(o_SPITType_MidiObject);
                this.sort();
            }
        }
    }

    public void sort() {
        EventQueueHandler.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    if (SPITType_MidiObjectTableModel.this.size() > 0) {
                        SPITType_MidiObjectTableModel.this.m_TableRowSorter.sort();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    public static class SPITType_MidiObjectRenderer
    extends TableAndListModel.TableCellEditorRenderer_String {
        private static final Border DEFAULT_NO_FOCUS_BORDER = new EmptyBorder(2, 2, 2, 2);
        protected Border m_NoFocusBorder = DEFAULT_NO_FOCUS_BORDER;
        public static Color s_NotConfirmedColor = new Color(100, 0, 0);

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel_RightClickToolTip o_JLabel = (JLabel_RightClickToolTip)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (table.getModel() instanceof SPITType_MidiObjectTableModel) {
                SPITType_MidiObject o_SPITType_MidiObject;
                SPITType_MidiObjectTableModel o_TableModel = (SPITType_MidiObjectTableModel)((Object)table.getModel());
                try {
                    int intRowModel = table.convertRowIndexToModel(row);
                    o_SPITType_MidiObject = (SPITType_MidiObject)o_TableModel.getElementAt(intRowModel);
                }
                catch (Exception e) {
                    o_SPITType_MidiObject = null;
                    Object var11_13 = null;
                }
                if (o_SPITType_MidiObject != null) {
                    String stringToolTip;
                    SPIT_Type_Interface o_SPIT_Type_Interface = o_SPITType_MidiObject.getSPIT_Type_Interface();
                    if (o_SPIT_Type_Interface == null || !o_SPIT_Type_Interface.getConfirmed()) {
                        o_JLabel.setBackground(s_NotConfirmedColor);
                    }
                    if ((stringToolTip = o_SPITType_MidiObject.getToolTipText()).length() > 0) {
                        o_JLabel.setToolTipText(stringToolTip);
                        o_JLabel.setToolTipText_RightClick(stringToolTip);
                    } else {
                        o_JLabel.setToolTipText(null);
                        o_JLabel.setToolTipText_RightClick(null);
                    }
                } else {
                    o_JLabel.setBackground(s_NotConfirmedColor);
                }
            }
            return o_JLabel;
        }
    }

    public static class SPITRowFilter
    extends RowFilter<SPITType_MidiObject, Integer> {
        private SPITType_MidiObjectTableModel m_SPITType_MidiObjectTableModel;
        private String m_FilterString;

        public SPITRowFilter(SPITType_MidiObjectTableModel p_SPITType_MidiObjectTableModel) {
            this.initMembers();
            this.m_SPITType_MidiObjectTableModel = p_SPITType_MidiObjectTableModel;
        }

        private void initMembers() {
            this.m_FilterString = null;
        }

        public void setFilterString(String p_FilterString) {
            this.m_FilterString = p_FilterString == null ? "" : p_FilterString.toLowerCase();
            if (this.m_SPITType_MidiObjectTableModel != null) {
                this.m_SPITType_MidiObjectTableModel.fireTableDataChanged();
            }
        }

        @Override
        public boolean include(RowFilter.Entry entry) {
            if (this.m_SPITType_MidiObjectTableModel == null) {
                return false;
            }
            if (this.m_FilterString == null) {
                return true;
            }
            if (this.m_FilterString.length() <= 0) {
                return true;
            }
            int intRow = (Integer)entry.getIdentifier();
            SPITType_MidiObject o_SPITType_MidiObject = this.m_SPITType_MidiObjectTableModel.getSPITType_MidiObject(intRow);
            if (o_SPITType_MidiObject == null) {
                return false;
            }
            SPIT_Type_Interface o_SPIT_Type_Interface = o_SPITType_MidiObject.getSPIT_Type_Interface();
            if (o_SPIT_Type_Interface == null) {
                return false;
            }
            if (o_SPIT_Type_Interface.getGroupName().toLowerCase().contains(this.m_FilterString)) {
                return true;
            }
            if (o_SPIT_Type_Interface.getName().toLowerCase().contains(this.m_FilterString)) {
                return true;
            }
            if (o_SPITType_MidiObject.getMIDI_MessageObject(0).getMessageBytesString().contains(this.m_FilterString)) {
                return true;
            }
            if (o_SPITType_MidiObject.getMIDI_MessageObject(1).getMessageBytesString().contains(this.m_FilterString)) {
                return true;
            }
            return o_SPITType_MidiObject.getMIDI_MessageObject(2).getMessageBytesString().contains(this.m_FilterString);
        }
    }
}

